/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.axiom;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.filter.RemoveDummyElementFilter;
import com.ibm.ws.wssecurity.filter.XMLStreamReaderFilter;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.MultipleInputStream;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectNormalWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.context.MessageContext;

public class OMWSSObjectDataSource
implements OMDataSource {
    private static final TraceComponent tc = Tr.register(OMWSSObjectDataSource.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final boolean DEBUG = true;
    private static final String ENCODING = "UTF-8";
    QName qName = null;
    WSSObjectDocumentImpl wssObjectDocumentImpl = null;

    public OMWSSObjectDataSource(QName qName, WSSObjectDocumentImpl wssObject) {
        this.qName = qName;
        this.wssObjectDocumentImpl = wssObject;
    }

    protected XMLStreamReader createReader() throws XMLStreamException {
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(1024);
        WSSObjectNormalWriter vpw = new WSSObjectNormalWriter(baos);
        try {
            this.wssObjectDocumentImpl.getRootWSSObject().serialize(vpw, true);
        }
        catch (IOException e) {
            XMLStreamException xe = new XMLStreamException(e.getMessage());
            xe.initCause(e);
            throw xe;
        }
        ByteArrayHolder bytes = baos.getByteArrayHolder();
        InputStream is = new ByteArrayInputStream(bytes.getValue(), bytes.getOffset(), bytes.getLength());
        is = this.wrapWithDummyElement(is);
        XMLStreamReader reader = StAXUtils.createXMLStreamReader(is, ENCODING);
        RemoveDummyElementFilter filter = new RemoveDummyElementFilter();
        filter.init(reader, (MessageContext)null, (XMLStreamReaderFilter)null);
        return filter;
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        XMLStreamReader reader = this.createReader();
        return reader;
    }

    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        throw new XMLStreamException("not implemented yet.");
    }

    @Override
    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        throw new XMLStreamException("not implemented yet.");
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter instanceof MTOMXMLStreamWriter) {
            MTOMXMLStreamWriter mtomwriter = (MTOMXMLStreamWriter)xmlWriter;
            OutputStream os = mtomwriter.getOutputStream();
            if (os == null) {
                throw new NullPointerException("can not get output stream from MTOMXMLStreamWriter.");
            }
            try {
                WSSObjectNormalWriter vpw = new WSSObjectNormalWriter(os);
                this.wssObjectDocumentImpl.getRootWSSObject().serialize(vpw, true);
                vpw.flush();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        } else {
            throw new XMLStreamException("writer is not MTOMXMLSTreamWriter");
        }
    }

    private InputStream wrapWithDummyElement(InputStream is) throws XMLStreamException {
        ArrayList<OMNamespace> namespaces = this.wssObjectDocumentImpl.getNamespacesInAncestor().getDeclaredOMNamespacesInAncestor();
        int size = 0;
        if (namespaces != null) {
            size = namespaces.size();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of declared OMNamespaces in ancestor = " + size);
        }
        StringBuffer dummyStart = new StringBuffer();
        dummyStart.append("<dummy");
        for (int i = 0; i < size; ++i) {
            OMNamespace omNamespace = namespaces.get(i);
            String prefix = omNamespace.getPrefix();
            String nsUri = omNamespace.getNamespaceURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "    OMNamespace[" + i + "]: prefix = " + prefix + ", namespace = " + nsUri);
            }
            if ("".equals(prefix)) {
                dummyStart.append(" xmlns=\"");
            } else {
                dummyStart.append(" xmlns:");
                dummyStart.append(prefix);
                dummyStart.append("=\"");
            }
            dummyStart.append(nsUri);
            dummyStart.append("\"");
        }
        dummyStart.append(">");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dummy start element = " + dummyStart);
        }
        InputStream[] inputStreams = new InputStream[3];
        try {
            inputStreams[0] = new ByteArrayInputStream(dummyStart.toString().getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            XMLStreamException xe = new XMLStreamException(e.getMessage());
            xe.initCause(e);
            throw xe;
        }
        inputStreams[1] = is;
        inputStreams[2] = new ByteArrayInputStream(Constants.DUMMY_END_TAG_UTF8_BYTE_ARRAY);
        return new MultipleInputStream(inputStreams);
    }
}

