/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.trust.client.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClient;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClientValidateResult;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustRequesterConfig;
import com.ibm.ws.wssecurity.trust.ext.client.base.TrustProperties;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13Client;
import com.ibm.ws.wssecurity.trust.ext.client.v13.Trust13Properties;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import com.ibm.wsspi.wssecurity.trust.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.trust.config.RequesterConfig;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.List;

public class WSSTrust13ClientFactory
extends WSSTrustClient
implements WSSConstants {
    private static final SecurityPermission ISSUE_TOKEN_PERM = new SecurityPermission("wssapi.TrustClient.issue");

    @Override
    public List<SecurityToken> issue(ProviderConfig providerConfig, List<RequesterConfig> requestConfigs) throws WSSException {
        List securityTokens = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        Trust13Properties trustProperties = new Trust13Properties();
        ITrustProviderConfig trustProviderConfig = (ITrustProviderConfig)providerConfig;
        ArrayList<ITrustRequesterConfig> trustRequestConfigs = new ArrayList<ITrustRequesterConfig>();
        for (RequesterConfig requestConfig : requestConfigs) {
            ((ITrustRequesterConfig)requestConfig).setAction(trustProperties.ACTION_ISSUE);
            ((ITrustRequesterConfig)requestConfig).put("RequestType", trustProperties.REQUESTTYPE_BATCHISSUE);
            trustRequestConfigs.add((ITrustRequesterConfig)requestConfig);
        }
        final Trust13Client client = Trust13Client.getInstance();
        final ITrustProviderConfig prvProviderConfig = trustProviderConfig;
        final ArrayList<ITrustRequesterConfig> prvTrustRequestConfigs = trustRequestConfigs;
        final Trust13Properties prvTrustProperties = trustProperties;
        try {
            securityTokens = (List)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    try {
                        return client.sendList(prvProviderConfig, prvTrustRequestConfigs, (TrustProperties)prvTrustProperties);
                    }
                    catch (SoapSecurityException e) {
                        throw new WSSException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (WSSException)pae.getException();
        }
        return securityTokens;
    }

    @Override
    public List<SecurityToken> issue(ProviderConfig providerConfig, RequesterConfig requestConfig) throws WSSException {
        List securityTokens = null;
        ITrustProviderConfig trustProviderConfig = (ITrustProviderConfig)providerConfig;
        ITrustRequesterConfig trustRequestConfig = (ITrustRequesterConfig)requestConfig;
        Trust13Properties trustProperties = new Trust13Properties();
        trustRequestConfig.setAction(trustProperties.ACTION_ISSUE);
        trustRequestConfig.put("RequestType", trustProperties.REQUESTTYPE_ISSUE);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        final Trust13Client client = Trust13Client.getInstance();
        final ITrustProviderConfig prvTrustProviderConfig = trustProviderConfig;
        final ITrustRequesterConfig prvTrustRequestConfig = trustRequestConfig;
        final Trust13Properties prvTrustProperties = trustProperties;
        try {
            securityTokens = (List)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    try {
                        return client.sendList(prvTrustProviderConfig, prvTrustRequestConfig, (TrustProperties)prvTrustProperties);
                    }
                    catch (SoapSecurityException e) {
                        throw new WSSException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (WSSException)pae.getException();
        }
        return securityTokens;
    }

    @Override
    public List<WSSTrustClientValidateResult> validate(ProviderConfig providerConfig, List<RequesterConfig> requestConfigs) throws WSSException {
        List results = null;
        ITrustProviderConfig trustProviderConfig = (ITrustProviderConfig)providerConfig;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        Trust13Properties trustProperties = new Trust13Properties();
        ArrayList<ITrustRequesterConfig> trustRequestConfigs = new ArrayList<ITrustRequesterConfig>();
        for (RequesterConfig requestConfig : requestConfigs) {
            ((ITrustRequesterConfig)requestConfig).setAction(trustProperties.ACTION_VALIDATE);
            ((ITrustRequesterConfig)requestConfig).put("RequestType", trustProperties.REQUESTTYPE_BATCHVALIDATE);
            trustRequestConfigs.add((ITrustRequesterConfig)requestConfig);
        }
        final Trust13Client client = Trust13Client.getInstance();
        final ITrustProviderConfig prvTrustProviderConfig = trustProviderConfig;
        final ArrayList<ITrustRequesterConfig> prvTrustRequestConfigs = trustRequestConfigs;
        final Trust13Properties prvTrustProperties = trustProperties;
        try {
            results = (List)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    try {
                        return client.sendValidateList(prvTrustProviderConfig, prvTrustRequestConfigs, prvTrustProperties);
                    }
                    catch (SoapSecurityException e) {
                        throw new WSSException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (WSSException)pae.getException();
        }
        return results;
    }

    @Override
    public List<WSSTrustClientValidateResult> validate(ProviderConfig providerConfig, RequesterConfig requestConfig) throws WSSException {
        List results = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ISSUE_TOKEN_PERM);
        }
        ITrustProviderConfig trustProviderConfig = (ITrustProviderConfig)providerConfig;
        ITrustRequesterConfig trustRequestConfig = (ITrustRequesterConfig)requestConfig;
        Trust13Properties trustProperties = new Trust13Properties();
        trustRequestConfig.setAction(trustProperties.ACTION_VALIDATE);
        trustRequestConfig.put("RequestType", trustProperties.REQUESTTYPE_VALIDATE);
        final Trust13Client client = Trust13Client.getInstance();
        final ITrustProviderConfig prvTrustProviderConfig = trustProviderConfig;
        final ITrustRequesterConfig prvTrustRequestConfig = trustRequestConfig;
        final Trust13Properties prvTrustProperties = trustProperties;
        try {
            results = (List)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    try {
                        return client.sendValidate(prvTrustProviderConfig, prvTrustRequestConfig, prvTrustProperties);
                    }
                    catch (SoapSecurityException e) {
                        throw new WSSException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (WSSException)pae.getException();
        }
        return results;
    }
}

