/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.trust.client.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.trust.ext.client.ITrustProviderConfig;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;

public class TrustProviderConfig
implements ITrustProviderConfig {
    ClassLoader appClassLoader = null;
    String applicationName = null;
    String bindingName = null;
    ConfigurationContext configContext = null;
    boolean loadFromJar = false;
    String policySetName = null;
    String provider = null;
    PolicySetConfiguration psc = null;
    String scope = null;
    ClassLoader sysClassLoader = null;
    String wst = null;
    QName serviceName = new QName(null, "service");
    QName portName = new QName(null, "port");
    boolean includeXML = false;

    public TrustProviderConfig() {
    }

    public TrustProviderConfig(String wstNamespace, String providerAddress) throws WSSException {
        this.init(wstNamespace, providerAddress);
    }

    @Override
    public ClassLoader getApplicationClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getBindingName() {
        return this.bindingName;
    }

    @Override
    public String getBindingScope() {
        return this.scope;
    }

    @Override
    public ConfigurationContext getConfigurationContext() {
        return this.configContext;
    }

    @Override
    public String getIssuerURI() {
        return null;
    }

    @Override
    public boolean getLoadPolicySetAndBindingFromJar() {
        return this.loadFromJar;
    }

    @Override
    public PolicySetConfiguration getPolicySetConfiguration() {
        return this.psc;
    }

    @Override
    public String getPolicySetName() {
        return this.policySetName;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public ClassLoader getSystemClassLoader() {
        return this.sysClassLoader;
    }

    @Override
    public String getWSTrustNamespace() {
        return this.wst;
    }

    @Override
    public void init(String wsTrustNamespace, String providerAddress) throws WSSException {
        this.setWSTrustNamespace(wsTrustNamespace);
        this.setProvider(providerAddress);
    }

    @Override
    public void setApplicationClassLoader(ClassLoader appClassLoader) {
        this.appClassLoader = appClassLoader;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    @Override
    public void setBindingScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setConfigurationContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    @Override
    public void setIssuerURI(String uri) {
    }

    @Override
    public void setLoadPolicySetAndBindingFromJar(boolean loadFromJar) {
        this.loadFromJar = loadFromJar;
    }

    @Override
    public void setPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName, String bindingName, String bindingScope, boolean loadFromJar) {
        this.setApplicationClassLoader(appClassLoader);
        this.setSystemClassLoader(this.sysClassLoader);
        this.setPolicySetName(policySetName);
        this.setBindingName(bindingName);
        this.setBindingScope(bindingScope);
        this.setLoadPolicySetAndBindingFromJar(loadFromJar);
    }

    @Override
    public void setPolicySetConfiguration(Object psc) {
        if (psc instanceof PolicySetConfiguration) {
            this.psc = (PolicySetConfiguration)psc;
        }
    }

    @Override
    public void setPolicySetName(String policySetName) {
        this.policySetName = policySetName;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public void setSystemClassLoader(ClassLoader appClassLoader) {
        this.sysClassLoader = this.sysClassLoader;
    }

    @Override
    public void setWSTrustNamespace(String namespace) throws WSSException {
        if (!namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512") && !namespace.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            throw WSSException.format("security.wssecurity.trust.client.wstnamespace", namespace);
        }
        this.wst = namespace;
    }

    @Override
    public void validate() throws SoapSecurityException {
        try {
            new URI(this.provider);
        }
        catch (URISyntaxException e) {
            throw SoapSecurityException.format("security.wssecurity.trust.client.provider", this.provider);
        }
    }

    @Override
    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setPortName(QName portName) {
        this.portName = portName;
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public void setIncludeRSTRProperties(boolean includeXML) {
        this.includeXML = includeXML;
    }

    @Override
    public boolean getIncludeRSTRProperties() {
        return this.includeXML;
    }
}

