/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.BinarySecurityToken;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class X509GenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(X509GenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509GenerateLoginModule.class.getName();
    private static final String VALUE_TYPE = "ValueType".intern();
    private static final String ENCODING_TYPE = "EncodingType".intern();
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.X509Token");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    CallbackHandler _handler;
    List<SecurityToken> _processedTokens;
    List<SecurityToken> _insertedTokens;
    SecurityTokenManager _securityTokenManager;
    Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        boolean isThumbprint;
        X509Certificate x509;
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509GenerateCallback x509Callback = new X509GenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{x509Callback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "138", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", e);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        if (x509Callback.isUsedIdentityAssertion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the certificate of initial sender...");
            }
            if (messageContext == null) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6836E");
                throw new LoginException(errorMes);
            }
            obj = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert");
            if (obj == null || !(obj instanceof X509Certificate)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6836E");
                throw new LoginException(errorMes);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate of initial sender is used.");
            }
            x509 = (X509Certificate)obj;
            try {
                keyInformation = ksManager.getKeyInformation(x509);
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "182", this);
                throw new LoginException(e.toString());
            }
        }
        if (x509Callback.isUsedRequestorCertificate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the certificate of requestor...");
            }
            if (messageContext == null) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(errorMes);
            }
            obj = Axis2Util.getProperty(messageContext, "com.ibm.xml.soapsec.RequestCert");
            if (obj == null || !(obj instanceof X509Certificate)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(errorMes);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate of requestor is used.");
            }
            x509 = (X509Certificate)obj;
            try {
                keyInformation = ksManager.getKeyInformation(x509);
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "206", this);
                throw new LoginException(e.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting the key information using the configuration...");
        }
        try {
            String keyStoreName = x509Callback.getKeyStorePath();
            if (keyStoreName == null) {
                keyStoreName = x509Callback.getKeyStoreReference();
            }
            keyInformation = ksManager.getKeyInformation(keyStoreName, x509Callback.getKeyStoreType(), x509Callback.getKeyStorePassword(), x509Callback.getKeyStoreReference(), x509Callback.getAlias(), x509Callback.getKeyPassword(), x509Callback.getKeyName());
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "222", this);
            throw new LoginException(e.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The key information got with the configuration is used.");
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        Boolean useErrata = false;
        OperationContext opCtx = messageContext.getOperationContext();
        if (opCtx == null) {
            opCtx = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (opCtx != null) {
            MessageContext tempMsgCtx;
            Map.Entry singleMsgCtx;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid operation context to look for USE_X509ERRATA_10 property");
            }
            HashMap allMsgCtxs = opCtx.getMessageContexts();
            Set msgContexts = allMsgCtxs.entrySet();
            Iterator it = msgContexts.iterator();
            Object prop = null;
            HashMap pMap = null;
            while (it.hasNext()) {
                singleMsgCtx = (Map.Entry)it.next();
                tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (pMap == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the WSS_PROPERTYMAP in the msg ctx with key: " + singleMsgCtx.getKey());
                }
                if ((prop = pMap.get("com.ibm.ws.wssecurity.generateX509Errata10Token")) != null) {
                    useErrata = prop;
                    tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", pMap);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did NOT find USE_X509ERRATA_10 in WSS_PROPERTYMAP property map.");
            }
            if (prop == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find USE_X509ERRATA_10 or the WSS_PROPERTYMAP in any message context.Try to find WSS_RAMP_PROPERTYMAP. ");
                }
                while (it.hasNext()) {
                    singleMsgCtx = (Map.Entry)it.next();
                    tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                    pMap = (HashMap)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (pMap == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the WSS_RAMP_PROPERTYMAP in the msg ctx with key: " + singleMsgCtx.getKey());
                    }
                    if ((prop = pMap.get("com.ibm.ws.wssecurity.generateX509Errata10Token")) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found USE_X509ERRATA_10 in WSS_RAMP_PROPERTYMAP property map.");
                        }
                        useErrata = prop;
                        tempMsgCtx.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", pMap);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did NOT find USE_X509ERRATA_10 in WSS_RAMP_PROPERTYMAP property map.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OperationContext was null, cannot look for USE_X509ERRATA_10 in WSS_PROPERTYMAP.");
            }
        }
        String s1 = (String)config2.getProperties().get("com.ibm.ws.wssecurity.generateX509Errata10Token");
        QName valueType = config2.getType();
        if (useErrata.booleanValue()) {
            valueType = com.ibm.ws.wssecurity.common.Constants.X509V3;
        } else if (s1 != null && s1.equals("true")) {
            valueType = com.ibm.ws.wssecurity.common.Constants.X509V3;
            useErrata = true;
        }
        SecurityToken existToken = null;
        String tokenId = null;
        try {
            X509Certificate x5092 = (X509Certificate)keyInformation.getCertificate();
            tokenId = keyInformation.getSubjectDN();
            existToken = X509GenerateLoginModule.getToken(config2, keyInfoType, x5092, this._securityTokenManager);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "242", this);
            throw new LoginException(e.toString());
        }
        boolean isForwardable = true;
        String forwardable = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
            isForwardable = false;
        }
        boolean isStandAlone = config2.isStandAlone();
        if (keyInfoType == null) {
            isThumbprint = false;
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname(keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid(keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb(keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer(keyInfoType);
            isThumbprint = ConfigUtil.isKeyInfoThumbprint(keyInfoType);
        }
        if (existToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + tokenId + "] stored in the Subject.");
            }
            Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            X509TokenImpl x509Token = (X509TokenImpl)_tokenFactory.getToken(isForwardable);
            if (useErrata.booleanValue()) {
                x509Token.setTokenToErrata10();
            }
            try {
                QName etype;
                tokenId = null;
                if (isStandAlone) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    x509Token.setId(tokenId);
                    X509GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, x509Token, true, this._context);
                    this._processedTokens.add(x509Token);
                    this._insertedTokens.add(x509Token);
                } else if (isStrref) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    x509Token.setId(tokenId);
                    x509Token.setReferenceURI("#" + tokenId);
                    X509GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, x509Token, true, this._context);
                    this._processedTokens.add(x509Token);
                    this._insertedTokens.add(x509Token);
                } else if (isEmb) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    x509Token.setId(tokenId);
                    X509GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, x509Token, false, this._context);
                    this._processedTokens.add(x509Token);
                    this._insertedTokens.add(x509Token);
                } else if (isKeyId) {
                    etype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    QName idtype = (QName)this._context.get(Constants.WSSECURITY_KEY_IDTYPE);
                    tokenId = X509GenerateLoginModule.getKeyIdentifier(keyInformation, etype, idtype);
                    x509Token.setId(tokenId);
                    x509Token.setKeyIdentifier(tokenId);
                    x509Token.setKeyIdentifierEncodingType(etype);
                    this._processedTokens.add(x509Token);
                } else if (isThumbprint) {
                    etype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    if (etype == null) {
                        etype = com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY;
                    }
                    tokenId = X509GenerateLoginModule.getThumbprint(keyInformation, etype);
                    x509Token.setId(tokenId);
                    x509Token.setThumbprint(tokenId);
                    x509Token.setThumbprintEncodingType(etype);
                    x509Token.setThumbprintValueType(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1);
                    this._processedTokens.add(x509Token);
                } else if (isKeyName) {
                    tokenId = keyInformation.getSubjectDN();
                    x509Token.setId(tokenId);
                    x509Token.setKeyName(tokenId);
                    this._processedTokens.add(x509Token);
                } else if (isX509) {
                    String issuerName = keyInformation.getIssuerDN();
                    String issuerSerial = keyInformation.getIssuerSerial();
                    tokenId = issuerName + ":" + issuerSerial;
                    x509Token.setId(tokenId);
                    x509Token.setIssuerName(issuerName);
                    x509Token.setIssuerSerial(issuerSerial);
                    this._processedTokens.add(x509Token);
                }
                final X509TokenImpl tempToken = x509Token;
                final X509Certificate tempx509 = (X509Certificate)keyInformation.getCertificate();
                final byte[] tempbinary = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        tempToken.setCertificate(tempx509);
                        tempToken.setBinary(tempbinary);
                        return null;
                    }
                });
                x509Token.setKey(62, keyInformation.getPublicOrSecretKey());
                x509Token.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "368", this);
                throw new LoginException(e.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is the token [" + existToken.getId() + "] stored in the Subject.");
        }
        if (isStandAlone) {
            this._processedTokens.add(existToken);
        } else if (isStrref) {
            this._processedTokens.add(existToken);
        } else if (isEmb) {
            X509TokenImpl x509Token = (X509TokenImpl)_tokenFactory.getToken(isForwardable);
            if (useErrata.booleanValue()) {
                x509Token.setTokenToErrata10();
            }
            try {
                x509Token.setId(IdUtils.getInstance().makeUniqueId(this._context, "x509bst_"));
                final X509TokenImpl tempToken = x509Token;
                final X509Certificate tempx509 = (X509Certificate)keyInformation.getCertificate();
                final byte[] tempbinary = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        tempToken.setCertificate(tempx509);
                        tempToken.setBinary(tempbinary);
                        return null;
                    }
                });
                x509Token.setKey(62, keyInformation.getPublicOrSecretKey());
                x509Token.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "399", this);
                throw new LoginException(e.toString());
            }
            this._processedTokens.add(x509Token);
            this._insertedTokens.add(x509Token);
        } else if (isKeyId) {
            this._processedTokens.add(existToken);
        } else if (isThumbprint) {
            this._processedTokens.add(existToken);
        } else if (isKeyName) {
            this._processedTokens.add(existToken);
        } else if (isX509) {
            this._processedTokens.add(existToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig config2, String keyInfoType, Certificate cert, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("Certificate cert, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2, keyInfoType);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                if (!(t instanceof X509Token) || !((X509Token)t).getCertificate().equals(cert)) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("Map, TokenGeneratorConfig, String, Certificate)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final String getKeyIdentifier(KeyStoreManager.KeyInformation keyInformation, QName etype, QName idtype) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyIdentifier(");
            buf.append("KeyInformation keyInformation, ");
            buf.append("QName etype[").append(etype).append("], ");
            buf.append("QName idtype[").append(idtype).append("])");
            Tr.entry(tc, buf.toString());
        }
        String keyIdentifier = null;
        if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
            if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                try {
                    keyIdentifier = keyInformation.getB64KeyId();
                }
                catch (SoapSecurityException e) {
                    Tr.processException(e, clsName + ".getKeyIdentifier", "555");
                    throw new LoginException(e.toString());
                }
            } else {
                if (!NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{idtype.toString()});
                    throw new LoginException(errorMes);
                }
                try {
                    keyIdentifier = keyInformation.getB64KeyId60();
                }
                catch (SoapSecurityException e) {
                    Tr.processException(e, clsName + ".getKeyIdentifier", "563");
                    throw new LoginException(e.toString());
                }
            }
        } else {
            if (!NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{etype.toString()});
                throw new LoginException(errorMes);
            }
            if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                try {
                    keyIdentifier = keyInformation.getHexKeyId();
                }
                catch (SoapSecurityException e) {
                    Tr.processException(e, clsName + ".getKeyIdentifier", "579");
                    throw new LoginException(e.toString());
                }
            }
            if (!NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{idtype.toString()});
                throw new LoginException(errorMes);
            }
            try {
                keyIdentifier = keyInformation.getHexKeyId60();
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, clsName + ".getKeyIdentifier", "508");
                throw new LoginException(e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyIdentifier(");
            buf.append("KeyInformation, QName, QName)");
            buf.append(" returns String[").append(keyIdentifier).append("]");
            Tr.entry(tc, buf.toString());
        }
        return keyIdentifier;
    }

    private static final String getThumbprint(KeyStoreManager.KeyInformation keyInformation, QName etype) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getThumbprint(");
            buf.append("KeyInformation keyInformation, ");
            buf.append("QName etype[").append(etype).append("])");
            Tr.entry(tc, buf.toString());
        }
        String thumbprint = null;
        if (NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
            try {
                thumbprint = keyInformation.getB64Thumbprint();
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, clsName + ".getThumbprint", "628");
                throw new LoginException(e.toString());
            }
        } else if (NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
            try {
                thumbprint = keyInformation.getHexThumbprint();
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, clsName + ".getThumbprint", "636");
                throw new LoginException(e.toString());
            }
        } else {
            String errorMes = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{etype.toString()});
            throw new LoginException(errorMes);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getThumbprint(");
            buf.append("KeyInformation, QName)");
            buf.append(" returns String[").append(thumbprint).append("]");
            Tr.entry(tc, buf.toString());
        }
        return thumbprint;
    }

    static final void createOMTokenElement(OMFactory factory, OMElement parent, QName valueType, KeyStoreManager.KeyInformation keyInformation, X509TokenImpl token, boolean insertId, Map<Object, Object> context) throws LoginException {
        String id;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("KeyInformation keyInformation, X509TokenImpl token, ");
            buf.append("boolean insertId[").append(insertId).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement tokenElem = factory.createOMElement("BinarySecurityToken", nsWsse, pWsse);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsse, pWsse);
        }
        if (insertId && (id = token.getId()) != null) {
            isDecl = false;
            String pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                tokenElem.declareNamespace(nsWsu, pWsu);
            }
            tokenElem.addAttribute("Id", id, tokenElem.getOMFactory().createOMNamespace(nsWsu, pWsu));
        }
        DOMUtils.setQNameAttr(tokenElem, null, ENCODING_TYPE, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, wssVersion);
        DOMUtils.setQNameAttr(tokenElem, null, VALUE_TYPE, valueType, wssVersion);
        String binary = null;
        try {
            binary = keyInformation.getEncodedBinary();
        }
        catch (SoapSecurityException e) {
            Tr.processException(e, clsName + ".login", "720");
            throw new LoginException(e.toString());
        }
        if (binary != null) {
            tokenElem.addChild(factory.createOMText(binary));
        }
        token.setXML(new OMStructure(tokenElem));
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory, OMElement, QName, KeyInformation, ");
            buf.append("X509TokenImpl, boolean, Map)");
            buf.append(" returns OMElement [").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
    }

    static final void createWSSObjectTokenElement(WSSObjectElement parent, QName valueType, KeyStoreManager.KeyInformation keyInformation, X509TokenImpl token, boolean insertId, Map<Object, Object> context) throws LoginException {
        String id;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createWSSObjectTokenElement(");
            buf.append("WSSObjectElement parent[").append(parent.getQName()).append("], ");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("KeyInformation keyInformation, X509TokenImpl token, ");
            buf.append("boolean insertId[").append(insertId).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        BinarySecurityToken tokenElem = new BinarySecurityToken(parent.getWSSObjectDocument());
        if (insertId && (id = token.getId()) != null && !id.isEmpty()) {
            tokenElem.setWsuId(VariablePartFactory.getInstance().createAttrValueWithString(id));
        }
        tokenElem.setEncodingType(VariablePartFactory.getInstance().createAttrValueWithString(com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY_STRING));
        tokenElem.setValueType(VariablePartFactory.getInstance().createAttrValueWithString(valueType.toString()));
        byte[] binary = null;
        try {
            binary = keyInformation.getBinary();
            if (binary != null) {
                VariablePartTextValue varPart = VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(binary);
                tokenElem.setContent(varPart);
                varPart.calcCache();
            }
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".login", "903");
            throw new LoginException(e.toString());
        }
        token.setXML(new WSSObjectStructureImpl(tokenElem));
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("WSSObjectElement, QName, KeyInformation, ");
            buf.append("X509TokenImpl, boolean, Map)");
            buf.append(" returns WSSObjectElement [").append(tokenElem.getQName()).append("]");
            Tr.exit(tc, buf.toString());
        }
    }

    static final void createTokenElement(Object parent, QName valueType, KeyStoreManager.KeyInformation keyInformation, X509TokenImpl token, boolean insertId, Map<Object, Object> context) throws LoginException {
        if (parent instanceof WSSObjectElement) {
            X509GenerateLoginModule.createWSSObjectTokenElement((WSSObjectElement)parent, valueType, keyInformation, token, insertId, context);
        } else {
            X509GenerateLoginModule.createOMTokenElement(((OMElement)parent).getOMFactory(), (OMElement)parent, valueType, keyInformation, token, insertId, context);
        }
    }
}

