/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis2.util.ObjectStateUtils;

public class UsernameTokenImpl
extends SecurityTokenImpl
implements UsernameToken {
    private static final TraceComponent tc = Tr.register(UsernameTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 993421755380734658L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission GETPASSWORD_PERM = new SecurityPermission("wssapi.UsernameToken.getPassword");
    private static final SecurityPermission GETXML_PERM = new SecurityPermission("wssapi.UsernameToken.getXML");
    private static final SecurityPermission SETUSERNAME_PERM = new SecurityPermission("wssapi.UsernameToken.setUsername");
    private static final SecurityPermission SETPASSWORD_PERM = new SecurityPermission("wssapi.UsernameToken.setPassword");
    private static final SecurityPermission SETCREATED_PERM = new SecurityPermission("wssapi.UsernameToken.setCreated");
    private static final SecurityPermission SETNONCE_PERM = new SecurityPermission("wssapi.UsernameToken.setNonce");
    protected String username;
    protected char[] password;
    protected int hashcode = 0;
    private Date created;
    private byte[] nonce;

    public UsernameTokenImpl() {
        this.tokenQName = UsernameToken.TokenQname;
        this.valueType = UsernameToken.ValueType;
        this.hashcode = SecurityUIDGenerator.createUID().hashCode();
    }

    public void setValueType(QName aValueType) {
        this.valueType = aValueType;
    }

    @Override
    public String getId() {
        if (this.id == null || this.id.length() == 0) {
            int value = 0;
            value = SecurityUIDGenerator.createUID().hashCode();
            this.id = "unt_" + String.valueOf(value);
        }
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSERNAME_PERM.toString());
            }
            sm.checkPermission(SETUSERNAME_PERM);
        }
        if (!this.readOnly) {
            this.username = username;
            this.principal = username;
        }
    }

    @Override
    public char[] getPassword() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETPASSWORD_PERM.toString());
            }
            sm.checkPermission(GETPASSWORD_PERM);
        }
        char[] password = this.password;
        if (this.readOnly && password != null) {
            int passwordlen = this.password.length;
            password = new char[passwordlen];
            System.arraycopy(this.password, 0, password, 0, passwordlen);
        }
        return password;
    }

    public void setPassword(char[] password) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPASSWORD_PERM.toString());
            }
            sm.checkPermission(SETPASSWORD_PERM);
        }
        if (!this.readOnly) {
            this.password = password;
        }
    }

    @Override
    public Date getCreatedTime() {
        Date created = this.created;
        if (this.readOnly && created != null) {
            created = (Date)this.created.clone();
        }
        return created;
    }

    public void setCreatedTime(Date created) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCREATED_PERM.toString());
            }
            sm.checkPermission(SETCREATED_PERM);
        }
        if (!this.readOnly) {
            this.created = created;
        }
    }

    @Override
    public byte[] getNonce() {
        byte[] nonce = this.nonce;
        if (this.readOnly && this.nonce != null) {
            int noncelen = this.nonce.length;
            nonce = new byte[noncelen];
            System.arraycopy(this.nonce, 0, nonce, 0, noncelen);
        }
        return nonce;
    }

    public void setNonce(byte[] nonce) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETNONCE_PERM.toString());
            }
            sm.checkPermission(SETNONCE_PERM);
        }
        if (!this.readOnly) {
            this.nonce = nonce;
        }
    }

    public int getIteration() {
        return 0;
    }

    public String getSalt() {
        return null;
    }

    @Override
    public XMLStructure getXML() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETXML_PERM.toString());
            }
            sm.checkPermission(GETXML_PERM);
        }
        XMLStructure xml = this.xml;
        if (this.readOnly && xml != null) {
            xml = new OMStructure(((OMStructure)xml).getNode().cloneOMElement());
        }
        return xml;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ":" + this.principal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsernameToken)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            StringBuffer hashString = new StringBuffer();
            if (this.getId() != null) {
                hashString.append(this.getId());
            }
            if (this.username != null) {
                hashString.append(this.username);
            }
            if (this.password != null) {
                hashString.append(new String(this.password));
            }
            this.hashcode = hashString.length() > 0 ? hashString.hashCode() : SecurityUIDGenerator.createUID().hashCode();
        }
        return this.hashcode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        String version = ObjectStateUtils.readString(in, "UsernameToken.version");
        if (VERSION_NUMBER.equals(version)) {
            this.username = ObjectStateUtils.readString(in, "UsernameToken.username");
            Object tmp = ObjectStateUtils.readObject(in, "UsernameToken.password");
            if (tmp != null) {
                this.password = (char[])tmp;
            }
            if ((tmp = ObjectStateUtils.readObject(in, "UsernameToken.created")) != null) {
                this.created = (Date)tmp;
            }
            if ((tmp = ObjectStateUtils.readObject(in, "UsernameToken.nonce")) != null) {
                this.nonce = (byte[])tmp;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectStateUtils.writeString(out, VERSION_NUMBER, "UsernameToken.version");
        ObjectStateUtils.writeString(out, this.username, "UsernameToken.username");
        ObjectStateUtils.writeObject(out, this.password, "UsernameToken.password");
        ObjectStateUtils.writeObject(out, this.created, "UsernameToken.created");
        ObjectStateUtils.writeObject(out, this.nonce, "UsernameToken.nonce");
    }
}

