/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSRealmFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Password;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.UsernameToken;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;

public class UNTGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UNTGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UNTGenerateLoginModule.class.getName();
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        com.ibm.websphere.wssecurity.wssapi.token.UsernameToken tokenPriv;
        com.ibm.websphere.wssecurity.wssapi.token.UsernameToken token;
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        NameCallback usernameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("passowrd: ", false);
        UNTGenerateCallback untCallback = new UNTGenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{usernameCallback, passwordCallback, untCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "112", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", e);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        NonceManager nmanager = (NonceManager)this._context.get(NonceManager.class);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        Boolean usingGUICBH = (Boolean)this._context.remove("com.ibm.ws.wssecurity.wssapi.token.impl.UNTGenerateLoginModule.GUIUNTisUsed");
        String username = null;
        char[] password = null;
        String passwordStr = null;
        boolean setNonce = untCallback.isNonce();
        boolean setCreatedTimestamp = untCallback.isCreatedTimestamp();
        if (untCallback.isUsingIdentityAssertion()) {
            if (untCallback.isUsingRunAsSubject()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the RunAs identity...");
                }
                try {
                    username = WSSRealmFactory.getInstance().getRealmQualifiedRunAsIdentity(messageContext, untCallback.isSendRealm(), untCallback.isUsingTrustedRealm());
                }
                catch (SoapSecurityException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught: " + e.getMessage() + e.getCause());
                    }
                    throw new LoginException(e.getMessage());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the identifier of initial sender...");
                }
                if (messageContext != null && (obj = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderId")) != null && obj instanceof com.ibm.websphere.wssecurity.wssapi.token.UsernameToken) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The identifier of initial sender is used.");
                    }
                    token = (com.ibm.websphere.wssecurity.wssapi.token.UsernameToken)obj;
                    username = token.getUsername();
                    if (untCallback.isUsingTrustedRealm()) {
                        tokenPriv = token;
                        char[] tmp_password = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return tokenPriv.getPassword();
                            }
                        });
                        String string = passwordStr = tmp_password == null ? null : tmp_password.toString();
                    }
                }
                if (username == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Use username and password set by callbach handler [" + this._handler + "].");
                    }
                    username = usernameCallback.getName();
                    if (untCallback.isUsingTrustedRealm()) {
                        char[] tmp_password = passwordCallback.getPassword();
                        passwordStr = tmp_password == null ? null : tmp_password.toString();
                    }
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Use username = " + username + " password = " + (passwordStr == null ? "null" : "not null"));
                    }
                    username = WSSRealmFactory.getInstance().getRealmQualifiedIdentity(username, passwordStr, untCallback.isSendRealm(), untCallback.isUsingTrustedRealm());
                }
                catch (SoapSecurityException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught: " + e.getMessage() + e.getCause());
                    }
                    throw new LoginException(e.getMessage());
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the cached username token...");
            }
            if (messageContext != null) {
                obj = null;
                if (usingGUICBH != null && !WSSContextManagerFactory.getInstance().processIsServer()) {
                    Set<SecurityTokenWrapper> set;
                    Subject subject;
                    block50: {
                        WSSContext context = null;
                        Object cntxt = messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                        if (!(cntxt instanceof WSSContext)) {
                            cntxt = messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssLoginPromptContext");
                        }
                        context = (WSSContext)cntxt;
                        subject = null;
                        try {
                            subject = context.getRunAsSubject(messageContext);
                        }
                        catch (SoapSecurityException se) {
                            if (!tc.isDebugEnabled()) break block50;
                            Tr.debug(tc, "Exception caught " + se.getMessage());
                        }
                    }
                    if (subject != null && (set = subject.getPrivateCredentials(SecurityTokenWrapper.class)) != null && !set.isEmpty()) {
                        for (SecurityTokenWrapper stw : set) {
                            SecurityToken t = stw.getSecurityToken();
                            if (t == null || !(t instanceof com.ibm.websphere.wssecurity.wssapi.token.UsernameToken) || stw.getEndPoint() == null || stw.getEndPoint().length() <= 0 || messageContext.getTo() == null || !messageContext.getTo().getAddress().equals(stw.getEndPoint())) continue;
                            obj = t;
                            break;
                        }
                    }
                }
                if (obj != null && obj instanceof com.ibm.websphere.wssecurity.wssapi.token.UsernameToken) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The cached username token is used.");
                    }
                    token = (com.ibm.websphere.wssecurity.wssapi.token.UsernameToken)obj;
                    username = token.getUsername();
                    tokenPriv = token;
                    password = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return tokenPriv.getPassword();
                        }
                    });
                }
            }
            if (username == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use username and password set by callbach handler [" + this._handler + "].");
                }
                username = usernameCallback.getName();
                password = passwordCallback.getPassword();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Acquired username is [" + username + "].");
            Tr.debug(tc, "Acuqired password is [" + (password == null ? "null" : "XXXXXXXX") + "].");
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        boolean isForwardable = true;
        String forwardable = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
            isForwardable = false;
        }
        SecurityToken existToken = null;
        String tokenId = IdUtils.getInstance().makeUniqueId(this._context, "unt_");
        try {
            existToken = UNTGenerateLoginModule.getToken(config2, username, password, this._securityTokenManager);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "209", this);
            throw new LoginException(e.toString());
        }
        if (existToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + tokenId + "] stored in the Subject.");
            }
            UsernameTokenImpl untToken = (UsernameTokenImpl)_tokenFactory.getToken(isForwardable);
            final String usernamePriv = username;
            final char[] passwordPriv = password;
            final UsernameTokenImpl tokenSetUsernamePriv = untToken;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tokenSetUsernamePriv.setUsername(usernamePriv);
                    tokenSetUsernamePriv.setPassword(passwordPriv);
                    return null;
                }
            });
            untToken.setKey(61, null);
            untToken.setKey(62, null);
            untToken.setId(tokenId);
            int wssVersion = 0;
            Object obj2 = null;
            obj2 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj2 != null && obj2 instanceof Integer) {
                wssVersion = (Integer)obj2;
            }
            Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            XMLStructure xml = UNTGenerateLoginModule.createTokenElement(parent, username, password, tokenId, setNonce, setCreatedTimestamp, wssVersion, nmanager);
            untToken.setXML(xml);
            if (usingGUICBH != null && !WSSContextManagerFactory.getInstance().processIsServer()) {
                Subject subject;
                block51: {
                    WSSContext context = null;
                    Object cntxt = messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                    if (!(cntxt instanceof WSSContext)) {
                        cntxt = messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssLoginPromptContext");
                    }
                    context = (WSSContext)cntxt;
                    subject = null;
                    try {
                        subject = context.getRunAsSubject(messageContext);
                        if (subject == null) {
                            subject = new Subject();
                            context.setRunAsSubject(subject, messageContext);
                        }
                    }
                    catch (SoapSecurityException se) {
                        if (!tc.isDebugEnabled()) break block51;
                        Tr.debug(tc, "Exception caught " + se.getMessage());
                    }
                }
                if (subject != null && messageContext.getTo() != null) {
                    SecurityTokenWrapper stw = new SecurityTokenWrapper(untToken);
                    stw.setEndPoint(messageContext.getTo().getAddress());
                    subject.getPrivateCredentials().add(stw);
                }
            }
            this._processedTokens.add(untToken);
            this._insertedTokens.add(untToken);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + existToken.getId() + "] stored in the Subject.");
            }
            this._processedTokens.add(existToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig config2, String username, char[] password, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("String username[").append(username).append("], ");
            buf.append("char[] password[");
            buf.append(password == null ? "null" : "not null");
            buf.append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                com.ibm.websphere.wssecurity.wssapi.token.UsernameToken ut;
                if (!(t instanceof com.ibm.websphere.wssecurity.wssapi.token.UsernameToken) || !(ut = (com.ibm.websphere.wssecurity.wssapi.token.UsernameToken)t).getUsername().equals(username) || !UNTGenerateLoginModule.equalsCharArray(((com.ibm.websphere.wssecurity.wssapi.token.UsernameToken)t).getPassword(), password)) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig, String, char[], SecurityTokenManager)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private static final OMElement createOMTokenElement(OMFactory factory, OMElement parent, String username, char[] password, String id, boolean setNonce, boolean setCreatedTimestamp, int wssVersion, NonceManager nmanager) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("String username[").append(username).append("], ");
            buf.append("char[] password [");
            buf.append(password == null ? "null" : "not null").append("], ");
            buf.append("String id[").append(id).append("], ");
            buf.append("boolean setNonce[").append(setNonce).append("], ");
            buf.append("boolean setCreatedTimestamp[").append(setCreatedTimestamp).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("NonceManager nmanager)");
            Tr.entry(tc, buf.toString());
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement tokenElem = factory.createOMElement("UsernameToken", nsWsse, pWsse);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsse, pWsse);
        }
        if (id != null) {
            isDecl = false;
            String pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                tokenElem.declareNamespace(nsWsu, pWsu);
            }
            tokenElem.addAttribute("Id", id, tokenElem.getOMFactory().createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, pWsu));
        }
        OMElement un = factory.createOMElement("Username", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, pWsse);
        un.addChild(factory.createOMText(username));
        tokenElem.addChild(un);
        if (password != null && password.length > 0) {
            OMElement pwd = factory.createOMElement("Password", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, pWsse);
            DOMUtils.setQNameAttr(pwd, null, "Type", com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT, wssVersion);
            pwd.addChild(factory.createOMText(new String(password)));
            tokenElem.addChild(pwd);
        }
        if (setCreatedTimestamp) {
            try {
                NonceUtil.addCreated(factory, tokenElem, nsWsu);
            }
            catch (SoapSecurityException e) {
                throw new LoginException(e.toString());
            }
        }
        if (setNonce) {
            try {
                NonceUtil.addNonce(factory, tokenElem, nsWsse, nmanager, null);
            }
            catch (SoapSecurityException e) {
                throw new LoginException(e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory, OMElement, String, char[], String, boolean, boolean, int)");
            buf.append(" returns OMElement [").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private static final WSSObjectElement createWSSObjectTokenElement(WSSObjectElement parent, String username, char[] password, String id, boolean setNonce, boolean setCreatedTimestamp, int wssVersion, NonceManager nmanager) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createWSSObjectTokenElement(");
            buf.append("WSSObjectElement parent[").append(parent.getQName()).append("], ");
            buf.append("String username[").append(username).append("], ");
            buf.append("char[] password [");
            buf.append(password == null ? "null" : "not null").append("], ");
            buf.append("String id[").append(id).append("], ");
            buf.append("boolean setNonce[").append(setNonce).append("], ");
            buf.append("boolean setCreatedTimestamp[").append(setCreatedTimestamp).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("NonceManager nmanager)");
            Tr.entry(tc, buf.toString());
        }
        WSSObjectDocumentImpl doc = parent.getWSSObjectDocument();
        UsernameToken tokenElem = new UsernameToken(doc);
        if (id != null && !id.isEmpty()) {
            tokenElem.setWsuId(VariablePartFactory.getInstance().createAttrValueWithString(id));
        }
        tokenElem.setUsername(VariablePartFactory.getInstance().createTextValueWithString(username));
        if (password != null && password.length > 0) {
            Password pwdElem = new Password(doc);
            pwdElem.setType(VariablePartFactory.getInstance().createAttrValueWithString(com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT_STRING));
            pwdElem.setPassword(VariablePartFactory.getInstance().createTextValueWithString(new String(password)));
            tokenElem.addChild(pwdElem);
        }
        if (setCreatedTimestamp) {
            WSSObjectUtils.addCreated(tokenElem);
        }
        if (setNonce) {
            try {
                WSSObjectUtils.addNonce(tokenElem, nmanager);
            }
            catch (SoapSecurityException e) {
                throw new LoginException(e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createWSSObjectTokenElement(");
            buf.append("WSSObjectElement, String, char[], String, boolean, boolean, int)");
            buf.append(" returns WSSObjectElement [").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private static final XMLStructure createTokenElement(Object parent, String username, char[] password, String id, boolean setNonce, boolean setCreatedTimestamp, int wssVersion, NonceManager nmanager) throws LoginException {
        XMLStructure xml = null;
        if (parent instanceof WSSObjectElement) {
            WSSObjectElement elem = UNTGenerateLoginModule.createWSSObjectTokenElement((WSSObjectElement)parent, username, password, id, setNonce, setCreatedTimestamp, wssVersion, nmanager);
            xml = new WSSObjectStructureImpl(elem);
        } else {
            OMElement elem = UNTGenerateLoginModule.createOMTokenElement(((OMElement)parent).getOMFactory(), (OMElement)parent, username, password, id, setNonce, setCreatedTimestamp, wssVersion, nmanager);
            xml = new OMStructure(elem);
        }
        return xml;
    }

    private static final boolean equalsCharArray(char[] a, char[] b) {
        boolean ret;
        block6: {
            block5: {
                ret = true;
                if (a != null) break block5;
                if (b == null) break block6;
                ret = false;
                break block6;
            }
            if (b == null) {
                ret = false;
            } else {
                int al = a.length;
                int bl = b.length;
                if (al != bl) {
                    ret = false;
                } else {
                    for (int i = 0; i < al; ++i) {
                        if (a[i] == b[i]) continue;
                        ret = false;
                        break;
                    }
                }
            }
        }
        return ret;
    }
}

