/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.wssapi.DOMStructure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Key;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.axis2.util.XMLUtils;

public class SecurityTokenWrapper
implements SecurityToken,
Consumable,
Generatable,
Externalizable,
com.ibm.ws.wssecurity.wssapi.token.SecurityTokenWrapper {
    private static final TraceComponent tc = Tr.register(SecurityTokenWrapper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final long serialVersionUID = 6615415757895974041L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission SETKEYINFOTYPE_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setKeyInfoType");
    private static final SecurityPermission SETUSEDTOKENCONSUMER_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedTokenConsumer");
    private static final SecurityPermission SETUSEDTOKENGENERATOR_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedTokenGenerator");
    private static final SecurityPermission SETREADONLY_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setReadOnly");
    private static final SecurityPermission SETREFERENCED_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setReferenced");
    private static final SecurityPermission SETPROCESSED_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setProcessed");
    private static final SecurityPermission SETERROR_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setError");
    private static final SecurityPermission SETUSEDTOLOGIN_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedToLogin");
    private static Map<Integer, String> referenceMap = new HashMap<Integer, String>();
    private String wssapiLoginConfigName;
    private CallbackHandler wssapiCallbackHandler;
    private int wssapiReferenceType;
    private SecurityToken securityToken;
    private String keyInfoType;
    private SoapSecurityException error;
    private int usedTokenGeneratorHash;
    private int usedTokenConsumerHash;
    private int usedTokenConsumerClass;
    private boolean referenced;
    private boolean processed;
    private boolean usedToLogin;
    private String keyInfoUniqueID;
    private transient DOMStructure currentDOM;
    private transient com.ibm.wsspi.wssecurity.wssapi.OMStructure OMSfromCurrentDOM;
    private boolean defaultImpl = false;
    private boolean readOnly = false;
    private String endPoint = "";

    public SecurityTokenWrapper(SecurityToken securityToken) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
    }

    public SecurityTokenWrapper(SecurityToken securityToken, CallbackHandler callbackHandler, String loginConfigName) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
        this.wssapiCallbackHandler = callbackHandler;
        this.wssapiLoginConfigName = loginConfigName;
    }

    public SecurityTokenWrapper(SecurityToken securityToken, CallbackHandler callbackHandler, boolean isGenerator) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
        this.wssapiCallbackHandler = callbackHandler;
        Map<QName, TokenMapping> dvmap = DefaultValueManager.getInstance().getTokenMapping();
        TokenMapping tm = dvmap.get(securityToken.getValueType());
        String login = isGenerator ? tm.getJaasLoginConfigNameForGenerator() : tm.getJaasLoginConfigNameForConsumer();
        this.wssapiLoginConfigName = login;
    }

    @Override
    public Key getKey(int keyType) throws WSSException {
        return this.securityToken.getKey(keyType);
    }

    @Override
    public XMLStructure getXML() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecurityTokenWrapper:getXML()...readonly: " + this.isReadOnly());
        }
        XMLStructure xml = this.securityToken.getXML();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityToken XMLStructure: " + xml);
            Tr.debug(tc, "SecurityToken XMLStructure hash: " + xml.hashCode());
        }
        if (!this.defaultImpl && xml != null) {
            if (xml instanceof DOMStructure) {
                if (this.currentDOM == null || !xml.equals(this.currentDOM)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Current DOM Element hash: " + (this.currentDOM == null ? null : Integer.valueOf(this.currentDOM.hashCode())));
                        }
                        this.currentDOM = (DOMStructure)xml;
                        OMElement ome = XMLUtils.toOM(this.currentDOM.getNode());
                        this.OMSfromCurrentDOM = new OMStructure(ome);
                    }
                    catch (Exception sse) {
                        if (tc.isDebugEnabled()) {
                            Tr.error(tc, ConfigUtil.getMessage("security.wssecurity.X509TokenConsumer.s01", new String[]{sse.getMessage()}));
                        }
                        return null;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Saved current DOM: " + this.currentDOM);
                    Tr.debug(tc, "Saved current OMStructure from DOM: " + this.OMSfromCurrentDOM);
                }
                xml = this.readOnly ? new OMStructure(this.OMSfromCurrentDOM.getNode().cloneOMElement()) : this.OMSfromCurrentDOM;
            } else if (xml instanceof com.ibm.wsspi.wssecurity.wssapi.OMStructure) {
                if (this.readOnly) {
                    xml = new OMStructure(((com.ibm.wsspi.wssecurity.wssapi.OMStructure)xml).getNode().cloneOMElement());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.error(tc, "Unexpected XMLStructure: " + xml);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecurityTokenWrapper:getXML() exits...");
        }
        return xml;
    }

    @Override
    public String getId() {
        return this.securityToken.getId();
    }

    @Override
    public String getReferenceURI() {
        return this.securityToken.getReferenceURI();
    }

    @Override
    public String getKeyIdentifier() {
        return this.securityToken.getKeyIdentifier();
    }

    @Override
    public QName getKeyIdentifierEncodingType() {
        return this.securityToken.getKeyIdentifierEncodingType();
    }

    @Override
    public QName getKeyIdentifierValueType() {
        return this.securityToken.getKeyIdentifierEncodingType();
    }

    @Override
    public String getKeyName() {
        return this.securityToken.getKeyName();
    }

    @Override
    public QName getValueType() {
        return this.securityToken.getValueType();
    }

    @Override
    public QName getTokenQname() {
        return this.securityToken.getTokenQname();
    }

    @Override
    public String getThumbprint() {
        return this.securityToken.getThumbprint();
    }

    @Override
    public QName getThumbprintValueType() {
        return this.securityToken.getThumbprintValueType();
    }

    @Override
    public QName getThumbprintEncodingType() {
        return this.securityToken.getThumbprintEncodingType();
    }

    @Override
    public String getPrincipal() {
        return this.securityToken.getPrincipal();
    }

    public CallbackHandler getWssapiCallbackHandler() {
        return this.wssapiCallbackHandler;
    }

    public String getWssapiLoginConfigName() {
        return this.wssapiLoginConfigName;
    }

    public int getWssapiReferenceType() {
        return this.wssapiReferenceType;
    }

    public String getWssapiReferenceTypeByStr() {
        return referenceMap.get(this.wssapiReferenceType);
    }

    public void setWssapiReferenceType(int referenceType) {
        this.wssapiReferenceType = referenceType;
    }

    @Override
    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public String getKeyInfoType() {
        return this.keyInfoType;
    }

    public void setKeyInfoType(String keyInfoType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETKEYINFOTYPE_PERM.toString());
            }
            sm.checkPermission(SETKEYINFOTYPE_PERM);
        }
        if (!this.readOnly) {
            this.keyInfoType = keyInfoType;
        }
    }

    public int getUsedTokenGeneratorHash() {
        return this.usedTokenGeneratorHash;
    }

    public void setUsedTokenGenerator(int usedConfigHash) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENGENERATOR_PERM.toString());
            }
            sm.checkPermission(SETUSEDTOKENGENERATOR_PERM);
        }
        if (!this.readOnly) {
            this.usedTokenGeneratorHash = usedConfigHash;
        }
    }

    public int getUsedTokenConsumerClass() {
        return this.usedTokenConsumerClass;
    }

    public int getUsedTokenConsumerHash() {
        return this.usedTokenConsumerHash;
    }

    public void setUsedTokenConsumer(int usedConfigHash, int usedConfigClass) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENCONSUMER_PERM.toString());
            }
            sm.checkPermission(SETUSEDTOKENCONSUMER_PERM);
        }
        if (!this.readOnly) {
            this.usedTokenConsumerHash = usedConfigHash;
            this.usedTokenConsumerClass = usedConfigClass;
        }
    }

    public String getKeyInfoUniqueID() {
        return this.keyInfoUniqueID;
    }

    public void setKeyInfoUniqueID(String keyInfoId) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETKEYINFOTYPE_PERM.toString());
            }
            sm.checkPermission(SETKEYINFOTYPE_PERM);
        }
        if (!this.readOnly) {
            this.keyInfoUniqueID = keyInfoId;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETREADONLY_PERM.toString());
            }
            sm.checkPermission(SETREADONLY_PERM);
        }
        if (this.defaultImpl) {
            ((SecurityTokenImpl)this.securityToken).readOnly = true;
        }
        this.readOnly = true;
    }

    public boolean isReferenced() {
        return this.referenced;
    }

    public void setReferenced(boolean referenced) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETREFERENCED_PERM.toString());
            }
            sm.checkPermission(SETREFERENCED_PERM);
        }
        if (!this.readOnly) {
            this.referenced = referenced;
        }
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPROCESSED_PERM.toString());
            }
            sm.checkPermission(SETPROCESSED_PERM);
        }
        if (!this.readOnly) {
            this.processed = processed;
        }
    }

    public SoapSecurityException getError() {
        return this.error;
    }

    public void setError(SoapSecurityException error) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETERROR_PERM.toString());
            }
            sm.checkPermission(SETERROR_PERM);
        }
        if (!this.readOnly) {
            this.error = error;
        }
    }

    public boolean isUsedToLogin() {
        return this.usedToLogin;
    }

    public void setUsedToLogin(boolean usedToLogin) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOLOGIN_PERM.toString());
            }
            sm.checkPermission(SETUSEDTOLOGIN_PERM);
        }
        if (!this.readOnly) {
            this.usedToLogin = usedToLogin;
        }
    }

    @Override
    public void setEndPoint(String ept) {
        this.endPoint = ept;
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version = ObjectStateUtils.readString(in, "SecurityTokenWrapper.version");
        if (VERSION_NUMBER.equals(version)) {
            this.wssapiLoginConfigName = ObjectStateUtils.readString(in, "SecurityTokenWrapper.wssapiLoginConfigName");
            Object tmp = ObjectStateUtils.readObject(in, "SecurityTokenWrapper.wssapiCallBackHandler");
            if (tmp != null) {
                this.wssapiCallbackHandler = (CallbackHandler)tmp;
            }
            this.wssapiReferenceType = in.readInt();
            tmp = ObjectStateUtils.readObject(in, "SecurityTokenWrapper.securityToken");
            if (tmp != null) {
                this.securityToken = (SecurityToken)tmp;
            }
            this.keyInfoType = ObjectStateUtils.readString(in, "SecurityTokenWrapper.keyInfoType");
            tmp = ObjectStateUtils.readObject(in, "SecurityTokenWrapper.error");
            if (tmp != null) {
                this.error = (SoapSecurityException)tmp;
            }
            this.usedTokenGeneratorHash = in.readInt();
            this.usedTokenConsumerHash = in.readInt();
            this.usedTokenConsumerClass = in.readInt();
            this.referenced = in.readBoolean();
            this.processed = in.readBoolean();
            this.usedToLogin = in.readBoolean();
            this.defaultImpl = in.readBoolean();
            this.readOnly = in.readBoolean();
            this.endPoint = in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ObjectStateUtils.writeString(out, VERSION_NUMBER, "SecurityTokenWrapper.version");
        ObjectStateUtils.writeString(out, this.wssapiLoginConfigName, "SecurityTokenWrapper.wssapiLoginConfigName");
        ObjectStateUtils.writeObject(out, this.wssapiCallbackHandler, "SecurityTokenWrapper.wssapiCallBackHandler");
        out.writeInt(this.wssapiReferenceType);
        ObjectStateUtils.writeObject(out, this.securityToken, "SecurityTokenWrapper.securityToken");
        ObjectStateUtils.writeString(out, this.keyInfoType, "SecurityTokenWrapper.keyInfoType");
        ObjectStateUtils.writeObject(out, this.error, "SecurityTokenWrapper.error");
        out.writeInt(this.usedTokenGeneratorHash);
        out.writeInt(this.usedTokenConsumerHash);
        out.writeInt(this.usedTokenConsumerClass);
        out.writeBoolean(this.referenced);
        out.writeBoolean(this.processed);
        out.writeBoolean(this.usedToLogin);
        out.writeBoolean(this.defaultImpl);
        out.writeBoolean(this.readOnly);
        out.writeUTF(this.endPoint);
    }

    static {
        referenceMap.put(65, "STRREF");
        referenceMap.put(66, "KEYID");
        referenceMap.put(67, "EMB");
        referenceMap.put(68, "THUMBPRINT");
        referenceMap.put(71, "X509ISSUER");
    }
}

