/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Key;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.util.ObjectStateUtils;

public abstract class SecurityTokenImpl
implements SecurityToken,
Generatable,
Consumable,
Externalizable {
    private static final String VERSION_NUMBER = "1.0";
    private static final TraceComponent tc = Tr.register(SecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected String id;
    protected String principal;
    protected QName valueType;
    protected QName tokenQName;
    private Map<Integer, Key> keyMap = new HashMap<Integer, Key>();
    protected XMLStructure xml;
    protected String referenceURI;
    private String keyIdentifier;
    protected QName keyIdentifierEncodingType;
    protected QName keyIdentifierValueType;
    private String keyName;
    private String thumbprint;
    private QName thumbprintValueType;
    private QName thumbprintEncodingType;
    private static final SecurityPermission GETKEY_SIG_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.signingKey");
    private static final SecurityPermission GETKEY_ENC_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.encryptingKey");
    private static final SecurityPermission GETKEY_VER_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.verifingKey");
    private static final SecurityPermission GETKEY_DEC_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.decryptingKey");
    protected boolean readOnly;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (!this.readOnly) {
            this.id = id;
        }
    }

    @Override
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        if (!this.readOnly) {
            this.principal = principal;
        }
    }

    @Override
    public QName getValueType() {
        return this.valueType;
    }

    @Override
    public QName getTokenQname() {
        return this.tokenQName;
    }

    @Override
    public Key getKey(int keyType) throws WSSException {
        SecurityManager sm;
        if (keyType == 61) {
            SecurityManager sm2 = System.getSecurityManager();
            if (sm2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_SIG_PERM.toString());
                }
                sm2.checkPermission(GETKEY_SIG_PERM);
            }
        } else if (keyType == 62) {
            SecurityManager sm3 = System.getSecurityManager();
            if (sm3 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_ENC_PERM.toString());
                }
                sm3.checkPermission(GETKEY_ENC_PERM);
            }
        } else if (keyType == 63) {
            SecurityManager sm4 = System.getSecurityManager();
            if (sm4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_VER_PERM.toString());
                }
                sm4.checkPermission(GETKEY_VER_PERM);
            }
        } else if (keyType == 64 && (sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETKEY_DEC_PERM.toString());
            }
            sm.checkPermission(GETKEY_DEC_PERM);
        }
        return this.keyMap.get(keyType);
    }

    public void setKey(int keyType, Key key) {
        if (!this.readOnly) {
            this.keyMap.put(keyType, key);
        }
    }

    @Override
    public XMLStructure getXML() {
        XMLStructure xml = this.xml;
        if (this.readOnly && xml != null) {
            xml = new OMStructure(((OMStructure)xml).getNode().cloneOMElement());
        }
        return xml;
    }

    public void setXML(XMLStructure xml) {
        if (!this.readOnly) {
            this.xml = xml;
        }
    }

    @Override
    public String getReferenceURI() {
        return this.referenceURI;
    }

    public void setReferenceURI(String referenceURI) {
        if (!this.readOnly) {
            this.referenceURI = referenceURI;
        }
    }

    @Override
    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(String keyIdentifier) {
        if (!this.readOnly) {
            this.keyIdentifier = keyIdentifier;
        }
    }

    @Override
    public QName getKeyIdentifierEncodingType() {
        return this.keyIdentifierEncodingType;
    }

    public void setKeyIdentifierEncodingType(QName keyIdentifierEncodingType) {
        if (!this.readOnly && keyIdentifierEncodingType != null) {
            this.keyIdentifierEncodingType = keyIdentifierEncodingType;
        }
    }

    @Override
    public QName getKeyIdentifierValueType() {
        return this.keyIdentifierValueType;
    }

    public void setKeyIdentifierValueType(QName keyIdentifierValueType) {
        if (!this.readOnly && keyIdentifierValueType != null) {
            this.keyIdentifierValueType = keyIdentifierValueType;
        }
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        if (!this.readOnly) {
            this.keyName = keyName;
        }
    }

    @Override
    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String thumbprint) {
        if (!this.readOnly) {
            this.thumbprint = thumbprint;
        }
    }

    @Override
    public QName getThumbprintEncodingType() {
        return this.thumbprintEncodingType;
    }

    public void setThumbprintEncodingType(QName thumbprintEncodingType) {
        if (!this.readOnly) {
            this.thumbprintEncodingType = thumbprintEncodingType;
        }
    }

    @Override
    public QName getThumbprintValueType() {
        return this.thumbprintValueType;
    }

    public void setThumbprintValueType(QName thumbprintValueType) {
        if (!this.readOnly) {
            this.thumbprintValueType = thumbprintValueType;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version = ObjectStateUtils.readString(in, "SecurityToken.version");
        if (VERSION_NUMBER.equals(version)) {
            HashMap tmpHM;
            this.id = ObjectStateUtils.readString(in, "SecurityToken.id");
            this.principal = ObjectStateUtils.readString(in, "SecurityToken.principal");
            Object tmp = ObjectStateUtils.readObject(in, "SecurityToken.valueType");
            if (tmp != null) {
                this.valueType = (QName)tmp;
            }
            if ((tmp = ObjectStateUtils.readObject(in, "SecurityToken.tokenQName")) != null) {
                this.tokenQName = (QName)tmp;
            }
            this.keyMap = (tmpHM = ObjectStateUtils.readHashMap(in, "SecurityToken.keyMap")) != null ? new HashMap<Integer, Key>(tmpHM) : new HashMap<Integer, Key>();
            this.xml = null;
            tmp = ObjectStateUtils.readObject(in, "SecurityToken.xml");
            if (tmp != null) {
                this.xml = (XMLStructure)tmp;
            }
            this.referenceURI = ObjectStateUtils.readString(in, "SecurityToken.referenceURI");
            this.keyIdentifier = ObjectStateUtils.readString(in, "SecurityToken.keyIdentifier");
            tmp = ObjectStateUtils.readObject(in, "SecurityToken.keyIdentifierEncodingType");
            if (tmp != null) {
                this.keyIdentifierEncodingType = (QName)tmp;
            }
            if ((tmp = ObjectStateUtils.readObject(in, "SecurityToken.keyIdentifierValueType")) != null) {
                this.keyIdentifierValueType = (QName)tmp;
            }
            this.keyName = ObjectStateUtils.readString(in, "SecurityToken.keyName");
            this.thumbprint = ObjectStateUtils.readString(in, "SecurityToken.thumbprint");
            tmp = ObjectStateUtils.readObject(in, "SecurityToken.thumbprintValueType");
            if (tmp != null) {
                this.thumbprintValueType = (QName)tmp;
            }
            if ((tmp = ObjectStateUtils.readObject(in, "SecurityToken.thumbprintEncodingType")) != null) {
                this.thumbprintEncodingType = (QName)tmp;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ObjectStateUtils.writeString(out, VERSION_NUMBER, "SecurityToken.version");
        ObjectStateUtils.writeString(out, this.id, "SecurityToken.id");
        ObjectStateUtils.writeObject(out, this.principal, "SecurityToken.principal");
        ObjectStateUtils.writeObject(out, this.valueType, "SecurityToken.valueType");
        ObjectStateUtils.writeObject(out, this.tokenQName, "SecurityToken.tokenQName");
        ObjectStateUtils.writeHashMap(out, (HashMap)this.keyMap, "SecurityToken.keyMap");
        ObjectStateUtils.writeObject(out, this.xml, "SecurityToken.xml");
        ObjectStateUtils.writeString(out, this.referenceURI, "SecurityToken.referenceURI");
        ObjectStateUtils.writeString(out, this.keyIdentifier, "SecurityToken.keyIdentifier");
        ObjectStateUtils.writeObject(out, this.keyIdentifierEncodingType, "SecurityToken.keyIdentifierEncodingType");
        ObjectStateUtils.writeObject(out, this.keyIdentifierValueType, "SecurityToken.keyIdentifierValueType");
        ObjectStateUtils.writeString(out, this.keyName, "SecurityToken.keyName");
        ObjectStateUtils.writeString(out, this.thumbprint, "SecurityToken.thumbprint");
        ObjectStateUtils.writeObject(out, this.thumbprintValueType, "SecurityToken.thumbprintValueType");
        ObjectStateUtils.writeObject(out, this.thumbprintEncodingType, "SecurityToken.thumbprintEncodingType");
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }
}

