/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.DerivedKeyUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecureConversationToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis2.util.ObjectStateUtils;

public class SCT
extends SecureConversationToken
implements CacheableToken {
    private static final TraceComponent tc = Tr.register(SCT.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 1710253288493106515L;
    private static final SecurityPermission RENEW_PERM = new SecurityPermission("wssapi.SCT.renew");
    private static final SecurityPermission CANCEL_PERM = new SecurityPermission("wssapi.SCT.cancel");
    private WSSGenerationContext wssGenerationContext;
    private WSSConsumingContext wssConsumingContext;
    private Map _map;
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCT.class.getName();
    private SecurityTokenManagerImpl securityTokenManager = null;
    private Map dkgMap = null;
    public static final String SERIALIZATION_DESCRIPTION_UUID = "SCT.uuid";
    public static final String SERIALIZATION_DESCRIPTION_CLIENT_ID = "SCT.clientID";
    public static final String SERIALIZATION_DESCRIPTION_TOKEN_ID = "SCT.tokenID";
    public static final String SERIALIZATION_DESCRIPTION_CURRENT_INSTANCE = "SCT.currentInstance";
    public static final String SERIALIZATION_DESCRIPTION_KEY_MAP = "SCT.keyMap";
    public static final String SERIALIZATION_DESCRIPTION_APPLIES_TO = "SCT.appliesTo";
    public static final String SERIALIZATION_DESCRIPTION_ALGORITHM = "SCT.algorithm";
    public static final String SERIALIZATION_DESCRIPTION_PROVIDER = "SCT.provider";
    public static final String SERIALIZATION_DESCRIPTION_ISSUER = "SCT.issuer";
    public static final String SERIALIZATION_DESCRIPTION_INSTANCES = "SCT.instances";
    private String uuid = "";
    private String clientID = "";
    private String tokenID = "";
    private boolean isCancelled = false;
    private HashMap<String, KeyHistoryEntry> keyMap;
    private ArrayList appliesToList;
    private String issuer;
    private boolean renewable = false;
    private boolean renewableAfterExpiration = false;
    private ArrayList allKeyInstances = new ArrayList();
    private String algorithm = "";
    private String provider = "";
    private int keySize = 0;
    private byte[] serializedBytes = null;
    private static final String CLASS_NAME = SCT.class.getName();

    public SCT() {
        this.keyMap = new HashMap();
        this.appliesToList = new ArrayList();
    }

    public SCT(String uuid) {
        this();
        this.uuid = uuid;
    }

    public SCT(String uuid, KeyHistoryEntry[] entries) {
        this(uuid);
        for (KeyHistoryEntry entry : entries) {
            String instance = entry.getInstance();
            this.addKeyInstance(instance, entry);
        }
    }

    @Override
    public String getIdentifier() {
        return this.getUUID();
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getTokenID() {
        return this.tokenID;
    }

    @Override
    public String[] getInstances() {
        String[] instanceNames = new String[this.allKeyInstances.size()];
        this.allKeyInstances.toArray(instanceNames);
        return instanceNames;
    }

    public KeyHistoryEntry getKeyHistoryEntry(String instance) {
        return this.keyMap.get(instance);
    }

    public byte[] getClientSecret(String instance) {
        byte[] secret;
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        byte[] byArray = secret = keyEntry == null ? null : keyEntry.getClientSecret();
        if (this.readOnly && secret != null) {
            int secretlen = secret.length;
            byte[] secret2 = new byte[secretlen];
            System.arraycopy(secret, 0, secret2, 0, secretlen);
            secret = secret2;
        }
        return secret;
    }

    public byte[] getServerSecret(String instance) {
        byte[] secret;
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        byte[] byArray = secret = keyEntry == null ? null : keyEntry.getServerSecret();
        if (this.readOnly && secret != null) {
            int secretlen = secret.length;
            byte[] secret2 = new byte[secretlen];
            System.arraycopy(secret, 0, secret2, 0, secretlen);
            secret = secret2;
        }
        return secret;
    }

    public byte[] getSecret(String instance) {
        byte[] secret;
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        byte[] byArray = secret = keyEntry == null ? null : keyEntry.getSecret();
        if (this.readOnly && secret != null) {
            int secretlen = secret.length;
            byte[] secret2 = new byte[secretlen];
            System.arraycopy(secret, 0, secret2, 0, secretlen);
            secret = secret2;
        }
        return secret;
    }

    @Override
    public Date getCreation(String instance) {
        Date created;
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        Date date = created = keyEntry == null ? null : keyEntry.getCreated();
        if (this.readOnly && created != null) {
            created = (Date)created.clone();
        }
        return created;
    }

    @Override
    public Date getExpiration(String instance) {
        Date expires;
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        Date date = expires = keyEntry == null ? null : keyEntry.getExpires();
        if (this.readOnly && expires != null) {
            expires = (Date)expires.clone();
        }
        return expires;
    }

    public SCTState getState(String instance) {
        KeyHistoryEntry keyEntry = this.keyMap.get(instance);
        return keyEntry == null ? null : keyEntry.getState();
    }

    public ArrayList getAppliesToList() {
        return (ArrayList)this.appliesToList.clone();
    }

    public String getAppliesTo(int i) {
        return (String)this.appliesToList.get(i);
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public boolean isRenewableAfterExpiration() {
        return this.renewableAfterExpiration;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getProvider() {
        return this.provider;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setUUID(String newUUID) {
        if (!this.readOnly) {
            this.uuid = newUUID;
        }
    }

    public void setClientID(String newClientID) {
        if (!this.readOnly) {
            this.clientID = newClientID;
        }
    }

    public void setTokenID(String newTokenID) {
        if (!this.readOnly) {
            this.tokenID = newTokenID;
        }
    }

    public void setIssuer(String newIssuer) {
        if (!this.readOnly) {
            this.issuer = newIssuer;
        }
    }

    public void setKeyHistoryEntry(KeyHistoryEntry entry) {
        if (!this.readOnly) {
            this.addKeyInstance(entry.getInstance(), entry);
        }
    }

    public void setClientSecret(String instance, byte[] newClientSecret) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setClientSecret(newClientSecret);
        }
    }

    public void setServerSecret(String instance, byte[] newServerSecret) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setServerSecret(newServerSecret);
        }
    }

    public void setSecret(String instance, byte[] newSecret) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setSecret(newSecret);
        }
    }

    public void setCreation(String instance, Date newCreation) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setCreated(newCreation);
        }
    }

    public void setExpiration(String instance, Date newExpiration) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setExpires(newExpiration);
        }
    }

    public void setState(String instance, SCTState newState) {
        KeyHistoryEntry entry;
        if (!this.readOnly && (entry = this.keyMap.get(instance)) != null) {
            entry.setState(newState);
        }
    }

    public void setRenewable(boolean newRenewable) {
        if (!this.readOnly) {
            this.renewable = newRenewable;
        }
    }

    public void setRenewableAfterExpiration(boolean newRenewableAfterExpiration) {
        if (!this.readOnly) {
            this.renewableAfterExpiration = newRenewableAfterExpiration;
        }
    }

    public void setAlgorithm(String newAlgorithm) {
        if (!this.readOnly) {
            this.algorithm = newAlgorithm;
        }
    }

    public void setProvider(String newProvider) {
        if (!this.readOnly) {
            this.provider = newProvider;
        }
    }

    public void setKeySize(int newKeySize) {
        if (!this.readOnly) {
            this.keySize = newKeySize;
        }
    }

    public void setAppliesTo(String newAppliesTo) {
        if (!this.readOnly) {
            this.appliesToList.clear();
            this.addAppliesTo(newAppliesTo);
        }
    }

    public void addAppliesTo(String newAppliesTo) {
        if (!this.readOnly) {
            try {
                URL url = new URL(newAppliesTo);
                if (url != null) {
                    String urlWithPort = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setAppliesTo(" + newAppliesTo + ") stored as: " + urlWithPort);
                    }
                    this.appliesToList.add(urlWithPort);
                    if (url.getPort() == url.getDefaultPort()) {
                        String urlWithoutPort = url.getProtocol() + "://" + url.getHost() + url.getPath();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setAppliesTo(" + newAppliesTo + ") also stored as: " + urlWithoutPort);
                        }
                        this.appliesToList.add(urlWithoutPort);
                    }
                } else {
                    Tr.warning(tc, "url == null, invalid appliesTo: " + newAppliesTo);
                    this.appliesToList.add(newAppliesTo);
                }
            }
            catch (MalformedURLException e) {
                Tr.warning(tc, "invalid appliesTo: " + newAppliesTo);
                this.appliesToList.add(newAppliesTo);
            }
        }
    }

    public void setAppliesTo(ArrayList newAppliesToList) {
        if (!this.readOnly) {
            this.appliesToList = newAppliesToList;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelState() {
        if (!this.readOnly) {
            this.isCancelled = true;
        }
    }

    public static final Date parseDateTime(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseDateTime( " + s + " )");
        }
        if (s == null) {
            return null;
        }
        try {
            Date d = UTC.parse(s);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseDateTime( " + s + " )");
            }
            return d;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parseDateTime( " + s + " ) returns null");
            }
            return null;
        }
    }

    public WSSConsumingContext getWssConsumingContext() {
        return this.wssConsumingContext;
    }

    public void setWssConsumingContext(WSSConsumingContext wssConsumingContext) {
        this.wssConsumingContext = wssConsumingContext;
    }

    public WSSGenerationContext getWssGenerationContext() {
        return this.wssGenerationContext;
    }

    public void setWssGenerationContext(WSSGenerationContext wssGenerationContext) {
        this.wssGenerationContext = wssGenerationContext;
    }

    public Map getMap() {
        return this._map;
    }

    public void setMap(Map tokenConfigMap) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saving the configuration needed for trust client APIs");
        }
        this._map = tokenConfigMap;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT configuration map = " + this._map.toString());
        }
    }

    public void setSecurityTokenManagerImpl(SecurityTokenManagerImpl tokenMgr) {
        this.securityTokenManager = tokenMgr;
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String algorithm, String clientLabel, String serviceLabel) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedKeyToken( " + algorithm + ", " + clientLabel + ", " + serviceLabel + ")");
        }
        if (clientLabel == null) {
            clientLabel = "Default";
        }
        if (serviceLabel == null) {
            serviceLabel = "Default";
        }
        Map<String, Object> algoMap = this.getKeyAlgorithm(algorithm);
        SCTGenerateCallbackHandler cb = null;
        cb = (Boolean)algoMap.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, (String)algoMap.get("algorithm"), (Integer)algoMap.get("keyLength"), null, 0, clientLabel, serviceLabel) : new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, null, 0, (String)algoMap.get("algorithm"), (Integer)algoMap.get("keyLength"), clientLabel, serviceLabel);
        DKToken dktoken = new DKToken();
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedKeyToken(String, String )");
        }
        return dktoken;
    }

    public DerivedKeyToken getDerivedKeyToken(String algorithm, int keylen, String clientLabel, String serviceLabel) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedKeyToken( " + algorithm + ", " + keylen + " , " + clientLabel + " , " + serviceLabel + ")");
        }
        Map<String, Object> algoMap = this.getKeyAlgorithm(algorithm);
        SCTGenerateCallbackHandler cb = null;
        if (clientLabel == null) {
            clientLabel = "Default";
        }
        if (serviceLabel == null) {
            serviceLabel = "Default";
        }
        cb = (Boolean)algoMap.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, (String)algoMap.get("algorithm"), keylen, null, 0, clientLabel, serviceLabel) : new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, null, 0, (String)algoMap.get("algorithm"), keylen, clientLabel, serviceLabel);
        DKToken dktoken = new DKToken();
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedKeyToken(String, int, String)");
        }
        return dktoken;
    }

    private Map<String, Object> getKeyAlgorithm(String algName) {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAlgorithm(String algName): algName=" + algName);
        }
        if ((map = DefaultValueManager.getInstance().getSignatureAlgorithmMap().get(algName)) != null) {
            map.put("isSignature", Boolean.TRUE);
        }
        if (map == null && (map = DefaultValueManager.getInstance().getEncryptionAlgorithmMap().get(algName)) != null) {
            map.put("isSignature", Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyAlgorithm(String algName, int keyBytesLength) returns map" + map);
        }
        return map;
    }

    public boolean isValid(String instance, long expirationCushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter isValid()...");
        }
        if (this.keyMap.containsKey(instance)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT instance = " + instance + ", cushion = " + expirationCushion);
            }
            Date creationTime = this.getCreation(instance);
            Date expirationTime = this.getExpiration(instance);
            Date now = new Date();
            boolean valid = true;
            long clockSkew = CacheConfigFactory.getInstance().getClockSkewToleranceMilliseconds();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current time = " + now.toString() + "(" + now.getTime() + " ms), " + "SCT creation time = " + creationTime.toString() + "(" + creationTime.getTime() + " ms), " + "Expiration time =  " + expirationTime.toString() + "(" + expirationTime.getTime() + " ms), " + "Clock Skew tolerance = " + clockSkew + " ms.");
            }
            if (clockSkew != 0L) {
                if (creationTime != null && creationTime.getTime() > now.getTime() && creationTime.getTime() > now.getTime() + clockSkew) {
                    valid = false;
                }
                if (valid && expirationTime != null && expirationTime.getTime() - expirationCushion < now.getTime() && expirationTime.getTime() - expirationCushion < now.getTime() - clockSkew) {
                    valid = false;
                }
            } else {
                if (creationTime != null) {
                    boolean bl = valid = creationTime.getTime() <= now.getTime();
                }
                if (expirationTime != null) {
                    boolean bl = valid = valid && now.getTime() < expirationTime.getTime() - expirationCushion;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit isValid()..., " + valid);
            }
            return valid;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit isValid()..., false");
        }
        return false;
    }

    public boolean validateAppliesToURI(String incomingAppliesToString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAppliesToURI(" + incomingAppliesToString + ")");
        }
        boolean rc = false;
        if (incomingAppliesToString == null || this.appliesToList == null) {
            return false;
        }
        for (int loop = 0; loop < this.appliesToList.size() && !rc; ++loop) {
            String appliesTo = (String)this.appliesToList.get(loop);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appliesTo in SCT: " + appliesTo);
                Tr.debug(tc, "appliesTo incoming: " + incomingAppliesToString);
            }
            rc = STSUriUtil.URICompare(appliesTo, incomingAppliesToString) == 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAppliesToURI(" + incomingAppliesToString + ") returns " + rc);
        }
        return rc;
    }

    public byte[] getSerializationBytes() {
        String method;
        block4: {
            method = CLASS_NAME + ".getSerializationBytes()";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, method);
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream outObjStream = new ObjectOutputStream(byteStream);
                this.writeExternal(outObjStream);
                outObjStream.close();
                byteStream.close();
                this.serializedBytes = byteStream.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Fail to serialize SCT. ", e.getStackTrace());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, method);
        }
        return this.serializedBytes;
    }

    @Override
    public int getStatus(String instance) {
        SCTState s;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus(" + instance + ")");
        }
        if ((s = this.getState(instance)).equals((Object)SCTState.ISSUED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + instance + ")");
            }
            return 81;
        }
        if (s.equals((Object)SCTState.CANCELLED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + instance + ")");
            }
            return 83;
        }
        if (s.equals((Object)SCTState.RENEWED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + instance + ")");
            }
            return 82;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus(" + instance + ")");
        }
        return -1;
    }

    @Override
    public void cancel() throws WSSException {
    }

    @Override
    public void cancel(WSSGenerationContext wssgenerationcontext, WSSConsumingContext wssconsumingcontext) throws WSSException {
    }

    @Override
    public boolean validate() throws WSSException {
        return false;
    }

    @Override
    public boolean validate(WSSGenerationContext wssgenerationcontext, WSSConsumingContext wssconsumingcontext) throws WSSException {
        return false;
    }

    @Override
    public void renew() throws WSSException {
    }

    @Override
    public void renew(WSSGenerationContext wssgenerationcontext, WSSConsumingContext wssconsumingcontext) throws WSSException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = in.readInt();
        this.readExternalVersion1(in);
    }

    private void readExternalVersion1(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uuid = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_UUID);
        this.clientID = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_CLIENT_ID);
        this.tokenID = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_TOKEN_ID);
        this.isCancelled = in.readBoolean();
        this.keyMap = ObjectStateUtils.readHashMap(in, SERIALIZATION_DESCRIPTION_KEY_MAP);
        this.appliesToList = ObjectStateUtils.readArrayList(in, SERIALIZATION_DESCRIPTION_APPLIES_TO);
        this.renewable = in.readBoolean();
        this.renewableAfterExpiration = in.readBoolean();
        this.algorithm = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_ALGORITHM);
        this.provider = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_PROVIDER);
        this.keySize = in.readInt();
        this.issuer = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_ISSUER);
        this.allKeyInstances = ObjectStateUtils.readArrayList(in, SERIALIZATION_DESCRIPTION_INSTANCES);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(1);
        ObjectStateUtils.writeString(out, this.uuid, SERIALIZATION_DESCRIPTION_UUID);
        ObjectStateUtils.writeString(out, this.clientID, SERIALIZATION_DESCRIPTION_CLIENT_ID);
        ObjectStateUtils.writeString(out, this.tokenID, SERIALIZATION_DESCRIPTION_TOKEN_ID);
        out.writeBoolean(this.isCancelled);
        ObjectStateUtils.writeHashMap(out, this.keyMap, SERIALIZATION_DESCRIPTION_KEY_MAP);
        ObjectStateUtils.writeArrayList(out, this.appliesToList, SERIALIZATION_DESCRIPTION_APPLIES_TO);
        out.writeBoolean(this.renewable);
        out.writeBoolean(this.renewableAfterExpiration);
        ObjectStateUtils.writeString(out, this.algorithm, SERIALIZATION_DESCRIPTION_ALGORITHM);
        ObjectStateUtils.writeString(out, this.provider, SERIALIZATION_DESCRIPTION_PROVIDER);
        out.writeInt(this.keySize);
        ObjectStateUtils.writeString(out, this.issuer, SERIALIZATION_DESCRIPTION_ISSUER);
        ObjectStateUtils.writeArrayList(out, this.allKeyInstances, SERIALIZATION_DESCRIPTION_INSTANCES);
    }

    private synchronized void addKeyInstance(String uuid, KeyHistoryEntry keyEntry) {
        this.keyMap.put(uuid, keyEntry);
        this.allKeyInstances.add(uuid);
    }

    public static class KeyHistoryEntry
    implements Externalizable {
        public static final String SERIALIZATION_DESCRIPTION_INSTANCE = "KHE.instance";
        public static final String SERIALIZATION_DESCRIPTION_CLIENT_SECRET = "KHE.clientSecret";
        public static final String SERIALIZATION_DESCRIPTION_SERVER_SECRET = "KHE.serverSecret";
        public static final String SERIALIZATION_DESCRIPTION_SECRET = "KHE.secret";
        public static final String SERIALIZATION_DESCRIPTION_VALID_TIME_START = "KHE.validTimeStart";
        public static final String SERIALIZATION_DESCRIPTION_VALID_TIME_END = "KHE.validTimeEnd";
        public static final String SERIALIZATION_DESCRIPTION_STATE = "KHE.state";
        private String instance;
        private byte[] clientSecret;
        private byte[] serverSecret;
        private byte[] secret;
        private Date validTimeStart;
        private Date validTimeEnd;
        private SCTState state;
        private static final long serialVersionUID = 4800424159027149133L;
        private static final TraceComponent tc = Tr.register(KeyHistoryEntry.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

        public KeyHistoryEntry() {
            this.instance = "";
            this.clientSecret = new byte[0];
            this.serverSecret = new byte[0];
            this.secret = new byte[0];
            this.validTimeStart = new Date(0L);
            this.validTimeEnd = new Date(0L);
            this.state = SCTState.NULL;
        }

        public KeyHistoryEntry(String instance, byte[] clientSecret, byte[] serverSecret, Date created, Date expires, SCTState state) {
            this.instance = instance;
            this.clientSecret = KeyHistoryEntry.copyOf(clientSecret);
            this.serverSecret = KeyHistoryEntry.copyOf(serverSecret);
            this.validTimeStart = (Date)created.clone();
            this.validTimeEnd = (Date)expires.clone();
            this.state = state;
            this.secret = this.createDerivedKeyByte(this.clientSecret, this.serverSecret);
        }

        private byte[] createDerivedKeyByte(byte[] clientSecret, byte[] serverSecret) {
            String methodName = "createDerivedKeyByte";
            byte[] bytes = null;
            try {
                bytes = DerivedKeyUtil.createDerivedKeyByte(clientSecret, "", serverSecret, clientSecret.length, 0, 0, "HmacSha1");
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, CLASS_NAME + "." + methodName, "%C", this);
            }
            return bytes;
        }

        public String getInstance() {
            return this.instance;
        }

        public byte[] getClientSecret() {
            return KeyHistoryEntry.copyOf(this.clientSecret);
        }

        public byte[] getServerSecret() {
            return KeyHistoryEntry.copyOf(this.serverSecret);
        }

        public byte[] getSecret() {
            return KeyHistoryEntry.copyOf(this.secret);
        }

        public Date getCreated() {
            return (Date)this.validTimeStart.clone();
        }

        public Date getExpires() {
            return (Date)this.validTimeEnd.clone();
        }

        public SCTState getState() {
            return this.state;
        }

        public void setInstance(String newInstance) {
            this.instance = newInstance;
        }

        public void setClientSecret(byte[] newClientSecret) {
            this.clientSecret = KeyHistoryEntry.copyOf(newClientSecret);
        }

        public void setServerSecret(byte[] newServerSecret) {
            this.serverSecret = KeyHistoryEntry.copyOf(newServerSecret);
        }

        public void setSecret(byte[] newSecret) {
            this.secret = KeyHistoryEntry.copyOf(newSecret);
        }

        public void setCreated(Date createdDate) {
            this.validTimeStart = (Date)createdDate.clone();
        }

        public void setExpires(Date expiresDate) {
            this.validTimeEnd = (Date)expiresDate.clone();
        }

        public void setState(SCTState newState) {
            this.state = newState;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.readExternalVersion1(in);
        }

        public void readExternalVersion1(ObjectInput in) throws IOException, ClassNotFoundException {
            String methodName = "readExternalVersion1";
            this.instance = ObjectStateUtils.readString(in, SERIALIZATION_DESCRIPTION_INSTANCE);
            Object deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_CLIENT_SECRET);
            if (deserialized != null) {
                this.clientSecret = (byte[])deserialized;
                deserialized = null;
            }
            if ((deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_SERVER_SECRET)) != null) {
                this.serverSecret = (byte[])deserialized;
                deserialized = null;
            }
            if ((deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_VALID_TIME_START)) != null) {
                this.validTimeStart = (Date)deserialized;
                deserialized = null;
            }
            if ((deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_VALID_TIME_END)) != null) {
                this.validTimeEnd = (Date)deserialized;
                deserialized = null;
            }
            if ((deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_STATE)) != null) {
                this.state = (SCTState)((Object)deserialized);
                deserialized = null;
            }
            try {
                deserialized = ObjectStateUtils.readObject(in, SERIALIZATION_DESCRIPTION_SECRET);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SERIALIZATION_DESCRIPTION_SECRET");
                }
            }
            catch (Throwable e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot deserialize combined secret = " + e.getMessage());
                }
                deserialized = null;
            }
            if (deserialized != null) {
                this.secret = (byte[])deserialized;
                deserialized = null;
            } else {
                this.secret = this.createDerivedKeyByte(this.clientSecret, this.serverSecret);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDerivedKeyByte");
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            ObjectStateUtils.writeString(out, this.instance, SERIALIZATION_DESCRIPTION_INSTANCE);
            ObjectStateUtils.writeObject(out, this.clientSecret, SERIALIZATION_DESCRIPTION_CLIENT_SECRET);
            ObjectStateUtils.writeObject(out, this.serverSecret, SERIALIZATION_DESCRIPTION_SERVER_SECRET);
            ObjectStateUtils.writeObject(out, this.validTimeStart, SERIALIZATION_DESCRIPTION_VALID_TIME_START);
            ObjectStateUtils.writeObject(out, this.validTimeEnd, SERIALIZATION_DESCRIPTION_VALID_TIME_END);
            ObjectStateUtils.writeObject(out, (Object)this.state, SERIALIZATION_DESCRIPTION_STATE);
            ObjectStateUtils.writeObject(out, this.secret, SERIALIZATION_DESCRIPTION_SECRET);
        }

        private static byte[] copyOf(byte[] original) {
            byte[] copy = null;
            if (original != null) {
                copy = new byte[original.length];
                System.arraycopy(original, 0, copy, 0, original.length);
            }
            return copy;
        }
    }

    public static enum SCTState {
        NULL,
        ISSUED,
        CANCELLED,
        RENEWED,
        AMENDED;

    }
}

