/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.GenericSecurityTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Serializer;
import com.ibm.wsspi.wssecurity.platform.token.AuthnToken;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class SAMLTokenImpl
extends GenericSecurityTokenImpl
implements SAMLToken,
CacheableToken,
AuthnToken {
    private static final TraceComponent tc = Tr.register(SAMLTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final QName saml11ValueType = new QName("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
    public static final QName saml11KeyIdentifierValueType = new QName("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
    public static final QName saml20ValueType = new QName("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
    public static final QName saml20KeyIdentifierValueType = new QName("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
    private static final short VERSION = 1;
    public static final String saml11TokenName = "security.wssecurity_http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    public static final String saml20TokenName = "security.wssecurity_http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    protected String tokenName = null;
    protected String _identifier = null;
    private String subjectDns = null;
    private String subjectIp = null;
    private List<String> audienceRestriction = new ArrayList<String>();
    private QName assertionQname = null;
    private String authnMethod = null;
    private String confirmMethod = null;
    private byte[] holderOfKeyBytes = null;
    private String initiatorName = null;
    private String keyType = null;
    private String issuername = null;
    private String samlId = null;
    private Date expirationTime = null;
    private Date createTime = null;
    private boolean isassertionValid = false;
    private List<SAMLAttribute> samlAttrts = new ArrayList<SAMLAttribute>();
    private Map<String, String> stringAttributes = new HashMap<String, String>();
    private SAMLNameID nameId = null;
    private Date authnInstant = null;
    private boolean oneTimeUse = false;
    private static final long serialVersionUID = 3166835820878605529L;
    private static final String VERSION_NUMBER = "1.0";
    private int hashcode = 0;
    private byte[] tokenBytes;
    private boolean isForwardable = true;

    public SAMLTokenImpl() {
    }

    public SAMLTokenImpl(byte[] inBytes) {
        this.tokenBytes = inBytes;
        if (this.tokenBytes != null) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void initialize(byte[] encodedToken) {
        if (encodedToken == null) {
            return;
        }
        try {
            ByteArrayInputStream bayin = new ByteArrayInputStream(encodedToken);
            ObjectInputStream in = new ObjectInputStream(bayin);
            this.readExternal(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setValueType(String vType) {
        if (saml11ValueType.getLocalPart().equals(vType)) {
            this.valueType = saml11ValueType;
        } else if (saml20ValueType.getLocalPart().equals(vType)) {
            this.valueType = saml20ValueType;
        }
    }

    @Override
    public void setKeyIdentifierValueType(QName vType) {
        if (!this.readOnly) {
            this.keyIdentifierValueType = vType;
        }
    }

    @Override
    public void setValueType(QName vType) {
        if (!this.readOnly) {
            this.valueType = vType;
        }
    }

    public void setAssertionQName(QName q) {
        if (!this.readOnly) {
            this.assertionQname = q;
        }
    }

    public void setAuthenticationMethod(String method) {
        if (!this.readOnly) {
            this.authnMethod = method;
        }
    }

    public void setConfirmationMethod(String method) {
        if (!this.readOnly) {
            this.confirmMethod = method;
        }
    }

    public void setHolderOfKeyBytes(byte[] byt) {
        if (!this.readOnly) {
            this.holderOfKeyBytes = byt;
        }
    }

    public void setInitiatorName(String name) {
        if (!this.readOnly) {
            this.initiatorName = name;
        }
    }

    public void setKeyType(String type) {
        if (!this.readOnly) {
            this.keyType = type;
        }
    }

    public void setSAMLIssuerName(String name) {
        if (!this.readOnly) {
            this.issuername = name;
        }
    }

    public void setSamlExpires(Date date) {
        if (!this.readOnly) {
            this.expirationTime = date;
        }
    }

    public void setSamlCreated(Date date) {
        if (!this.readOnly) {
            this.createTime = date;
        }
    }

    public void setSamlID(String id) {
        if (!this.readOnly) {
            this.samlId = id;
        }
    }

    public void setSubjectDNS(String dns) {
        if (!this.readOnly) {
            this.subjectDns = dns;
        }
    }

    public void setSubjectIPAddress(String ip) {
        if (!this.readOnly) {
            this.subjectIp = ip;
        }
    }

    public void setAudienceRestriction(List<String> audience) {
        if (!this.readOnly) {
            this.audienceRestriction = audience;
        }
    }

    public void SetIsAssertionValid(boolean state) {
        if (!this.readOnly) {
            this.isassertionValid = state;
        }
    }

    public void setSAMLAttributes(List<SAMLAttribute> atts) {
        if (!this.readOnly) {
            this.samlAttrts = atts;
        }
    }

    public void setStringAttributes(Map<String, String> atts) {
        if (!this.readOnly) {
            this.stringAttributes = atts;
        }
    }

    @Override
    public QName getAssertionQName() {
        return this.assertionQname;
    }

    @Override
    public String getAuthenticationMethod() {
        return this.authnMethod;
    }

    @Override
    public String getConfirmationMethod() {
        return this.confirmMethod;
    }

    @Override
    public byte[] getHolderOfKeyBytes() {
        return this.holderOfKeyBytes;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getSAMLIssuerName() {
        return this.issuername;
    }

    @Override
    public Date getSamlExpires() {
        return this.expirationTime;
    }

    @Override
    public Date getSamlCreated() {
        return this.createTime;
    }

    @Override
    public String getSamlID() {
        return this.samlId;
    }

    @Override
    public String getSubjectDNS() {
        return this.subjectDns;
    }

    @Override
    public String getSubjectIPAddress() {
        return this.subjectIp;
    }

    @Override
    public List<String> getAudienceRestriction() {
        List<String> samlAudienceRestriction = null;
        samlAudienceRestriction = this.readOnly ? new ArrayList<String>(this.audienceRestriction) : this.audienceRestriction;
        return samlAudienceRestriction;
    }

    public boolean isAssertionValid() {
        return this.isassertionValid;
    }

    @Override
    public boolean isOneTimeUse() {
        return this.oneTimeUse;
    }

    public void setIsOneTimeUse(boolean flag) {
        this.oneTimeUse = flag;
    }

    @Override
    public List<SAMLAttribute> getSAMLAttributes() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_SAMLATTRIBUTES_PERM);
        }
        List<SAMLAttribute> samlAttributes = null;
        if (this.readOnly) {
            samlAttributes = new ArrayList<SAMLAttribute>();
            Iterator<SAMLAttribute> it = this.samlAttrts.iterator();
            while (it.hasNext()) {
                SAMLAttribute anAttribute = new SAMLAttribute(it.next());
                samlAttributes.add(anAttribute);
            }
        } else {
            samlAttributes = this.samlAttrts;
        }
        return samlAttributes;
    }

    @Override
    public Map<String, String> getStringAttributes() {
        Map<String, String> stringSAMLAttributes = null;
        stringSAMLAttributes = this.readOnly ? new HashMap<String, String>(this.stringAttributes) : this.stringAttributes;
        return stringSAMLAttributes;
    }

    @Override
    public SAMLNameID getSAMLNameID() {
        return this.nameId;
    }

    public void setSAMLNameID(SAMLNameID id) {
        this.nameId = id;
    }

    @Override
    public InputStream getXMLInputStream() throws WSSException {
        try {
            OMElement samlXML = ((OMStructure)this.xml).getNode();
            byte[] data = Serializer.serialize(samlXML);
            return new ByteArrayInputStream(data);
        }
        catch (Exception e) {
            throw new WSSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getIdentifier() {
        return this._identifier;
    }

    public void setIdentifier(String id) {
        this._identifier = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SAMLTokenImpl)) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Not a SAMLTokenImpl:" + o);
            }
            return false;
        }
        return ((SAMLTokenImpl)o).hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "hashCode=" + this.hashcode);
        }
        if (this.hashcode == 0) {
            StringBuffer hashString = new StringBuffer();
            if (this.samlId != null) {
                hashString.append(this.samlId);
            }
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "SamlID=" + this.samlId);
            }
            if (this.issuername != null) {
                hashString.append(this.issuername);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLIssuerName=" + this.issuername);
            }
            if (this.valueType != null) {
                hashString.append(this.valueType.getLocalPart());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hashString=" + hashString.toString());
            }
            if (hashString.length() > 0) {
                this.hashcode = hashString.toString().hashCode();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "hashcode=" + this.hashcode);
        }
        return this.hashcode;
    }

    @Override
    public boolean isTokenValid() {
        long current_time = System.currentTimeMillis();
        long timeRemaining = this.expirationTime.getTime() - current_time;
        return timeRemaining > 0L;
    }

    @Override
    public long getTokenExpiration() {
        return this.expirationTime.getTime();
    }

    @Override
    public boolean isTokenForwardable() {
        return this.isForwardable;
    }

    public void setIsForwardable(boolean forward) {
        if (!this.readOnly) {
            this.isForwardable = forward;
        }
    }

    @Override
    public String getTokenPrincipal() {
        return this.principal;
    }

    @Override
    public String getTokenRealm() {
        return null;
    }

    @Override
    public byte[] getTokenBytes() {
        try {
            ByteArrayOutputStream bayout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bayout);
            this.writeExternal(out);
            out.flush();
            out.close();
            this.tokenBytes = bayout.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.tokenBytes;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public short getTokenVersion() {
        return 1;
    }

    @Override
    public String getTokenUniqueID() {
        String id = this.samlId + this.issuername;
        if (this.valueType != null) {
            id = id + this.valueType.getLocalPart();
        }
        return id;
    }

    @Override
    public void setTokenReadOnly() {
        this.readOnly = true;
    }

    @Override
    public String[] getTokenAttributes(String key) {
        Map<String, String> atts = this.getStringAttributes();
        if (atts != null) {
            String att = atts.get(key);
            String[] ats = new String[]{att};
            return ats;
        }
        return null;
    }

    @Override
    public String[] addTokenAttribute(String key, String value) {
        this.getStringAttributes().put(key, value);
        String[] val = new String[]{value};
        SAMLAttribute att = new SAMLAttribute(key, val, null, null, null, null);
        this.getSAMLAttributes().add(att);
        int i = this.getStringAttributes().size();
        String[] atts = new String[i];
        Iterator<String> it = this.getStringAttributes().values().iterator();
        i = 0;
        while (it.hasNext()) {
            atts[i] = it.next();
            ++i;
        }
        return atts;
    }

    @Override
    public Enumeration<?> getTokenAttributeNames() {
        Vector v = new Vector();
        ListIterator<SAMLAttribute> it = this.getSAMLAttributes().listIterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v.elements();
    }

    @Override
    public Date getAuthenticationInstant() {
        return this.authnInstant;
    }

    public void setAuthenticationInstant(Date authnDate) {
        this.authnInstant = authnDate;
    }

    public Object clone() {
        return new SAMLTokenImpl(this.getTokenBytes());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, "SAMLToken.version");
        ObjectOutputInputUtil.writeUTF(out, this._identifier, "SAMLToken.identifier");
        ObjectOutputInputUtil.writeUTF(out, this.authnMethod, "SAMLToken.authnMethod");
        ObjectOutputInputUtil.writeUTF(out, this.confirmMethod, "SAMLToken.confirmMethod");
        ObjectOutputInputUtil.writeInt(out, this.hashcode, "SAMLToken.hashcode");
        ObjectOutputInputUtil.writeUTF(out, this.id, "SAMLToken.id");
        ObjectOutputInputUtil.writeUTF(out, this.initiatorName, "SAMLToken.initiatorName");
        ObjectOutputInputUtil.writeUTF(out, this.issuername, "SAMLToken.issuername");
        ObjectOutputInputUtil.writeUTF(out, this.keyType, "SAMLToken.keyType");
        ObjectOutputInputUtil.writeUTF(out, this.principal, "SAMLToken.principal");
        ObjectOutputInputUtil.writeUTF(out, this.samlId, "SAMLToken.samlId");
        ObjectOutputInputUtil.writeUTF(out, this.subjectDns, "SAMLToken.subjectDns");
        ObjectOutputInputUtil.writeUTF(out, this.subjectIp, "SAMLToken.subjectIp");
        ObjectOutputInputUtil.writeUTF(out, this.tokenName, "SAMLToken.tokenName");
        ObjectOutputInputUtil.writeBoolean(out, this.isForwardable, "SAMLToken.isForwardable");
        ObjectOutputInputUtil.writeBoolean(out, this.oneTimeUse, "SAMLToken.oneTimeUse");
        ObjectOutputInputUtil.writeObject(out, this.assertionQname, "SAMLToken.assertionQname");
        ObjectOutputInputUtil.writeObject(out, this.audienceRestriction, "SAMLToken.audienceRestriction");
        ObjectOutputInputUtil.writeObject(out, this.createTime, "SAMLToken.createTime");
        ObjectOutputInputUtil.writeObject(out, this.expirationTime, "SAMLToken.expirationTime");
        ObjectOutputInputUtil.writeObject(out, this.holderOfKeyBytes, "SAMLToken.holderOfKeyBytes");
        ObjectOutputInputUtil.writeObject(out, this.keyIdentifierEncodingType, "SAMLToken.keyIdentifierEncodingType");
        ObjectOutputInputUtil.writeObject(out, this.keyIdentifierValueType, "SAMLToken.keyIdentifierValueType");
        ObjectOutputInputUtil.writeObject(out, this.samlAttrts, "SAMLToken.samlAttrts");
        ObjectOutputInputUtil.writeObject(out, this.stringAttributes, "SAMLToken.stringAttributes");
        ObjectOutputInputUtil.writeObject(out, this.tokenQName, "SAMLToken.tokenQName");
        ObjectOutputInputUtil.writeObject(out, this.valueType, "SAMLToken.valueType");
        ObjectOutputInputUtil.writeObject(out, this.nameId, "SAMLToken.nameId");
        ObjectOutputInputUtil.writeObject(out, this.authnInstant, "SAMLToken.authnInstant");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal(ObjectInput in)");
        }
        super.readExternal(in);
        String version = ObjectOutputInputUtil.readUTF(in, "SAMLToken.version");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SAMLToken.version=" + version);
        }
        if (VERSION_NUMBER.equals(version)) {
            this._identifier = ObjectOutputInputUtil.readUTF(in, "SAMLToken.identifier");
            this.authnMethod = ObjectOutputInputUtil.readUTF(in, "SAMLToken.authnMethod");
            this.confirmMethod = ObjectOutputInputUtil.readUTF(in, "SAMLToken.confirmMethod");
            this.hashcode = ObjectOutputInputUtil.readInt(in, "SAMLToken.hashcode");
            this.id = ObjectOutputInputUtil.readUTF(in, "SAMLToken.id");
            this.initiatorName = ObjectOutputInputUtil.readUTF(in, "SAMLToken.initiatorName");
            this.issuername = ObjectOutputInputUtil.readUTF(in, "SAMLToken.issuername");
            this.keyType = ObjectOutputInputUtil.readUTF(in, "SAMLToken.keyType");
            this.principal = ObjectOutputInputUtil.readUTF(in, "SAMLToken.principal");
            this.samlId = ObjectOutputInputUtil.readUTF(in, "SAMLToken.samlId");
            this.subjectDns = ObjectOutputInputUtil.readUTF(in, "SAMLToken.subjectDns");
            this.subjectIp = ObjectOutputInputUtil.readUTF(in, "SAMLToken.subjectIp");
            this.tokenName = ObjectOutputInputUtil.readUTF(in, "SAMLToken.tokenName");
            this.isForwardable = ObjectOutputInputUtil.readBoolean(in, "SAMLToken.isForwardable");
            this.oneTimeUse = ObjectOutputInputUtil.readBoolean(in, "SAMLToken.oneTimeUse");
            Object tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.assertionQname");
            if (tmp != null) {
                this.assertionQname = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.audienceRestriction")) != null) {
                this.audienceRestriction = (List)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.createTime")) != null) {
                this.createTime = (Date)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.expirationTime")) != null) {
                this.expirationTime = (Date)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.holderOfKeyBytes")) != null) {
                this.holderOfKeyBytes = (byte[])tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.keyIdentifierEncodingType")) != null) {
                this.keyIdentifierEncodingType = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.keyIdentifierValueType")) != null) {
                this.keyIdentifierValueType = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.samlAttrts")) != null) {
                this.samlAttrts = (List)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.stringAttributes")) != null) {
                this.stringAttributes = (Map)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.tokenQName")) != null) {
                this.tokenQName = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.valueType")) != null) {
                this.valueType = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.nameId")) != null) {
                this.nameId = (SAMLNameID)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "SAMLToken.authnInstant")) != null) {
                this.authnInstant = (Date)tmp;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readExternal(ObjectInput in)");
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        boolean isReadOnly = this.readOnly;
        return isReadOnly;
    }
}

