/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLTokenFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.util.SAMLIssuerConfigData;
import com.ibm.ws.wssecurity.platform.util.SAMLIssuerConfigDataFactory;
import com.ibm.ws.wssecurity.saml.config.impl.ConsumerConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.CredentialConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.KeyInformationConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.KeyStoreConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.ProviderConfigImpl;
import com.ibm.ws.wssecurity.util.SAMLTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;

public abstract class SAMLTokenFactoryImpl
extends SAMLTokenFactory {
    private static final TraceComponent tc = Tr.register(SAMLTokenFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLTokenFactoryImpl.class.getName();
    protected static Map<String, String> tokensMap = new HashMap<String, String>();
    protected static Map<String, String> wasTokensMap = new HashMap<String, String>();

    public SAMLTokenFactoryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SAMLTokenFactoryImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SAMLTokenFactoryImpl()");
        }
    }

    protected static final String getImplClassName(String vType) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getImplClassName(" + vType + ")");
        }
        boolean isServerSide = WSSContextManagerFactory.getInstance().processIsServer();
        String impl = tokensMap.get(vType);
        if (isServerSide) {
            impl = wasTokensMap.get(vType);
        }
        if (impl == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, vType, " is not implemented");
            }
            throw new WSSException("Unknown Token ValueType:" + vType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImplClassName(" + vType + "): " + impl);
        }
        return impl;
    }

    @Override
    public CredentialConfig newCredentialConfig(Subject subject) throws WSSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_NEWCREDENTIALCONFIG_PERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newCredentialConfig(Subject subject)");
        }
        CredentialConfigImpl aCredentialConfig = null;
        String principalName = null;
        if (subject != null) {
            SAMLToken aSAMLToken = null;
            try {
                aSAMLToken = SAMLTokenHelper.getSAMLTokenFromSubject(subject);
            }
            catch (SoapSecurityException e) {
                throw new WSSException(e);
            }
            SAMLNameID nameID = null;
            if (aSAMLToken == null) {
                Iterator<Principal> it = subject.getPrincipals().iterator();
                while (it.hasNext()) {
                    principalName = it.next().getName();
                    nameID = new SAMLNameID(principalName, null, null, null, null);
                }
            } else {
                nameID = aSAMLToken.getSAMLNameID();
                if (nameID == null) {
                    principalName = aSAMLToken.getPrincipal();
                    nameID = new SAMLNameID(principalName, null, null, null, null);
                }
            }
            if (nameID != null) {
                aCredentialConfig = new CredentialConfigImpl();
                aCredentialConfig.setSAMLNameID(nameID);
            }
            if (aSAMLToken != null) {
                if (aCredentialConfig == null) {
                    aCredentialConfig = new CredentialConfigImpl();
                }
                aCredentialConfig.setSAMLAttributes(aSAMLToken.getSAMLAttributes());
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (aSAMLToken.getAuthenticationMethod() != null && !aSAMLToken.getAuthenticationMethod().isEmpty()) {
                    map.put("AuthenticationMethod", aSAMLToken.getAuthenticationMethod());
                }
                if (aSAMLToken.getAuthenticationInstant() != null) {
                    map.put("AuthenticationInstant", aSAMLToken.getAuthenticationInstant());
                }
                aCredentialConfig.setProperties(map);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newCredentialConfig(Subject subject)");
        }
        return aCredentialConfig;
    }

    @Override
    public CredentialConfig newCredentialConfig() throws WSSException {
        return new CredentialConfigImpl();
    }

    @Override
    public SAMLToken newSAMLToken(Subject subject, RequesterConfig request, ProviderConfig providerConfig) throws WSSException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSAMLToken(Subject,  RequesterConfig, ProviderConfig)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_NEWSAMLTOKEN_PERM);
        }
        CredentialConfig aCredentialConfig = this.newCredentialConfig(subject);
        SAMLToken aSAMLToken = this.newSAMLToken(aCredentialConfig, request, providerConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newSAMLToken(Subject,  RequesterConfig, ProviderConfig)");
        }
        return aSAMLToken;
    }

    @Override
    public ProviderConfig newDefaultProviderConfig(String stsUri) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newDefaultProviderConfig(" + stsUri + ")");
        }
        SAMLIssuerConfigData samlIssuerDataCfg = (SAMLIssuerConfigData)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return SAMLIssuerConfigDataFactory.getInstance();
            }
        });
        String uri = samlIssuerDataCfg.getProperty("IssuerURI");
        if (stsUri != null && stsUri.isEmpty()) {
            uri = stsUri;
        }
        String ttl = samlIssuerDataCfg.getProperty("TimeToLiveMilliseconds");
        long ttll = 3600000L;
        if (ttl != null && !ttl.isEmpty()) {
            ttll = Long.parseLong(ttl);
        }
        ProviderConfigImpl samlIssuerCfg = new ProviderConfigImpl();
        samlIssuerCfg.setIssuerURI(uri);
        samlIssuerCfg.setTimeToLive(ttll);
        String storePath = samlIssuerDataCfg.getProperty("KeyStorePath");
        String storeRef = samlIssuerDataCfg.getProperty("KeyStoreRef");
        String storeType = samlIssuerDataCfg.getProperty("KeyStoreType");
        String storePass = samlIssuerDataCfg.getProperty("KeyStorePassword");
        KeyStoreConfigImpl ksc = new KeyStoreConfigImpl(storeType, storePath, storePass, storeRef);
        String keyName = samlIssuerDataCfg.getProperty("KeyName");
        String keyPath = samlIssuerDataCfg.getProperty("KeyPassword");
        String keyAlias = samlIssuerDataCfg.getProperty("KeyAlias");
        KeyInformationConfigImpl kic = new KeyInformationConfigImpl(keyAlias, keyPath, keyName);
        samlIssuerCfg.setKeyStoreConfig(ksc);
        samlIssuerCfg.setKeyInformationConfig(kic);
        String trustPass = samlIssuerDataCfg.getProperty("TrustStorePassword");
        String trustPath = samlIssuerDataCfg.getProperty("TrustStorePath");
        String trustType = samlIssuerDataCfg.getProperty("TrustStoreType");
        String trustRef = samlIssuerDataCfg.getProperty("TrustStoreRef");
        KeyStoreConfigImpl tsc = new KeyStoreConfigImpl(trustType, trustPath, trustPass, trustRef);
        samlIssuerCfg.setTrustStoreConfig(tsc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newDefaultProviderConfig(" + stsUri + ")");
        }
        return samlIssuerCfg;
    }

    @Override
    public Subject newSubject(SAMLToken aSAMLToken) throws WSSException {
        Subject fSubject;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSubject(SAMLToken aSAMLToken)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_NEWSUBJECT_PERM);
        }
        final String principal = aSAMLToken.getPrincipal();
        final WSSContextManager aWSSContextManager = WSSContextManagerFactory.getInstance();
        final String realm = aWSSContextManager.getDefaultRealm();
        final SAMLToken fSAMLToken = aSAMLToken;
        try {
            fSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Subject aSubject = aWSSContextManager.login(realm, principal);
                    aSubject.getPrivateCredentials().add(fSAMLToken);
                    return aSubject;
                }
            });
        }
        catch (Exception e) {
            throw new WSSException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newSubject(SAMLToken aSAMLToken)");
        }
        return fSubject;
    }

    @Override
    public ConsumerConfig newConsumerConfig() throws WSSException {
        ConsumerConfigImpl samlConsumerCfg = new ConsumerConfigImpl();
        return samlConsumerCfg;
    }

    @Override
    public SAMLToken newSAMLToken(ConsumerConfig consumer, InputStream in) throws WSSException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSAMLToken( ConsumerConfig, XMLStructure)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_NEWSAMLTOKEN_PERM);
        }
        try {
            XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader(in);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
            OMElement om = staxOMBuilder.getDocumentElement();
            OMStructure xml = new OMStructure(om);
            return this.newSAMLToken(consumer, xml);
        }
        catch (Exception e) {
            throw new WSSException(e.getMessage(), e.getCause());
        }
    }

    static {
        tokensMap.put("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", "com.ibm.ws.wssecurity.wssapi.token.impl.SAML11TokenImpl");
        tokensMap.put("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", "com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenImpl");
        wasTokensMap.put("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1", "com.ibm.ws.wssecurity.wssapi.token.impl.SAML11TokenImpl");
        wasTokensMap.put("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0", "com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenImpl");
    }
}

