/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SAMLGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLTokenFactory;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.trust.WSSTrustClient;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.SAMLTokenCacheHelper;
import com.ibm.ws.wssecurity.util.SAMLTokenHelper;
import com.ibm.ws.wssecurity.util.SamlConfigUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.GenericSecurityTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.config.SamlConstants;
import com.ibm.wsspi.wssecurity.trust.config.ProviderConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;

public class SAMLGenerateLoginModule
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    List<SecurityToken> _processedTokens;
    List<SecurityToken> _insertedTokens;
    SecurityTokenManager _securityTokenManager;
    MessageContext messageContext = null;
    Map<Object, Object> _context;
    OMNode _referencedTokenElement;
    private static final TraceComponent tc = Tr.register(SAMLGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLGenerateLoginModule.class.getName();
    private static final String UNAUTHENTICATED = "UNAUTHENTICATED";
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._subject = subject;
        this._handler = callbackHandler;
        this._sharedState = sharedState;
        this._options = options;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        OMStructure xml;
        SAMLGenerateCallback samlCallback = new SAMLGenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{samlCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "138", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", e);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        this.messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        SecurityToken samlToken = null;
        Collection<SecurityToken> tokens = this._securityTokenManager.getTokens(config2);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                if (!(t instanceof SAMLTokenImpl)) continue;
                samlToken = (SAMLTokenImpl)t;
                break;
            }
        }
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(this.messageContext);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        if (samlToken == null) {
            samlToken = this.createSAMLToken(samlCallback, gconfig, config2, this.messageContext, isServer);
        } else if (!isServer && (xml = (OMStructure)samlToken.getXML()) != null) {
            this._referencedTokenElement = xml.getNode();
        }
        this._processedTokens.add(samlToken);
        if (this.requireDKT()) {
            this.populateSharedStateForDKT((SAMLToken)samlToken);
        } else {
            this._context.put(Constants.WSSECURITY_KEYINFO_TYPE, "KEYID");
        }
        return true;
    }

    private SAMLToken createSAMLToken(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx, boolean isServer) throws LoginException {
        SAMLToken samlToken = null;
        String serviceEndpointAddress = null;
        if (mCtx.getTo() != null) {
            serviceEndpointAddress = mCtx.getTo().getAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from mc) is: " + serviceEndpointAddress);
            }
        } else {
            Options options = mCtx.getOptions();
            if (options != null) {
                serviceEndpointAddress = options.getTo().getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from options, from mc returns null) is: " + serviceEndpointAddress);
            }
        }
        samlToken = isServer ? this.processServerSideSAML(samlCallback, gconfig, config2, mCtx) : this.processClientSideSAML(samlCallback, gconfig, config2, mCtx);
        return samlToken;
    }

    private SAMLToken processClientSideSAML(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx) throws LoginException {
        SAMLToken samlToken = this.getSAMLTokenFromMessageContext(samlCallback, config2, this.messageContext);
        if (samlToken == null) {
            String requestMode;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not SAML found from RequestContext. Continue to issue.");
            }
            samlToken = (requestMode = samlCallback.getTokenRequest()) == null || requestMode.equalsIgnoreCase("issue") || requestMode.equalsIgnoreCase("issueByWSPrincipal") ? this.processClientSideSAMLIssue(samlCallback, gconfig, config2, mCtx) : this.processPropagationToken(samlCallback, config2, mCtx);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found SAMLToken from RequestContext. Not issue performed.");
        }
        this.messageContext.setProperty(SAMLTokenHelper.SAMLTOKEN_ID, samlToken.getSamlID());
        SAMLTokenHelper.setSAMLTokenToContext(samlToken, this.messageContext);
        this.mapKeyIdentifierToTokenValueType(samlToken);
        this._insertedTokens.add(samlToken);
        this.createSecurityTokenReferenceElement(samlToken, config2);
        return samlToken;
    }

    private SAMLTokenImpl processClientSideSAMLIssue(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx) throws LoginException {
        SAMLTokenImpl token = null;
        long cushion = samlCallback.getCacheCushion();
        boolean caching = samlCallback.cacheToken();
        if (caching) {
            token = (SAMLTokenImpl)SAMLTokenCacheHelper.getSAMLToken(mCtx, config2, cushion);
        }
        KeyStoreManager.KeyInformation keyInfo = null;
        if (samlCallback.getKeyType() != null && (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public"))) {
            keyInfo = this.getKeyInformation(samlCallback);
        }
        if (token == null) {
            String stsEndpointAddress = samlCallback.getStsURI();
            if (stsEndpointAddress != null && stsEndpointAddress.indexOf("www.ibm.com/SelfIssue") > -1) {
                stsEndpointAddress = null;
            }
            if (stsEndpointAddress != null && stsEndpointAddress.equalsIgnoreCase(SamlConstants.SAMLTOKEN_SELF_ISSUER)) {
                stsEndpointAddress = null;
            }
            token = stsEndpointAddress == null || stsEndpointAddress.isEmpty() ? this.selfIssueSAMLToken(samlCallback, gconfig, config2, mCtx, keyInfo) : this.stsIssueSAMLToken(samlCallback, gconfig, config2, mCtx, keyInfo);
            if (caching) {
                SAMLTokenCacheHelper.setSAMLTokenCacheKeys(token, mCtx, config2, cushion);
            }
        }
        if (token != null) {
            String confirmationMethod;
            String id = IdUtils.getInstance().makeUniqueId(this._context, "saml_");
            token.setId(id);
            if ((samlCallback.getConfirmationMethod().contains("holder") || samlCallback.getConfirmationMethod().contains("Holder")) && (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public"))) {
                Key privateKey = null;
                try {
                    privateKey = keyInfo.getPrivateOrSecretKey();
                }
                catch (Exception e) {
                    throw new LoginException(e.getMessage());
                }
                token.setKey(61, privateKey);
                token.setKey(64, privateKey);
            }
            if ((confirmationMethod = token.getConfirmationMethod()) == null || confirmationMethod.isEmpty()) {
                try {
                    confirmationMethod = samlCallback.getConfirmationMethod();
                    confirmationMethod = SamlConfigUtils.getNormalizedConfirmationMethod(confirmationMethod, config2.getType().getLocalPart());
                    token.setConfirmationMethod(confirmationMethod);
                    Tr.debug(tc, "Set Token Confirmation Method = " + confirmationMethod);
                }
                catch (Exception e) {}
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fail to acquire SAML assertion");
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7510E"));
        }
        return token;
    }

    private SAMLToken processPropagationToken(SAMLGenerateCallback samlCallback, TokenGeneratorConfig config2, MessageContext mCtx) throws LoginException {
        SAMLToken samlToken;
        boolean valid;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processPropagationToken");
            }
            valid = false;
            samlToken = null;
            try {
                Subject subj = SAMLTokenHelper.getRunAsSubject(mCtx);
                samlToken = SAMLTokenHelper.getSAMLTokenFromSubject(subj);
                if (samlToken == null) break block12;
                QName cVersion = config2.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenType localname from Config=" + cVersion.getLocalPart());
                    Tr.debug(tc, "TokenType namespace from Config=" + cVersion.getNamespaceURI());
                }
                QName tVersion = samlToken.getValueType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Propagated Token ValueType localname=" + tVersion.getLocalPart());
                    Tr.debug(tc, "Propagated Token ValueType namespace=" + tVersion.getNamespaceURI());
                }
                if (!NamespaceUtil.equals(cVersion, tVersion)) break block12;
                String confirmationMethod = SamlConfigUtils.getNormalizedConfirmationMethod(samlCallback.getConfirmationMethod(), cVersion.getLocalPart());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Normalized confirmationMethod=" + confirmationMethod);
                    Tr.debug(tc, "Token confirmationMethod=" + samlToken.getConfirmationMethod());
                }
                if (!confirmationMethod.equalsIgnoreCase(samlToken.getConfirmationMethod()) && samlToken.getConfirmationMethod() != null) break block12;
                Date expires = samlToken.getSamlExpires();
                Date now = new Date();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expires=" + expires);
                }
                if (now.getTime() - samlCallback.getCacheCushion() >= expires.getTime()) break block12;
                valid = true;
                SAMLTokenImpl clonedToken = SAMLTokenHelper.cloneSAMLToken(samlToken);
                if ((samlCallback.getConfirmationMethod().contains("holder") || samlCallback.getConfirmationMethod().contains("Holder")) && (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public"))) {
                    Key privateKey = null;
                    try {
                        privateKey = this.getPrivateKey(samlCallback);
                    }
                    catch (Exception e) {
                        throw new LoginException(e.getMessage());
                    }
                    clonedToken.setKey(61, privateKey);
                    clonedToken.setKey(64, privateKey);
                }
                samlToken = clonedToken;
            }
            catch (SoapSecurityException e) {
                throw new LoginException(e.getMessage());
            }
        }
        if (!valid) {
            samlToken = null;
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7514E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPropagationToken:" + samlToken.getSamlID());
        }
        return samlToken;
    }

    private SAMLToken processServerSideSAML(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx) throws LoginException {
        SAMLToken samlToken = SAMLTokenHelper.getSAMLTokenFromContext(mCtx);
        String assertionID = SAMLTokenHelper.getSAMLTokenAssertionIDFromContext(mCtx);
        if (assertionID == null) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7511E"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SAML AssertionID = " + assertionID);
        }
        return samlToken;
    }

    private SAMLTokenImpl selfIssueSAMLToken(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx, KeyStoreManager.KeyInformation keyInfo) throws LoginException {
        SecurityToken samlToken = null;
        try {
            final SAMLTokenFactory samlFactory = SAMLTokenFactory.getInstance(config2.getType().getLocalPart());
            final RequesterConfig reqData = this.getRequesterConfig(gconfig, samlFactory, samlCallback, mCtx, config2.getType().getLocalPart());
            if (!samlCallback.isSignatureRequired()) {
                reqData.setAssertionSignatureRequired(false);
            }
            String issueByPrincipal = samlCallback.getTokenRequest();
            boolean issueByPrincipalOnly = false;
            if (issueByPrincipal != null && issueByPrincipal.equalsIgnoreCase("issueByWSPrincipal")) {
                issueByPrincipalOnly = true;
            }
            final boolean isIssueByPrincipal = issueByPrincipalOnly;
            String stsUri = samlCallback.getStsURI();
            final com.ibm.wsspi.wssecurity.saml.config.ProviderConfig samlIssuerCfg = samlFactory.newDefaultProviderConfig(stsUri);
            final Subject fSubject = SAMLTokenHelper.getRunAsSubject(mCtx);
            samlToken = (SecurityToken)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    CredentialConfig cred = null;
                    if (isIssueByPrincipal) {
                        cred = samlFactory.newCredentialConfig();
                        String principalName = null;
                        if (fSubject != null) {
                            Iterator<Principal> it = fSubject.getPrincipals().iterator();
                            if (it.hasNext()) {
                                principalName = it.next().getName();
                            }
                            cred.setRequesterNameID(principalName);
                        }
                    } else {
                        cred = samlFactory.newCredentialConfig(fSubject);
                    }
                    if (cred == null) {
                        cred.setRequesterNameID(SAMLGenerateLoginModule.UNAUTHENTICATED);
                    }
                    return samlFactory.newSAMLToken(cred, reqData, samlIssuerCfg);
                }
            });
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        return (SAMLTokenImpl)samlToken;
    }

    private RequesterConfig getRequesterConfig(WSSGeneratorConfig gconfig, SAMLTokenFactory samlFactory, SAMLGenerateCallback samlCallback, MessageContext mCtx, String tokenVersion) throws LoginException {
        RequesterConfig reqData = null;
        String method = samlCallback.getConfirmationMethod();
        try {
            method = SamlConfigUtils.getNormalizedConfirmationMethod(method, tokenVersion);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        if (method.contains("bearer")) {
            reqData = samlFactory.newBearerTokenGenerateConfig();
        } else if (method.contains("sender")) {
            reqData = samlFactory.newSenderVouchesTokenGenerateConfig();
        } else if (samlCallback.getKeyType().contains("symmetric") || samlCallback.getKeyType().contains("Symmetric")) {
            reqData = samlFactory.newSymmetricHolderOfKeyTokenGenerateConfig();
            reqData.setKeyAliasForAppliesTo(samlCallback.getTargetServiceAlias());
            String algorithmSuite = ((PolicyOutboundConfig)gconfig).getAlgorithmSuite();
            if (algorithmSuite != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Algorithm Suite = " + algorithmSuite);
                }
                String keySizeStr = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
                reqData.getRSTTProperties().put("wstrustClientKeySize", keySizeStr);
            }
        } else if (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public")) {
            reqData = samlFactory.newAsymmetricHolderOfKeyTokenGenerateConfig();
            reqData.setKeyAliasForRequester(samlCallback.getAlias());
        } else {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7512E", new String[]{method}));
        }
        String serviceEndpointAddress = null;
        if (mCtx.getTo() != null) {
            serviceEndpointAddress = mCtx.getTo().getAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from mc) is: " + serviceEndpointAddress);
            }
        } else {
            Options options = mCtx.getOptions();
            if (options != null) {
                serviceEndpointAddress = options.getTo().getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from options, from mc returns null) is: " + serviceEndpointAddress);
            }
        }
        reqData.getRSTTProperties().put("wstrustClientAppliesToAddress", serviceEndpointAddress);
        reqData.setConfirmationMethod(samlCallback.getConfirmationMethod());
        return reqData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SAMLTokenImpl stsIssueSAMLToken(SAMLGenerateCallback samlCallback, WSSGeneratorConfig gconfig, TokenGeneratorConfig config2, MessageContext mCtx, KeyStoreManager.KeyInformation keyInfo) throws LoginException {
        SAMLTokenImpl samlToken = null;
        String stsEndpointAddress = null;
        try {
            stsEndpointAddress = samlCallback.getStsURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  stsEndpointAddress:  " + stsEndpointAddress);
            }
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        String serviceEndpointAddress = null;
        if (mCtx.getTo() != null) {
            serviceEndpointAddress = mCtx.getTo().getAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from mc) is: " + serviceEndpointAddress);
            }
        } else {
            Options options = mCtx.getOptions();
            if (options != null) {
                serviceEndpointAddress = options.getTo().getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The End Point Address (from options, from mc returns null) is: " + serviceEndpointAddress);
            }
        }
        String appName = null;
        ConfigurationContext axisConfigCtx = mCtx.getConfigurationContext();
        if (axisConfigCtx == null) throw new LoginException();
        AxisConfiguration axisConfig = axisConfigCtx.getAxisConfiguration();
        if (axisConfig == null) throw new LoginException();
        Parameter p = axisConfig.getParameter(ConstantsRetrieverFactory.getInstance().getApplicationNameKey());
        if (p != null) {
            appName = (String)p.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  appName:  " + appName);
            }
        }
        if (appName == null || appName.isEmpty()) {
            appName = "test";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  appName:  " + appName);
            }
        }
        String algorithmSuite = ((PolicyOutboundConfig)gconfig).getAlgorithmSuite();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Algorithm Suite = " + algorithmSuite);
        }
        String keySizeStr = null;
        if (algorithmSuite != null) {
            keySizeStr = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
        }
        if (samlCallback.getKeySize() != null && !samlCallback.getKeySize().isEmpty()) {
            keySizeStr = samlCallback.getKeySize();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  keySizeStr:  " + keySizeStr);
        }
        try {
            OMStructure oms;
            String wstnamespace = samlCallback.getWSTrustNamespace();
            if (wstnamespace == null) {
                wstnamespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  WS-Trust namespace:  " + wstnamespace);
            }
            ProviderConfig providerConfig = WSSTrustClient.newProviderConfig(wstnamespace, stsEndpointAddress);
            providerConfig.setPolicySetName(samlCallback.getStsPolicy());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  policySetName:  " + samlCallback.getStsPolicy());
            }
            providerConfig.setBindingName(samlCallback.getStsBinding());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  stsBinding:  " + samlCallback.getStsBinding());
            }
            providerConfig.setApplicationName(appName);
            providerConfig.setBindingScope(samlCallback.getStsBindingScope());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  stsBindingScope:  " + samlCallback.getStsBindingScope());
            }
            providerConfig.setLoadPolicySetAndBindingFromJar(samlCallback.getLoadStsPolicySetAndBindingFromJar());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  loadStsPolicySetAndBindingFromJar:  " + samlCallback.getLoadStsPolicySetAndBindingFromJar());
            }
            boolean collectionRequest = samlCallback.isCollectionRequest();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  collectionRequest:  " + collectionRequest);
            }
            com.ibm.wsspi.wssecurity.trust.config.RequesterConfig request = WSSTrustClient.newRequesterConfig(wstnamespace);
            request.put("wstrustClientAppliesToAddress", serviceEndpointAddress);
            request.put("wstrustClientKeyType", samlCallback.getKeyType());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  keyType:  " + samlCallback.getKeyType());
            }
            request.put("wstrustClientTokenType", config2.getType().getLocalPart());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  tokenType:  " + config2.getType().getLocalPart());
            }
            if (keySizeStr != null) {
                request.put("wstrustClientKeySize", keySizeStr);
            }
            if (keyInfo != null && (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public")) && (oms = this.getUseKey(keyInfo, samlCallback, wstnamespace)) != null) {
                request.addXML(oms);
            }
            request.setSOAPNamespace("http://schemas.xmlsoap.org/soap/envelope/");
            if (samlCallback.getStsSoapVersion() != null && samlCallback.getStsSoapVersion().equals("1.1")) {
                request.setSOAPNamespace("http://schemas.xmlsoap.org/soap/envelope/");
            } else if (samlCallback.getStsSoapVersion() != null && samlCallback.getStsSoapVersion().equals("1.2")) {
                request.setSOAPNamespace("http://www.w3.org/2003/05/soap-envelope");
            } else {
                String soapLevel = mCtx.getEnvelope().getNamespace().getName();
                if (com.ibm.ws.wssecurity.common.Constants.NS_SOAP12.equalsIgnoreCase(soapLevel)) {
                    request.setSOAPNamespace("http://www.w3.org/2003/05/soap-envelope");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAMLGenerateLoginModule.stsIssueSAMLToken()...  soapNamespace:  " + request.getSOAPNamespace());
            }
            request.setRSTTProperties(samlCallback.getRSTTProperties());
            WSSTrustClient factory = WSSTrustClient.getInstance(providerConfig);
            List<SecurityToken> tokens = null;
            if (!collectionRequest) {
                tokens = factory.issue(providerConfig, request);
            } else {
                ArrayList<com.ibm.wsspi.wssecurity.trust.config.RequesterConfig> requestList = new ArrayList<com.ibm.wsspi.wssecurity.trust.config.RequesterConfig>();
                requestList.add(request);
                tokens = factory.issue(providerConfig, requestList);
            }
            if (tokens == null) return samlToken;
            for (SecurityToken token : tokens) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "response contains:  " + token.getValueType().getLocalPart());
                }
                if (!(token instanceof SAMLTokenImpl)) continue;
                samlToken = (SAMLTokenImpl)token;
            }
            return samlToken;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.CWWSS7513E", new String[]{e.toString()}));
                e.printStackTrace();
            }
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        this._context.put(Constants.WSSECURITY_TOKENELEMENT_REFERENCED, this._referencedTokenElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }

    private boolean requireDKT() {
        KeyInfoContentGeneratorConfig keyInfoContent = (KeyInfoContentGeneratorConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        DerivedKeyInfoConfig dkic = null;
        if (keyInfoContent != null) {
            dkic = keyInfoContent.getDerivedKeyInfoConfig();
        }
        boolean requireDKT = false;
        if (dkic != null) {
            requireDKT = dkic.isRequireDerivedKeys();
        }
        return requireDKT;
    }

    private void populateSharedStateForDKT(SAMLToken token) {
        String dkeyTokenIdType = Constants.WSSECURITY_KEY_ID;
        QName dkeyTokenValueType = token.getKeyIdentifierValueType();
        String KEYIDvalue = token.getSamlID();
        byte[] secretBytes = token.getHolderOfKeyBytes();
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId", KEYIDvalue);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken", dkeyTokenIdType);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType", dkeyTokenValueType);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secretBytes);
        this._processedTokens.add(token);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
    }

    private void mapKeyIdentifierToTokenValueType(SAMLToken token) {
        QName dkeyTokenValueType = token.getKeyIdentifierValueType();
        if (dkeyTokenValueType != null) {
            String KEYIDvalue = token.getSamlID();
            String key = dkeyTokenValueType.getLocalPart() + ":" + KEYIDvalue;
            this.messageContext.setProperty(key, token.getValueType());
        }
    }

    private Key getPrivateKey(SAMLGenerateCallback samlCallback) {
        String storePath = samlCallback.getKeyStorePath();
        String storeType = samlCallback.getKeyStoreType();
        char[] storePassword = SAMLTokenHelper.decodePassword(samlCallback.getKeyStorePassword());
        String keyStoreRef = samlCallback.getKeyStoreReference();
        String alias = samlCallback.getAlias();
        char[] keyPassword = SAMLTokenHelper.decodePassword(samlCallback.getKeyPassword());
        String keyName = samlCallback.getKeyName();
        Key pKey = null;
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        try {
            keyInformation = ksManager.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
            pKey = keyInformation.getPrivateOrSecretKey();
        }
        catch (Exception e) {
            // empty catch block
        }
        return pKey;
    }

    private KeyStoreManager.KeyInformation getKeyInformation(SAMLGenerateCallback samlCallback) throws LoginException {
        String storePath = samlCallback.getKeyStorePath();
        String storeType = samlCallback.getKeyStoreType();
        char[] storePassword = SAMLTokenHelper.decodePassword(samlCallback.getKeyStorePassword());
        String keyStoreRef = samlCallback.getKeyStoreReference();
        String alias = samlCallback.getAlias();
        char[] keyPassword = SAMLTokenHelper.decodePassword(samlCallback.getKeyPassword());
        String keyName = samlCallback.getKeyName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storePath=" + storePath);
            Tr.debug(tc, "alias=" + alias);
            Tr.debug(tc, "KeyName=" + keyName);
        }
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        try {
            keyInformation = ksManager.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to create KeyInformation:" + e.getMessage());
            }
            throw new LoginException(e.getMessage());
        }
        return keyInformation;
    }

    private OMStructure getUseKey(KeyStoreManager.KeyInformation keyInfo, SAMLGenerateCallback samlCallback, String wstnamespace) throws LoginException {
        String keyInfoType = samlCallback.getUsekeyType();
        if (keyInfoType == null || keyInfoType.isEmpty()) {
            return null;
        }
        if (keyInfoType.equalsIgnoreCase("KeyValue")) {
            keyInfoType = "KeyValue";
        } else if (keyInfoType.equalsIgnoreCase("X509Certificate")) {
            keyInfoType = "X509Certificate";
        } else if (keyInfoType.equalsIgnoreCase("X509IssuerSerial")) {
            keyInfoType = "X509IssuerSerial";
        } else if (keyInfoType.equalsIgnoreCase("X509SKI")) {
            keyInfoType = "X509SKI";
        } else if (keyInfoType.equalsIgnoreCase("X509SubjectName")) {
            keyInfoType = "X509SubjectName";
        } else if (keyInfoType.equalsIgnoreCase("Thumbprint")) {
            keyInfoType = "Thumbprint";
        }
        OMElement keyValue = null;
        OMStructure oms = null;
        try {
            keyValue = KeyInfoUtil.createKeyInfo(keyInfoType, keyInfo, null);
            OMElement usekey = omFactory.createOMElement(new QName(wstnamespace, "UseKey", "wst"));
            usekey.addChild(keyValue);
            oms = new OMStructure(usekey);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        return oms;
    }

    private void createSecurityTokenReferenceElement(SAMLToken token, TokenGeneratorConfig config2) {
        Map<Object, Object> tokenProps = config2.getProperties();
        String signToken = (String)tokenProps.get("signToken");
        if (signToken == null || signToken.isEmpty()) {
            return;
        }
        OMElement parent = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        OMFactory factory = parent.getOMFactory();
        int wssVersion = 0;
        Object obj = null;
        obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement elem1 = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
        if (isDecl) {
            elem1.declareNamespace(nsWsse, "wsse");
        }
        OMElement elem12 = factory.createOMElement("KeyIdentifier", nsWsse, pWsse);
        elem12.addAttribute("ValueType", token.getKeyIdentifierValueType().getLocalPart(), null);
        elem12.setText(token.getId());
        elem1.addChild(elem12);
        OMStructure oms = new OMStructure(elem1);
        GenericSecurityTokenImpl gToken = new GenericSecurityTokenImpl();
        gToken.setXML(oms);
        this._insertedTokens.add(gToken);
    }

    private SAMLToken getSAMLTokenFromMessageContext(SAMLGenerateCallback samlCallback, TokenGeneratorConfig config2, MessageContext mCtx) throws LoginException {
        boolean valid;
        SAMLToken samlToken;
        block26: {
            samlToken = (SAMLToken)Axis2Util.getProperty(mCtx, SamlConstants.SAMLTOKEN_IN_MESSAGECONTEXT);
            valid = true;
            if (samlToken != null) {
                valid = false;
                try {
                    QName cVersion = config2.getType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TokenType localname from Config=" + cVersion.getLocalPart());
                    }
                    QName tVersion = samlToken.getValueType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token ValueType localname=" + tVersion.getLocalPart());
                    }
                    if (NamespaceUtil.equals(cVersion, tVersion)) {
                        String confirmationMethod = SamlConfigUtils.getNormalizedConfirmationMethod(samlCallback.getConfirmationMethod(), cVersion.getLocalPart());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Normalized confirmationMethod=" + confirmationMethod);
                            Tr.debug(tc, "Token confirmationMethod=" + samlToken.getConfirmationMethod());
                        }
                        if (confirmationMethod.equalsIgnoreCase(samlToken.getConfirmationMethod()) || samlToken.getConfirmationMethod() == null) {
                            Date expires = samlToken.getSamlExpires();
                            long clockSkew = 10800000L;
                            Date now = new Date();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "expires=" + expires);
                            }
                            if (samlCallback.isFailOverToTokenRequest()) {
                                if (now.getTime() + samlCallback.getCacheCushion() < expires.getTime()) {
                                    valid = true;
                                }
                            } else if (now.getTime() - samlCallback.getCacheCushion() < expires.getTime()) {
                                valid = true;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug(tc, "Exception while getting SAMLToken from MessageContext:" + e.getMessage());
                }
            }
        }
        if (!valid) {
            if (!samlCallback.isFailOverToTokenRequest()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid SAMLToken " + samlToken.getSamlID());
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7514E"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid SAMLToken " + samlToken.getSamlID());
            }
            samlToken = null;
        }
        if (samlToken != null && samlToken instanceof SAMLTokenImpl) {
            SAMLTokenImpl token = (SAMLTokenImpl)samlToken;
            String id = samlToken.getId();
            if (id == null || id.isEmpty()) {
                token.setId(samlToken.getSamlID());
            }
            if ((samlCallback.getConfirmationMethod().contains("holder") || samlCallback.getConfirmationMethod().contains("Holder")) && (samlCallback.getKeyType().contains("public") || samlCallback.getKeyType().contains("Public"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create Key for holder-of-key");
                }
                try {
                    KeyStoreManager.KeyInformation keyInfo = this.getKeyInformation(samlCallback);
                    Key privateKey = keyInfo.getPrivateOrSecretKey();
                    token.setKey(61, privateKey);
                    token.setKey(64, privateKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Add Key for holder-of-key of Publickey");
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Fail to process privateKey for holder-of-key." + e.getMessage());
                    }
                    throw new LoginException(e.getMessage());
                }
            }
            samlToken = token;
        }
        if (samlToken != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Founf valid SAMLToken from RequestContext:" + samlToken.getSamlID());
        }
        return samlToken;
    }
}

