/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SAMLConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLTokenFactory;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.saml.common.util.IdUtils;
import com.ibm.ws.wssecurity.saml.config.impl.ConsumerConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.KeyInformationConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.KeyStoreConfigImpl;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedDataConsumer;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.SAMLTokenHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityFaultCode;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

public class SAMLConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SAMLConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLConsumeLoginModule.class.getName();
    private static CacheableTokenCache cacheObject = CacheableTokenCacheFactory.getInstance();
    private static long extraTime = CacheConfigFactory.getInstance().getCacheGraceTimeMilliseconds();
    private static long cushionTime = CacheConfigFactory.getInstance().getCacheCushionMilliseconds();
    private static long clockSkew = CacheConfigFactory.getInstance().getClockSkewToleranceMilliseconds();
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._sharedState = sharedState;
        this._options = options;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        SAMLConsumeCallback samlCallback = new SAMLConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{samlCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "127", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        QName vtype = config2.getType();
        if (vtype == null || !vtype.getLocalPart().contains("SAML")) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7515E", new String[]{vtype.toString()}));
        }
        WSSConsumerConfig cconfig = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (target == null) {
            boolean isKeyId;
            boolean isStrref;
            if (keyInfoType == null) {
                isStrref = false;
                isKeyId = false;
            } else {
                isKeyId = ConfigUtil.isKeyInfoKeyid(keyInfoType);
                isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            }
            this.resolveKeyInfo(samlCallback, config2, cconfig, messageContext, keyInfoType, isKeyId, isStrref, this._securityTokenManager, this._context);
        } else if (target.getLocalName().equals("DerivedKeyToken")) {
            SAMLToken samlToken = this.preProcessDKTokenElement(target, config2, messageContext);
            byte[] secret = samlToken.getHolderOfKeyBytes();
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secret);
            this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", samlToken);
        } else if (target.getLocalName().equals("Assertion") && target.getNamespace().getNamespaceURI().indexOf("SAML") > 0) {
            this._token = SAMLConsumeLoginModule.processSAMLElement(samlCallback, target, config2, cconfig, messageContext, this._context);
            messageContext.setProperty("samlAssertionId", this._token);
        } else if (target.getLocalName().equals("SecurityTokenReference")) {
            this._token = this.resolveSTR(target, config2, messageContext);
        } else if (target.getLocalName().equals("EncryptedData") || target.getLocalName().equals("EncryptedAssertion")) {
            this._token = SAMLConsumeLoginModule.processEncryptedData(samlCallback, target, config2, cconfig, messageContext, this._context);
        } else {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7515E", new String[]{target.getNamespace().getNamespaceURI()}));
        }
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        if (isServer && this._token != null && this._token instanceof SAMLToken) {
            messageContext.setProperty(SAMLTokenHelper.SAMLTOKEN_ID, ((SAMLToken)this._token).getSamlID());
            SAMLTokenHelper.setSAMLTokenToContext((SAMLToken)this._token, messageContext);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (this._token != null) {
            this._securityTokenManager.addToken(this._token);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token hash value = " + this._token.hashCode());
            }
            this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }

    private static final SAMLToken processSAMLElement(SAMLConsumeCallback samlCallback, OMElement target, TokenConsumerConfig config2, WSSConsumerConfig cconfig, MessageContext messageContext, Map<Object, Object> context) throws LoginException {
        String tokenId = null;
        QName idattr = IdUtils.getInstance().getIdAttributeName(target);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
        }
        if (idattr != null) {
            tokenId = target.getAttributeValue(idattr);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier of the token is [" + tokenId + "]");
        }
        ConsumerConfigImpl samlConsumerCfg = new ConsumerConfigImpl();
        samlConsumerCfg.setAliasForTokenProvider(samlCallback.getTrustedSTSAlias());
        samlConsumerCfg.setTrustAnySTS(samlCallback.isTrustAnySigner());
        samlConsumerCfg.setAssertionSignatureRequired(samlCallback.isSignatureRequired());
        samlConsumerCfg.setClockSkew(samlCallback.getClockSkew());
        String algorithmSuite = ((PolicyInboundConfig)cconfig).getAlgorithmSuite();
        if (algorithmSuite != null) {
            String algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            if (algorithmSuite.contains("Basic256")) {
                algorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            } else if (algorithmSuite.contains("Basic192")) {
                algorithm = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            }
            samlConsumerCfg.setAlgorithmSuite(algorithm);
        }
        char[] storepass = SAMLTokenHelper.decodePassword(samlCallback.getKeyStorePassword());
        KeyStoreConfigImpl ksc = null;
        KeyStoreConfigImpl tsc = null;
        KeyInformationConfigImpl kic = null;
        if (storepass != null && storepass.length > 0) {
            ksc = new KeyStoreConfigImpl(samlCallback.getKeyStoreType(), samlCallback.getKeyStorePath(), new String(storepass), samlCallback.getKeyStoreReference());
        }
        if ((storepass = SAMLTokenHelper.decodePassword(samlCallback.getTrustStorePassword())) != null && storepass.length > 0) {
            tsc = new KeyStoreConfigImpl(samlCallback.getTrustStoreType(), samlCallback.getTrustStorePath(), new String(storepass), null);
        }
        String alias = samlCallback.getAlias();
        storepass = SAMLTokenHelper.decodePassword(samlCallback.getKeyPassword());
        String keyPass = null;
        if (storepass != null && storepass.length > 0) {
            keyPass = new String(storepass);
        }
        if (alias != null && !alias.isEmpty()) {
            kic = new KeyInformationConfigImpl(samlCallback.getAlias(), keyPass, samlCallback.getKeyName());
        }
        samlConsumerCfg.setKeyStoreConfig(ksc);
        samlConsumerCfg.setKeyInformationConfig(kic);
        samlConsumerCfg.setTrustStoreConfig(tsc);
        SAMLToken samlToken = null;
        try {
            SAMLTokenFactory wssTokenFactory = SAMLTokenFactory.getInstance(config2.getType().getLocalPart());
            OMStructure xml = new OMStructure();
            xml.setNode(target);
            samlToken = wssTokenFactory.newSAMLToken((ConsumerConfig)samlConsumerCfg, xml);
        }
        catch (Exception e) {
            QName soapFault = SoapSecurityFaultCode.InvalidSecurityToken;
            context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The SAML hash value = " + samlToken.hashCode());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSAMLElement=" + samlToken);
        }
        return samlToken;
    }

    private static final SecurityToken processEncryptedData(SAMLConsumeCallback samlCallback, OMElement target, TokenConsumerConfig config2, WSSConsumerConfig cconfig, MessageContext messageContext, Map<Object, Object> context) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processEncryptedAssertion=" + target.getLocalName());
        }
        String tokenId = null;
        QName idattr = IdUtils.getInstance().getIdAttributeName(target);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
        }
        if (idattr != null) {
            tokenId = target.getAttributeValue(idattr);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier of the token is [" + tokenId + "]");
        }
        ConsumerConfigImpl samlConsumerCfg = new ConsumerConfigImpl();
        samlConsumerCfg.setAliasForTokenProvider(samlCallback.getTrustedSTSAlias());
        String algorithmSuite = ((PolicyInboundConfig)cconfig).getAlgorithmSuite();
        if (algorithmSuite != null) {
            String algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            if (algorithmSuite.contains("Basic256")) {
                algorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            } else if (algorithmSuite.contains("Basic192")) {
                algorithm = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            }
            samlConsumerCfg.setAlgorithmSuite(algorithm);
        }
        char[] storepass = SAMLTokenHelper.decodePassword(samlCallback.getKeyStorePassword());
        KeyStoreConfigImpl ksc = null;
        KeyStoreConfigImpl tsc = null;
        KeyInformationConfigImpl kic = null;
        if (storepass != null && storepass.length > 0) {
            ksc = new KeyStoreConfigImpl(samlCallback.getKeyStoreType(), samlCallback.getKeyStorePath(), new String(storepass), samlCallback.getKeyStoreReference());
        }
        if ((storepass = SAMLTokenHelper.decodePassword(samlCallback.getTrustStorePassword())) != null && storepass.length > 0) {
            tsc = new KeyStoreConfigImpl(samlCallback.getTrustStoreType(), samlCallback.getTrustStorePath(), new String(storepass), null);
        }
        String alias = samlCallback.getAlias();
        storepass = SAMLTokenHelper.decodePassword(samlCallback.getKeyPassword());
        String keyPass = null;
        if (storepass != null && storepass.length > 0) {
            keyPass = new String(storepass);
        }
        if (alias != null && !alias.isEmpty()) {
            kic = new KeyInformationConfigImpl(samlCallback.getAlias(), keyPass, samlCallback.getKeyName());
        }
        samlConsumerCfg.setKeyStoreConfig(ksc);
        samlConsumerCfg.setKeyInformationConfig(kic);
        samlConsumerCfg.setTrustStoreConfig(tsc);
        OMElement clearXML = null;
        SAMLToken token = null;
        try {
            OMElement om = target;
            if ("EncryptedAssertion".equals(target.getLocalName())) {
                om = DOMUtils.getFirstChildElement(target);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, om.getLocalName());
            }
            clearXML = EncryptedDataConsumer.DecryptEncryptedData(om, samlConsumerCfg);
            token = SAMLConsumeLoginModule.processSAMLElement(samlCallback, clearXML, config2, cconfig, messageContext, context);
        }
        catch (Exception e) {
            QName soapFault = SoapSecurityFaultCode.InvalidSecurityToken;
            context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            throw new LoginException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processEncryptedAssertion=" + token.getSamlID());
        }
        return token;
    }

    private SAMLToken preProcessDKTokenElement(OMElement target, TokenConsumerConfig tconfig, MessageContext messageContext) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("preProcessDKTokenElement(");
            buf.append("\nOMElement target [").append(DOMUtils.getDisplayName(target)).append("], ");
            Tr.entry(tc, buf.toString());
        }
        SAMLToken token = null;
        int wssVersion = 0;
        Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String kidValue = null;
        OMElement elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
        if (elem != null && (elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "KeyIdentifier")) != null) {
            SecurityToken tmpToken;
            String valtype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
            QName valtypeQN = DOMUtils.getQName(elem, valtype, wssVersion);
            kidValue = DOMUtils.getStringValue(elem);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found ValueType: " + valtypeQN + "\n" + "Found KeyIdentifier value: " + kidValue);
            }
            if ((tmpToken = this._securityTokenManager.getToken(tconfig, kidValue)) instanceof SAMLToken) {
                token = (SAMLToken)tmpToken;
            }
            if (token == null) {
                token = SAMLTokenHelper.getSAMLTokenFromContext(messageContext);
            }
        }
        return token;
    }

    private SAMLToken resolveSTR(OMElement target, TokenConsumerConfig tconfig, MessageContext messageContext) {
        SAMLToken token = null;
        OMElement keyidElement = DOMUtils.getChildElement(target, target.getNamespace().getNamespaceURI(), "KeyIdentifier");
        if (keyidElement != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found KeyIdentifier element: " + keyidElement);
            }
            QName valuetypeQN = null;
            Iterator it = keyidElement.getAllAttributes();
            String samlID = null;
            if (it != null) {
                while (it.hasNext()) {
                    OMAttribute attr = (OMAttribute)it.next();
                    if (attr.getQName().getLocalPart().equals(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q.getLocalPart())) {
                        valuetypeQN = new QName(attr.getAttributeValue());
                    }
                    if (valuetypeQN == null) continue;
                    samlID = keyidElement.getText();
                    break;
                }
                if ((token = (SAMLToken)this._securityTokenManager.getToken(tconfig, samlID)) == null) {
                    token = SAMLTokenHelper.getSAMLTokenFromContext(messageContext);
                }
            }
        }
        return token;
    }

    private void resolveKeyInfo(SAMLConsumeCallback samlCallback, TokenConsumerConfig config2, WSSConsumerConfig cconfig, MessageContext messageContext, String keyInfoType, boolean isKeyId, boolean isStrref, SecurityTokenManager securityTokenManager, Map<Object, Object> context) throws LoginException {
        KeyInfoContentConsumerConfig keyInfoContent;
        DerivedKeyInfoConfig dkic;
        String tokenId;
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("resolveKeyInfo(");
            buf.append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            buf.append("SOAPMessageContext messageContext, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("boolean isKeyId[").append(isKeyId).append("], ");
            buf.append("boolean isStrref[").append(isStrref).append("], ");
            buf.append("SecurityTokenManager securityTokenManager, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (isStrref) {
            tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
            this.mapRefUriToToken(tokenId);
        } else if (isKeyId) {
            tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_ID);
            QName enctype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
            QName valuetype = (QName)this._context.get(Constants.WSSECURITY_KEY_VALUETYPE);
            this.mapKeyIdToToken(tokenId, enctype, valuetype, messageContext);
        }
        if (this._token != null && (dkic = (keyInfoContent = (KeyInfoContentConsumerConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey")).getDerivedKeyInfoConfig()) != null && dkic.isRequireDerivedKeys()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "DerivedKey is required.");
            }
            if (dkic.isRequireImpliedDerivedKeys()) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "ImpliedDerivedKeys is used.");
                }
                byte[] secret = ((SAMLToken)this._token).getHolderOfKeyBytes();
                this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secret);
                this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", this._token);
            }
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("resolveKeyInfo(");
            buf.append(" returns SecurityToken[").append(this._token).append("]");
            Tr.exit(tc, buf.toString());
        }
    }

    private SecurityToken mapRefUriToToken(String tokenId) {
        TokenConsumerConfig tconfig;
        SecurityToken existToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapRefUriToToken()");
        }
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token identifier is [" + tokenId + "]");
        }
        if ((existToken = this._securityTokenManager.getToken(tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey"), tokenId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: SecurityToken whose identifier is \"" + tokenId + "\" was not found in the Subject.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + tokenId + "] stored in the Subject.");
                Tr.debug(tc, "Token instance: " + existToken + " and hashcode: " + existToken.hashCode());
            }
            this._token = existToken;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapRefUriToToken()");
        }
        return existToken;
    }

    private boolean mapKeyIdToToken(String tokenId, QName enctype, QName valuetype, MessageContext messageContext) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapKeyIdToToken() for token id: " + tokenId + "...encoding type: " + enctype + "...value type:" + valuetype);
        }
        TokenConsumerConfig tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        this._token = this._securityTokenManager.getToken(tconfig, tokenId);
        if (this._token != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Found token from SecurityTokenManager");
            }
            return true;
        }
        SAMLToken samlToken = SAMLTokenHelper.getSAMLTokenFromContext(messageContext);
        if (samlToken == null) {
            QName soapFault = SoapSecurityFaultCode.SecurityTokenUnavailable;
            this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.CWWSS7516E", new String[]{this.getClass().getName(), valuetype.toString(), tokenId}));
        }
        this._token = samlToken;
        this.updateSharedState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapKeyIdToToken()");
        }
        return true;
    }

    private void updateSharedState() {
        if (this._token == null) {
            return;
        }
        String was_principal = this._token.getPrincipal();
        if (was_principal != null) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.Constants.DN", was_principal);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAML client principal: " + was_principal);
            }
        }
    }
}

