/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.ws.wssecurity.saml.assertion.wssapi.SAMLAssertionBuilder;
import com.ibm.ws.wssecurity.saml.assertion.wssapi.SAMLAssertionParser;
import com.ibm.ws.wssecurity.saml.assertion.wssapi.SAMLAssertionVerifier;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.config.impl.RequesterConfigImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLTokenBuilder;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedDataConsumer;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenFactoryImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axiom.om.OMElement;

public class SAML20TokenFactoryImpl
extends SAMLTokenFactoryImpl {
    private static final TraceComponent tc = Tr.register(SAML20TokenFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAML20TokenFactoryImpl.class.getName();
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.SAML20Token");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);

    public SAML20TokenFactoryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SAML20TokenFactoryImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SAML20TokenFactoryImpl()");
        }
    }

    public SAMLTokenImpl newSecurityToken(String tokenValueType) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSecurityToken(" + tokenValueType + ")");
        }
        SAML20TokenImpl samlToken = (SAML20TokenImpl)_tokenFactory.getToken(true);
        samlToken.setValueType(tokenValueType);
        return samlToken;
    }

    @Override
    public RequesterConfig newBearerTokenGenerateConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newBearerTokenGenerateConfig()");
        }
        RequesterConfigImpl reqData = new RequesterConfigImpl();
        reqData.getRSTTProperties().put("wstrustClientKeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        reqData.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        reqData.getRSTTProperties().put("wstrustClientTokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newBearerTokenGenerateConfig()");
        }
        return reqData;
    }

    @Override
    public RequesterConfig newSenderVouchesTokenGenerateConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newBearerTokenGenerateConfig()");
        }
        RequesterConfigImpl reqData = new RequesterConfigImpl();
        reqData.getRSTTProperties().put("wstrustClientKeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        reqData.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        reqData.getRSTTProperties().put("wstrustClientTokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newBearerTokenGenerateConfig()");
        }
        return reqData;
    }

    @Override
    public RequesterConfig newSymmetricHolderOfKeyTokenGenerateConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSymmetricHolderOfKeyTokenGenerateConfig()");
        }
        RequesterConfigImpl reqData = new RequesterConfigImpl();
        reqData.getRSTTProperties().put("wstrustClientKeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
        reqData.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        reqData.getRSTTProperties().put("wstrustClientTokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newSymmetricHolderOfKeyTokenGenerateConfig()");
        }
        return reqData;
    }

    @Override
    public RequesterConfig newAsymmetricHolderOfKeyTokenGenerateConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newAsymmetricHolderOfKeyTokenGenerateConfig()");
        }
        RequesterConfigImpl reqData = new RequesterConfigImpl();
        reqData.getRSTTProperties().put("wstrustClientKeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
        reqData.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        reqData.getRSTTProperties().put("wstrustClientTokenType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newAsymmetricHolderOfKeyTokenGenerateConfig()");
        }
        return reqData;
    }

    @Override
    public SAMLToken newSAMLToken(CredentialConfig cred, RequesterConfig request, ProviderConfig provider) throws WSSException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSAMLToken( CredentialConfig, RequesterConfig, ProviderConfig)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_NEWSAMLTOKEN_PERM);
        }
        try {
            String tokenValueType = WSSConstants.SAML.SAML20_VALUE_TYPE;
            SAMLTokenImpl samlToken = this.newSecurityToken(tokenValueType);
            if (request == null || provider == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "newSAMLToken( CredentialConfig, RequesterConfig, ProviderConfig): request or provider data is null");
                }
                return samlToken;
            }
            final CredentialConfig credPriv = cred;
            final RequesterConfig requestPriv = request;
            final ProviderConfig providerPriv = provider;
            SAMLAssertion saml = null;
            try {
                saml = (SAMLAssertion)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        return SAMLAssertionBuilder.createSignedSAMLAssertion(providerPriv, requestPriv, credPriv);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception calling doPrivileged method: " + pae.getException().getMessage());
                }
                throw (WSSException)pae.getException();
            }
            if (saml == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "SAMLAssertionBuilder.createSignedSAMLAssertion returned a null object");
                }
                return this.newSecurityToken(tokenValueType);
            }
            samlToken = SAMLTokenBuilder.createSAMLToken(saml);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "newSAMLToken( CredentialConfig, RequesterConfig, ProviderConfig)");
            }
            return samlToken;
        }
        catch (Exception e) {
            throw new WSSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public SAMLToken newSAMLToken(ConsumerConfig consumer, XMLStructure xml) throws WSSException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newSAMLToken( ConsumerConfig, XMLStructure)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_NEWSAMLTOKEN_PERM);
        }
        try {
            String tokenValueType;
            OMElement samlXML = ((OMStructure)xml).getNode();
            if (samlXML.getLocalName().equals("EncryptedData") || samlXML.getLocalName().equals("EncryptedAssertion")) {
                if ("EncryptedAssertion".equals(samlXML.getLocalName())) {
                    samlXML = DOMUtils.getFirstChildElement(samlXML);
                }
                samlXML = EncryptedDataConsumer.DecryptEncryptedData(samlXML, consumer);
            }
            final OMElement samlXMLPriv = samlXML;
            final ConsumerConfig consumerPriv = consumer;
            SAMLAssertion newSAML = null;
            try {
                newSAML = (SAMLAssertion)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        return SAMLAssertionParser.parseSAML(samlXMLPriv, consumerPriv);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception calling doPrivileged method: " + pae.getException().getMessage());
                }
                throw (WSSException)pae.getException();
            }
            boolean isValid = false;
            if (newSAML != null) {
                isValid = newSAML.validate();
            } else {
                Tr.debug(tc, "SAMLAssertionParser.parseSAML doPrivileged block returned a null object");
            }
            if (!isValid) {
                throw new WSSException(MessageHelper.getMessage("security.wssecurity.WSSML6010E"));
            }
            if (consumer != null && consumer.isAssertionSignatureRequired()) {
                KeyStoreConfig tsc = consumer.getTrustStoreConfig();
                KeyStoreManager ksManager = KeyStoreManager.getInstance();
                KeyStoreManager.KeyInformation keyInformation = null;
                if (consumer.getAliasForTokenProvider() != null && !consumer.getAliasForTokenProvider().isEmpty()) {
                    keyInformation = ksManager.getKeyInformation(tsc.getPath(), tsc.getType(), tsc.getPassword().toCharArray(), tsc.getKsRef(), consumer.getAliasForTokenProvider(), null, "");
                }
                KeyStore trustAnchor = null;
                if (!consumer.trustAnySTS()) {
                    trustAnchor = ksManager.getKeyStore(tsc.getPath(), tsc.getType(), tsc.getPassword().toCharArray(), tsc.getKsRef());
                }
                if (!(isValid = SAMLAssertionVerifier.verifySAMLSignature(samlXML, keyInformation, trustAnchor))) {
                    throw new WSSException(MessageHelper.getMessage("security.wssecurity.WSSML6011E"));
                }
            }
            if (!(tokenValueType = newSAML.getAssertionQName().getNamespaceURI()).contains("2.0")) {
                throw new WSSException(MessageHelper.getMessage("security.wssecurity.WSSML6012E"));
            }
            SAML20TokenImpl samlToken = SAMLTokenBuilder.createSAMLToken(newSAML);
            samlToken.setId(samlToken.getSamlID());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "newSAMLToken( ConsumerConfig, XMLStructure)");
            }
            return samlToken;
        }
        catch (Exception e) {
            throw new WSSException(e.getMessage(), e.getCause());
        }
    }
}

