/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import java.security.SecurityPermission;

public class LTPAPropagationTokenImpl
extends LTPATokenImpl
implements LTPAPropagationToken {
    private static final TraceComponent tc = Tr.register(LTPAPropagationTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -2476162626084258807L;
    private static final SecurityPermission GETWSCREDENTIAL_PERM = new SecurityPermission("wssapi.LTPATokenWrapper.getWSCredential");
    private WSCredential _wsCred = null;
    private WSPrincipal _wsPrinc = null;

    public LTPAPropagationTokenImpl() {
        this.valueType = LTPAPropagationToken.ValueType;
        this.tokenQName = LTPAPropagationToken.TokenQname;
    }

    public WSCredential getWSCredential() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETWSCREDENTIAL_PERM.toString());
            }
            sm.checkPermission(GETWSCREDENTIAL_PERM);
        }
        return this._wsCred;
    }

    public void setWSCredential(WSCredential cred) {
        if (!this.readOnly) {
            this._wsCred = cred;
        }
    }

    public WSPrincipal getWSPrincipal() {
        return this._wsPrinc;
    }

    public void setWSPrincipal(WSPrincipal prin) {
        if (!this.readOnly) {
            this._wsPrinc = prin;
        }
    }
}

