/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.wssecurity.core.TokenCacheManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.token.PropagationToken;
import com.ibm.ws.wssecurity.token.TokenCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.axis2.context.MessageContext;

public class LTPAPropagationGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAPropagationGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAPropagationGenerateLoginModule.class.getName();
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        SecurityToken existToken;
        String uniqueID;
        Subject runAsSubject;
        TokenCacheManager tokenMgr;
        byte[] credToken;
        byte[] binary;
        WSPrincipal principal;
        WSCredential credential;
        Subject subject;
        block55: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            NameCallback usernameCallback = new NameCallback("username: ");
            PasswordCallback passwordCallback = new PasswordCallback("passowrd: ", false);
            PropertyCallback propertyCallback = new PropertyCallback(null);
            Callback[] callbacks = new Callback[]{usernameCallback, passwordCallback, propertyCallback};
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                LoginException e1 = new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
                Tr.processException((Throwable)e1, clsName + ".login", "153", this);
                throw e1;
            }
            this._context = propertyCallback.getProperties();
            this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            subject = null;
            credential = null;
            principal = null;
            binary = null;
            credToken = null;
            WSSContextManager manager = WSSContextManagerFactory.getInstance();
            if (manager == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSContextManager object missing");
            }
            try {
                if (!manager.getServerSecurityEnabled()) {
                    String message = ConfigConstants.getMessage("security.wssecurity.WSEC0166E");
                    LoginException e1 = new LoginException(message);
                    Tr.processException((Throwable)e1, clsName + ".login", "182", this);
                    throw e1;
                }
            }
            catch (SoapSecurityException e) {
                LoginException e1 = new LoginException(e.toString());
                Tr.processException((Throwable)e1, clsName + ".login", "188", this);
                throw e1;
            }
            try {
                tokenMgr = TokenCacheManagerFactory.getInstance();
            }
            catch (SoapSecurityException e1) {
                LoginException e2 = new LoginException(e1.getMessage());
                Tr.processException((Throwable)e2, clsName + ".login", "197", this);
                throw e2;
            }
            try {
                MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSContext secContext = WSSContextFactory.getInstance();
                runAsSubject = secContext.getRunAsSubject(messageContext);
            }
            catch (SoapSecurityException e1) {
                LoginException e2 = new LoginException(e1.getMessage());
                Tr.processException((Throwable)e2, clsName + ".login", "211", this);
                throw e2;
            }
            WSCredentialTokenMapperInterface wsCredTokenMapper = null;
            uniqueID = null;
            try {
                wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
                if (wsCredTokenMapper != null && runAsSubject != null) {
                    uniqueID = wsCredTokenMapper.createSubjectUniqueID(runAsSubject);
                }
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".login", "224", this);
                if (!tc.isDebugEnabled()) break block55;
                Tr.debug(tc, "Caught exception while getting unique ID from subject.", new Object[]{e});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unique ID from tokens in contextSubject: " + uniqueID);
        }
        if (tokenMgr != null && uniqueID != null && uniqueID.length() > 0) {
            PropagationToken cachedToken = null;
            try {
                cachedToken = tokenMgr.getCachedToken(uniqueID);
            }
            catch (SoapSecurityException e) {
                LoginException e1 = new LoginException(e.getMessage());
                Tr.processException((Throwable)e1, clsName + ".login", "238", this);
                throw e1;
            }
            if (cachedToken != null) {
                binary = cachedToken.getToken();
                long currentTime = System.currentTimeMillis();
                if (cachedToken.getExpiration() - currentTime > 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached token based on unique ID.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached token, but it is expired.");
                    }
                    binary = null;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find cached token based on unique ID.");
            }
        }
        if (binary == null) {
            TokenHolder tokenHolder;
            Subject newSubject;
            block56: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing login to obtain token.");
                }
                try {
                    subject = SubjectHelper.createNewSubjectFromExisting(runAsSubject);
                }
                catch (Exception e) {
                    LoginException e1 = new LoginException(e.getMessage());
                    Tr.processException((Throwable)e1, clsName + ".login", "270", this);
                    throw e1;
                }
                String jaasConfig = "system.WSS_OUTBOUND";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using JAAS config: " + jaasConfig);
                }
                WSSMarkerObject marker = new WSSMarkerObject(Boolean.TRUE);
                LTPAPropagationGenerateLoginModule.addToSubject(subject, marker);
                CSIv2PerformPolicy csiv2PerformPolicy = new CSIv2PerformPolicy((CSIv2EffectivePerformPolicy)null);
                TokenPropagationCallbackHandler cbh = new TokenPropagationCallbackHandler(this._context, csiv2PerformPolicy);
                if (cbh == null) {
                    LoginException e1 = new LoginException("Unable to get instance of TokenPropagationCallbackHandler");
                    Tr.processException((Throwable)e1, clsName + ".login", "287", this);
                    throw e1;
                }
                LoginContext lc = new LoginContext(jaasConfig, subject, cbh);
                lc.login();
                newSubject = lc.getSubject();
                try {
                    credential = SubjectHelper.getWSCredentialFromSubject(newSubject);
                    principal = SubjectHelper.getPrincipalFromSubject(newSubject);
                    credToken = credential.getCredentialToken();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block56;
                    Tr.debug(tc, "Did not find Credential Token.");
                }
            }
            try {
                tokenHolder = AccessController.doPrivileged(new PrivilegedExceptionAction<TokenHolder>(){

                    @Override
                    public TokenHolder run() throws Exception {
                        WSOpaqueTokenHelper helper = WSOpaqueTokenHelper.getInstance();
                        String name = helper.getOpaqueTokenName();
                        int version = helper.getOpaqueTokenVersion();
                        Iterator<TokenHolder> privateCreds = newSubject.getPrivateCredentials(TokenHolder.class).iterator();
                        while (privateCreds != null && privateCreds.hasNext()) {
                            TokenHolder cred = privateCreds.next();
                            if (!(cred instanceof TokenHolder) || !cred.getName().equals(name) || cred.getVersion() != version) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found TokenHolder containing opaque authz token");
                            }
                            return cred;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not find TokenHolder containing opaque authz token");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LoginException e1 = new LoginException(e.getMessage());
                Tr.processException((Throwable)e1, clsName + ".login", "335", this);
                throw e1;
            }
            if (tokenHolder != null) {
                binary = tokenHolder.getBytes();
                if (tokenMgr != null) {
                    long cushion;
                    long expiration = 0L;
                    AuthenticationToken authn = SubjectHelper.getDefaultAuthTokenFromSubject(newSubject);
                    expiration = authn.getExpiration();
                    try {
                        cushion = tokenMgr.getCushion();
                    }
                    catch (SoapSecurityException e) {
                        LoginException e1 = new LoginException(e.getMessage());
                        Tr.processException((Throwable)e1, clsName + ".login", "349", this);
                        throw e1;
                    }
                    long currentTime = System.currentTimeMillis();
                    long remaining = expiration - currentTime - cushion;
                    if (remaining < 0L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Token has expired. Do not cache.");
                        }
                    } else {
                        PropagationToken propTok = new PropagationToken(binary, expiration - cushion);
                        if (uniqueID != null && uniqueID.length() > 0 && propTok != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caching token.");
                            }
                            try {
                                tokenMgr.cacheToken(uniqueID, propTok);
                            }
                            catch (SoapSecurityException e) {
                                LoginException e1 = new LoginException(e.getMessage());
                                Tr.processException((Throwable)e1, clsName + ".login", "368", this);
                                throw e1;
                            }
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find WSCredential in new Subject.");
            }
        }
        String id = IdUtils.getInstance().makeUniqueId(this._context, "ltpa_");
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        int wssVersion = 0;
        Object obj = null;
        obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        try {
            existToken = LTPAPropagationGenerateLoginModule.getToken(config2, binary, this._securityTokenManager);
        }
        catch (SoapSecurityException e) {
            LoginException e1 = new LoginException(e.toString());
            Tr.processException((Throwable)e, clsName + ".login", "398", this);
            throw e1;
        }
        if (existToken == null) {
            XMLStructure xml = LTPAGenerateLoginModule.createTokenElement(parent, config2, binary, id, wssVersion);
            LTPAPropagationTokenImpl ltpaToken = new LTPAPropagationTokenImpl();
            ltpaToken.setId(id);
            ltpaToken.setWSCredential(credential);
            ltpaToken.setWSPrincipal(principal);
            ltpaToken.setPrincipal(principal.getName());
            ltpaToken.setBinary(credToken);
            ltpaToken.setXML(xml);
            ltpaToken.setKey(61, null);
            ltpaToken.setKey(62, null);
            this._processedTokens.add(ltpaToken);
            this._insertedTokens.add(ltpaToken);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + existToken.getId() + "] stored in the Subject.");
            }
            this._processedTokens.add(existToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig config2, byte[] binary, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] binary[");
            buf.append(binary == null ? "null" : "not null");
            buf.append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                LTPAPropagationToken lt;
                byte[] tokenBinary;
                if (!(t instanceof LTPAPropagationToken) || !LTPAGenerateLoginModule.equalsByteArray(tokenBinary = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lt = (LTPAPropagationToken)t){
                    final /* synthetic */ LTPAPropagationToken val$lt;
                    {
                        this.val$lt = lTPAPropagationToken;
                    }

                    @Override
                    public Object run() {
                        return this.val$lt.getBinary();
                    }
                }), binary)) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig, byte[], SecurityTokenManager)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private static final void addToSubject(final Subject subject, final Object marker) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(Subject subject, Object marker)");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrivateCredentials().contains(marker)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding marker to Subject: " + marker);
                    }
                    subject.getPrivateCredentials().add(marker);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject already contains marker: " + marker);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(Subject subject, Object marker)");
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                Tr.processException(ex, clsName + "init", "543");
            }
        }
    }
}

