/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAv2TokenImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.BinarySecurityToken;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;

public class LTPAGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAGenerateLoginModule.class.getName();
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        AuthenticationToken tokenFromSubject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        NameCallback usernameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("passowrd: ", false);
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{usernameCallback, passwordCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "152", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", e);
            LoginException le = new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
            le.initCause(e);
            throw le;
        }
        String username = usernameCallback.getName();
        char[] password = passwordCallback.getPassword();
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        boolean ret = true;
        Subject subject = null;
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        QName type = config2.getType();
        boolean isLTPAv1 = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(type);
        byte[] binary = null;
        if (username != null && username.length() > 0 && password != null && password.length > 0) {
            final String un = username;
            final String pwd = String.valueOf(password);
            try {
                subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws LoginException {
                        Subject sub = null;
                        WSSContextManager contextMgr = WSSContextManagerFactory.getInstance();
                        if (contextMgr != null) {
                            sub = contextMgr.login(contextMgr.getDefaultRealm(), un, pwd);
                        }
                        return sub;
                    }
                });
            }
            catch (PrivilegedActionException e1) {
                LoginException le = new LoginException(e1.toString());
                le.initCause(e1);
                throw le;
            }
            if (subject != null) {
                tokenFromSubject = null;
                tokenFromSubject = isLTPAv1 ? this.getAuthTokenFromSubject(subject) : this.getSSOTokenFromSubject(subject);
                if (tokenFromSubject != null) {
                    binary = tokenFromSubject.getBytes();
                }
            }
        }
        if (binary == null || binary.length == 0) {
            try {
                MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSContext secContext = WSSContextFactory.getInstance();
                if (secContext != null && (subject = secContext.getRunAsSubject(messageContext)) != null) {
                    tokenFromSubject = null;
                    tokenFromSubject = isLTPAv1 ? this.getAuthTokenFromSubject(subject) : this.getSSOTokenFromSubject(subject);
                    if (tokenFromSubject != null) {
                        binary = tokenFromSubject.getBytes();
                    }
                }
            }
            catch (SoapSecurityException e) {
                LoginException le = new LoginException(e.toString());
                le.initCause(e);
                throw le;
            }
        }
        if (binary == null || binary.length == 0) {
            ret = false;
        }
        if (ret) {
            SecurityToken existToken;
            String id = IdUtils.getInstance().makeUniqueId(this._context, "ltpa_");
            int wssVersion = 0;
            Object obj = null;
            obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            try {
                existToken = LTPAGenerateLoginModule.getToken(config2, binary, this._securityTokenManager);
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "172", this);
                LoginException le = new LoginException(e.toString());
                le.initCause(e);
                throw le;
            }
            if (existToken == null) {
                XMLStructure xml = LTPAGenerateLoginModule.createTokenElement(parent, config2, binary, id, wssVersion);
                LTPATokenImpl ltpaToken = null;
                ltpaToken = isLTPAv1 ? new LTPATokenImpl() : new LTPAv2TokenImpl();
                ltpaToken.setId(id);
                ltpaToken.setPrincipal(username);
                ltpaToken.setBinary(binary);
                ltpaToken.setXML(xml);
                ltpaToken.setKey(61, null);
                ltpaToken.setKey(62, null);
                String forwardable = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
                if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
                    ltpaToken.setIsForwardable(false);
                } else {
                    ltpaToken.setIsForwardable(true);
                }
                this._processedTokens.add(ltpaToken);
                this._insertedTokens.add(ltpaToken);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + existToken.getId() + "] stored in the Subject.");
                }
                this._processedTokens.add(existToken);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return ret;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final OMElement createOMTokenElement(OMFactory factory, OMElement parent, TokenGeneratorConfig config2, byte[] credToken, String id, int wssVersion) {
        QName tokenType;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory factory,");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] credToken[");
            buf.append(credToken == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String id[").append(id).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement tokenElem = factory.createOMElement("BinarySecurityToken", nsWsse, pWsse);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsse, "wsse");
        }
        if (id != null) {
            isDecl = false;
            String pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                tokenElem.declareNamespace(nsWsu, "wsu");
            }
            tokenElem.addAttribute("Id", id, factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, pWsu));
        }
        if ((tokenType = config2.getType()) == null) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN;
        }
        tokenElem.declareNamespace(tokenType.getNamespaceURI(), "wsst");
        DOMUtils.setQNameAttr(tokenElem, null, "EncodingType", com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, wssVersion);
        DOMUtils.setQNameAttr(tokenElem, null, "ValueType", tokenType, wssVersion);
        String data = Base64.encode(credToken);
        tokenElem.addChild(factory.createOMText(data));
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createOMTokenElement(");
            buf.append("OMFactory, OMElement, TokenGeneratorConfig, byte[], String, int)");
            buf.append(" returns OMElement[").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private static final WSSObjectElement createWSSObjectTokenElement(WSSObjectElement parent, TokenGeneratorConfig config2, byte[] credToken, String id, int wssVersion) {
        QName tokenType;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createWSSObjectTokenElement(");
            buf.append("WSSObjectElement parent[").append(parent.getQName()).append("], ");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] credToken[");
            buf.append(credToken == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String id[").append(id).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSObjectDocumentImpl doc = parent.getWSSObjectDocument();
        BinarySecurityToken tokenElem = new BinarySecurityToken(doc);
        if (id != null) {
            tokenElem.setWsuId(VariablePartFactory.getInstance().createAttrValueWithString(id));
        }
        if ((tokenType = config2.getType()) == null) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN;
        }
        String localPart = tokenType.getLocalPart();
        String prefix = null;
        prefix = "LTPAv2".equals(localPart) ? "w2" : "w1";
        NamespacePrefixPairSortedSet nsppss = doc.getDeclaredNamespaces();
        NamespacePrefixPair nspp = nsppss.getNamespacePrefixPair(prefix);
        if (nspp == null) {
            nspp = new NamespacePrefixPair(prefix, tokenType.getNamespaceURI());
            nsppss.add(nspp);
        }
        String value = prefix + ":" + localPart;
        tokenElem.setValueType(VariablePartFactory.getInstance().createAttrValueWithString(value));
        VariablePartTextValue varPart = VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(credToken);
        tokenElem.setContent(varPart);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createWSSObjectTokenElement(");
            buf.append("WSSObjectElement, TokenGeneratorConfig, byte[], String, int)");
            buf.append(" returns OMElement[").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    protected static final XMLStructure createTokenElement(Object parent, TokenGeneratorConfig config2, byte[] credToken, String id, int wssVersion) {
        XMLStructure xml = null;
        if (parent instanceof WSSObjectElement) {
            WSSObjectElement elem = LTPAGenerateLoginModule.createWSSObjectTokenElement((WSSObjectElement)parent, config2, credToken, id, wssVersion);
            xml = new WSSObjectStructureImpl(elem);
        } else {
            OMElement elem = LTPAGenerateLoginModule.createOMTokenElement(((OMElement)parent).getOMFactory(), (OMElement)parent, config2, credToken, id, wssVersion);
            xml = new OMStructure(elem);
        }
        return xml;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig config2, byte[] binary, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] binary[");
            buf.append(binary == null ? "null" : "not null");
            buf.append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                LTPAToken lt;
                byte[] tokenBinary;
                if (!(t instanceof LTPAToken) || !LTPAGenerateLoginModule.equalsByteArray(tokenBinary = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lt = (LTPAToken)t){
                    final /* synthetic */ LTPAToken val$lt;
                    {
                        this.val$lt = lTPAToken;
                    }

                    @Override
                    public Object run() {
                        return this.val$lt.getBinary();
                    }
                }), binary)) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig, byte[], SecurityTokenManager)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    static final boolean equalsByteArray(byte[] a, byte[] b) {
        boolean ret;
        block6: {
            block5: {
                ret = true;
                if (a != null) break block5;
                if (b == null) break block6;
                ret = false;
                break block6;
            }
            if (b == null) {
                ret = false;
            } else {
                int al = a.length;
                int bl = b.length;
                if (al != bl) {
                    ret = false;
                } else {
                    for (int i = 0; i < al; ++i) {
                        if (a[i] == b[i]) continue;
                        ret = false;
                        break;
                    }
                }
            }
        }
        return ret;
    }

    private AuthenticationToken getAuthTokenFromSubject(Subject subject) throws LoginException {
        if (subject == null) {
            return null;
        }
        AuthenticationToken authToken2 = null;
        try {
            for (AuthenticationToken authToken2 : subject.getPrivateCredentials(AuthenticationToken.class)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing AUTH token with name: " + authToken2.getName());
                }
                if (!authToken2.getName().equals("oid:1.3.18.0.2.30.2")) continue;
                return authToken2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find internally implemented AuthenticationToken.");
            }
            return null;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthenticationToken from Subject.", new Object[]{e});
            }
            Tr.processException((Throwable)e, clsName + ".login", "653", this);
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
    }

    private SingleSignonToken getSSOTokenFromSubject(final Subject subject) throws LoginException {
        if (subject == null) {
            return null;
        }
        SingleSignonToken ssoToken = null;
        try {
            ssoToken = (SingleSignonToken)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (SingleSignonToken ssoToken : subject.getPrivateCredentials(SingleSignonToken.class)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing SSO token with name: " + ssoToken.getName());
                        }
                        if (!ssoToken.getName().equals("LtpaToken")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found SSO token.");
                        }
                        return ssoToken;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not find internally implemeted SSO token.");
                    }
                    return null;
                }
            });
            return ssoToken;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SingleSignonToken from Subject.", new Object[]{e});
            }
            Tr.processException((Throwable)e, clsName + ".login", "706", this);
            LoginException le = new LoginException(e.toString());
            le.initCause(e);
            throw le;
        }
    }
}

