/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAv2TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509ConsumeLoginModule;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class LTPAConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509ConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        boolean isAuthnEventsRequired;
        Date tokenExpDate;
        String tokenPrincipalName;
        byte[] binary;
        String tokenId;
        LTPATokenImpl ltpaToken;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            PropertyCallback propertyCallback = new PropertyCallback(null);
            Callback[] callbacks = new Callback[]{propertyCallback};
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".login", "129", this);
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
            }
            this._context = propertyCallback.getProperties();
            TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
            ltpaToken = null;
            QName vtype = config2.getType();
            ltpaToken = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(vtype) ? new LTPAv2TokenImpl() : new LTPATokenImpl();
            this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, ltpaToken);
            if (!com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(vtype) && !com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(vtype)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.toString()});
                throw new LoginException(errorMes);
            }
            OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            ltpaToken.setXML(new OMStructure(target));
            tokenId = null;
            QName idattr = IdUtils.getInstance().getIdAttributeName(target);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
            }
            if (idattr != null) {
                tokenId = target.getAttributeValue(idattr);
            }
            boolean enforceTokenVersion = config2.isEnforceTokenVersion();
            int wssVersion = 0;
            Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            QName valueTypeQName = DOMUtils.getQName(target, target.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q), wssVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The ValueType attribute of the target element is [" + valueTypeQName.toString() + "].");
            }
            if (!valueTypeQName.equals(vtype)) {
                if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(valueTypeQName)) {
                    ltpaToken = new LTPAv2TokenImpl();
                } else if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(valueTypeQName)) {
                    ltpaToken = new LTPATokenImpl();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The ValueType attribute matches neither ltpa v1 or ltpa v2 token types.");
                    }
                    String errorMes = ConfigUtil.getMessage("security.wssecurity.LTPAConsumeLoginModule.invalidValueType", new String[]{vtype.toString(), valueTypeQName.toString()});
                    throw new LoginException(errorMes);
                }
                this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, ltpaToken);
                if (enforceTokenVersion) {
                    String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), valueTypeQName.toString()});
                    throw new LoginException(errorMes);
                }
            }
            ltpaToken.setId(tokenId);
            String encoded = DOMUtils.getStringValue(target);
            binary = Base64.decode(encoded);
            WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
            Subject subject = ctxMgr.login(ctxMgr.getDefaultRealm(), binary);
            WSCredential wsCred = null;
            tokenPrincipalName = "";
            tokenExpDate = new Date(System.currentTimeMillis());
            Iterator<WSCredential> publicCreds = subject.getPublicCredentials(WSCredential.class).iterator();
            if (publicCreds.hasNext()) {
                wsCred = publicCreds.next();
            }
            try {
                if (wsCred.getRealmSecurityName() != null) {
                    tokenPrincipalName = wsCred.getRealmSecurityName();
                }
                if (wsCred.getExpiration() != 0L) {
                    tokenExpDate = new Date(wsCred.getExpiration());
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "Cannot get WSCredential infor from the subject");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LTPA token Principal Name = " + tokenPrincipalName);
            Tr.debug(tc, "LTPA token Expiration date = " + tokenExpDate.toString());
        }
        ltpaToken.setBinary(binary);
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, this._context);
        if (isAuthnEventsRequired) {
            Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", tokenId);
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "Username", tokenPrincipalName);
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "Expiration", tokenExpDate.toString());
        }
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        this._token = ltpaToken;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            if (_ltpaServerObjectClass == null) {
                Class<?> clazz = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    clazz = cl != null ? cl.loadClass(LTPA_SERVER_OBJECT_CLASS) : Class.forName(LTPA_SERVER_OBJECT_CLASS);
                    _ltpaServerObjectClass = clazz;
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                try {
                    _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                    if (_getLTPAServerMethod != null) {
                        _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                try {
                    _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", byte[].class);
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        }
    }
}

