/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Hex;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;

public class KeyStoreManager {
    private static final TraceComponent tc = Tr.register(KeyStoreManager.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreManager.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_SUBJECTKEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private static final String MESSAGE_DIGEST_SHA1 = "SHA";
    private static boolean initialized = false;
    private static KeyStoreManager instance = null;
    private static Stack<MessageDigest> sha1Pool;
    private final Map<String, KeyStore> keyStoreCache = new HashMap<String, KeyStore>();
    private final Map<Integer, KeyInformation> keyInformationCache = new HashMap<Integer, KeyInformation>();
    private static final int STATUS_OK = 0;
    private static final int STATUS_ENTRY_ERROR = 1;
    private static final int STATUS_CERT_ERROR = 2;
    private static final int STATUS_KEYID_ERROR = 4;
    private static final int STATUS_THUMBPRINT_ERROR = 8;

    private KeyStoreManager() {
    }

    private static final synchronized void init() {
        if (!initialized) {
            instance = new KeyStoreManager();
            sha1Pool = new Stack();
            initialized = true;
        }
    }

    public static final KeyStoreManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (!initialized) {
            KeyStoreManager.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance()");
        }
        return instance;
    }

    public final synchronized KeyInformation getKeyInformation(X509Certificate x509) throws SoapSecurityException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            StringBuffer buf2 = new StringBuffer("getKeyInformation(");
            buf2.append("X509Certificate x509[");
            buf2.append(x509 == null ? "null" : x509.getSubjectDN().getName());
            buf2.append("])");
            Tr.entry(tc, buf2.toString());
        }
        KeyInformation keyInformation = null;
        int hashCode = x509.hashCode();
        Integer hash = new Integer(hashCode);
        keyInformation = this.keyInformationCache.get(hash);
        if (keyInformation == null) {
            if (tc.isDebugEnabled()) {
                buf = new StringBuffer("There is no cached key information with the X509 certificate [");
                buf.append(x509 == null ? "null" : x509.getSubjectDN().getName());
                buf.append("]. So a new key information is created.");
                Tr.debug(tc, buf.toString());
            }
            keyInformation = this.createKeyInformation(x509);
            this.keyInformationCache.put(hash, keyInformation);
        } else if (tc.isDebugEnabled()) {
            buf = new StringBuffer("There is the cached key information with the X509 certificate [");
            buf.append(x509 == null ? "null" : x509.getSubjectDN().getName());
            buf.append("]. So the key information is used.");
            Tr.debug(tc, buf.toString());
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("getKeyInformation(");
            buf.append("X509Certificate)");
            buf.append(" returns KeyInformation[").append(keyInformation).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keyInformation;
    }

    private final KeyInformation createKeyInformation(X509Certificate x509) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createKeyInformation(");
            buf.append("X509Certificate x509[");
            buf.append(x509 == null ? "null" : x509.getSubjectDN().getName());
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        String subjectDN = null;
        String encSubjectDN = null;
        String issuerDN = null;
        String encIssuerDN = null;
        String issuerSerial = null;
        String b64KeyId = null;
        String b64KeyId60 = null;
        String b64Thumbprint = null;
        String hexKeyId = null;
        String hexKeyId60 = null;
        String hexThumbprint = null;
        byte[] binary = null;
        PublicKey publickey = null;
        Key privatekey = null;
        int status = 0;
        long expiration = -1L;
        String errorMes = null;
        subjectDN = x509.getSubjectDN().getName();
        encSubjectDN = KeyInfo.X509Data.encodeDName(subjectDN);
        issuerDN = x509.getIssuerDN().getName();
        encIssuerDN = KeyInfo.X509Data.encodeDName(issuerDN);
        issuerSerial = x509.getSerialNumber().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subjectDN[" + subjectDN + "], " + "encSubjectDN[" + encSubjectDN + "], " + "issuerDN[" + issuerDN + "], " + "encIssuerDN[" + encIssuerDN + "], " + "issuerSerial[" + issuerSerial + "]");
        }
        try {
            binary = x509.getEncoded();
            x509.checkValidity();
        }
        catch (CertificateEncodingException e) {
            status += 2;
            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "210", this);
            Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{e});
            errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{e.getClass().getName() + ": " + e.getMessage()});
        }
        catch (CertificateExpiredException e) {
            status += 2;
            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "218", this);
            Tr.error(tc, "security.wssecurity.WSEC6805E", new Object[]{subjectDN, e});
            errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6805E", new String[]{subjectDN, e.getClass().getName() + ": " + e.getMessage()});
        }
        catch (CertificateException e) {
            status += 2;
            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "229", this);
            Tr.error(tc, "security.wssecurity.WSEC6806E", new Object[]{subjectDN, e});
            errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6806E", new String[]{subjectDN, e.getClass().getName() + ": " + e.getMessage()});
        }
        expiration = x509.getNotAfter().getTime();
        if (status == 0 && expiration - System.currentTimeMillis() < 5184000000L) {
            long millisBeforeExpiration = expiration - System.currentTimeMillis();
            long daysLeft = millisBeforeExpiration / 86400000L;
            Tr.warning(tc, "security.wssecurity.WSEC6807W", new Object[]{subjectDN, new Long(daysLeft)});
        }
        if (status == 0) {
            try {
                byte[] keyid = KeyStoreManager.makeSubjectKeyIdentifier(x509, null);
                b64KeyId = Base64.encode(keyid);
                hexKeyId = Hex.encode(keyid);
                keyid = KeyStoreManager.makeSubjectKeyIdentifier(x509, Constants.IT60SHA1);
                b64KeyId60 = Base64.encode(keyid);
                hexKeyId60 = Hex.encode(keyid);
            }
            catch (NoSuchAlgorithmException e) {
                status += 4;
                Tr.processException((Throwable)e, clsName + ".createKeyInformation", "260", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass().getName() + ": " + e.getMessage();
            }
            catch (InvalidAlgorithmParameterException e) {
                status += 4;
                Tr.processException((Throwable)e, clsName + ".createKeyInformation", "267", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + e.getClass().getName() + ": " + e.getMessage();
            }
            catch (Exception e) {
                status += 4;
                Tr.processException((Throwable)e, clsName + ".createKeyInformation", "274", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
            }
            publickey = x509.getPublicKey();
        }
        if (status == 0) {
            try {
                byte[] thumbprint = KeyStoreManager.makeThumbprint(binary);
                b64Thumbprint = Base64.encode(thumbprint);
                hexThumbprint = Hex.encode(thumbprint);
            }
            catch (Exception e) {
                status += 8;
                Tr.processException((Throwable)e, clsName + ".createKeyInformation", "289", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
            }
        }
        KeyInformation keyInformation = new KeyInformation(null, null, encSubjectDN, publickey, privatekey, x509, binary, subjectDN, encSubjectDN, encIssuerDN, issuerSerial, b64KeyId, b64KeyId60, b64Thumbprint, hexKeyId, hexKeyId60, hexThumbprint, status, expiration, 5184000000L, errorMes);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createKeyInformation(");
            buf.append("X509Certificate)");
            buf.append(" returns KeyInformation[").append(keyInformation).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keyInformation;
    }

    public final synchronized KeyInformation getKeyInformation(String storePath, String storeType, char[] storePassword, String keyStoreRef, String alias, char[] keyPassword, String keyName) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInformation(");
            buf.append("String storePath[").append(storePath).append("], ");
            buf.append("String storeType[").append(storeType).append("], ");
            buf.append("char[] storePassword[");
            buf.append(storePassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyStoreRef[").append(keyStoreRef).append("], ");
            buf.append("String alias[").append(alias).append("], ");
            buf.append("char[] keyPassword[");
            buf.append(keyPassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyName[").append(keyName).append("])");
            Tr.entry(tc, buf.toString());
        }
        KeyInformation keyInformation = null;
        KeyStore keyStore = this.getKeyStore(storePath, storeType, storePassword, keyStoreRef);
        if (keyStore != null) {
            int hashCode = keyStore.hashCode();
            Integer hash = new Integer(hashCode += alias.hashCode());
            keyInformation = this.keyInformationCache.get(hash);
            if (keyInformation == null) {
                boolean HWKeyStoreRef = false;
                HWKeyStoreRef = ConfigUtil.isHWKeyStore(keyStoreRef);
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("There is no cached key information with the keystore [");
                    buf.append(storePath);
                    buf.append("] and the alias [");
                    buf.append(alias);
                    buf.append("]. So a new key information is created.");
                    Tr.debug(tc, buf.toString());
                }
                keyInformation = this.createKeyInformation(keyStore, storePath, alias, keyPassword, keyName, HWKeyStoreRef);
                this.keyInformationCache.put(hash, keyInformation);
            } else if (tc.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer("There is the cached key information with the keystore [");
                buf.append(storePath);
                buf.append("] and the alias [");
                buf.append(alias);
                buf.append("]. So the key information is used.");
                Tr.debug(tc, buf.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInformation(");
            buf.append("String, String, char[], String, String, char[], String)");
            buf.append(" returns KeyInformation[").append(keyInformation).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keyInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final KeyInformation createKeyInformation(KeyStore keyStore, String storePath, String alias, char[] keyPassword, String keyName, boolean isHWKeyStoreRef) throws SoapSecurityException {
        KeyStore.Entry entry;
        String errorMes;
        long expiration;
        int status;
        Key privatekey;
        Key publickey;
        byte[] binary;
        X509Certificate x509;
        String hexThumbprint;
        String hexKeyId60;
        String hexKeyId;
        String b64Thumbprint;
        String b64KeyId60;
        String b64KeyId;
        String issuerSerial;
        String encIssuerDN;
        String issuerDN;
        String encSubjectDN;
        String subjectDN;
        String encKeyName;
        block52: {
            String tmpMsg;
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("createKeyInformation(");
                buf.append("KeyStore keyStore, ");
                buf.append("String alias[").append(alias).append("], ");
                buf.append("char[] keyPassword[");
                buf.append(keyPassword == null ? "null" : "not null");
                buf.append("], ");
                buf.append("String keyName[").append(keyName).append("])");
                buf.append("boolean isHWKeyStoreRef[").append(isHWKeyStoreRef).append("])");
                Tr.entry(tc, buf.toString());
            }
            if ((encKeyName = KeyInfo.X509Data.encodeDName(keyName)) == null || encKeyName.length() == 0) {
                encKeyName = keyName;
            }
            subjectDN = null;
            encSubjectDN = null;
            issuerDN = null;
            encIssuerDN = null;
            issuerSerial = null;
            b64KeyId = null;
            b64KeyId60 = null;
            b64Thumbprint = null;
            hexKeyId = null;
            hexKeyId60 = null;
            hexThumbprint = null;
            x509 = null;
            binary = null;
            publickey = null;
            privatekey = null;
            status = 0;
            expiration = -1L;
            errorMes = null;
            KeyStore.PasswordProtection pwdProtection = null;
            if (keyPassword != null && keyPassword.length > 0) {
                pwdProtection = new KeyStore.PasswordProtection(keyPassword);
            }
            entry = null;
            Exception ex = null;
            String exName = null;
            String exMsg = null;
            try {
                entry = keyStore.getEntry(alias, pwdProtection);
                if (ex == null) break block52;
                ++status;
            }
            catch (UnrecoverableKeyException urke) {
                ex = urke;
                exName = urke.getClass().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UnrecoverableKeyException encountered.  Key password is probably incorrect.");
                }
                if (ex == null) break block52;
                ++status;
                Tr.processException((Throwable)ex, clsName + ".createKeyInformation", "427", this);
                Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{"'" + alias + "'", "'" + storePath + "'", ex});
                tmpMsg = exMsg == null ? exName : exName + ": " + exName;
                errorMes = ConfigUtil.getMessage("security.wssecurity.ConfigUtil.s27", new String[]{"'" + alias + "'", "'" + storePath + "'", tmpMsg});
            }
            catch (Exception e) {
                ex = e;
                exName = e.getClass().getName();
                exMsg = e.getMessage();
                if (ex == null) break block52;
                ++status;
                {
                    catch (Throwable throwable) {
                        if (ex != null) {
                            ++status;
                            Tr.processException((Throwable)ex, clsName + ".createKeyInformation", "427", this);
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{"'" + alias + "'", "'" + storePath + "'", ex});
                            String tmpMsg22 = exMsg == null ? exName : exName + ": " + exName;
                            errorMes = ConfigUtil.getMessage("security.wssecurity.ConfigUtil.s27", new String[]{"'" + alias + "'", "'" + storePath + "'", tmpMsg22});
                        }
                        throw throwable;
                    }
                }
                Tr.processException((Throwable)ex, clsName + ".createKeyInformation", "427", this);
                Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{"'" + alias + "'", "'" + storePath + "'", ex});
                tmpMsg = exMsg == null ? exName : exName + ": " + exName;
                errorMes = ConfigUtil.getMessage("security.wssecurity.ConfigUtil.s27", new String[]{"'" + alias + "'", "'" + storePath + "'", tmpMsg});
            }
            Tr.processException((Throwable)ex, clsName + ".createKeyInformation", "427", this);
            Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{"'" + alias + "'", "'" + storePath + "'", ex});
            tmpMsg = exMsg == null ? exName : exName + ": " + exName;
            errorMes = ConfigUtil.getMessage("security.wssecurity.ConfigUtil.s27", new String[]{"'" + alias + "'", "'" + storePath + "'", tmpMsg});
        }
        if (entry == null && status == 0) {
            String error = "entry=null";
            ++status;
            Tr.error(tc, "security.wssecurity.WSEC6800E", new Object[]{"'" + alias + "'", "'" + storePath + "'", error});
            errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6800E", new String[]{"'" + alias + "'", "'" + storePath + "'", error});
        }
        if (status == 0) {
            Certificate cert;
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                KeyStore.TrustedCertificateEntry tcentry;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trusted Certificate Entry.");
                }
                if ((cert = (tcentry = (KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate()) != null && cert instanceof X509Certificate) {
                    x509 = (X509Certificate)cert;
                    subjectDN = x509.getSubjectDN().getName();
                    encSubjectDN = KeyInfo.X509Data.encodeDName(subjectDN);
                    issuerDN = x509.getIssuerDN().getName();
                    encIssuerDN = KeyInfo.X509Data.encodeDName(issuerDN);
                    issuerSerial = x509.getSerialNumber().toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "subjectDN[" + subjectDN + "], " + "encSubjectDN[" + encSubjectDN + "], " + "issuerDN[" + issuerDN + "], " + "encIssuerDN[" + encIssuerDN + "], " + "issuerSerial[" + issuerSerial + "]");
                    }
                    try {
                        binary = cert.getEncoded();
                        x509.checkValidity();
                    }
                    catch (CertificateEncodingException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "478", this);
                        Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{e.getClass().getName() + ": " + e.getMessage()});
                    }
                    catch (CertificateExpiredException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "486", this);
                        Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{subjectDN, alias, storePath, e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{subjectDN, alias, storePath, e.getClass().getName() + ": " + e.getMessage()});
                    }
                    catch (CertificateException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "497", this);
                        Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{subjectDN, alias, storePath, e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{subjectDN, alias, storePath, e.getClass().getName() + ": " + e.getMessage()});
                    }
                    expiration = x509.getNotAfter().getTime();
                    if (status == 0 && expiration - System.currentTimeMillis() < 5184000000L) {
                        long millisBeforeExpiration = expiration - System.currentTimeMillis();
                        long daysLeft = millisBeforeExpiration / 86400000L;
                        Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{subjectDN, alias, storePath, new Long(daysLeft)});
                    }
                    if (status == 0) {
                        try {
                            byte[] keyid = KeyStoreManager.makeSubjectKeyIdentifier(cert, null);
                            b64KeyId = Base64.encode(keyid);
                            hexKeyId = Hex.encode(keyid);
                            keyid = KeyStoreManager.makeSubjectKeyIdentifier(cert, Constants.IT60SHA1);
                            b64KeyId60 = Base64.encode(keyid);
                            hexKeyId60 = Hex.encode(keyid);
                        }
                        catch (NoSuchAlgorithmException e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "528", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass().getName() + ": " + e.getMessage();
                        }
                        catch (InvalidAlgorithmParameterException e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "535", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                        catch (Exception e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "542", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                        publickey = cert.getPublicKey();
                    }
                    if (status == 0) {
                        try {
                            byte[] thumbprint = KeyStoreManager.makeThumbprint(binary);
                            b64Thumbprint = Base64.encode(thumbprint);
                            hexThumbprint = Hex.encode(thumbprint);
                        }
                        catch (Exception e) {
                            status += 8;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "557", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                    }
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry pkentry;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Private Key Entry.");
                }
                if ((cert = (pkentry = (KeyStore.PrivateKeyEntry)entry).getCertificate()) != null && cert instanceof X509Certificate) {
                    x509 = (X509Certificate)cert;
                    subjectDN = x509.getSubjectDN().getName();
                    encSubjectDN = KeyInfo.X509Data.encodeDName(subjectDN);
                    issuerDN = x509.getIssuerDN().getName();
                    encIssuerDN = KeyInfo.X509Data.encodeDName(issuerDN);
                    issuerSerial = x509.getSerialNumber().toString();
                    try {
                        binary = cert.getEncoded();
                        x509.checkValidity();
                    }
                    catch (CertificateEncodingException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "615", this);
                        Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{e.getClass().getName() + ": " + e.getMessage()});
                    }
                    catch (CertificateExpiredException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "623", this);
                        Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{subjectDN, alias, storePath, e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{subjectDN, alias, storePath, e.getClass().getName() + ": " + e.getMessage()});
                    }
                    catch (CertificateException e) {
                        status += 2;
                        Tr.processException((Throwable)e, clsName + ".createKeyInformation", "634", this);
                        Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{subjectDN, alias, storePath, e});
                        errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{subjectDN, alias, storePath, e.getClass().getName() + ": " + e.getMessage()});
                    }
                    expiration = x509.getNotAfter().getTime();
                    if (status == 0 && expiration - System.currentTimeMillis() < 5184000000L) {
                        long millisBeforeExpiration = expiration - System.currentTimeMillis();
                        long daysLeft = millisBeforeExpiration / 86400000L;
                        Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{subjectDN, alias, storePath, new Long(daysLeft)});
                    }
                    if (status == 0) {
                        try {
                            byte[] keyid = KeyStoreManager.makeSubjectKeyIdentifier(cert, null);
                            b64KeyId = Base64.encode(keyid);
                            hexKeyId = Hex.encode(keyid);
                            keyid = KeyStoreManager.makeSubjectKeyIdentifier(cert, Constants.IT60SHA1);
                            b64KeyId60 = Base64.encode(keyid);
                            hexKeyId60 = Hex.encode(keyid);
                        }
                        catch (NoSuchAlgorithmException e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "665", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + e.getClass().getName() + ": " + e.getMessage();
                        }
                        catch (InvalidAlgorithmParameterException e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "672", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                        catch (Exception e) {
                            status += 4;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "679", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                        publickey = cert.getPublicKey();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "subjectDN[" + subjectDN + "], " + "encSubjectDN[" + encSubjectDN + "], " + "issuerDN[" + issuerDN + "], " + "encIssuerDN[" + encIssuerDN + "], " + "issuerSerial[" + issuerSerial + "], " + "publickey[" + publickey + "]");
                        }
                    }
                    if (status == 0) {
                        try {
                            byte[] thumbprint = KeyStoreManager.makeThumbprint(binary);
                            b64Thumbprint = Base64.encode(thumbprint);
                            hexThumbprint = Hex.encode(thumbprint);
                        }
                        catch (Exception e) {
                            status += 8;
                            Tr.processException((Throwable)e, clsName + ".createKeyInformation", "704", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{e});
                            errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + e.getClass().getName() + ": " + e.getMessage();
                        }
                    }
                }
                privatekey = pkentry.getPrivateKey();
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry skentry = (KeyStore.SecretKeyEntry)entry;
                subjectDN = keyName;
                encSubjectDN = encKeyName;
                publickey = skentry.getSecretKey();
                privatekey = publickey;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subjectDN[" + subjectDN + "], " + "encSubjectDN[" + encSubjectDN + "], " + "privatekey=publickey[" + privatekey + "]");
                }
            }
        }
        KeyInformation keyInformation = new KeyInformation(storePath, alias, encKeyName, publickey, privatekey, x509, binary, subjectDN, encSubjectDN, encIssuerDN, issuerSerial, b64KeyId, b64KeyId60, b64Thumbprint, hexKeyId, hexKeyId60, hexThumbprint, status, expiration, 5184000000L, errorMes);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createKeyInformation(");
            buf.append("KeyStore, String, char[], String)");
            buf.append(" returns KeyInformation[").append(keyInformation).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keyInformation;
    }

    public final synchronized KeyInformation getKeyInformationInPkiPath(String storePath, String storeType, char[] storePassword, String keyStoreRef, String alias, char[] keyPassword, String keyName, List certStores) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInformationInPkiPath(");
            buf.append("String storePath[").append(storePath).append("], ");
            buf.append("String storeType[").append(storeType).append("], ");
            buf.append("char[] storePassword[");
            buf.append(storePassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyStoreRef[").append(keyStoreRef).append("], ");
            buf.append("String alias[").append(alias).append("], ");
            buf.append("char[] keyPassword[");
            buf.append(keyPassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyName[").append(keyName).append("])");
            Tr.entry(tc, buf.toString());
        }
        KeyInformation keyInformation = this.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
        KeyStore keyStore = this.getKeyStore(storePath, storeType, storePassword, keyStoreRef);
        byte[] binary = null;
        try {
            binary = CertificateUtil.encodePkiPath(keyStore.getProvider(), certStores, keyStore, alias);
        }
        catch (Exception e) {
            keyInformation._status += 2;
            Tr.processException((Throwable)e, clsName + ".getKeyInformationInPkiPath", "777", this);
            Tr.error(tc, "security.wssecurity.PkiPathCallbackHandler.s01", new Object[]{e});
            keyInformation._errorMes = ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01") + ": " + e.getClass().getName() + ": " + e.getMessage();
        }
        KeyInformation.access$302(keyInformation, binary);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInformationInPkiPath( KeyStore keyStore, String storePath, String alias, char[] keyPassword,  String keyName)");
        }
        return keyInformation;
    }

    public final synchronized KeyInformation getKeyInformationInPKCS7(String storePath, String storeType, char[] storePassword, String keyStoreRef, String alias, char[] keyPassword, String keyName, List certStores) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyInformationInPkiPath(");
            buf.append("String storePath[").append(storePath).append("], ");
            buf.append("String storeType[").append(storeType).append("], ");
            buf.append("char[] storePassword[");
            buf.append(storePassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyStoreRef[").append(keyStoreRef).append("], ");
            buf.append("String alias[").append(alias).append("], ");
            buf.append("char[] keyPassword[");
            buf.append(keyPassword == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String keyName[").append(keyName).append("])");
            Tr.entry(tc, buf.toString());
        }
        KeyInformation keyInformation = this.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
        KeyStore keyStore = this.getKeyStore(storePath, storeType, storePassword, keyStoreRef);
        byte[] binary = null;
        try {
            binary = CertificateUtil.encodePKCS7(null, certStores, keyStore, alias);
        }
        catch (Exception e) {
            keyInformation._status += 2;
            Tr.processException((Throwable)e, clsName + ".getKeyInformationInPKCS7", "824", this);
            Tr.error(tc, "security.wssecurity.PKCS7CallbackHandler.s01", new Object[]{e});
            keyInformation._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6806E") + ": " + e.getClass().getName() + ": " + e.getMessage();
        }
        KeyInformation.access$302(keyInformation, binary);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInformationInPKCS7(String storePath, String storeType, +char[] storePassword, String keyStoreRef, String alias, char[] keyPassword, String keyName, List certStores)");
        }
        return keyInformation;
    }

    public final synchronized KeyStore getKeyStore(String storePath, String storeType, char[] storePassword, String keyStoreRef) throws SoapSecurityException {
        StringBuffer buf;
        boolean bStorePath;
        if (tc.isEntryEnabled()) {
            StringBuffer buf2 = new StringBuffer("getKeyStore(");
            buf2.append("String storePath[").append(storePath).append("], ");
            buf2.append("String storeType[").append(storeType).append("], ");
            buf2.append("char[] storePassword[");
            buf2.append(storePassword == null ? "null" : "not null");
            buf2.append("], ");
            buf2.append("String keyStoreRef[").append(keyStoreRef).append("])");
            Tr.entry(tc, buf2.toString());
        }
        boolean bKeyStoreRef = keyStoreRef != null && keyStoreRef.length() > 0;
        boolean bl = bStorePath = storePath != null && storePath.length() > 0;
        if (!bKeyStoreRef && !bStorePath) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Both KeyStoreRef and StorePass are null or empty length");
            }
            String msg = "security.wssecurity.KeyStoreManager.noKeyStoreRefAndStorePath";
            SoapSecurityException e = SoapSecurityException.format(msg);
            Tr.processException((Throwable)e, clsName + ".getKeyStore", "866", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        KeyStore keyStore = null;
        if (bKeyStoreRef) {
            keyStore = ConfigUtil.getKeyStore(keyStoreRef);
        }
        if (keyStore == null) {
            if (bStorePath && (keyStore = this.keyStoreCache.get(storePath = ConfigUtil.expandInstallLocation(storePath))) == null) {
                if (tc.isDebugEnabled()) {
                    buf = new StringBuffer("There is no cached key store with the keystore [");
                    buf.append(storePath);
                    buf.append("]. So a new key store is loaded.");
                    Tr.debug(tc, buf.toString());
                }
                keyStore = ConfigUtil.getKeyStore(storeType, storePath, storePassword);
                this.keyStoreCache.put(storePath, keyStore);
            }
        } else if (tc.isDebugEnabled()) {
            buf = new StringBuffer("There is cached key store with the keystore reference [");
            buf.append(keyStoreRef);
            buf.append("]. So the key store is used.");
            Tr.debug(tc, buf.toString());
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("getKeyStore(");
            buf.append("String, String, char[], String)");
            buf.append(" returns KeyStore[").append(keyStore).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keyStore;
    }

    private static final byte[] certToSubjectKeyIdentifier(Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certToSubjectKeyIdentifier(Certificate cert)");
        }
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        byte[] ki = null;
        byte[] der = ((X509Certificate)cert).getExtensionValue(OID_SUBJECTKEYIDENTIFIER);
        if (der != null) {
            ki = new byte[der.length - 4];
            System.arraycopy(der, 4, ki, 0, der.length - 4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certToSubjectKeyIdentifier(Certificate)");
        }
        return ki;
    }

    private static final byte[] pubkeyToSubjectKeyIdentifier(Certificate cert, QName idty) throws Exception {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("pubkeyToSubjectKeyIdentifier(");
            buf.append("Certificate cert, ");
            buf.append("QName idty[").append(idty).append("])");
            Tr.entry(tc, buf.toString());
        }
        byte[] bits = null;
        if (cert != null) {
            byte[] key = cert.getPublicKey().getEncoded();
            if (key[0] != 48) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6801E", new String[]{Hex.encode(key)});
                RuntimeException e = new RuntimeException(errorMes);
                Tr.processException(e, clsName + ".pubkeyToSubjectKeyIdentifier", "952");
                throw e;
            }
            int len = key[1] & 0xFF;
            int offset = (len & 0x80) == 0 ? 2 : 2 + (len & 0x7F);
            len = key[offset + 1] & 0xFF;
            if ((len & 0x80) == 0) {
                offset += 2;
            } else {
                int lenoff = offset + 2;
                offset += 2 + (len & 0x7F);
                switch (len & 0x7F) {
                    case 1: {
                        len = key[lenoff] & 0xFF;
                        break;
                    }
                    case 2: {
                        len = ((key[lenoff] & 0xFF) << 8) + (key[lenoff + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        len = ((key[lenoff] & 0xFF) << 16) + ((key[lenoff + 1] & 0xFF) << 8) + (key[lenoff + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        len = ((key[lenoff] & 0xFF) << 24) + ((key[lenoff + 1] & 0xFF) << 16) + ((key[lenoff + 2] & 0xFF) << 8) + (key[lenoff + 3] & 0xFF);
                        break;
                    }
                    default: {
                        String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6802E", new String[]{Hex.encode(key)});
                        RuntimeException e = new RuntimeException(errorMes);
                        Tr.processException(e, clsName + ".pubkeyToSubjectKeyIdentifier", "987");
                        throw e;
                    }
                }
            }
            if (key[offset += len] != 3) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6803E", new String[]{Integer.toString(key[offset] & 0xFF, 16)});
                RuntimeException e = new RuntimeException(errorMes);
                Tr.processException(e, clsName + ".pubkeyToSubjectKeyIdentifier", "999");
                throw e;
            }
            offset += ((len = key[offset + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (len & 0x7F);
            AlgorithmFactory factory = AlgorithmFactory.getInstance();
            MessageDigest digester = factory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(idty, Constants.ITSHA1) || idty == null) {
                digester.update(key, offset, key.length - offset);
                bits = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
            } else if (NamespaceUtil.equals(idty, Constants.IT60SHA1)) {
                digester.update(key, offset, key.length - offset);
                byte[] digest = digester.digest();
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                bits = new byte[8];
                bits[0] = (byte)(64 + (digest[digest.length - 8] & 0xF));
                System.arraycopy(digest, digest.length - 8 + 1, bits, 1, bits.length - 1);
            } else {
                factory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", digester);
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{idty.toString()});
                IllegalArgumentException e = new IllegalArgumentException(errorMes);
                Tr.processException(e, clsName + ".pubkeyToSubjectKeyIdentifier", "1026");
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pubkeyToSubjectKeyIdentifier(Certificate, QName)");
        }
        return bits;
    }

    private static final byte[] makeSubjectKeyIdentifier(Certificate cert, QName idty) throws Exception {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("makeSubjectKeyIdentifier(");
            buf.append("Certificate cert, ");
            buf.append("QName idty[").append(idty).append("])");
            Tr.entry(tc, buf.toString());
        }
        byte[] bits = null;
        if (cert != null && ((bits = KeyStoreManager.certToSubjectKeyIdentifier(cert)) == null || idty != null)) {
            if (idty == null || NamespaceUtil.equals(idty, Constants.ITSHA1)) {
                if (bits == null || bits.length != 20) {
                    bits = KeyStoreManager.pubkeyToSubjectKeyIdentifier(cert, idty);
                }
            } else if (NamespaceUtil.equals(idty, Constants.IT60SHA1)) {
                if (bits == null || bits.length != 8) {
                    bits = KeyStoreManager.pubkeyToSubjectKeyIdentifier(cert, idty);
                }
            } else {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{idty.toString()});
                IllegalArgumentException e = new IllegalArgumentException(errorMes);
                Tr.processException(e, clsName + ".makeSubjectKeyIdentifier", "1066");
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIdentifier(Certificate, QName)");
        }
        return bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MessageDigest getSHA1Digest() throws NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSHA1Digest()");
        }
        MessageDigest digest = null;
        Stack<MessageDigest> stack = sha1Pool;
        synchronized (stack) {
            if (!sha1Pool.empty()) {
                digest = sha1Pool.pop();
                digest.reset();
            }
        }
        if (digest == null) {
            digest = MessageDigest.getInstance(MESSAGE_DIGEST_SHA1);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getSHA1Digest()");
            buf.append(" returns MessageDigest [").append(digest).append("]");
            Tr.exit(tc, buf.toString());
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseSHA1Digest(MessageDigest digest) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("releaseSHA1Digest(");
            buf.append("MessageDigest digest[").append(digest).append("](");
            Tr.entry(tc, buf.toString());
        }
        Stack<MessageDigest> stack = sha1Pool;
        synchronized (stack) {
            sha1Pool.push(digest);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSHA1Digest(MessageDigest)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] makeThumbprint(byte[] certBinary) throws NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("makeThumbprint(");
            buf.append("byte[] certBinary)");
            Tr.entry(tc, buf.toString());
        }
        byte[] bits = null;
        if (certBinary != null) {
            MessageDigest digest = null;
            try {
                digest = KeyStoreManager.getSHA1Digest();
                bits = digest.digest(certBinary);
            }
            finally {
                if (digest != null) {
                    KeyStoreManager.releaseSHA1Digest(digest);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeThumbprint(Certificate cert, QName idty)");
        }
        return bits;
    }

    public static class KeyInformation {
        private static final TraceComponent tc = Tr.register(KeyInformation.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        private String _kspath;
        private String _alias;
        private String _name;
        private Key _publicOrSecretKey;
        private Key _privateOrSecretKey;
        private Certificate _certificate;
        private byte[] _binary;
        private String _encodedBinary;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _b64Thumbprint;
        private String _hexKeyId;
        private String _hexKeyId60;
        private String _hexThumbprint;
        private int _status;
        private long _expiration;
        private long _daysInMSBeforeExpireWarning;
        private String _errorMes;

        private KeyInformation(String kspath, String alias, String name, Key publicOrSecretKey, Key privateOrSecretKey, X509Certificate certificate, byte[] binary, String subjectDN, String encSubjectDN, String encIssuerDN, String issuerSerial, String b64KeyId, String b64KeyId60, String b64Thumbprint, String hexKeyId, String hexKeyId60, String hexThumbprint, int status, long expiration, long daysInMSBeforeExpireWarning, String errorMes) {
            this._kspath = kspath;
            this._alias = alias;
            this._name = name;
            this._publicOrSecretKey = publicOrSecretKey;
            this._privateOrSecretKey = privateOrSecretKey;
            this._certificate = certificate;
            this._binary = binary;
            this._subjectDN = subjectDN;
            this._encSubjectDN = encSubjectDN;
            this._encIssuerDN = encIssuerDN;
            this._issuerSerial = issuerSerial;
            this._b64KeyId = b64KeyId;
            this._b64KeyId60 = b64KeyId60;
            this._b64Thumbprint = b64Thumbprint;
            this._hexKeyId = hexKeyId;
            this._hexKeyId60 = hexKeyId60;
            this._hexThumbprint = hexThumbprint;
            this._status = status;
            this._expiration = expiration;
            this._daysInMSBeforeExpireWarning = daysInMSBeforeExpireWarning;
            this._errorMes = errorMes;
        }

        public String getName() {
            return this._name;
        }

        public Key getPublicOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getPublicOrSecretKey", "1219", this);
                throw e;
            }
            this.checkExpiration();
            return this._publicOrSecretKey;
        }

        public Key getPrivateOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getPrivateOrSecretKey", "1229", this);
                throw e;
            }
            this.checkExpiration();
            return this._privateOrSecretKey;
        }

        public Certificate getCertificate() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getCertificate", "1239", this);
                throw e;
            }
            this.checkExpiration();
            return this._certificate;
        }

        public byte[] getBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getBinary", "1249", this);
                throw e;
            }
            this.checkExpiration();
            return this._binary;
        }

        public String getEncodedBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getEncodedBinary", "1259", this);
                throw e;
            }
            this.checkExpiration();
            if (this._encodedBinary == null) {
                this._encodedBinary = Base64.encode(this._binary);
            }
            return this._encodedBinary;
        }

        public String getSubjectDN() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getSubjectDN", "1272", this);
                throw e;
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        public String getIssuerDN() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getIssuerDN", "1282", this);
                throw e;
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        public String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getIssuerSerial", "1292", this);
                throw e;
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        public String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getB64KeyId", "1303", this);
                throw e;
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        public String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getB64KeyId60", "1314", this);
                throw e;
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        public String getB64Thumbprint() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 8) == 8) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getB64Thumbprint", "1325", this);
                throw e;
            }
            this.checkExpiration();
            return this._b64Thumbprint;
        }

        public String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getHexKeyId", "1336", this);
                throw e;
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        public String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getHexKeyId60", "1347", this);
                throw e;
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        public String getHexThumbprint() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 8) == 8) {
                SoapSecurityException e = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)e, clsName + ".getHexThumbprint", "1358", this);
                throw e;
            }
            this.checkExpiration();
            return this._hexThumbprint;
        }

        private void checkExpiration() throws SoapSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkExpiration()");
            }
            if (this._expiration >= 0L) {
                long millisBeforeExpiration = this._expiration - System.currentTimeMillis();
                if (millisBeforeExpiration < 0L) {
                    this._status += 2;
                    this._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + millisBeforeExpiration + " ms."});
                    SoapSecurityException e = new SoapSecurityException(this._errorMes);
                    Tr.processException((Throwable)e, clsName + ".checkExpiration", "1382", this);
                    throw e;
                }
                if (millisBeforeExpiration < this._daysInMSBeforeExpireWarning) {
                    long daysLeft = millisBeforeExpiration / 86400000L;
                    Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{this._subjectDN, this._alias, this._kspath, new Long(daysLeft)});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpiration()");
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            buf.append("keystorePath=[").append(this._kspath).append("], ");
            buf.append("alias=[").append(this._alias).append("], ");
            buf.append("name=[").append(this._name).append("], ");
            buf.append("status=[").append(this._status).append("], ");
            buf.append(")");
            return buf.toString();
        }

        static /* synthetic */ byte[] access$302(KeyInformation x0, byte[] x1) {
            x0._binary = x1;
            return x1;
        }
    }
}

