/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KRBAuthnTokenImpl
extends BinarySecurityTokenImpl
implements KRBAuthnToken,
KRBTicket,
CacheableToken,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    private static final String VERSION_NUMBER = "1.0";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final long DEFAULT_TOKEN_CUSHION = 600000L;
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static MessageDigest md = null;
    private static final TraceComponent tc = Tr.register(KRBAuthnTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static GSSManager gssMgr = null;
    private short version = 1;
    private byte[] tokenBytes = null;
    private String uniqueId = null;
    private String kpn = null;
    private String realm = null;
    protected KerberosTicket tgt = null;
    private GSSCredential gssCred = null;
    private long expiration = 0L;
    private String tokenName = WSSECURITY_KRBAUTHNTOKEN_NAME;
    private boolean isReadOnly = false;
    private Date renewTill = null;
    private Hashtable<String, String> kData = null;
    private String identifier = null;
    private boolean isAddressless = false;
    private boolean isForwardable = false;
    private boolean isRenewable = false;
    private int credType = 0;
    private byte[] apReqBytes = null;

    public KRBAuthnTokenImpl() {
    }

    public KRBAuthnTokenImpl(byte[] inputTokenBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBAuthnTokenImpl(TokenBytes)... " + inputTokenBytes);
        }
        this.tokenBytes = inputTokenBytes;
        if (KRB5Util.hasValue(this.tokenBytes)) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{KRB5Util.stackToString(e)});
                throw new RuntimeException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(TokenBytes)");
        }
    }

    public KRBAuthnTokenImpl(Map map) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBAuthnTokenImpl(map): ");
        }
        this.kpn = (String)map.get(KRBAuthnTokenFactory.PRINCIPAL_NAME);
        this.tgt = (KerberosTicket)map.get(KRBAuthnTokenFactory.KERBEROS_TICKET);
        this.gssCred = (GSSCredential)map.get(KRBAuthnTokenFactory.GSS_CREDENTIAL);
        this.realm = (String)map.get(KRBAuthnTokenFactory.REALM_NAME);
        Long exp = (Long)map.get(KRBAuthnTokenFactory.EXPIRATION_TIME);
        if (exp != null) {
            this.expiration = exp;
        }
        if (this.tgt != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TGT: " + KRB5Util.printTGT(this.tgt));
            }
            if (this.kpn == null) {
                this.kpn = this.tgt.getClient().toString();
            }
            if (!map.containsKey(KRBAuthnTokenFactory.EXPIRATION_TIME)) {
                this.expiration = this.tgt.getEndTime().getTime();
            }
            this.renewTill = this.tgt.getRenewTill();
            this.isAddressless = this.tgt.getClientAddresses() == null;
            this.isForwardable = this.tgt.isForwardable();
            this.isRenewable = this.tgt.isRenewable();
        } else if (this.gssCred != null) {
            try {
                if (this.kpn == null) {
                    this.kpn = ((Object)this.gssCred.getName()).toString();
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            }
        }
        if (this.gssCred != null) {
            long gssExp = 0L;
            try {
                gssExp = this.gssCred.getRemainingLifetime();
                gssExp = gssExp * 1000L + System.currentTimeMillis();
                if (gssExp < this.expiration || this.expiration == 0L) {
                    this.expiration = gssExp;
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            }
        }
        if (this.realm == null && this.kpn != null && (index = this.kpn.indexOf("@")) != -1) {
            this.realm = this.kpn.substring(index + 1, this.kpn.length());
        }
        this.principal = KRB5Util.stripOutPrincipalName(this.kpn);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(map) = " + this.toString());
        }
    }

    @Override
    public GSSCredential getGSSCredential() throws SoapSecurityException {
        if (this.tgt != null) {
            try {
                this.gssCred = this.getGSSCredential(this.tgt);
            }
            catch (PrivilegedActionException pE) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{pE});
                throw new SoapSecurityException(pE);
            }
        }
        if (tc.isDebugEnabled()) {
            if (this.gssCred != null) {
                Tr.debug(tc, "this.gssCred = " + this.gssCred.toString());
            } else {
                Tr.debug(tc, "this.gssCred = null");
                if (this.tgt == null) {
                    Tr.debug(tc, "this.tgt = null");
                }
            }
        }
        return this.gssCred;
    }

    private GSSCredential getGSSCredential(final KerberosTicket ticket) throws PrivilegedActionException {
        GSSCredential gssCrd = null;
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(ticket);
        gssCrd = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction(){

            public Object run() throws SoapSecurityException {
                GSSCredential gc = KRBAuthnTokenImpl.this.createGSSCredential(ticket);
                return gc;
            }
        });
        return gssCrd;
    }

    private GSSCredential createGSSCredential(KerberosTicket ticket) throws SoapSecurityException {
        GSSCredential gssCrd = null;
        if (ticket != null) {
            try {
                String clientName = ticket.getClient().getName();
                Oid krbOid = new Oid(KRB5_OID);
                if (clientName != null && clientName.length() > 0) {
                    if (gssMgr == null) {
                        gssMgr = GSSManager.getInstance();
                    }
                    GSSName gssName = gssMgr.createName(clientName, GSSName.NT_USER_NAME, krbOid);
                    gssCrd = gssMgr.createCredential(gssName.canonicalize(krbOid), Integer.MAX_VALUE, krbOid, 1);
                }
            }
            catch (Throwable t) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{t});
                throw new SoapSecurityException(t);
            }
        }
        return gssCrd;
    }

    @Override
    public boolean isAddressless() {
        return this.isAddressless;
    }

    @Override
    public boolean isRenewable() {
        return this.isRenewable;
    }

    @Override
    public Date getRenewTill() {
        return this.renewTill;
    }

    @Override
    public String getTokenRealm() {
        return this.realm;
    }

    @Override
    public KerberosTicket getKerberosTicket() {
        return this.tgt;
    }

    @Override
    public String[] addTokenAttribute(String key, String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enters addTokenAttribute( key = " + key + ", value = " + value + " )");
        }
        if (!this.isReadOnly) {
            String oldvalue;
            if (this.kData == null) {
                this.kData = new Hashtable();
            }
            if ((oldvalue = this.kData.put(key, value)) != null) {
                String[] returnedData = new String[]{oldvalue};
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Exits addTokenAttribute()... " + returnedData[0]);
                }
                return returnedData;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exits addTokenAttribute()... " + null);
        }
        return null;
    }

    @Override
    public Enumeration getTokenAttributeNames() {
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        return this.kData.keys();
    }

    @Override
    public String[] getTokenAttributes(String key) {
        String data;
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        if ((data = this.kData.get(key)) != null) {
            String[] returnedData = new String[]{data};
            return returnedData;
        }
        return null;
    }

    @Override
    public byte[] getTokenBytes() {
        try {
            ByteArrayOutputStream bayout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bayout);
            this.writeExternal(out);
            out.flush();
            out.close();
            this.tokenBytes = bayout.toByteArray();
        }
        catch (Exception e) {
            Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            throw new RuntimeException(e.getMessage());
        }
        return this.tokenBytes;
    }

    @Override
    public long getTokenExpiration() {
        return this.expiration;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public String getTokenPrincipal() {
        return KRB5Util.stripOutPrincipalName(this.kpn);
    }

    @Override
    public String getTokenUniqueID() {
        if (this.uniqueId == null) {
            if (this.tgt != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl: using principal name and hash of TGT for unique ID");
                }
                this.uniqueId = this.tgt.hashCode() > 0 ? this.kpn + this.tgt.hashCode() : this.kpn + -1 * this.tgt.hashCode() + "n";
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl: using principal for unique ID");
                }
                this.uniqueId = this.kpn;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KRBAuthnTokenImpl: token unique ID = " + this.uniqueId);
        }
        return this.uniqueId;
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null && this.tgt != null) {
            this.identifier = this.tgt.getClient().getName();
        }
        return this.identifier;
    }

    public void setIdentifier(String idd) {
        this.identifier = idd;
    }

    @Override
    public short getTokenVersion() {
        return this.version;
    }

    @Override
    public boolean isTokenForwardable() {
        return true;
    }

    @Override
    public boolean isTokenValid() {
        long current_time = System.currentTimeMillis();
        long timeRemaining = this.expiration - current_time;
        return timeRemaining > 0L;
    }

    @Override
    public void setTokenReadOnly() {
        this.isReadOnly = true;
    }

    public boolean isKRBAuthnToken(byte[] inBytes) {
        boolean isKRB;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isKRBAuthnToken(byte[] inBytes)... " + inBytes);
            }
            isKRB = false;
            if (KRB5Util.hasValue(inBytes)) {
                try {
                    String name;
                    ByteArrayInputStream bayin = new ByteArrayInputStream(inBytes);
                    ObjectInputStream in = new ObjectInputStream(bayin);
                    String version = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.version");
                    if (VERSION_NUMBER.equals(version) && KRBAuthnToken.WSSECURITY_KRBAUTHNTOKEN_NAME.equals(name = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.tokenName"))) {
                        isKRB = true;
                    }
                    in.close();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "isKRBAuthnToken. Can not determine if this is a KRBAuthnToken.");
                    Tr.debug(tc, KRB5Util.stackToString(e));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKRBAuthnToken(byte[] inBytes)");
        }
        return isKRB;
    }

    @Override
    public synchronized void setKerberosTicket(KerberosTicket kbt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKerberosTicket()");
        }
        this.tgt = kbt;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, KRB5Util.printTGT(kbt));
        }
        if (kbt != null) {
            this.expiration = kbt.getEndTime().getTime();
            this.kpn = kbt.getClient().toString();
            this.renewTill = kbt.getRenewTill();
            this.isAddressless = kbt.getClientAddresses() == null;
            this.isRenewable = kbt.isRenewable();
            try {
                this.gssCred = this.getGSSCredential(kbt);
            }
            catch (PrivilegedActionException pEX) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No GSSCredential created - " + pEX.getLocalizedMessage());
                }
                this.gssCred = null;
            }
        } else {
            this.gssCred = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKerberosTicket()");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal(ObjectInput in)");
        }
        if (VERSION_NUMBER.equals(version = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.version"))) {
            this.tokenName = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.tokenName");
            this.credType = ObjectOutputInputUtil.readInt(in, "KRBAuthnToken.credType");
            this.kpn = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.kpn");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "this.kpn=" + this.kpn);
            }
            this.uniqueId = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.uniqueId");
            this.identifier = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.identifier");
            this.realm = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.realm");
            this.expiration = ObjectOutputInputUtil.readLong(in, "KRBAuthnToken.expiration");
            this.readOnly = ObjectOutputInputUtil.readBoolean(in, "KRBAuthnToken.readOnly");
            Object tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.kData");
            if (tmp != null) {
                this.kData = (Hashtable)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.tgt")) != null) {
                this.tgt = (KerberosTicket)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.APREQ")) != null) {
                this.apReqBytes = (byte[])tmp;
            }
            if (this.tgt != null) {
                try {
                    this.gssCred = this.getGSSCredential(this.tgt);
                }
                catch (PrivilegedActionException pE) {
                    Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{pE});
                    throw new IOException(pE);
                }
                this.renewTill = this.tgt.getRenewTill();
                this.isAddressless = this.tgt.getClientAddresses() == null;
                this.isForwardable = this.tgt.isForwardable();
                this.isRenewable = this.tgt.isRenewable();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readExternal(ObjectInput in)=" + in.available());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal(ObjectOutput out)");
        }
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, "KRBAuthnToken.version");
        ObjectOutputInputUtil.writeUTF(out, this.tokenName, "KRBAuthnToken.tokenName");
        ObjectOutputInputUtil.writeInt(out, this.credType, "KRBAuthnToken.credType");
        ObjectOutputInputUtil.writeUTF(out, this.kpn, "KRBAuthnToken.kpn");
        ObjectOutputInputUtil.writeUTF(out, this.uniqueId, "KRBAuthnToken.uniqueId");
        ObjectOutputInputUtil.writeUTF(out, this.identifier, "KRBAuthnToken.identifier");
        ObjectOutputInputUtil.writeUTF(out, this.realm, "KRBAuthnToken.realm");
        ObjectOutputInputUtil.writeLong(out, this.expiration, "KRBAuthnToken.expiration");
        ObjectOutputInputUtil.writeBoolean(out, this.readOnly, "KRBAuthnToken.readOnly");
        ObjectOutputInputUtil.writeObject(out, this.kData, "KRBAuthnToken.kData");
        ObjectOutputInputUtil.writeObject(out, this.tgt, "KRBAuthnToken.tgt");
        ObjectOutputInputUtil.writeObject(out, this.apReqBytes, "KRBAuthnToken.APREQ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeExternal(ObjectOutput out): this.tgt = " + KRB5Util.printTGT(this.tgt));
        }
    }

    @Override
    public String toString() {
        Set<String> s;
        StringBuffer sb = new StringBuffer();
        Date exp = new Date(this.expiration);
        sb.append("\n\ntoken name:         " + this.tokenName);
        sb.append("\nversion:            " + this.version);
        sb.append("\nhashCode:           " + this.hashCode());
        sb.append("\nuniqueId:           " + this.uniqueId);
        sb.append("\nkerberos principal: " + this.kpn);
        sb.append("\nrealm:              " + this.realm);
        sb.append("\nexpiration:         " + exp);
        sb.append("\nrenew until:        " + this.renewTill);
        sb.append("\nisReadOnly:         " + this.isReadOnly);
        sb.append("\nisAddressless:      " + this.isAddressless);
        sb.append("\nisForwardable:      " + this.isForwardable);
        sb.append("\nisRenewable:        " + this.isRenewable);
        sb.append("\nKerberosTicket:     " + KRB5Util.printTGT(this.tgt));
        sb.append("\nGSSCredential:      " + this.gssCred);
        if (this.kData != null && !this.kData.isEmpty() && (s = this.kData.keySet()) != null && !s.isEmpty()) {
            Iterator<String> it = s.iterator();
            sb.append("\n\nAttributes: ");
            String key = null;
            while (it.hasNext()) {
                key = it.next();
                sb.append("\n" + key + " : " + this.kData.get(key));
            }
        }
        return sb.toString();
    }
}

