/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ1510Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ4120Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQToken;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ1510Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ4120Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQToken;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRBAuthnTokenImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import javax.security.auth.kerberos.KerberosTicket;
import javax.xml.namespace.QName;

public class KRB5TokenImpl
extends KRBAuthnTokenImpl
implements KRB5_APREQ1510Token,
KRB5_APREQ4120Token,
KRB5_APREQToken,
KRB5_GSSAPREQ1510Token,
KRB5_GSSAPREQ4120Token,
KRB5_GSSAPREQToken {
    private static final short VERSION = 1;
    protected short version = 1;
    private String VERSION_NUMBER = "1.0";
    protected String identifier = null;
    protected KerberosTicket tgs = null;
    protected String spn = null;
    protected String apreqSha1 = null;
    protected byte[] secreteBytes = null;
    protected String client = null;
    protected Date serviceExpirationTime = null;
    private byte[] tokenBytes = null;
    private int hashcode = 0;
    private static final TraceComponent tc = Tr.register(KRB5TokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    public KRB5TokenImpl() {
    }

    public KRB5TokenImpl(byte[] inBytes) {
        this.tokenBytes = inBytes;
        if (this.tokenBytes != null) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public KRB5TokenImpl(Map table) {
        super(table);
        this.copyTable(table);
    }

    private void copyTable(Map _table) {
        this.identifier = (String)_table.get("TGSAuthToken.identifier");
        this.spn = (String)_table.get("TGSAuthToken.spn");
        this.tgs = (KerberosTicket)_table.get("TGSAuthToken.tgs");
        this.valueType = (QName)_table.get("TGSAuthToken.valueType");
        this.secreteBytes = (byte[])_table.get("TGSAuthToken.secreteBytes");
        this.apreqSha1 = (String)_table.get("TGSAuthToken.apreqSha1");
        this.client = (String)_table.get("TGSAuthToken.client");
        this.serviceExpirationTime = (Date)_table.get("TGSAuthToken.tgsExpirationTime");
    }

    @Override
    public String getSHA1ofAPREQ() {
        return this.apreqSha1;
    }

    @Override
    public String getSPNName() {
        return this.spn;
    }

    @Override
    public Date getServiceTicketExpirationTime() {
        return this.serviceExpirationTime;
    }

    @Override
    public String getClientPrincipal() {
        return this.client;
    }

    @Override
    public byte[] getAPREQKeyByte() {
        return this.secreteBytes;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            StringBuffer hashID = new StringBuffer();
            if (this.tgt != null) {
                hashID.append(this.tgt.hashCode());
            }
            if (this.tgs != null) {
                hashID.append(this.tgs.hashCode());
            }
            if (this.principal != null) {
                hashID.append(this.principal);
            }
            if (this.spn != null) {
                hashID.append(this.spn);
            }
            if (this.apreqSha1 != null) {
                hashID.append(this.apreqSha1);
            }
            this.hashcode = hashID.toString().hashCode();
            if (this.hashcode == 0) {
                this.hashcode = SecurityUIDGenerator.createUID().hashCode();
            }
        }
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KRB5TokenImpl)) {
            return false;
        }
        return ((KRB5TokenImpl)o).hashCode() == this.hashCode();
    }

    @Override
    public byte[] getTokenBytes() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getTokenBytes()");
        }
        try {
            ByteArrayOutputStream bayout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bayout);
            this.writeExternal(out);
            out.flush();
            out.close();
            this.tokenBytes = bayout.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getTokenBytes()");
        }
        return this.tokenBytes;
    }

    public Object clone() {
        return new KRB5TokenImpl(this.getTokenBytes());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        String version = ObjectOutputInputUtil.readUTF(in, "KRB5Token.version");
        if (this.VERSION_NUMBER.equals(version)) {
            this.identifier = ObjectOutputInputUtil.readUTF(in, "KRB5Token.identifier");
            this.spn = ObjectOutputInputUtil.readUTF(in, "KRB5Token.spn");
            this.apreqSha1 = ObjectOutputInputUtil.readUTF(in, "KRB5Token.apreqSha1");
            this.client = ObjectOutputInputUtil.readUTF(in, "KRB5Token.client");
            Object tmp = ObjectOutputInputUtil.readObject(in, "KRB5Token.tgs");
            if (tmp != null) {
                this.tgs = (KerberosTicket)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRB5Token.valueType")) != null) {
                this.valueType = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRB5Token.secreteBytes")) != null) {
                this.secreteBytes = (byte[])tmp;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectOutputInputUtil.writeUTF(out, this.VERSION_NUMBER, "KRB5Token.version");
        ObjectOutputInputUtil.writeUTF(out, this.identifier, "KRB5Token.identifier");
        ObjectOutputInputUtil.writeUTF(out, this.spn, "KRB5Token.spn");
        ObjectOutputInputUtil.writeUTF(out, this.apreqSha1, "KRB5Token.apreqSha1");
        ObjectOutputInputUtil.writeUTF(out, this.client, "KRB5Token.client");
        ObjectOutputInputUtil.writeObject(out, this.tgs, "KRB5Token.tgs");
        ObjectOutputInputUtil.writeObject(out, this.valueType, "KRB5Token.valueType");
        ObjectOutputInputUtil.writeObject(out, this.secreteBytes, "KRB5Token.secreteBytes");
    }
}

