/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.security.SecurityPermission;
import javax.xml.namespace.QName;

public class DKToken
extends SecurityTokenImpl
implements DerivedKeyToken {
    private static final TraceComponent tc = Tr.register(BinarySecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 99538763796610756L;
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.DKToken.getBytes");
    private static final SecurityPermission SETSECRET_PERM = new SecurityPermission("wssapi.DKToken.setSecret");
    private static final SecurityPermission SETSECRET_ARRAY_PERM = new SecurityPermission("wssapi.DKToken.setSecret_array");
    private static final SecurityPermission SETSCTUUID_PERM = new SecurityPermission("wssapi.DKToken.setSecurityContextTokenUUID");
    private static final SecurityPermission SETSERVICELABEL_PERM = new SecurityPermission("wssapi.DKToken.setServiceLabel");
    private static final SecurityPermission SETCLIENTLABEL_PERM = new SecurityPermission("wssapi.DKToken.setClientLabel");
    private QName vtype = null;
    private byte[] dktbyte = new byte[0];
    private byte[] nonce = null;
    private byte[] secret = new byte[0];
    private byte[] clientSecret = new byte[0];
    private byte[] serverSecret = new byte[0];
    private String refTokenUUID = null;
    private String refTokenId = null;
    private String refTokenInstance = null;
    private QName refTokenType = null;
    private String algorithm = Constants.SC_DK_ALGO_PSHA1;
    private String sLabel = null;
    private String cLabel = null;
    private String label;
    private int length = 0;
    private SecurityToken masterToken = null;
    private XMLStructure props = null;
    int offset = 0;
    int generation = 0;
    private boolean referMasterTokenBySTR = true;
    private String referMaterTokenEncode = null;
    protected static final int ENCRYPTION = 1;
    protected static final int SIGNATURE = 2;
    protected static final int DECRYPTION = 3;
    protected static final int VERIFICATION = 4;

    public DKToken() {
        this.valueType = DerivedKeyToken.ValueType;
        this.tokenQName = DerivedKeyToken.TokenQname;
    }

    public DKToken(QName vType, QName tType) {
        this.valueType = vType;
        this.tokenQName = tType;
    }

    public QName getType() {
        return this.vtype;
    }

    public void setType(QName type) {
        if (!this.readOnly) {
            this.vtype = type;
        }
    }

    public void setType(String uri, String localName) {
        if (!this.readOnly) {
            this.vtype = new QName(uri, localName);
        }
    }

    public boolean isTrusted() {
        return false;
    }

    public void setTrusted(boolean truested) {
        if (!this.readOnly) {
            // empty if block
        }
    }

    public boolean isValid() {
        return false;
    }

    public long getExpiration() {
        return 0L;
    }

    public byte[] getBytes() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            sm.checkPermission(GETBYTES_PERM);
        }
        byte[] dktbyte = this.dktbyte;
        if (this.readOnly && dktbyte != null) {
            int dktbytelen = this.dktbyte.length;
            dktbyte = new byte[dktbytelen];
            System.arraycopy(this.dktbyte, 0, dktbyte, 0, dktbytelen);
        }
        return dktbyte;
    }

    public void setBytes(byte[] dktbyte) {
        if (!this.readOnly) {
            this.dktbyte = dktbyte;
        }
    }

    @Override
    public byte[] getNonce() {
        byte[] nonce = this.nonce;
        if (this.readOnly && nonce != null) {
            int noncelen = this.nonce.length;
            nonce = new byte[noncelen];
            System.arraycopy(this.nonce, 0, nonce, 0, noncelen);
        }
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        if (!this.readOnly) {
            this.nonce = nonce;
        }
    }

    public QName getrefTokenType() {
        return this.refTokenType;
    }

    public void setrefTokenType(QName refTokenType) {
        if (!this.readOnly) {
            this.refTokenType = refTokenType;
        }
    }

    public void setrefTokenType(String uri, String localName) {
        if (!this.readOnly) {
            this.refTokenType = new QName(uri, localName);
        }
    }

    public void setClientSecret(byte[] cSecret) {
        if (!this.readOnly) {
            this.clientSecret = cSecret;
        }
    }

    public byte[] getClientSecret() {
        return this.clientSecret;
    }

    public void setServerSecret(byte[] sSecret) {
        if (!this.readOnly) {
            this.serverSecret = sSecret;
        }
    }

    public byte[] getServerSecret() {
        return this.serverSecret;
    }

    @Override
    public String getSecurityContextTokenTokenUUID() {
        return this.refTokenUUID;
    }

    @Override
    public void setSecurityContextTokenUUID(String uuid) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSCTUUID_PERM.toString());
            }
            sm.checkPermission(SETSCTUUID_PERM);
        }
        if (!this.readOnly) {
            this.refTokenUUID = uuid;
        }
    }

    public String getRefTokenInstance() {
        return this.refTokenInstance;
    }

    public void setRefTokenInstance(String curInstance) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSCTUUID_PERM.toString());
            }
            sm.checkPermission(SETSCTUUID_PERM);
        }
        if (!this.readOnly) {
            this.refTokenInstance = curInstance;
        }
    }

    public String getrefTokenId() {
        return this.refTokenId;
    }

    public void setrefTokenId(String id) {
        if (!this.readOnly) {
            this.refTokenId = id;
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algo) {
        if (!this.readOnly) {
            this.algorithm = algo;
        }
    }

    @Override
    public String getServiceLabel() {
        return this.sLabel;
    }

    @Override
    public void setServiceLabel(String sLabel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSERVICELABEL_PERM.toString());
            }
            sm.checkPermission(SETSERVICELABEL_PERM);
        }
        if (!this.readOnly) {
            this.sLabel = sLabel;
        }
    }

    @Override
    public String getClientLabel() {
        return this.cLabel;
    }

    @Override
    public void setClientLabel(String cLabel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCLIENTLABEL_PERM.toString());
            }
            sm.checkPermission(SETCLIENTLABEL_PERM);
        }
        if (!this.readOnly) {
            this.cLabel = cLabel;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!this.readOnly) {
            this.label = label;
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (!this.readOnly) {
            this.length = length;
        }
    }

    @Override
    public byte[] getSecret() {
        byte[] secret = this.secret;
        if (this.readOnly && secret != null) {
            int secretlen = this.secret.length;
            secret = new byte[secretlen];
            System.arraycopy(this.secret, 0, secret, 0, secretlen);
        }
        return this.secret;
    }

    public SecurityToken getDerivableSecurityToken() {
        return this.masterToken;
    }

    public void setDerivableSecurityToken(SecurityToken insct) {
        if (!this.readOnly) {
            this.masterToken = insct;
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (!this.readOnly) {
            this.offset = offset;
        }
    }

    public int getGeneration() {
        return this.offset;
    }

    public void setGeneration(int generation) {
        if (!this.readOnly) {
            this.generation = generation;
        }
    }

    public XMLStructure getProperties() {
        XMLStructure props = this.props;
        if (this.readOnly && props != null) {
            props = new OMStructure(((OMStructure)props).getNode().cloneOMElement());
        }
        return props;
    }

    public void setProperties(XMLStructure struc) {
        if (!this.readOnly) {
            this.props = struc;
        }
    }

    public String getSecurityContextTokenId() {
        return this.refTokenId;
    }

    @Override
    public SecurityContextToken getSecurityContextToken() {
        return null;
    }

    public boolean isReferMasterTokenBySTR() {
        return this.referMasterTokenBySTR;
    }

    public void setReferMasterTokenBySTR(boolean state) {
        this.referMasterTokenBySTR = state;
    }

    public String getReferMaterTokenEncoding() {
        return this.referMaterTokenEncode;
    }

    public void setReferMaterTokenEncoding(String name) {
        this.referMaterTokenEncode = name;
    }
}

