/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.DerivedKeyUtil;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSNonceGenerator;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsc.DerivedKeyToken;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.KeyIdentifier;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Reference;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.SecurityTokenReference;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

public class DKTGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(DKTGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DKTGenerateLoginModule.class.getName();
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KWAES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KWAES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KWAES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private CallbackHandler _handler;
    private Map _sharedState;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private OMNode _referencedTokenElement;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private boolean _isOM = false;
    private boolean _isWSSObject = false;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        String keyInfoName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw new LoginException(e.getMessage());
            }
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("loginForPolicyset(");
            buf.append("SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        DKToken dktoken = null;
        boolean baseTokenInMessage = false;
        String tokenId = null;
        String tokenUUID = null;
        String tokenInstance = null;
        if (this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference") != null) {
            baseTokenInMessage = true;
            tokenId = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference");
        } else if (this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId") != null) {
            tokenId = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId");
        }
        if (this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.externalTokenReference") != null) {
            tokenUUID = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.externalTokenReference");
            tokenInstance = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenInstance");
        }
        if (tokenId == null && tokenUUID == null) {
            return true;
        }
        if (this._sharedState.get(Constants.WSSECURITY_TOKEN_PROCESSED) != null) {
            this._processedTokens = (List)this._sharedState.get(Constants.WSSECURITY_TOKEN_PROCESSED);
        }
        if (this._sharedState.get(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED) != null) {
            this._insertedTokens = (List)this._sharedState.get(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED);
        }
        String encAlg = null;
        String sigAlg = null;
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        boolean isSigning = false;
        boolean isEncrypting = false;
        String keyType = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isEncrypting = false;
            isSigning = false;
        } else {
            isSigning = "SigningKey".equals(keyType);
            isEncrypting = "EncryptingKey".equals(keyType);
            if (isSigning) {
                sigAlg = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
            }
            if (isEncrypting) {
                encAlg = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
            }
            if (tc.isDebugEnabled()) {
                if (isSigning) {
                    Tr.debug(tc, "Verifying key type");
                } else if (isEncrypting) {
                    Tr.debug(tc, "Encrypting key type");
                }
            }
        }
        if (!isSigning && !isEncrypting) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "protection Key is not required.");
            }
            return true;
        }
        KeyInfoContentGeneratorConfig keyInfoContent = (KeyInfoContentGeneratorConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        DerivedKeyInfoConfig dkic = null;
        if (keyInfoContent != null) {
            dkic = keyInfoContent.getDerivedKeyInfoConfig();
        }
        if (!dkic.isRequireDerivedKeys()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Derived Key is not required.");
            }
            return true;
        }
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        boolean isStrref = false;
        boolean isKeyIdentifier = false;
        if (this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken") != null) {
            if (((String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken")).equals(Constants.WSSECURITY_KEY_REFERENCE)) {
                isStrref = true;
            }
            if (((String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken")).equals(Constants.WSSECURITY_KEY_ID)) {
                isKeyIdentifier = true;
            }
        }
        String keyIdEncoding = null;
        if (this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType") != null) {
            keyIdEncoding = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType");
        }
        int wssVersion = 0;
        Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        javax.xml.namespace.QName baseTokenType = (javax.xml.namespace.QName)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType");
        if (com.ibm.ws.wssecurity.common.Constants.SCT.equals(baseTokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
            tokenType = baseTokenType.getLocalPart();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Referenced Token Value Type = " + baseTokenType);
            Tr.debug(tc, "Token Value Type = " + tokenType);
        }
        boolean alreadyExist = false;
        Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (parent instanceof WSSObjectElement) {
            this._isWSSObject = true;
        } else {
            this._isOM = true;
        }
        boolean includeLengthInMessage = true;
        int encKeyLength = 16;
        int sigKeyLength = 20;
        String sLabel = "WS-SecureConversation";
        String cLabel = "WS-SecureConversation";
        int nonceSize = 16;
        int offset = 0;
        int generation = 0;
        Map<Object, Object> tconfigProps = null;
        int tokenGenerators = gconfig.getTokenGenerators().size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The supplied algorithms from algorithm suite, Encryption Algorithm: " + encAlg + " and Signature Algorithm: = " + sigAlg);
            Tr.debug(tc, "Number of token generators in the configuration = " + tokenGenerators);
        }
        tconfigProps = config2.getProperties();
        if (keyInfoContent != null && (keyInfoName = keyInfoContent.getKeyName()) != null) {
            List<Configuration> operations = gconfig.getOperationGenerators();
            String keyInfoUsedSign = null;
            String keyInfoUsedEnc = null;
            for (Configuration conf : operations) {
                String keyname;
                if (conf instanceof SignatureGeneratorConfig) {
                    keyname = ((SignatureGeneratorConfig)conf).getSigningKeyInfo().getContentGenerator().getKeyName();
                    if (!keyInfoName.equals(keyname)) continue;
                    keyInfoUsedSign = keyname;
                    continue;
                }
                if (!(conf instanceof EncryptionGeneratorConfig) || !keyInfoName.equals(keyname = ((EncryptionGeneratorConfig)conf).getEncryptionKeyInfo().getContentGenerator().getKeyName())) continue;
                keyInfoUsedEnc = keyname;
            }
            if (keyInfoName.equals(keyInfoUsedSign) && keyInfoName.equals(keyInfoUsedEnc)) {
                includeLengthInMessage = false;
            }
        }
        if (!includeLengthInMessage && gconfig instanceof PolicyOutboundConfig) {
            encAlg = ((PolicyOutboundConfig)gconfig).getEncryptionAlgorithm();
            sigAlg = ((PolicyOutboundConfig)gconfig).getSymmetricSignatureAlgorithm();
        }
        if (encAlg != null) {
            encKeyLength = DKTGenerateLoginModule.getKeyLength(false, gconfig, config2, dkic, encAlg);
            encAlg = DKTGenerateLoginModule.mapKeyAlgorithm2JCE(encAlg, false, false, false, true);
        }
        if (sigAlg != null) {
            sigKeyLength = DKTGenerateLoginModule.getKeyLength(true, gconfig, config2, dkic, sigAlg);
            sigAlg = DKTGenerateLoginModule.mapKeyAlgorithm2JCE(sigAlg, false, false, true, false);
        }
        if (encKeyLength == sigKeyLength) {
            includeLengthInMessage = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption algorithm (JCE mapping) and key length are = " + encAlg + ", " + encKeyLength);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature algorithm (JCE mapping)and key length are = " + sigAlg + ", " + sigKeyLength);
        }
        if (isEncrypting && encAlg == null) {
            throw new LoginException("Missing Algorithm info in the config");
        }
        if (isSigning && sigAlg == null) {
            throw new LoginException("Missing Algorithm info in the config");
        }
        if (dkic != null) {
            sLabel = dkic.getServiceLabel();
            cLabel = dkic.getClientLabel();
            String nonceSizeStr = dkic.getNonceLength();
            if (nonceSizeStr != null && nonceSizeStr.length() > 0) {
                nonceSize = new Integer(nonceSizeStr);
            }
        } else {
            sLabel = (String)config2.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
            cLabel = (String)config2.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (messageContext != null) {
            String InboundtokenType = null;
            OperationContext opCtx = messageContext.getOperationContext();
            if (opCtx != null) {
                HashMap allMsgCtxs = opCtx.getMessageContexts();
                Set msgContexts = allMsgCtxs.entrySet();
                for (Map.Entry singleMsgCtx : msgContexts) {
                    MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                    InboundtokenType = (String)tempMsgCtx.getProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
                    if (InboundtokenType == null) continue;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found SC TokenType: " + InboundtokenType);
                    break;
                }
            }
            if (InboundtokenType != null && InboundtokenType.length() > 0) {
                tokenType = InboundtokenType;
            }
        }
        DKTContent dktContent = new DKTContent(tokenType);
        if (isEncrypting) {
            dktContent.set(tokenId, tokenUUID, tokenInstance, baseTokenType, encKeyLength, sLabel, cLabel, offset, generation, nonceSize, keyIdEncoding);
        } else {
            dktContent.set(tokenId, tokenUUID, tokenInstance, baseTokenType, sigKeyLength, sLabel, cLabel, offset, generation, nonceSize, keyIdEncoding);
        }
        String refid = null;
        String reference = null;
        IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(this._context);
        refid = idAttrVal.getStringValue();
        if (isStrref) {
            reference = idAttrVal.getStringRefValue();
        } else if (isKeyIdentifier) {
            reference = idAttrVal.getStringRefValue();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using DKT id = " + refid + ", to create DKToken.");
        }
        try {
            dktoken = this.createDKTokenAndElement(parent, dktContent, refid, baseTokenInMessage, includeLengthInMessage, wssVersion, isStrref, isKeyIdentifier);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "942", this);
            throw new LoginException(e.toString());
        }
        if (dktoken == null) {
            if (tc.isDebugEnabled()) {
                Tr.error(tc, "DKToken cannot be created!");
            }
            throw new LoginException("Invalid derived key token");
        }
        if (isStrref) {
            dktoken.setReferenceURI(reference);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the token's Reference URI = " + reference);
            }
        } else if (isKeyIdentifier) {
            dktoken.setReferenceURI(reference);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the token's key Identifier = " + reference);
            }
        }
        Key encKey = null;
        Key sigKey = null;
        try {
            if (encAlg != null) {
                encKey = this.createDerivedKey(dktoken, encAlg, encKeyLength);
                if (isEncrypting && encKey == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
                }
                if (encKey != null) {
                    dktoken.setKey(62, encKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Derived key (for encryption) algorithm = " + encKey.getAlgorithm() + ", and key = " + Base64.encode(encKey.getEncoded()));
                    }
                }
            }
            if (sigAlg != null) {
                sigKey = this.createDerivedKey(dktoken, sigAlg, sigKeyLength);
                if (isSigning && sigKey == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
                }
                if (sigKey != null) {
                    dktoken.setKey(61, sigKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Derived key (for signing) algorithm = " + sigKey.getAlgorithm() + ", and key = " + sigKey.getEncoded());
                    }
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{ex.toString()}));
        }
        catch (InvalidKeyException ex) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{ex.toString()}));
        }
        if (dkic.isRequireImpliedDerivedKeys()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implied Derived Keys property is = TRUE");
            }
            dktoken.setXML(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting the dktoken in the subject. dktoken id = " + dktoken.getId());
            Tr.debug(tc, "dktoken = " + dktoken.getKeyIdentifier() + ", dktoken.byte = " + ", dktoken.getAlgorithm =" + dktoken.getAlgorithm() + ", dktoken.getuniqueID=" + dktoken.getSecurityContextTokenTokenUUID());
        }
        this._processedTokens.add(dktoken);
        this._insertedTokens.add(dktoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login() returns.");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (this._processedTokens.size() > 0) {
            int il = this._processedTokens.size();
            for (int i = 0; i < il; ++i) {
                SecurityToken token = this._processedTokens.get(i);
                this._securityTokenManager.addToken(token);
            }
            this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
            this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final DKToken checkDKToken(TokenGeneratorConfig config2, String keyInfoType, String tokenId, String tokenUUID, String keyInfoName, String tokenInstance, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkDKToken(");
            buf.append("TokenGenratorConfig config, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("SecurityToken sctoken, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        DKToken token = null;
        String uniqueId = tokenId;
        Collection<SecurityToken> tokens = null;
        tokens = keyInfoName != null ? securityTokenManager.getTokensByKeyInfo(keyInfoName) : securityTokenManager.getTokens(config2, keyInfoType);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                if (!(t instanceof DKToken)) continue;
                String uuid = ((DKToken)t).getSecurityContextTokenTokenUUID();
                if (uuid != null && tokenUUID != null) {
                    uniqueId = tokenUUID;
                    String currentInstance = ((DKToken)t).getRefTokenInstance();
                    if (!uuid.equals(uniqueId) || currentInstance != null && !currentInstance.equals(tokenInstance)) continue;
                    token = (DKToken)t;
                    break;
                }
                String tid = ((DKToken)t).getrefTokenId();
                if (!tid.equals(uniqueId)) continue;
                token = (DKToken)t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkDKToken(");
            buf.append("TokenGenratorConfig, String, SCTWrapper, SecurityTokenManager)");
            buf.append(" returns DKToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    public static final OMElement createTokenElement(OMFactory factory, OMElement parent, javax.xml.namespace.QName valueType, String refId, String uuid, String curInstance, int wssVersion) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("SCT sct, ");
            buf.append("String curInstance[").append(curInstance).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        String tokenType = null;
        tokenType = valueType.getLocalPart();
        if (tokenType != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT NS =  [" + tokenType + "].");
        }
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsc = null;
        if (parent != null) {
            pWsc = DOMUtils.getNamespacePrefix(parent, nsWsc);
        }
        if (pWsc == null) {
            isDecl = true;
            pWsc = "wsc";
        }
        OMElement tokenElem = factory.createOMElement("SecurityContextToken", nsWsc, pWsc);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsc, "wsc");
        }
        isDecl = false;
        String pWsu = null;
        if (parent != null) {
            pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
        }
        if (pWsu == null) {
            isDecl = true;
            pWsu = "wsu";
        }
        if (isDecl) {
            tokenElem.declareNamespace(nsWsu, "wsu");
        }
        tokenElem.addAttribute("Id", refId, tokenElem.getOMFactory().createOMNamespace(nsWsu, pWsu));
        OMElement id = factory.createOMElement("Identifier", nsWsc, pWsc);
        id.addChild(factory.createOMText(uuid));
        tokenElem.addChild(id);
        if (curInstance != null) {
            OMElement instance = factory.createOMElement("Instance", nsWsc, pWsc);
            instance.addChild(factory.createOMText(curInstance));
            tokenElem.addChild(instance);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding instance = " + curInstance);
                Tr.debug(tc, "After adding instance, = " + DOMUtils.toString(tokenElem));
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory, OMElement, QName, SCT, String, int)");
            buf.append(" returns OMElement [").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private final DKToken createDKTokenAndElement(Object parent, DKTContent content, String refid, boolean sctin, boolean lengthin, int wssVersion, boolean isStrref, boolean isKeyId) throws SoapSecurityException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            StringBuffer buf2 = new StringBuffer("createDKTokenAndElement(");
            buf2.append("Object parent[").append(parent).append("], ");
            buf2.append("DKTContent content, ");
            buf2.append("String refid[").append(refid).append("], ");
            buf2.append("boolean sctin[").append(sctin).append("], ");
            buf2.append("boolean lengthin[").append(lengthin).append("], ");
            buf2.append("int wssVersion[").append(wssVersion).append("], ");
            buf2.append("boolean isStrref[").append(isStrref).append("], ");
            buf2.append("boolean isKeyId[").append(isKeyId).append("])");
            Tr.entry(tc, buf2.toString());
        }
        final DKToken dktoken = new DKToken(content.getType(), content.getTokenQName());
        byte[] nonce = WSSNonceGenerator.generateBytes(content.getNonceLength());
        if (this._isWSSObject) {
            WSSObjectElement dktobj = DKTGenerateLoginModule.createDKTWSSObjectElement((WSSObjectElement)parent, content, refid, sctin, lengthin, wssVersion, nonce, isStrref, isKeyId);
            dktoken.setXML(new WSSObjectStructureImpl(dktobj));
        } else if (this._isOM) {
            OMElement dktelem = DKTGenerateLoginModule.createDKTOMElement((OMElement)parent, content, refid, sctin, lengthin, wssVersion, nonce, isStrref, isKeyId);
            dktoken.setXML(new OMStructure(dktelem));
        }
        dktoken.setNonce(nonce);
        dktoken.setrefTokenType(content.getRefTokenType());
        dktoken.setrefTokenId(content.getRefTokenId());
        dktoken.setType(content.getType());
        dktoken.setId(refid);
        dktoken.setLength((int)content.getKeyLength());
        dktoken.setReferMasterTokenBySTR(isStrref);
        dktoken.setReferMaterTokenEncoding(content.getkeyIdEncodingType());
        if (content.getRefTokenUUID() != null) {
            final String uuid = content.getRefTokenUUID();
            final String instance = content.getRefInstanceUUID();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    dktoken.setSecurityContextTokenUUID(uuid);
                    dktoken.setRefTokenInstance(instance);
                    return null;
                }
            });
        }
        final String cL = content.getClientLabel() == null ? "WS-SecureConversation" : content.getClientLabel();
        final String sL = content.getServiceLabel() == null ? "WS-SecureConversation" : content.getServiceLabel();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                dktoken.setClientLabel(cL);
                dktoken.setServiceLabel(sL);
                dktoken.setLabel(cL + sL);
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            buf = new StringBuffer("createDKTokenAndElement creates a DKToken and element. ");
            buf.append(" Identifier is = ").append(dktoken.getId());
            buf.append(", Key length is = ").append(content.getKeyLength());
            buf.append(", Nonce is = ").append(Base64.encode(dktoken.getNonce()));
            buf.append(", Reference token type is = ").append(content.getRefTokenType());
            buf.append(", Reference Token uuid is = ").append(content.getRefTokenUUID());
            buf.append(", Reference Token id is = ").append(content.getRefTokenId());
            buf.append(", Type is = ").append(content.getType());
            buf.append(", Reference identifier is = ").append(refid);
            buf.append(", Client label is = ").append(dktoken.getClientLabel());
            buf.append(", Service label is = ").append(dktoken.getServiceLabel());
            Tr.debug(tc, buf.toString());
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("createDKTokenAndElement(");
            buf.append("Object, DKTContent, String, boolean, ");
            buf.append("boolean, int, boolean, boolean)");
            buf.append(" returns DKToken [").append(dktoken).append("]");
            Tr.exit(tc, buf.toString());
        }
        return dktoken;
    }

    private static final OMElement createDKTOMElement(OMElement parent, DKTContent content, String refid, boolean sctin, boolean lengthin, int wssVersion, byte[] nonce, boolean isStrref, boolean isKeyId) throws SoapSecurityException {
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        boolean isDecl = false;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13;
        String refTokenType = null;
        if (content.getType() != null && com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT.equals(tokenType = content.getType().getLocalPart())) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT;
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        OMFactory factory = parent.getOMFactory();
        refTokenType = content.getRefTokenType().getLocalPart();
        OMElement dktelem = factory.createOMElement("DerivedKeyToken", nsWsc, "wsc");
        dktelem.declareNamespace(nsWsc, "wsc");
        if (refid != null) {
            isDecl = false;
            String pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                dktelem.declareNamespace(nsWsu, "wsu");
            }
            dktelem.addAttribute("Id", refid, dktelem.getOMFactory().createOMNamespace(nsWsu, pWsu));
        }
        isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement elem1 = factory.createOMElement("SecurityTokenReference", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        if (isDecl) {
            elem1.declareNamespace(nsWsse, "wsse");
        }
        OMElement elem12 = null;
        if (isStrref) {
            elem12 = factory.createOMElement("Reference", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
            String refuri = null;
            refuri = sctin ? "#" + content.getRefTokenId() : content.getRefTokenUUID();
            elem12.addAttribute("URI", refuri, null);
            elem12.addAttribute("ValueType", refTokenType, null);
            if (!sctin && (refuri = content.getRefInstanceUUID()) != null) {
                elem12.addAttribute("Instance", refuri, dktelem.getOMFactory().createOMNamespace(nsWsc, "wsc"));
            }
        } else if (isKeyId) {
            elem12 = factory.createOMElement("KeyIdentifier", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
            OMNamespace wsseNS = factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
            String encoding = content.getkeyIdEncodingType();
            if (encoding != null && encoding.length() > 0) {
                elem12.addAttribute("EncodingType", encoding, null);
            }
            elem12.addAttribute("ValueType", refTokenType, null);
            elem12.setText(content.getRefTokenId());
        }
        elem1.addChild(elem12);
        dktelem.addChild(elem1);
        if (lengthin) {
            OMElement elem2 = factory.createOMElement("Length", nsWsc, "wsc");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The key length to be added to the message = " + content.getKeyLength());
            }
            String s = new Long(content.getKeyLength()).toString();
            elem2.setText(s);
            dktelem.addChild(elem2);
        }
        OMElement nonceElem = null;
        try {
            nonceElem = DKTGenerateLoginModule.createNonce(factory, dktelem, nsWsc, nonce);
        }
        catch (Exception sce) {
            throw new SoapSecurityException(sce.getMessage());
        }
        return dktelem;
    }

    private static final WSSObjectElement createDKTWSSObjectElement(WSSObjectElement parent, DKTContent content, String refid, boolean sctin, boolean lengthin, int wssVersion, byte[] nonce, boolean isStrref, boolean isKeyId) {
        String refTokenType;
        String tokenType;
        WSSObjectDocumentImpl doc = parent.getWSSObjectDocument();
        QName dktQName = Utf8ByteConstantsQNames.WSC_13.QN_DERIVED_KEY_TOKEN;
        QName instanceQName = Utf8ByteConstantsQNames.WSC_13.QN_INSTANCE;
        if (content.getType() != null && com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT.equals(tokenType = content.getType().getLocalPart())) {
            dktQName = Utf8ByteConstantsQNames.WSC.QN_DERIVED_KEY_TOKEN;
            instanceQName = Utf8ByteConstantsQNames.WSC.QN_INSTANCE;
        }
        VariablePartAttributeValue refVarPartAttr = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(refTokenType = content.getRefTokenType().getLocalPart()) ? Utf8ByteConstantsVariableParts.VPA_NS_WSC_SCT_13 : (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(refTokenType) ? Utf8ByteConstantsVariableParts.VPA_NS_WSC_SCT : VariablePartFactory.getInstance().createAttrValueWithString(refTokenType));
        DerivedKeyToken dkt = new DerivedKeyToken(doc, dktQName);
        if (refid != null && !refid.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding wsu:Id to DKT. wsu:Id = " + refid);
            }
            VariablePartAttributeValue vPart = IdUtils.getInstance().getVariablePart(refid);
            dkt.setWsuId(vPart);
        }
        if (lengthin) {
            long l;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Length to DKT. Length = " + new Long(content.getKeyLength()).toString());
            }
            if ((l = content.getKeyLength()) == 16L) {
                dkt.setLength(Utf8ByteConstantsVariableParts.VPT_16);
            } else if (l == 20L) {
                dkt.setLength(Utf8ByteConstantsVariableParts.VPT_20);
            } else {
                dkt.setLength(VariablePartFactory.getInstance().createTextValueWithString(new Long(content.getKeyLength()).toString()));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding Nonce to DKT. Nonce = " + Base64.encode(nonce));
        }
        dkt.setNonce(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(nonce));
        SecurityTokenReference secTokenRef = new SecurityTokenReference(doc);
        dkt.setSecurityTokenReference(secTokenRef);
        if (isStrref) {
            String instance;
            Reference reference = new Reference(doc);
            secTokenRef.addChild(reference);
            reference.setValueType(refVarPartAttr);
            String refuri = null;
            refuri = sctin ? "#" + content.getRefTokenId() : content.getRefTokenUUID();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding URI attribute to Reference. URI = " + refuri);
            }
            VariablePartAttributeValue vPart = IdUtils.getInstance().getVariablePart(refuri);
            reference.setUri(vPart);
            if (!sctin && (instance = content.getRefInstanceUUID()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Instance attribute to Reference. Instance = " + instance);
                }
                reference.setAttributeToSortedSet(instanceQName, VariablePartFactory.getInstance().createAttrValueWithString(instance));
            }
        } else if (isKeyId) {
            KeyIdentifier keyId = new KeyIdentifier(doc);
            secTokenRef.addChild(keyId);
            keyId.setValueType(refVarPartAttr);
            keyId.setContent(VariablePartFactory.getInstance().createTextValueWithString(content.getRefTokenId()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding KeyIdentifier to SecurityTokenReference. ValueType = " + refTokenType + ", content = " + content.getRefTokenId());
            }
        }
        return dkt;
    }

    private static final int getKeyLength(boolean sig, WSSGeneratorConfig config2, TokenGeneratorConfig tconfig, DerivedKeyInfoConfig dkic, String alg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyLength(boolean sig, String algorithmSuite, TokenGeneratorConfig config, DerivedKeyInfoConfig dkic, String alg)");
        }
        int dkLength = 0;
        String keyLengthInBinding = null;
        if (dkic != null) {
            keyLengthInBinding = dkic.getKeyLength();
        } else if (tconfig != null) {
            keyLengthInBinding = (String)tconfig.getProperties().get(Constants.DERIVED_KEY_LENGTH);
        }
        if (keyLengthInBinding != null && keyLengthInBinding.length() > 0) {
            dkLength = Integer.parseInt(keyLengthInBinding);
        }
        dkLength = DKTGenerateLoginModule.getMinKeyLengthFromAlgorithm(alg, sig, !sig, false, false, dkLength);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The returned Dervived Key Length is " + dkLength);
        }
        return dkLength;
    }

    public static final String mapKeyAlgorithm2JCE(String algName, boolean isV, boolean isD, boolean isS, boolean isE) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mapKeyAlgorithm2JCE(");
            buf.append("String algName[").append(algName).append("], ");
            buf.append("boolean isV[").append(isV).append("], ");
            buf.append("boolean isD[").append(isD).append("], ");
            buf.append("boolean isS[").append(isS).append("], ");
            buf.append("boolean isE[").append(isE).append("])");
            Tr.entry(tc, buf.toString());
        }
        String algorithm = algName;
        if (isV || isS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isV: " + isV + ", " + "isS: " + isS + ".");
            }
            if (HMAC.equals(algName)) {
                algorithm = "HmacSHA1";
            } else if (RSA.equals(algName)) {
                algorithm = "SHA1withRSA";
            } else if (DSA.equals(algName)) {
                algorithm = "SHA1withDSA";
            }
        } else if (isD || isE) {
            if (TRIPLEDES_CBC.equals(algName)) {
                algorithm = "DESede";
            } else if (AES128_CBC.equals(algName)) {
                algorithm = "AES";
            } else if (AES192_CBC.equals(algName)) {
                algorithm = "AES";
            } else if (AES256_CBC.equals(algName)) {
                algorithm = "AES";
            } else if (RSA_1_5.equalsIgnoreCase(algName)) {
                algorithm = "RSA";
            } else if (KWAES128.equalsIgnoreCase(algName)) {
                algorithm = "DESede/CBC/NoPadding";
            } else if (KWAES192.equalsIgnoreCase(algName)) {
                algorithm = "DESede/CBC/NoPadding";
            } else if (KWAES256.equalsIgnoreCase(algName)) {
                algorithm = "DESede/CBC/NoPadding";
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("mapKeyAlgorithm2JCE(");
            buf.append("String, boolean, boolean, boolean, boolean)");
            buf.append(" returns String [").append(algorithm).append("]");
            Tr.exit(tc, buf.toString());
        }
        return algorithm;
    }

    public static final int getMinKeyLengthFromAlgorithm(String algName, boolean isV, boolean isD, boolean isS, boolean isE, int keyLeng) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMinKeyLengthFromAlgorithm(");
            buf.append("String algName[").append(algName).append("], ");
            buf.append("boolean isV[").append(isV).append("], ");
            buf.append("boolean isD[").append(isD).append("], ");
            buf.append("boolean isS[").append(isS).append("], ");
            buf.append("boolean isE[").append(isE).append("])");
            Tr.entry(tc, buf.toString());
        }
        int keylength = 16;
        if (isV || isS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isV: " + isV + ", " + "isS: " + isS + ".");
            }
            if (keyLeng > 15) {
                keylength = keyLeng;
            } else if (HMAC.equals(algName)) {
                keylength = 20;
            } else if (RSA.equals(algName)) {
                keylength = 20;
            } else if (DSA.equals(algName)) {
                keylength = 20;
            }
        } else if (isD || isE) {
            if (TRIPLEDES_CBC.equals(algName)) {
                keylength = 24;
            } else if (AES128_CBC.equals(algName)) {
                keylength = 16;
            } else if (AES192_CBC.equals(algName)) {
                keylength = 24;
            } else if (AES256_CBC.equals(algName)) {
                keylength = 32;
            } else if (RSA_1_5.equalsIgnoreCase(algName)) {
                keylength = 16;
            } else if (KWAES128.equalsIgnoreCase(algName)) {
                keylength = 16;
            } else if (KWAES192.equalsIgnoreCase(algName)) {
                keylength = 24;
            } else if (KWAES256.equalsIgnoreCase(algName)) {
                keylength = 32;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getMinKeyLengthFromAlgorithm(");
            buf.append("String, boolean, boolean, boolean, boolean)");
            buf.append(" returns key length [").append(keylength).append("]");
            Tr.exit(tc, buf.toString());
        }
        return keylength;
    }

    private static final OMElement createNonce(OMFactory factory, OMElement parent, String ns, byte[] nonceByte) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createNonce(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("String ns[").append(ns).append("], ");
            buf.append("NonceManager nmnager)");
            Tr.entry(tc, buf.toString());
        }
        boolean nsDecl = false;
        String prefix = DOMUtils.getNamespacePrefix(parent, ns);
        if (prefix == null) {
            nsDecl = true;
            prefix = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC.equals(ns) || com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13.equals(ns) ? "wsc" : "wsse";
        }
        OMElement nonce = factory.createOMElement("Nonce", ns, prefix);
        if (nsDecl) {
            nonce.declareNamespace(ns, prefix);
        }
        nonce.addChild(factory.createOMText(Base64.encode(nonceByte)));
        parent.addChild(nonce);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createNonce(");
            buf.append("OMFactory, OMElement, String, NonceManager)");
            buf.append(" returns OMElement [").append(DOMUtils.getDisplayName(nonce)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return nonce;
    }

    private final Key createDerivedKey(DKToken dktoken, String keyalgo, int keylength) throws NoSuchAlgorithmException, InvalidKeyException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            StringBuffer buf2 = new StringBuffer("createDerivedKey(");
            buf2.append("DKToken dktoken, ");
            buf2.append("String keyalgo[").append(keyalgo).append("], ");
            buf2.append("int keylength[").append(keylength).append("])");
            Tr.entry(tc, buf2.toString());
        }
        SecretKey key = null;
        byte[] clientSecret = null;
        byte[] serverSecret = null;
        byte[] referencedKeyBytes = null;
        referencedKeyBytes = (byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes");
        if (referencedKeyBytes == null) {
            clientSecret = (byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret");
            serverSecret = (byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret");
            if (tc.isDebugEnabled()) {
                buf = new StringBuffer("Deriving key with: ");
                buf.append(", ServerSecret = ").append(Base64.encode(serverSecret));
                buf.append(", ClientSecret = ").append(Base64.encode(clientSecret));
                buf.append(", entropy Key Size (in bits) based on Algorithm Suite = ").append(keylength);
                Tr.debug(tc, buf.toString());
            }
        }
        try {
            if (referencedKeyBytes != null) {
                String label = dktoken.getLabel();
                if (label == null) {
                    label = dktoken.getClientLabel() == null ? "WS-SecureConversation" : dktoken.getClientLabel();
                    label = dktoken.getServiceLabel() == null ? label + "WS-SecureConversation" : label + dktoken.getServiceLabel();
                }
                key = DerivedKeyUtil.createDerivedKey(referencedKeyBytes, label, dktoken.getNonce(), keylength, dktoken.getOffset(), dktoken.getGeneration(), "HmacSha1", "AES");
            } else if (clientSecret != null && serverSecret != null) {
                key = DerivedKeyUtil.createDerivedKey(clientSecret, serverSecret, dktoken.getClientLabel(), dktoken.getServiceLabel(), dktoken.getNonce(), keylength, 0, 0, "HmacSha1", "AES");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{ex});
            throw ex;
        }
        catch (InvalidKeyException ex) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{ex});
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("createDerivedKey(DKT, String, int)");
            buf.append(" returns key [").append(key).append("])");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    private static class DKTContent {
        String sLabel = null;
        String cLabel = null;
        String refTokenUUID = null;
        String refTokenId = null;
        javax.xml.namespace.QName refTokenType = null;
        javax.xml.namespace.QName tokenType = null;
        javax.xml.namespace.QName tokenQName = null;
        long keyLength = 0L;
        String refInstance = null;
        SecurityToken sct = null;
        int offset = 0;
        int generation = 0;
        int nonceLength = 0;
        String keyIdEncodingType = null;

        private DKTContent(String tokenType) {
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
                this.tokenType = new javax.xml.namespace.QName("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13);
                this.tokenQName = new javax.xml.namespace.QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13, "DerivedKeyToken");
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
                this.tokenType = new javax.xml.namespace.QName("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT);
                this.tokenQName = new javax.xml.namespace.QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "DerivedKeyToken");
            }
        }

        private void set(String tokenId, String tokenUUID, String tokenInstance, javax.xml.namespace.QName baseTokenType, long length, String sLabel, String cLabel, int offset, int generation, int nonceleng, String keyIdEncoding) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DKTContent.set(" + tokenId + ", " + tokenUUID + ", " + tokenInstance + ", " + baseTokenType + ", " + length + "," + sLabel + ", " + cLabel + ", " + offset + ", " + generation);
            }
            this.sLabel = sLabel;
            this.cLabel = cLabel;
            this.offset = offset;
            this.generation = generation;
            this.nonceLength = nonceleng;
            this.keyIdEncodingType = keyIdEncoding;
            if (tokenUUID != null) {
                this.refTokenUUID = tokenUUID;
                this.refInstance = tokenInstance;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The token's ref token UUID = " + this.refTokenUUID);
                    Tr.debug(tc, "The token's ref token instance = " + this.refInstance);
                }
            }
            this.refTokenId = tokenId;
            this.refTokenType = baseTokenType;
            this.keyLength = length;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The labels are set via properties, service label = " + this.sLabel + " and client label = " + this.cLabel);
                Tr.debug(tc, "The token's ref token id = " + this.refTokenId);
                Tr.debug(tc, "The key length is = " + this.keyLength);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "set(" + length + "," + sLabel + ", " + cLabel + ", " + offset + ", " + generation + ") return");
            }
        }

        public long getKeyLength() {
            return this.keyLength;
        }

        public javax.xml.namespace.QName getRefTokenType() {
            return this.refTokenType;
        }

        public String getRefTokenUUID() {
            return this.refTokenUUID;
        }

        public String getRefTokenId() {
            return this.refTokenId;
        }

        public javax.xml.namespace.QName getType() {
            return this.tokenType;
        }

        public javax.xml.namespace.QName getTokenQName() {
            return this.tokenQName;
        }

        public String getServiceLabel() {
            return this.sLabel;
        }

        public String getClientLabel() {
            return this.cLabel;
        }

        public String getRefInstanceUUID() {
            return this.refInstance;
        }

        public SecurityToken getSecurityToken() {
            return this.sct;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getGeneration() {
            return this.generation;
        }

        public int getNonceLength() {
            return this.nonceLength;
        }

        public void setNonceLength(int l) {
            this.nonceLength = l;
        }

        public String getkeyIdEncodingType() {
            return this.keyIdEncodingType;
        }
    }
}

