/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.DerivedKeyUtil;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTConsumeLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

public class DKTConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(DKTConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DKTConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private Map _sharedState;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private WSSAuditService _wssAuditService;
    private WSSAuditEventGenerator _wssAuditEventGenerator;
    private boolean _isAuthnEventsRequired;
    private static Map<String, String> tokensMap = new HashMap<String, String>();

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        this._wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        this._wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = this._isAuthnEventsRequired = this._wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context) || this._wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, this._context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean isStrref;
        boolean isEmb;
        boolean isNone;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "160", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._token = null;
        this._context = propertyCallback.getProperties();
        OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (target != null && !"DerivedKeyToken".equalsIgnoreCase(target.getLocalName())) {
            return true;
        }
        TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        DKToken dkToken = new DKToken();
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, dkToken);
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isNone = true;
            isEmb = false;
            isStrref = false;
        } else {
            isNone = false;
            isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb(keyInfoType);
        }
        this._token = isNone || isEmb ? this.processElement(dkToken, target, config2, isNone, isEmb, this._securityTokenManager, this._context) : this.deriveKey(dkToken, config2, isStrref, this._securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (this._token != null) {
            this._securityTokenManager.addToken(this._token);
            this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private final SecurityToken deriveKey(DKToken dkToken, TokenConsumerConfig config2, boolean isStrref, SecurityTokenManager securityTokenManager) throws LoginException {
        boolean isVerifying;
        boolean isDecrypting;
        KeyInfoContentConsumerConfig keyInfoContent;
        DerivedKeyInfoConfig dkic;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("deriveKey(");
            buf.append("DKToken dkToken, TokenConsumerConfig config, ");
            buf.append("boolean isStrref[").append(isStrref).append("])");
            Tr.entry(tc, buf.toString());
        }
        if ((dkic = (keyInfoContent = (KeyInfoContentConsumerConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey")).getDerivedKeyInfoConfig()) == null || !dkic.isRequireDerivedKeys()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DerivedKey is not required.");
            }
            return null;
        }
        String keyType = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isDecrypting = false;
            isVerifying = false;
        } else {
            isVerifying = "VerifyingKey".equals(keyType);
            isDecrypting = "DecryptingKey".equals(keyType);
            if (tc.isDebugEnabled()) {
                if (isVerifying) {
                    Tr.debug(tc, "Verifying key type");
                } else if (isDecrypting) {
                    Tr.debug(tc, "Decrypting key type");
                }
            }
        }
        if (!isVerifying && !isDecrypting) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.getKey02", new String[]{keyType}));
        }
        DKToken token = null;
        final DKToken dkToken1 = new DKToken();
        if (dkic != null && dkic.isRequireImpliedDerivedKeys()) {
            String nonceStr = null;
            String lengthStr = null;
            int length = 32;
            byte[] nonce = null;
            nonceStr = (String)this._context.remove("ImpliedDerivedKeys_Nonce_Prop");
            lengthStr = (String)this._context.remove("ImpliedDerivedKeys_Length_Prop");
            if (lengthStr != null) {
                length = new Integer(lengthStr);
            }
            if (nonceStr != null) {
                nonce = Base64.decode(nonceStr);
            }
            String tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implied derived keys are used");
                Tr.debug(tc, "Token identifier is [" + tokenId + "]");
            }
            dkToken1.setClientSecret((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret"));
            dkToken1.setServerSecret((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret"));
            dkToken1.setBytes((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes"));
            dkToken1.setLength(length);
            dkToken1.setNonce(nonce);
            String dkt_id = null;
            if (isVerifying) {
                dkt_id = "verify_dkt";
                dkToken1.setId(dkt_id);
            } else {
                dkt_id = "decrypt_dkt";
                dkToken1.setId(dkt_id);
            }
            this._context.put(Constants.WSSECURITY_KEY_REFERENCE, dkt_id);
            String cl = null;
            String sl = null;
            cl = dkic.getClientLabel();
            sl = dkic.getServiceLabel();
            if (cl == null) {
                cl = "WS-SecureConversation";
            }
            if (sl == null) {
                sl = "WS-SecureConversation";
            }
            final String cL = cl;
            final String sL = sl;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    dkToken1.setClientLabel(cL);
                    dkToken1.setServiceLabel(sL);
                    return null;
                }
            });
            dkToken1.setDerivableSecurityToken((SecurityToken)this._context.get("com.ibm.ws.wssecurity.sc.dkt.baseToken"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Labels via properties, service label = " + sl + " and client label = " + cl);
            }
            token = dkToken = dkToken1;
        } else {
            SecurityToken existToken;
            String tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token identifier is [" + tokenId + "]");
            }
            if ((existToken = securityTokenManager.getToken(config2, tokenId)) == null) {
                Tr.error(tc, "security.wssecurity.SCTConsumeLoginModule.missingDKT", new Object[]{tokenId});
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.missingDKT", new String[]{tokenId}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There was the token [" + tokenId + "] in the Subject.");
            }
            if ((dkToken = (DKToken)existToken).getClientLabel() == null && dkToken.getServiceLabel() == null) {
                String cl = null;
                String sl = null;
                if (dkic != null) {
                    cl = dkic.getClientLabel();
                    sl = dkic.getServiceLabel();
                }
                if (cl == null) {
                    cl = "WS-SecureConversation";
                }
                if (sl == null) {
                    sl = "WS-SecureConversation";
                }
                final String cL = cl;
                final String sL = sl;
                final DKToken dkt = dkToken;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        dkt.setClientLabel(cL);
                        dkt.setServiceLabel(sL);
                        return null;
                    }
                });
            }
            token = dkToken;
            if (this._isAuthnEventsRequired) {
                Map<String, Object> auditContext = this._wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", tokenId);
                this._wssAuditEventGenerator.addExtendedAuditData(auditContext, "DKRefId", dkToken.getId());
            }
        }
        byte[] clientSecret = null;
        byte[] serverSecret = null;
        byte[] secret = null;
        final DKToken dkt = dkToken;
        secret = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return dkt.getBytes();
            }
        });
        if (secret != null) {
            clientSecret = dkToken.getClientSecret();
            serverSecret = dkToken.getServerSecret();
        }
        if (clientSecret == null && secret == null) {
            throw new LoginException("Cannot get SCT info to derive key");
        }
        int dktlength = dkToken.getLength();
        String keyLengthInBinding = null;
        if (dktlength == 0) {
            if (dkic != null) {
                keyLengthInBinding = dkic.getKeyLength();
            }
            if (keyLengthInBinding == null) {
                keyLengthInBinding = (String)config2.getProperties().get(Constants.DERIVED_KEY_LENGTH);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified Dervived Key Length is " + keyLengthInBinding);
            }
            if (keyLengthInBinding != null && keyLengthInBinding.length() > 0) {
                dktlength = Integer.parseInt(keyLengthInBinding);
            }
        }
        String algorithmSuite = null;
        WSSConsumerConfig cconfig = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        if (cconfig != null && cconfig instanceof PolicyInboundConfig) {
            algorithmSuite = ((PolicyInboundConfig)cconfig).getAlgorithmSuite();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The Algorithm Suite = " + algorithmSuite);
            }
        }
        int minKeySize = DKTGenerateLoginModule.getMinKeyLengthFromAlgorithm((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm"), isVerifying, isDecrypting, false, false, dktlength);
        int maxKeySize = 32;
        if (dktlength == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing Length information in the message. Using the key Length based on the algorithm = " + minKeySize);
            }
            dktlength = minKeySize;
        } else {
            if (dktlength > 0 && dktlength < minKeySize || dktlength > maxKeySize) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The key Length from the message = " + dktlength + " is incorrect.");
                }
                throw new LoginException("DerivedKey Length in the message doesn't match with the algorithm's");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using the key Length from the message = " + dktlength);
            }
        }
        String keyalgo = null;
        if ((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm") != null && (keyalgo = DKTGenerateLoginModule.mapKeyAlgorithm2JCE((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm"), isVerifying, isDecrypting, false, false)) == null) {
            throw new LoginException("Missing Algorithm info in the config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The supplied algorithm: " + (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm") + "Key algorithm and key length based on algorithm are = " + keyalgo + ", " + dktlength);
            Tr.debug(tc, "The key Length from the message = " + dktlength);
        }
        SecretKey key = null;
        try {
            if (secret != null) {
                String label = dkToken.getLabel();
                if (label == null) {
                    label = dkToken.getClientLabel() == null ? "WS-SecureConversation" : dkToken.getClientLabel();
                    label = dkToken.getServiceLabel() == null ? label + "WS-SecureConversation" : label + dkToken.getServiceLabel();
                }
                key = DerivedKeyUtil.createDerivedKey(secret, label, dkToken.getNonce(), dktlength, 0, 0, "HmacSha1", "AES");
            } else {
                key = DerivedKeyUtil.createDerivedKey(clientSecret, serverSecret, dkToken.getClientLabel(), dkToken.getServiceLabel(), dkToken.getNonce(), dktlength, 0, 0, "HmacSha1", "AES");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{ex});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{ex.toString()}));
        }
        catch (InvalidKeyException ex) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{ex});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{ex.toString()}));
        }
        if (key == null) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Derived key algorithm =  " + key.getAlgorithm() + ", and key = " + Base64.encode(key.getEncoded()) + ", key length = " + key.getEncoded().length);
        }
        if (isVerifying) {
            dkToken.setKey(63, key);
        } else if (isDecrypting) {
            dkToken.setKey(64, key);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("deriveKey(");
            buf.append("DKToken, TokenConsumerConfig, ");
            buf.append("boolean, String, String, boolean, ");
            buf.append("SecurityTokenManager)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private final SecurityToken processElement(DKToken dkToken, OMElement targetElem, TokenConsumerConfig config2, boolean isNone, boolean isEmb, SecurityTokenManager securityTokenManager, Map<Object, Object> context) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processElement(");
            buf.append("DKToken dkToken, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(targetElem)).append("], ");
            buf.append("TokenConsumerConfig config, ");
            buf.append("boolean isNone[").append(isNone).append("], ");
            buf.append("boolean isEmb[").append(isEmb).append("], ");
            buf.append("SecurityTokenManager securityTokenManager, Map context, String encAlg)");
            Tr.entry(tc, buf.toString());
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        DKToken token = null;
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        String dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Target Element namespace URI = " + targetElem.getNamespace().getNamespaceURI());
        }
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC.equals(targetElem.getNamespace().getNamespaceURI())) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT;
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
            dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT;
        }
        messageContext.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
        if (targetElem.getNamespace().getNamespaceURI().equals(nsWsc) && targetElem.getLocalName().equals("DerivedKeyToken")) {
            DKToken dkt;
            byte[] secret;
            boolean verify_dkt = false;
            String tokenId = null;
            if (isNone) {
                QName idattr = IdUtils.getInstance().getIdAttributeName(targetElem);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The identifier attribute of the dktoken target element is [" + idattr + "].");
                }
                if (idattr != null) {
                    tokenId = targetElem.getAttributeValue(idattr);
                }
            }
            dkToken.setId(tokenId);
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
                dkToken.setType("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13);
            }
            this.consumeDKTokenElement(dkToken, targetElem, messageContext, context);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dktoken id = " + dkToken.getId());
                Tr.debug(tc, "dktoken's reference token Id = " + dkToken.getrefTokenId());
            }
            if (this._isAuthnEventsRequired) {
                Map<String, Object> auditContext = this._wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", tokenId);
                this._wssAuditEventGenerator.addExtendedAuditData(auditContext, "DKRefId", dkToken.getrefTokenId());
            }
            if ((secret = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(dkt = dkToken){
                final /* synthetic */ DKToken val$dkt;
                {
                    this.val$dkt = dKToken;
                }

                @Override
                public Object run() {
                    return this.val$dkt.getBytes();
                }
            })) != null || dkToken.getClientSecret() != null) {
                verify_dkt = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found referenced token secret in the dktoken. Verification of DKtoken is successful!!");
                }
            }
            if (!verify_dkt) {
                Tr.error(tc, "Cannot find the token's key bytes referenced from the DerivedKeyToken Element. ");
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.verifyDKT"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding DKT to the subject using id: " + dkToken.getId());
            }
            token = dkToken;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processElement(");
            buf.append("DKToken, OMElement, TokenConsumerConfig, ");
            buf.append("boolean, boolean, boolean, securityTokenManager, Map)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private final void consumeDKTokenElement(final DKToken dkToken, OMElement target, MessageContext messageContext, Map<Object, Object> context) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("consumeDKTokenElement(");
            buf.append("DKToken dkToken, ");
            buf.append("OMElement target(").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        String tokenType = null;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        String dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13;
        tokenType = (String)messageContext.getProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
            dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT;
        }
        if (target != null && target.getNamespace().getNamespaceURI().equals(nsWsc) && target.getLocalName().equals("DerivedKeyToken")) {
            String str;
            String lengthStr;
            String refid;
            dkToken.setXML(new OMStructure(target));
            QName idattr = IdUtils.getInstance().getIdAttributeName(target);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
            }
            if (idattr != null && (refid = target.getAttributeValue(idattr)) != null) {
                dkToken.setId(refid);
            }
            String refTokenId = null;
            String refTokenUUID = null;
            String ttype = null;
            String instance = null;
            OMElement elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
            if (elem != null) {
                if ((elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference")) != null) {
                    ttype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
                    String refTokenUri = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.URI_Q);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reference Token URI in DerivedKeyToken element: " + refTokenUri);
                    }
                    if (refTokenUri.startsWith("#")) {
                        refTokenId = refTokenUri.substring(1);
                        refTokenUUID = SCTConsumeLoginModule.getUUIDByRef(refTokenId, messageContext, context, nsWsc);
                        instance = (String)messageContext.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
                    } else {
                        refTokenUUID = refTokenUri;
                        QName INSTANCE_Q = new QName(nsWsc, "Instance");
                        instance = elem.getAttributeValue(INSTANCE_Q);
                    }
                    final String uuid = refTokenUUID;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            dkToken.setSecurityContextTokenUUID(uuid);
                            return null;
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key instance = " + instance);
                    }
                } else {
                    elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
                    elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "KeyIdentifier");
                    String enctype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.ENCODINGTYPE_Q);
                    String valtype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
                    refTokenId = elem.getText();
                    int wssVersion = 0;
                    Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
                    if (obj != null && obj instanceof Integer) {
                        wssVersion = (Integer)obj;
                    }
                    if (enctype != null) {
                        QName enctypeQN = DOMUtils.getQName(elem, enctype, wssVersion);
                        dkToken.setKeyIdentifierEncodingType(enctypeQN);
                    }
                    ttype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
                }
            }
            dkToken.setClientSecret((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret"));
            dkToken.setServerSecret((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret"));
            dkToken.setBytes((byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes"));
            if (ttype != null) {
                dkToken.setrefTokenType("", ttype);
            }
            dkToken.setrefTokenId(refTokenId);
            int length = 0;
            elem = DOMUtils.getChildElement(target, nsWsc, "Length");
            if (elem != null && (lengthStr = DOMUtils.getStringValue(elem)) != null) {
                length = new Integer(lengthStr);
            }
            dkToken.setLength(length);
            elem = DOMUtils.getChildElement(target, nsWsc, "Nonce");
            byte[] nonce = null;
            if (elem != null && (str = DOMUtils.getStringValue(elem)) != null) {
                nonce = Base64.decode(str);
            }
            dkToken.setNonce(nonce);
            dkToken.setDerivableSecurityToken((SecurityToken)this._context.get("com.ibm.ws.wssecurity.sc.dkt.baseToken"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refTokenId = " + refTokenId + ", refTokenUUID = " + refTokenUUID + ", ttype = " + ttype);
                Tr.debug(tc, "Length = " + length);
                Tr.debug(tc, "nonce = " + (nonce != null ? "true" : "false"));
                Tr.debug(tc, "Key instance = " + instance);
                Tr.debug(tc, "sct value type = " + tokenType);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("consumeDKTokenElement(DKToken, ");
            buf.append("OMElement, MessageContext, Map)");
            Tr.exit(tc, buf.toString());
        }
    }

    static {
        tokensMap.put(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "resolveSCT");
        tokensMap.put("com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken13", "com.ibm.ws.wssecurity.wssapi.token.impl.SCT13");
    }
}

