/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.XMLStructureHelper;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.UNTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Element;

public class CommonTokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(CommonTokenGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonTokenGenerator.class.getName();
    private boolean initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        String jaasLoginConfigName;
        TokenGeneratorConfig config2;
        block75: {
            Subject sbj;
            Map<Object, Object> customProps;
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("invoke(");
                buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
                buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
                buf.append("Map context)");
                Tr.entry(tc, buf.toString());
            }
            config2 = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenGeneratorConfig [" + config2 + "].");
            }
            CallbackHandlerConfig cbhconf = config2.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandlerConfig [" + config2 + "].");
            }
            CallbackHandler myHandler = null;
            if (cbhconf != null) {
                myHandler = cbhconf.getInstance();
                if (myHandler == null) {
                    final String cbhname = cbhconf.getClassName();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + cbhname + "]...");
                        }
                        final ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invoke(OMDocument, OMElement, Map");
                                }
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class cls = null;
                        if (loader != null) {
                            try {
                                cls = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws ClassNotFoundException {
                                        return loader.loadClass(cbhname);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                cls = Class.forName(cbhname);
                            }
                        } else {
                            cls = Class.forName(cbhname);
                        }
                        if (!CallbackHandler.class.isAssignableFrom(cls)) {
                            SoapSecurityException e = SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                            Tr.processException((Throwable)e, clsName + ".invoke", "149", this);
                            throw e;
                        }
                        HashMap<String, CallbackHandlerConfig> properties = new HashMap<String, CallbackHandlerConfig>();
                        properties.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", cbhconf);
                        Constructor con = cls.getConstructor(Map.class);
                        myHandler = (CallbackHandler)con.newInstance(properties);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                        }
                    }
                    catch (SoapSecurityException e) {
                        Tr.processException(e, clsName + ".invoke", "153");
                        throw e;
                    }
                    catch (Exception e) {
                        String msg = "security.wssecurity.X509TokenGenerator.s01";
                        SoapSecurityException e1 = SoapSecurityException.format(msg, cbhname, (Throwable)e);
                        Tr.processException((Throwable)e, clsName + ".invoke", "159", this);
                        Tr.error(tc, msg, new Object[]{e1});
                        throw e1;
                    }
                    cbhconf.setInstance(myHandler);
                }
                if (myHandler instanceof UNTGUIPromptCallbackHandler) {
                    context.put("com.ibm.ws.wssecurity.wssapi.token.impl.UNTGenerateLoginModule.GUIUNTisUsed", new Boolean(true));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using GUI UNT Handler, setting flag for caching");
                    }
                }
                context.putAll(cbhconf.getProperties());
            }
            if ((customProps = config2.getProperties()) != null && parent != null) {
                String domEnabled = (String)customProps.get("com.ibm.wsspi.wssecurity.domElementEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "com.ibm.wsspi.wssecurity.domElementEnabled : " + domEnabled);
                }
                if (ConfigUtil.isTrue(domEnabled)) {
                    try {
                        OMElement ome = parent;
                        Element domElement = null;
                        if (ome != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Mapping DOM Element to OMElement for the message...");
                            }
                            domElement = XMLUtils.toDOM(ome);
                        }
                        context.put("com.ibm.wsspi.wssecurity.domProcessingElement", domElement);
                        HashMap domToOMElementTable = (HashMap)context.get("com.ibm.ws.wssecurity.domElementOmElementMap");
                        if (domToOMElementTable == null) {
                            domToOMElementTable = new HashMap();
                            context.put("com.ibm.ws.wssecurity.domElementOmElementMap", domToOMElementTable);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "com.ibm.ws.wssecurity.domElementOmElementMap: " + domToOMElementTable);
                        }
                    }
                    catch (Throwable t) {
                        QName fault = Axis2Util.setFailedAuthFaultCode(context);
                        throw SoapSecurityException.format(fault, "security.wssecurity.X509TokenGenerator.s01", t);
                    }
                }
            }
            context.put("com.ibm.ws.wssecurity.constants.processingElement", parent);
            jaasLoginConfigName = config2.getJAASConfig();
            context.putAll(config2.getJAASConfigProperties());
            final CommonCallbackHandler commonCBH = new CommonCallbackHandler(myHandler, context);
            Object obj = context.get("com.ibm.wsspi.wssecurity.core.subject");
            if (obj == null || !(obj instanceof Subject)) {
                sbj = new Subject();
                context.put("com.ibm.wsspi.wssecurity.core.subject", sbj);
            } else {
                sbj = (Subject)obj;
            }
            final Subject subject = sbj;
            boolean avoidJAAS = false;
            LoginModule lm = null;
            DKTGenerateLoginModule lm2 = null;
            String ourLoginConfig = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig");
            if (ConfigUtil.hasValue(ourLoginConfig)) {
                if ("system.wss.generate.sct".equals(ourLoginConfig)) {
                    lm = new SCTGenerateLoginModule();
                    lm2 = new DKTGenerateLoginModule();
                    avoidJAAS = true;
                } else if ("system.wss.generate.x509".equals(ourLoginConfig)) {
                    lm = new X509GenerateLoginModule();
                    avoidJAAS = true;
                } else if ("system.wss.generate.unt".equals(ourLoginConfig)) {
                    lm = new UNTGenerateLoginModule();
                    avoidJAAS = true;
                }
            }
            if (avoidJAAS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Avoiding JAAS login for " + jaasLoginConfigName);
                }
                HashMap sharedState = new HashMap();
                HashMap options = new HashMap();
                lm.initialize(subject, commonCBH, sharedState, options);
                if ("system.wss.generate.sct".equals(jaasLoginConfigName)) {
                    CommonCallbackHandler cCBH = new CommonCallbackHandler(null, context);
                    options = new HashMap();
                    lm2.initialize(subject, (CallbackHandler)cCBH, sharedState, options);
                }
                try {
                    if (lm.login()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to login");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to login");
                        }
                        throw new LoginException("Login module " + lm.getClass().getName() + " login() method returned false");
                    }
                    if (lm2 != null) {
                        if (lm2.login()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to login");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to login");
                            }
                            throw new LoginException("Login module " + lm2.getClass().getName() + " login() method returned false");
                        }
                    }
                    if (lm.commit()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to commit");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to commit");
                        }
                        throw new LoginException("Login module " + lm.getClass().getName() + " commit() method returned false");
                    }
                    if (lm2 == null) break block75;
                    if (lm2.commit()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to commit");
                        }
                        break block75;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to commit");
                    }
                    throw new LoginException("Login module " + lm2.getClass().getName() + " commit() method returned false");
                }
                catch (LoginException le) {
                    Tr.processException(le, clsName + ".invoke", "236");
                    Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{le});
                    QName fault = null;
                    fault = (QName)context.get("com.ibm.ws.wssecurity.sc.FaultCode");
                    if (fault != null) {
                        SoapSecurityException se = SoapSecurityException.format(fault, "security.wssecurity.X509TokenConsumer.s02", (Throwable)le);
                        throw se;
                    }
                    throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s02", le);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing JAAS login for " + jaasLoginConfigName);
            }
            LoginContext lcontext = null;
            try {
                lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws LoginException {
                        LoginContext lc = new LoginContext(jaasLoginConfigName, subject, commonCBH);
                        return lc;
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to construct the login context.");
                }
                lcontext.login();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to login.");
                }
            }
            catch (PrivilegedActionException pae) {
                LoginException le = (LoginException)pae.getCause();
                Tr.processException(le, clsName + ".invoke", "264");
                Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{le});
                throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s01", le);
            }
            catch (LoginException le) {
                Tr.processException(le, clsName + ".invoke", "268");
                Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{le});
                throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s02", le);
            }
        }
        context.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
        List processedTokens = (List)context.remove(Constants.WSSECURITY_TOKEN_PROCESSED);
        if (processedTokens == null) {
            SoapSecurityException e = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s03", jaasLoginConfigName);
            Tr.processException((Throwable)e, clsName + ".invoke", "287", this);
            throw e;
        }
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        final String keyInfoName = (String)context.get(Constants.WSSECURITY_KEYINFO_UNIQUE_NAME);
        boolean setToken = false;
        for (int i = processedTokens.size() - 1; i >= 0; --i) {
            SecurityToken token = (SecurityToken)processedTokens.get(i);
            SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token);
            if (tokenWrapper == null) {
                final SecurityTokenWrapper tw = new SecurityTokenWrapper(token);
                final TokenGeneratorConfig tconfig = config2;
                final String kit = keyInfoType;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        tw.setUsedTokenGenerator(tconfig.hashCode());
                        tw.setKeyInfoType(kit);
                        tw.setKeyInfoUniqueID(keyInfoName);
                        return null;
                    }
                });
                securityTokenManager.addTokenWrapper(tw);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityTokenWrapper[" + i + "] added: " + tw);
                }
            }
            if (setToken) continue;
            context.put(Constants.WSSECURITY_TOKEN_LOGININFO, token);
            setToken = true;
        }
        List insertedTokens = (List)context.remove(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED);
        if (insertedTokens != null && insertedTokens.size() > 0) {
            OMNode referencedTokenElement = (OMNode)context.get(Constants.WSSECURITY_TOKENELEMENT_REFERENCED);
            final Map<Object, Object> finalcontext = context;
            final XMLStructureHelper xmlHlpr = new XMLStructureHelper();
            OMElement tokenElem = null;
            for (int i = insertedTokens.size() - 1; i >= 0; --i) {
                final SecurityToken token = (SecurityToken)insertedTokens.get(i);
                if (token instanceof UsernameToken) {
                    try {
                        tokenElem = AccessController.doPrivileged(new PrivilegedExceptionAction<OMElement>(){

                            @Override
                            public OMElement run() throws SoapSecurityException {
                                return xmlHlpr.getOMElement(token, finalcontext);
                            }
                        });
                    }
                    catch (PrivilegedActionException pe) {
                        throw new SoapSecurityException(pe.getException());
                    }
                } else {
                    tokenElem = xmlHlpr.getOMElement(token, context);
                }
                if (tokenElem == null) continue;
                if (referencedTokenElement == null) {
                    OMNode firstChild = parent.getFirstOMChild();
                    if (firstChild == null) {
                        parent.addChild(tokenElem);
                        continue;
                    }
                    firstChild.insertSiblingBefore(tokenElem);
                    continue;
                }
                referencedTokenElement.insertSiblingAfter(tokenElem);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument, OMElement, Map)");
        }
    }
}

