/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKTConsumeLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTConsumeLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.UNTConsumeLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509ConsumeLoginModule;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Element;

public class CommonTokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(CommonTokenConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        boolean isAuthnErrorRequired;
        boolean isAuthnDeniedRequired;
        boolean isAuthnSuccessRequired;
        WSSAuditEventGenerator wssAuditEventGenerator;
        String jaasLoginConfigName;
        TokenConsumerConfig config2;
        block74: {
            Subject sbj;
            Map<Object, Object> customProps;
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("invoke(");
                buf.append("OMNode target[").append(DOMUtils.getDisplayName(target)).append("], ");
                buf.append("Map context)");
                Tr.entry(tc, buf.toString());
            }
            config2 = (TokenConsumerConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
            CallbackHandlerConfig cbhconf = config2.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandlerConfig [" + cbhconf + "].");
            }
            CallbackHandler myHandler = null;
            if (cbhconf != null) {
                myHandler = cbhconf.getInstance();
                if (myHandler == null) {
                    final String cbhname = cbhconf.getClassName();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + cbhname + "]...");
                        }
                        final ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invoke(OMElement, Map)");
                                }
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class cls = null;
                        if (loader != null) {
                            try {
                                cls = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws ClassNotFoundException {
                                        return loader.loadClass(cbhname);
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                cls = Class.forName(cbhname);
                            }
                        } else {
                            cls = Class.forName(cbhname);
                        }
                        if (!CallbackHandler.class.isAssignableFrom(cls)) {
                            QName fault = Axis2Util.setFailedAuthFaultCode(context);
                            throw SoapSecurityException.format(fault, "security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                        }
                        HashMap<String, CallbackHandlerConfig> properties = new HashMap<String, CallbackHandlerConfig>();
                        properties.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", cbhconf);
                        Constructor con = cls.getConstructor(Map.class);
                        myHandler = (CallbackHandler)con.newInstance(properties);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                        }
                    }
                    catch (SoapSecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        QName fault = Axis2Util.setFailedAuthFaultCode(context);
                        throw SoapSecurityException.format(fault, "security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                    }
                    cbhconf.setInstance(myHandler);
                }
                context.putAll(cbhconf.getProperties());
            }
            if ((customProps = config2.getProperties()) != null && target != null) {
                String domEnabled = (String)customProps.get("com.ibm.wsspi.wssecurity.domElementEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "com.ibm.wsspi.wssecurity.domElementEnabled : " + domEnabled);
                }
                if (ConfigUtil.isTrue(domEnabled)) {
                    try {
                        OMElement ome = (OMElement)target;
                        Element domElement = null;
                        if (ome != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Mapping DOM Element to OMElement for the message...");
                            }
                            domElement = XMLUtils.toDOM(ome);
                        }
                        context.put("com.ibm.wsspi.wssecurity.domProcessingElement", domElement);
                        HashMap domToOMElementTable = (HashMap)context.get("com.ibm.ws.wssecurity.domElementOmElementMap");
                        if (domToOMElementTable == null) {
                            domToOMElementTable = new HashMap();
                            context.put("com.ibm.ws.wssecurity.domElementOmElementMap", domToOMElementTable);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "com.ibm.ws.wssecurity.domElementOmElementMap: " + domToOMElementTable);
                        }
                    }
                    catch (Throwable t) {
                        QName fault = Axis2Util.setFailedAuthFaultCode(context);
                        throw SoapSecurityException.format(fault, "security.wssecurity.X509TokenGenerator.s01", t);
                    }
                }
            }
            context.put("com.ibm.ws.wssecurity.constants.processingElement", target);
            jaasLoginConfigName = config2.getJAASConfig();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JAAS config name is " + jaasLoginConfigName + ".");
            }
            if (jaasLoginConfigName == null) {
                QName fault = Axis2Util.setFailedAuthFaultCode(context);
                throw SoapSecurityException.format(fault, "security.wssecurity.WSEC6834E", config2.toString());
            }
            context.putAll(config2.getJAASConfigProperties());
            final CommonCallbackHandler commonCBH = new CommonCallbackHandler(myHandler, context);
            Object obj = context.get("com.ibm.wsspi.wssecurity.core.subject");
            if (obj == null || !(obj instanceof Subject)) {
                sbj = new Subject();
                context.put("com.ibm.wsspi.wssecurity.core.subject", sbj);
            } else {
                sbj = (Subject)obj;
            }
            final Subject subject = sbj;
            boolean avoidJAAS = false;
            LoginModule lm = null;
            DKTConsumeLoginModule lm2 = null;
            String ourLoginConfig = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig");
            if (ConfigUtil.hasValue(ourLoginConfig)) {
                if ("system.wss.consume.sct".equals(ourLoginConfig)) {
                    lm = new SCTConsumeLoginModule();
                    lm2 = new DKTConsumeLoginModule();
                    avoidJAAS = true;
                } else if ("system.wss.consume.x509".equals(ourLoginConfig)) {
                    lm = new X509ConsumeLoginModule();
                    avoidJAAS = true;
                } else if ("system.wss.consume.unt".equals(ourLoginConfig)) {
                    lm = new UNTConsumeLoginModule();
                    avoidJAAS = true;
                }
            }
            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
            wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            isAuthnSuccessRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context);
            isAuthnDeniedRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context);
            isAuthnErrorRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR, context);
            if (isAuthnSuccessRequired || isAuthnDeniedRequired || isAuthnErrorRequired) {
                wssAuditEventGenerator.setAuthnTypeData(context, config2.getType().toString());
            }
            if (avoidJAAS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Avoiding JAAS login for " + jaasLoginConfigName);
                }
                HashMap sharedState = new HashMap();
                HashMap options = new HashMap();
                lm.initialize(subject, commonCBH, sharedState, options);
                if ("system.wss.consume.sct".equals(jaasLoginConfigName)) {
                    CommonCallbackHandler cCBH = new CommonCallbackHandler(null, context);
                    options = new HashMap();
                    lm2.initialize(subject, (CallbackHandler)cCBH, sharedState, options);
                }
                try {
                    Map<String, Object> auditContext;
                    if (lm.login()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to login");
                        }
                    } else {
                        if (isAuthnDeniedRequired) {
                            auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, null);
                            wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        wssAuditEventGenerator.clearAuditData(context);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to login");
                        }
                        throw new LoginException("Login module " + lm.getClass().getName() + " login() method returned false");
                    }
                    if (lm2 != null) {
                        if (lm2.login()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to login");
                            }
                        } else {
                            if (isAuthnDeniedRequired) {
                                auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, null);
                                wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                            }
                            wssAuditEventGenerator.clearAuditData(context);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to login");
                            }
                            throw new LoginException("Login module " + lm2.getClass().getName() + " login() method returned false");
                        }
                    }
                    if (lm.commit()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to commit");
                        }
                        if (isAuthnSuccessRequired) {
                            auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                            wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                    } else {
                        if (isAuthnDeniedRequired) {
                            auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, null);
                            wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        wssAuditEventGenerator.clearAuditData(context);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to commit");
                        }
                        throw new LoginException("Login module " + lm.getClass().getName() + " commit() method returned false");
                    }
                    if (lm2 == null) break block74;
                    if (lm2.commit()) {
                        if (isAuthnSuccessRequired) {
                            auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                            wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to commit");
                        }
                        break block74;
                    }
                    if (isAuthnDeniedRequired) {
                        auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, null);
                        wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                        wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                    }
                    wssAuditEventGenerator.clearAuditData(context);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to commit");
                    }
                    throw new LoginException("Login module " + lm2.getClass().getName() + " commit() method returned false");
                }
                catch (Exception e) {
                    if (isAuthnErrorRequired) {
                        Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, e.toString());
                        wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "FAILURE");
                        wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                    }
                    wssAuditEventGenerator.clearAuditData(context);
                    SoapSecurityException se = CommonTokenConsumer.getSoapSecurityException(context, e);
                    throw se;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing JAAS login for " + jaasLoginConfigName);
            }
            LoginContext lcontext = null;
            try {
                lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws LoginException {
                        LoginContext lc = new LoginContext(jaasLoginConfigName, subject, commonCBH);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "invoke(OMElement, Map)");
                        }
                        return lc;
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to construct the login context.");
                }
                lcontext.login();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to login.");
                }
                if (isAuthnSuccessRequired) {
                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                    wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                }
            }
            catch (Exception e) {
                if (isAuthnDeniedRequired) {
                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, null);
                    wssAuditEventGenerator.addProviderData(auditContext, jaasLoginConfigName, "SUCCESS");
                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                }
                wssAuditEventGenerator.clearAuditData(context);
                SoapSecurityException se = CommonTokenConsumer.getSoapSecurityException(context, e);
                throw se;
            }
        }
        context.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
        SecurityToken token = (SecurityToken)context.remove(Constants.WSSECURITY_TOKEN_PROCESSED);
        if (token == null) {
            QName fault = Axis2Util.setFailedAuthFaultCode(context);
            throw SoapSecurityException.format(fault, "security.wssecurity.X509TokenGenerator.s03", jaasLoginConfigName);
        }
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token);
        String keyInfoName = (String)context.get(Constants.WSSECURITY_KEYINFO_UNIQUE_NAME);
        if (tokenWrapper == null) {
            final SecurityTokenWrapper tw = new SecurityTokenWrapper(token);
            final TokenConsumerConfig tconfig = config2;
            final String kit = keyInfoType;
            final String kin = keyInfoName;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    tw.setUsedTokenConsumer(tconfig.hashCode(), tconfig.getClass().getName().hashCode());
                    tw.setKeyInfoType(kit);
                    tw.setKeyInfoUniqueID(kin);
                    return null;
                }
            });
            securityTokenManager.addTokenWrapper(tw);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityTokenWrapper added: " + tw);
            }
        }
        context.put(Constants.WSSECURITY_TOKEN_LOGININFO, token);
        if (!isAuthnSuccessRequired && (isAuthnDeniedRequired || isAuthnErrorRequired)) {
            wssAuditEventGenerator.clearAuditData(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMElement, Map)");
        }
    }

    static SoapSecurityException getSoapSecurityException(Map<Object, Object> context, Exception ex) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSoapSecurityException(ex=" + ex.getClass() + ")");
        }
        Exception cause = ex;
        QName fault = Axis2Util.setFailedAuthFaultCodeIfNone(context);
        if (!(ex instanceof LoginException)) {
            LoginException le = null;
            if (ex instanceof PrivilegedActionException) {
                if (ex.getCause() instanceof LoginException) {
                    le = (LoginException)ex.getCause();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new LoginException");
                    }
                    le = new LoginException(ConfigUtil.getMessage("security.wssecurity.X509TokenConsumer.s01"));
                    le.initCause(ex.getCause());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new LoginException");
                }
                le = new LoginException();
                le.initCause(ex);
            }
            cause = le;
        }
        SoapSecurityException se = SoapSecurityException.format(fault, "security.wssecurity.X509TokenConsumer.s02", (Throwable)cause);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSoapSecurityException");
        }
        return se;
    }
}

