/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.BinarySecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import org.apache.axis2.util.ObjectStateUtils;

public abstract class BinarySecurityTokenImpl
extends SecurityTokenImpl
implements BinarySecurityToken {
    private static final TraceComponent tc = Tr.register(BinarySecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.BinarySecurityToken.getBytes");
    private static final SecurityPermission SETBYTES_PERM = new SecurityPermission("wssapi.BinarySecurityToken.setBytes");
    protected byte[] binary;

    public BinarySecurityTokenImpl() {
        this.tokenQName = BinarySecurityToken.TokenQname;
    }

    @Override
    public byte[] getBinary() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            sm.checkPermission(GETBYTES_PERM);
        }
        byte[] binary = this.binary;
        if (this.readOnly && binary != null) {
            int binarylen = this.binary.length;
            binary = new byte[binarylen];
            System.arraycopy(this.binary, 0, binary, 0, binarylen);
        }
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            sm.checkPermission(SETBYTES_PERM);
        }
        if (!this.readOnly) {
            this.binary = binary;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object tmp;
        super.readExternal(in);
        String version = ObjectStateUtils.readString(in, "BinarySecurityToken.version");
        if (VERSION_NUMBER.equals(version) && (tmp = ObjectStateUtils.readObject(in, "BinarySecurityToken.binary")) != null) {
            this.binary = (byte[])tmp;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectStateUtils.writeString(out, VERSION_NUMBER, "BinarySecurityToken.version");
        ObjectStateUtils.writeObject(out, this.binary, "BinarySecurityToken.binary");
    }
}

