/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.sig.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class WSSSignatureImpl
implements WSSSignature,
Generatable {
    private static final TraceComponent tc = Tr.register(WSSSignatureImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSSignatureImpl.class.getName();
    private static final long serialVersionUID = -5969154429557443129L;
    private SecurityToken token;
    private List<WSSSignPart> signParts = new ArrayList<WSSSignPart>();
    private String canonicalizationMethod = DefaultValueManager.getInstance().getCanonicalizationMethod();
    private String signatureMethod = DefaultValueManager.getInstance().getSignatureMethod();
    private boolean signatureConfirmation;
    private boolean requriredSignatureConfirmation;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSSignatureImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSSignatureImpl(SecurityToken token, SecurityTokenManagerImpl securityTokenManager) {
        this.token = token;
        this.securityTokenManager = securityTokenManager;
        SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
        tokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForSignature());
    }

    @Override
    public void setCanonicalizationMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setCanonicalizationMethod(" + method + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getCanonicalizationAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s09";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".setCanonicalizationMethod", "117", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.canonicalizationMethod = method;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setCanonicalizationMethod(String)");
        }
    }

    @Override
    public void setSignatureMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setSignatureMethod(" + method + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getSignatureAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s08";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".setSignatureMethod", "142", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.signatureMethod = method;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setSignatureMethod(String)");
        }
    }

    @Override
    public void addSignPart(int part) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart( " + part + " )");
        }
        WSSSignPartImpl signPart = new WSSSignPartImpl(this.token, this.securityTokenManager);
        signPart.setSignPart(part);
        this.signParts.add(signPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart( " + part + " )");
        }
    }

    @Override
    public void addSignPart(WSSSignPart part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + part + ")");
        }
        this.signParts.add(part);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(" + part + ")");
        }
    }

    @Override
    public void addSignPartByXPath(String xpath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPartByXPath( " + xpath + " )");
        }
        WSSSignPartImpl signPart = new WSSSignPartImpl(this.token, this.securityTokenManager);
        signPart.setSignPartByXPath(xpath);
        this.signParts.add(signPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPartByXPath( " + xpath + " )");
        }
    }

    @Override
    public void addSignPart(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + securityToken.toString() + ")");
        }
        WSSSignPartImpl signPart = new WSSSignPartImpl(this.token, this.securityTokenManager);
        signPart.setSignPart(securityToken);
        this.signParts.add(signPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(SecurityToken)");
        }
    }

    @Override
    public void addSignHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignHeader(" + header + ")");
        }
        WSSSignPartImpl signPart = new WSSSignPartImpl(this.token, this.securityTokenManager);
        signPart.setSignHeader(header);
        this.signParts.add(signPart);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignHeader(QName header)");
        }
    }

    @Override
    public void addSignPart(WSSTimestamp timestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + timestamp + ")");
        }
        WSSSignPartImpl signPart = new WSSSignPartImpl(this.token, this.securityTokenManager);
        signPart.setSignPart(timestamp);
        this.signParts.add(signPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(WSSTimestamp)");
        }
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public List<WSSSignPart> getSignedParts() {
        return this.signParts;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    @Override
    public void setTokenReference(int tokenReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(" + tokenReference + ")");
        }
        if (this.token != null) {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenWrapper.setWssapiReferenceType(tokenReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenReference(int tokenReference)");
        }
    }

    public String getTokenReferenceByStr() {
        String tokenReference = null;
        if (this.token != null) {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenReference = tokenWrapper.getWssapiReferenceTypeByStr();
        }
        return tokenReference;
    }

    public int getTokenReference() {
        int tokenReference = 0;
        if (this.token != null) {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenReference = tokenWrapper.getWssapiReferenceType();
        }
        return tokenReference;
    }

    public boolean isRequiredSignatureConfirmation() {
        return this.requriredSignatureConfirmation;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    @Override
    public void requireSignatureConfirmation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requireSignatureConfirmation()");
            Tr.exit(tc, "requireSignatureConfirmation()");
        }
        this.signatureConfirmation = true;
        this.requriredSignatureConfirmation = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WSSSignatureImpl:");
        buffer.append(" token: ");
        buffer.append(this.token);
        buffer.append(", canonicalizationMethod: ");
        buffer.append(this.canonicalizationMethod);
        buffer.append(", signatureMethod: ");
        buffer.append(this.signatureMethod);
        buffer.append(", signedParts: ");
        buffer.append(this.signParts);
        buffer.append(", signatureConfirmation: ");
        buffer.append(this.signatureConfirmation);
        buffer.append(", requriredSignatureConfirmation: ");
        buffer.append(this.requriredSignatureConfirmation);
        buffer.append("]");
        return buffer.toString();
    }
}

