/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.enc.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSEncryptPartImpl
implements WSSEncryptPart {
    private static final TraceComponent tc = Tr.register(WSSEncryptPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSEncryptPartImpl.class.getName();
    private static final long serialVersionUID = 8535931437145662325L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;
    private String headerNamespace;
    private String headerName;

    @Override
    public void addTransform(String algorithm, TransformParameterSpec paramSpec) throws WSSException {
        String msg = "security.wssecurity.WSEC7012E";
        WSSException e = WSSException.format(msg, clsName + ".addTransform(String, TransformParameterSpec)");
        Tr.processException((Throwable)e, clsName + ".addTransform", "94", this);
        Tr.error(tc, msg, new Object[]{e});
        throw e;
    }

    @Override
    public void addTransform(String algorithm) throws WSSException {
        String msg = "security.wssecurity.WSEC7012E";
        WSSException e = WSSException.format(msg, clsName + ".addTransform(String)");
        Tr.processException((Throwable)e, clsName + ".addTransform", "109", this);
        Tr.error(tc, msg, new Object[]{e});
        throw e;
    }

    @Override
    public void setEncryptHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptHeader(" + header.toString() + ")");
        }
        this.dialect = Constants.DIALECT_HEADER;
        this.headerNamespace = header.getNamespaceURI();
        this.headerName = header.getLocalPart();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], headerNamespace=[" + this.headerNamespace + "], headerName=[" + this.headerName + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptHeader(QName)");
        }
    }

    @Override
    public void setEncryptPart(int part) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPart(" + part + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = this.getKeyword(part);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPart(int)");
        }
    }

    @Override
    public void setEncryptPart(WSSSignature signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSSignature signature");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSSignature signature");
        }
    }

    @Override
    public void setEncryptPartByXPath(String xpath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPartByXPath(" + xpath + " )");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = xpath;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPartByXPath(" + xpath + " )");
        }
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getHeaderNamespace() {
        return this.headerNamespace;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getKeyword(int part) throws WSSException {
        String keyword;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword( " + part + ")");
        }
        if ((keyword = partMap.get(part)) == null) {
            String msg = "security.wssecurity.WSEC7010E";
            WSSException e = WSSException.format(msg);
            Tr.processException((Throwable)e, clsName + ".getKeyword", "263", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyword[" + keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword( " + part + ")");
        }
        return keyword;
    }

    @Override
    public void setEncryptPart(SecurityToken securityToken, boolean isElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPart(" + securityToken + ", " + isElement + ")");
        }
        QName qname = securityToken.getTokenQname();
        String node = isElement ? "" : "/node()";
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qname.getNamespaceURI() + "' and local-name()='" + qname.getLocalPart() + "']" + node;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPart(SecurityToken, boolean)");
        }
    }

    static {
        partMap.put(31, ConfidentialDialectElementSelector.WASDIALECTS[0]);
        partMap.put(32, ConfidentialDialectElementSelector.WASDIALECTS[3]);
    }
}

