/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.dec.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

public class WSSDecryptionImpl
implements WSSDecryption,
Consumable {
    private static final TraceComponent tc = Tr.register(WSSDecryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSDecryptionImpl.class.getName();
    private static final long serialVersionUID = -7471925006791048796L;
    private SecurityToken token;
    private List<WSSDecryptPart> decryptParts = new ArrayList<WSSDecryptPart>();
    private List<String> dataEncryptionMethods = new ArrayList<String>();
    private List<String> keyEncryptionMethods = new ArrayList<String>();
    private boolean encryptKey = true;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSDecryptionImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSDecryptionImpl(Class tokenClass, CallbackHandler callbackHandler, String loginModuleName, SecurityTokenManagerImpl securityTokenManager) throws WSSException {
        this.securityTokenManager = securityTokenManager;
        this.addToken(tokenClass, callbackHandler, loginModuleName);
    }

    @Override
    public void addRequiredDecryptPart(int part) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart( " + part + " )");
        }
        WSSDecryptPartImpl decryptPart = new WSSDecryptPartImpl();
        decryptPart.setRequiredDecryptPart(part);
        this.decryptParts.add(decryptPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart( " + part + " )");
        }
    }

    @Override
    public void addRequiredDecryptPart(WSSDecryptPart part) {
        this.decryptParts.add(part);
    }

    @Override
    public void addRequiredDecryptPart(WSSVerification verification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart(WSSVerification verification)");
        }
        WSSDecryptPartImpl decryptPart = new WSSDecryptPartImpl();
        decryptPart.setRequiredDecryptPart(verification);
        this.decryptParts.add(decryptPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart(WSSVerification verification)");
        }
    }

    @Override
    public void addRequiredDecryptHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart(QName qname)");
        }
        WSSDecryptPartImpl decryptPart = new WSSDecryptPartImpl();
        decryptPart.setRequiredDecryptHeader(header);
        this.decryptParts.add(decryptPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart(Qname qname)");
        }
    }

    @Override
    public void addRequiredDecryptPartByXPath(String part) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPartByXPath(" + part + ")");
        }
        WSSDecryptPartImpl decryptPart = new WSSDecryptPartImpl();
        decryptPart.setRequiredDecryptPartByXPath(part);
        this.decryptParts.add(decryptPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPartByXPath(" + part + ")");
        }
    }

    @Override
    public void addAllowedEncryptionMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDataEncryptionAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s14";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".addAllowedEncryptionMethod", "193", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.dataEncryptionMethods.add(method);
    }

    @Override
    public void addAllowedKeyEncryptionMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getKeyEncryptionAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s15";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".addAllowedKeyEncryptionMethod", "211", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.keyEncryptionMethods.add(method);
    }

    @Override
    public void encryptKey(boolean flag) {
        this.encryptKey = flag;
    }

    public List<String> getDataEncrpytionMethods() {
        return this.dataEncryptionMethods;
    }

    public List<String> getKeyEncryptionMethods() {
        return this.keyEncryptionMethods;
    }

    public List<WSSDecryptPart> getDecryptParts() {
        return this.decryptParts;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public boolean isEncryptKey() {
        return this.encryptKey;
    }

    @Override
    public void addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName)");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(class tokenClass, CallbackHandler callbackHandler, String loginConfigName)");
        }
    }

    @Override
    public void addToken(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler)");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler)");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WSSDecryptionImpl:");
        buffer.append(" dataEncryptionMethods: ");
        buffer.append(this.dataEncryptionMethods);
        buffer.append(", keyEncryptionMethods: ");
        buffer.append(this.keyEncryptionMethods);
        buffer.append(", decryptParts: ");
        buffer.append(this.decryptParts);
        buffer.append(", encryptKey: ");
        buffer.append(this.encryptKey);
        buffer.append(", token: ");
        buffer.append(this.token);
        buffer.append("]");
        return buffer.toString();
    }
}

