/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.dec.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSDecryptPartImpl
implements WSSDecryptPart {
    private static final TraceComponent tc = Tr.register(WSSDecryptPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSDecryptPartImpl.class.getName();
    private static final long serialVersionUID = 5579201733361587003L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;
    private String headerNamespace;
    private String headerName;

    @Override
    public void addRequiredTransform(String algorithm) throws WSSException {
        String msg = "security.wssecurity.WSEC7012E";
        WSSException e = WSSException.format(msg, clsName + ".addTransform(String, TransformParameterSpec)");
        Tr.processException((Throwable)e, clsName + ".addAllowedKeyEncryptionMethod", "108", this);
        Tr.error(tc, msg, new Object[]{e});
        throw e;
    }

    @Override
    public void setRequiredDecryptHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequiredDecryptHeader( header)");
        }
        this.dialect = Constants.DIALECT_HEADER;
        this.headerNamespace = header.getNamespaceURI();
        this.headerName = header.getLocalPart();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequiredDecryptHeader( header)");
        }
    }

    @Override
    public void setRequiredDecryptPart(int part) throws WSSException {
        this.keyword = this.getKeyword(part);
    }

    @Override
    public void setRequiredDecryptPart(WSSVerification verification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequiredDecryptPart(WSSVerification verification");
        }
        this.keyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequiredDecryptPart(WSSVerification verification");
        }
    }

    @Override
    public void setRequiredDecryptPartByXPath(String xpath) {
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = xpath;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getHeaderNamespace() {
        return this.headerNamespace;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getKeyword(int part) throws WSSException {
        String keyword;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword(" + part + ")");
        }
        if ((keyword = partMap.get(part)) == null) {
            String msg = "security.wssecurity.WSEC7010E";
            WSSException e = WSSException.format(msg);
            Tr.processException((Throwable)e, clsName + ".getKeyword", "226", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword(" + part + ")");
        }
        return keyword;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    static {
        partMap.put(51, ConfidentialDialectElementSelector.WASDIALECTS[0]);
        partMap.put(52, ConfidentialDialectElementSelector.WASDIALECTS[1]);
        partMap.put(53, ConfidentialDialectElementSelector.WASDIALECTS[3]);
    }
}

