/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.callbackhandler.SharedContextCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptionImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignatureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerificationImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;

public class WSSUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSUtil.class.getName();
    private static AlgorithmFactory algorithmFactoryInstance = null;
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static SecurityToken newSecurityTokenForGnenerator(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName, SecurityTokenManagerImpl securityTokenManager) throws WSSException {
        Map<QName, TokenMapping> dvmap;
        TokenMapping tm;
        if (tokenClass == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken token = null;
        if (callbackHandler != null) {
            token = WSSUtil.getSharedToken(callbackHandler);
        }
        if (token == null) {
            String stClassName = tokenClass.getName();
            String implClassName = tokenMap.get(stClassName);
            if (implClassName == null) {
                implClassName = stClassName;
            }
            try {
                token = (SecurityToken)Class.forName(implClassName).newInstance();
            }
            catch (IllegalAccessException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
        }
        if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(token.getValueType())).getJaasLoginConfigNameForGenerator()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper(token, callbackHandler, loginConfigName);
        securityTokenManager.addTokenWrapper(tokenWrapper);
        return token;
    }

    public static SecurityToken newSecurityTokenForConsumer(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName, SecurityTokenManagerImpl securityTokenManager) throws WSSException {
        Map<QName, TokenMapping> dvmap;
        TokenMapping tm;
        if (tokenClass == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken token = null;
        if (callbackHandler != null) {
            token = WSSUtil.getSharedToken(callbackHandler);
        }
        if (token == null) {
            String stClassName = tokenClass.getName();
            String implClassName = tokenMap.get(stClassName);
            if (implClassName == null) {
                implClassName = stClassName;
            }
            try {
                token = (SecurityToken)Class.forName(implClassName).newInstance();
            }
            catch (IllegalAccessException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                Tr.processException(e, clsName + ".processSCT()", "%C");
                throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
            }
        }
        if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(token.getValueType())).getJaasLoginConfigNameForConsumer()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper(token, callbackHandler, loginConfigName);
        securityTokenManager.addTokenWrapper(tokenWrapper);
        return token;
    }

    private static SecurityToken getSharedToken(CallbackHandler callbackhandler) throws WSSException {
        SharedContextCallback sharedCallback = new SharedContextCallback();
        Callback[] callbacks = new Callback[]{sharedCallback};
        SecurityToken token = null;
        try {
            callbackhandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            return null;
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".getSharedToken()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", callbackhandler.getClass().getName(), (Throwable)e);
        }
        WSSDecryption dec = sharedCallback.getWSSDecryption();
        WSSVerification ver = sharedCallback.getWSSVerification();
        if (dec != null || ver != null) {
            if (dec != null && dec instanceof WSSDecryptionImpl) {
                token = ((WSSDecryptionImpl)dec).getToken();
            }
            if (token == null && ver != null && ver instanceof WSSVerificationImpl) {
                token = ((WSSVerificationImpl)ver).getToken();
            }
        }
        WSSEncryption enc = sharedCallback.getWSSEncryption();
        WSSSignature sig = sharedCallback.getWSSSignature();
        if (enc != null || sig != null) {
            if (enc != null && enc instanceof WSSEncryptionImpl) {
                token = ((WSSEncryptionImpl)enc).getToken();
            }
            if (token == null && sig != null && sig instanceof WSSSignatureImpl) {
                token = ((WSSSignatureImpl)sig).getToken();
            }
        }
        return token;
    }

    public static AlgorithmFactory getAlgorithmFactory() {
        if (algorithmFactoryInstance == null) {
            algorithmFactoryInstance = WSSAlgorithmFactory.getInstance();
        }
        return algorithmFactoryInstance;
    }

    static {
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.UsernameToken", "com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509Token", "com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509PKCS7Token", "com.ibm.ws.wssecurity.wssapi.token.impl.X509PKCS7TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509PKIPathToken", "com.ibm.ws.wssecurity.wssapi.token.impl.X509PKIPathTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.LTPAToken", "com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken", "com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken", "com.ibm.ws.wssecurity.wssapi.token.impl.DKToken");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken", "com.ibm.ws.wssecurity.wssapi.token.impl.SCT");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken13", "com.ibm.ws.wssecurity.wssapi.token.impl.SCT13");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQToken", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_APREQTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ1510Token", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_APREQ1510TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ4120Token", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_APREQ4120TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQToken", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_GSSAPREQTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ1510Token", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_GSSAPREQ1510TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ4120Token", "com.ibm.ws.wssecurity.wssapi.token.impl.KRB5_GSSAPREQ4120TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.LTPAv2Token", "com.ibm.ws.wssecurity.wssapi.token.impl.LTPAv2TokenImpl");
    }
}

