/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerificationImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;

public class WSSInboundConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSInboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String COMMON_KEYINFO_CONTENT_CONSUMER = "com.ibm.ws.wssecurity.wssapi.CommonContentConsumer";
    private static final String COMMON_TOKEN_CONSUMER = "com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenConsumer";
    private Map<SecurityToken, PrivateConsumerConfig.TokenConsumerConfImpl> tokenConsumerMap = new HashMap<SecurityToken, PrivateConsumerConfig.TokenConsumerConfImpl>();
    private SecurityTokenManagerImpl securityTokenManager = null;
    private static final String clsName = WSSInboundConfig.class.getName();
    private static final String comp = "security.wssecurity";

    public WSSInboundConfig(SecurityTokenManagerImpl securityTokenManager) {
        this._properties = new HashMap();
        this.securityTokenManager = securityTokenManager;
        try {
            try {
                this._nonceManager = AccessController.doPrivileged(new PrivilegedExceptionAction<NonceManager>(){

                    @Override
                    public NonceManager run() throws SoapSecurityException {
                        return NonceManagerFactory.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException pac) {
                Throwable th = pac.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw new SoapSecurityException(th.getMessage());
            }
        }
        catch (SoapSecurityException e) {
            this._nonceManager = null;
        }
    }

    public void setActor(String actor) {
        this._myActor = actor;
    }

    public void setTimeStamp() {
        this._timestampConsumer = new PrivateConsumerConfig.TimestampConsumerConfImpl();
        this._timestampRequired = true;
    }

    public void process(Consumable consumable, WSSConsumingContext context) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Consumable consumable, WSSConsumingContext context)");
        }
        if (consumable instanceof SecurityTokenWrapper) {
            this.setTokenWrapper((SecurityTokenWrapper)consumable);
        } else if (consumable instanceof WSSDecryption) {
            this.setDecryption((WSSDecryption)((Object)consumable), context);
        } else if (consumable instanceof WSSVerification) {
            this.setVerification((WSSVerification)((Object)consumable), context);
        } else if (consumable instanceof WSSTimestamp) {
            this.setTimeStamp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Consumable, WSSConsumingContext)");
        }
    }

    public void setTokenWrapper(SecurityTokenWrapper tokenWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenWrapper(SecurityTokenWrapper tokenWrapper)");
        }
        PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfig = this.createTokenConsumerConfig(tokenWrapper.getValueType(), tokenWrapper.getWssapiLoginConfigName(), tokenWrapper.getWssapiCallbackHandler());
        SecurityToken token = tokenWrapper.getSecurityToken();
        this._tokenConsumers.add(tokenConsumerConfig);
        if (!this.tokenConsumerMap.containsKey(token)) {
            this.tokenConsumerMap.put(token, tokenConsumerConfig);
        }
        this._requiredSecurityTokens.add(tokenConsumerConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public void setVerification(WSSVerification verification, WSSConsumingContext context) throws WSSException {
        Iterator<String> iter;
        WSSVerificationImpl verificationImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerification(WSSVerification verfication, WSSConsumingContext context");
        }
        if ((verificationImpl = (WSSVerificationImpl)verification).isSignatureConfirmation()) {
            this._signatureConfirmationRequired = true;
            this._request = verificationImpl.isRequriredSignatureConfirmation();
        }
        if (verificationImpl.getCanonicalizationMethods().size() == 0) {
            List<String> canonicalizationMethods = DefaultValueManager.getInstance().getAllowedCanonicalizationMethods();
            iter = canonicalizationMethods.iterator();
            while (iter.hasNext()) {
                verification.addAllowedCanonicalizationMethod(iter.next());
            }
            this._allowedCanonicalizationMethods.addAll(canonicalizationMethods);
        } else {
            this._allowedCanonicalizationMethods.addAll(verificationImpl.getCanonicalizationMethods());
        }
        if (verificationImpl.getSignatureMethods().size() == 0) {
            List<String> signatureMethods = DefaultValueManager.getInstance().getAllowedSignatureMethods();
            iter = signatureMethods.iterator();
            while (iter.hasNext()) {
                verification.addAllowedSignatureMethod(iter.next());
            }
            this._allowedSignatureMethods.addAll(signatureMethods);
        } else {
            this._allowedSignatureMethods.addAll(verificationImpl.getSignatureMethods());
        }
        Iterator<String> cit = verificationImpl.getCanonicalizationMethods().iterator();
        while (cit.hasNext()) {
            PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
            signatureConsumerConfig._canonicalizationMethod = this.createAlgorithmConfig(cit.next());
            DerivedKeyInfoConfig dkInfo = null;
            Iterator<String> sit = verificationImpl.getSignatureMethods().iterator();
            while (sit.hasNext()) {
                List<Integer> verifyParts;
                PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfig;
                signatureConsumerConfig._signatureMethod = this.createAlgorithmConfig(sit.next());
                SecurityToken token = verificationImpl.getToken();
                SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Type =" + token.getValueType());
                }
                if (token instanceof DKToken) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "this is DKT");
                    }
                    if (((DKToken)token).getDerivableSecurityToken() != null) {
                        token = ((DKToken)token).getDerivableSecurityToken();
                    }
                }
                dkInfo = this.createDerivedKeyInfo(tokenWrapper.getWssapiCallbackHandler());
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfig = this.tokenConsumerMap.get(token);
                if (tokenConsumerConfig == null) {
                    tokenConsumerConfig = this.createTokenConsumerConfig(tokenWrapper.getValueType(), tokenWrapper.getWssapiLoginConfigName(), tokenWrapper.getWssapiCallbackHandler());
                    this.tokenConsumerMap.put(token, tokenConsumerConfig);
                    this._tokenConsumers.add(tokenConsumerConfig);
                } else {
                    this._requiredSecurityTokens.remove(tokenConsumerConfig);
                }
                tokenConsumerConfig._usedForVerification = true;
                PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfig = this.createKeyInfoContentConsumerConfig(tokenConsumerConfig);
                keyInfoContentConsumerConfig._derivedKeyInfo = dkInfo;
                ArrayList<KeyInfoContentConsumerConfig> keyInfoContentConsumerList = new ArrayList<KeyInfoContentConsumerConfig>();
                keyInfoContentConsumerList.add(keyInfoContentConsumerConfig);
                signatureConsumerConfig._signingKeyInfo = keyInfoConsumerConfig = this.createKeyInfoConsumerConfig(keyInfoContentConsumerList);
                if (((WSSVerificationImpl)verification).getVerifyParts().size() == 0 && (verifyParts = DefaultValueManager.getInstance().getVerifyParts()) != null) {
                    Iterator<Integer> iterator = verifyParts.iterator();
                    while (iterator.hasNext()) {
                        verification.addRequiredVerifyPart(iterator.next());
                    }
                }
                for (WSSVerifyPartImpl wSSVerifyPartImpl : verificationImpl.getVerifyParts()) {
                    Iterator<Object> iter2;
                    if (wSSVerifyPartImpl.getDigestMethods().size() == 0) {
                        wSSVerifyPartImpl.addAllowedDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
                        this._allowedDigestMethods.add("http://www.w3.org/2000/09/xmldsig#sha1");
                    } else {
                        this._allowedDigestMethods.addAll(wSSVerifyPartImpl.getDigestMethods());
                    }
                    if (wSSVerifyPartImpl.getTransforms().size() == 0) {
                        List<String> transforms = DefaultValueManager.getInstance().getTransformMethodsForVerification();
                        iter2 = transforms.iterator();
                        while (iter2.hasNext()) {
                            wSSVerifyPartImpl.addAllowedTransform((String)iter2.next());
                        }
                        this._allowedTransforms.addAll(transforms);
                    } else {
                        List<AlgorithmParameterData> transformMethods = wSSVerifyPartImpl.getTransforms();
                        if (transformMethods != null) {
                            iter2 = transformMethods.iterator();
                            while (iter2.hasNext()) {
                                this._allowedTransforms.add(((AlgorithmParameterData)iter2.next()).getAlgorithm());
                            }
                        }
                    }
                    PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                    for (String digestMethod : wSSVerifyPartImpl.getDigestMethods()) {
                        signingReferenceConfig._digestMethod = this.createAlgorithmConfig(digestMethod);
                        signingReferenceConfig.getTransforms().addAll(this.createTransforms(wSSVerifyPartImpl.getTransforms()));
                        PrivateCommonConfig.ReferencePartConfImpl referencePartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
                        PrivateCommonConfig.PartConfImpl partConfig = null;
                        String dialect = wSSVerifyPartImpl.getDialect();
                        partConfig = dialect.equals(Constants.DIALECT_HEADER) ? this.createPartConfig(wSSVerifyPartImpl.getDialect(), wSSVerifyPartImpl.getHeaderNamespace(), wSSVerifyPartImpl.getHeaderName()) : this.createPartConfig(wSSVerifyPartImpl.getDialect(), wSSVerifyPartImpl.getKeyword());
                        referencePartConfig.getParts().add(partConfig);
                        signingReferenceConfig._reference = referencePartConfig;
                        signatureConsumerConfig.getReferences().add(signingReferenceConfig);
                    }
                }
            }
            this._requiredIntegralParts.addAll(this.getIntegralParts(signatureConsumerConfig.getReferences()));
            this._signatureConsumers.add(signatureConsumerConfig);
        }
        this._verificationRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerification(WSSVerification, WSSConsumingContext)");
        }
    }

    public void setDecryption(WSSDecryption decryption, WSSConsumingContext context) throws WSSException {
        Iterator<String> iter;
        WSSDecryptionImpl decryptionImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDecryption(WSSDecryption decryption, WSSConsumingContext context)");
        }
        if ((decryptionImpl = (WSSDecryptionImpl)decryption).getDataEncrpytionMethods().size() == 0) {
            List<String> dataEncryptionMethods = DefaultValueManager.getInstance().getAllowedDataEncryptionMethods();
            iter = dataEncryptionMethods.iterator();
            while (iter.hasNext()) {
                decryptionImpl.addAllowedEncryptionMethod(iter.next());
            }
            this._allowedDataEncryptionMethods.addAll(dataEncryptionMethods);
        } else {
            this._allowedDataEncryptionMethods.addAll(decryptionImpl.getDataEncrpytionMethods());
        }
        if (decryptionImpl.getKeyEncryptionMethods().size() == 0) {
            List<String> keyEncryptionMethods = DefaultValueManager.getInstance().getAllowedKeyEncryptionMethods();
            iter = keyEncryptionMethods.iterator();
            while (iter.hasNext()) {
                decryption.addAllowedKeyEncryptionMethod(iter.next());
            }
            this._allowedKeyEncryptionMethods.addAll(keyEncryptionMethods);
        } else {
            this._allowedKeyEncryptionMethods.addAll(decryptionImpl.getKeyEncryptionMethods());
        }
        boolean isEncryptKey = decryptionImpl.isEncryptKey();
        Iterator<String> dit = decryptionImpl.getDataEncrpytionMethods().iterator();
        while (dit.hasNext()) {
            PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
            encryptionConsumerConfig._dataEncryptionMethod = this.createAlgorithmConfig(dit.next());
            for (String tmp : decryptionImpl.getKeyEncryptionMethods()) {
                List<Integer> decryptionParts;
                PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfig;
                encryptionConsumerConfig._keyEncryptionMethod = isEncryptKey ? this.createAlgorithmConfig(tmp) : null;
                DerivedKeyInfoConfig dkInfo = null;
                SecurityToken token = decryptionImpl.getToken();
                SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Type =" + token.getValueType());
                }
                if (token instanceof DKToken && ((DKToken)token).getDerivableSecurityToken() != null) {
                    token = ((DKToken)token).getDerivableSecurityToken();
                }
                dkInfo = this.createDerivedKeyInfo(tokenWrapper.getWssapiCallbackHandler());
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfig = this.tokenConsumerMap.get(token);
                if (tokenConsumerConfig == null) {
                    tokenConsumerConfig = this.createTokenConsumerConfig(tokenWrapper.getValueType(), tokenWrapper.getWssapiLoginConfigName(), tokenWrapper.getWssapiCallbackHandler());
                    this.tokenConsumerMap.put(token, tokenConsumerConfig);
                    this._tokenConsumers.add(tokenConsumerConfig);
                } else {
                    this._requiredSecurityTokens.remove(tokenConsumerConfig);
                }
                tokenConsumerConfig._usedForDecryption = true;
                PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfig = this.createKeyInfoContentConsumerConfig(tokenConsumerConfig);
                keyInfoContentConsumerConfig._derivedKeyInfo = dkInfo;
                ArrayList<KeyInfoContentConsumerConfig> keyInfoContentConsumerList = new ArrayList<KeyInfoContentConsumerConfig>();
                keyInfoContentConsumerList.add(keyInfoContentConsumerConfig);
                encryptionConsumerConfig._encryptionKeyInfo = keyInfoConsumerConfig = this.createKeyInfoConsumerConfig(keyInfoContentConsumerList);
                PrivateCommonConfig.ReferencePartConfImpl referencePartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
                if (decryptionImpl.getDecryptParts().size() == 0 && (decryptionParts = DefaultValueManager.getInstance().getDecryptionParts()) != null) {
                    Iterator<Integer> iterator = decryptionParts.iterator();
                    while (iterator.hasNext()) {
                        decryption.addRequiredDecryptPart(iterator.next());
                    }
                }
                for (WSSDecryptPartImpl wSSDecryptPartImpl : decryptionImpl.getDecryptParts()) {
                    PrivateCommonConfig.PartConfImpl partConfig = null;
                    String dialect = wSSDecryptPartImpl.getDialect();
                    partConfig = dialect.equals(Constants.DIALECT_HEADER) ? this.createPartConfig(wSSDecryptPartImpl.getDialect(), wSSDecryptPartImpl.getHeaderNamespace(), wSSDecryptPartImpl.getHeaderName()) : this.createPartConfig(wSSDecryptPartImpl.getDialect(), wSSDecryptPartImpl.getKeyword());
                    referencePartConfig.getParts().add(partConfig);
                }
                encryptionConsumerConfig._reference = referencePartConfig;
            }
            this._requiredConfidentialParts.add(encryptionConsumerConfig._reference);
            this._encryptionConsumers.add(encryptionConsumerConfig);
        }
        this._decryptionRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDecryption(WSSDecryption, WSSConsumingContext)");
        }
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAlgorithmConfig(String methodName)");
        }
        PrivateCommonConfig.AlgorithmConfImpl algorithmConf = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConf._algorithm = methodName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAlgorithmConfig(String)");
        }
        return algorithmConf;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(AlgorithmParameterData paramData) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAlgorithmConfig(AlgorithmParameterData paramData)");
        }
        PrivateCommonConfig.AlgorithmConfImpl algorithmConf = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConf._algorithm = paramData.getAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAlgorithmConfig(AlgorithmParameterData)");
        }
        return algorithmConf;
    }

    private List<PrivateCommonConfig.ReferencePartConfImpl> getIntegralParts(List<SigningReferenceConfig> references) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIntegralPart(List references)");
        }
        ArrayList<PrivateCommonConfig.ReferencePartConfImpl> integralParts = new ArrayList<PrivateCommonConfig.ReferencePartConfImpl>();
        for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : references) {
            integralParts.add(signingReferenceConfImpl._reference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIntegralPart(List)");
        }
        return integralParts;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String dialect, String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(" + dialect + ", " + keyword + ")");
        }
        PrivateCommonConfig.PartConfImpl partConfig = new PrivateCommonConfig.PartConfImpl();
        partConfig._dialect = dialect;
        partConfig._keyword = keyword;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String dialect, String keyword)");
        }
        return partConfig;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String dialect, String headerNamespace, String headerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(" + dialect + ", " + headerNamespace + ", " + headerName + ")");
        }
        PrivateCommonConfig.PartConfImpl partConfig = new PrivateCommonConfig.PartConfImpl();
        partConfig._dialect = dialect;
        partConfig._headerNamespace = headerNamespace;
        partConfig._headerName = headerName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String dialect, String headerNamespace, String headerName)");
        }
        return partConfig;
    }

    private List<PrivateCommonConfig.AlgorithmConfImpl> createTransforms(List<AlgorithmParameterData> transforms) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransforms(List<AlgorithmParameterData>    transforms)");
        }
        ArrayList<PrivateCommonConfig.AlgorithmConfImpl> transformAlgorithms = new ArrayList<PrivateCommonConfig.AlgorithmConfImpl>();
        if (transforms.size() == 0) {
            List<String> transformMethods = DefaultValueManager.getInstance().getTransformMethodsForSignature();
            if (transformMethods != null) {
                Iterator<String> iter = transformMethods.iterator();
                while (iter.hasNext()) {
                    transformAlgorithms.add(this.createAlgorithmConfig(iter.next()));
                }
            }
        } else {
            for (AlgorithmParameterData transform : transforms) {
                transformAlgorithms.add(this.createAlgorithmConfig(transform));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransforms(List)");
        }
        return transformAlgorithms;
    }

    private PrivateConsumerConfig.TokenConsumerConfImpl createTokenConsumerConfig(QName valueType, String loginConfigName, CallbackHandler callbackHandler) {
        PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfig;
        block5: {
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("createTokenConsumerConfig(");
                buf.append("QName valueType[").append(valueType).append("], ");
                buf.append("String loginConfigName[").append(loginConfigName).append("], ");
                buf.append("CallbackHandler callbackHandler)");
                Tr.entry(tc, buf.toString());
            }
            tokenConsumerConfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
            tokenConsumerConfig._className = COMMON_TOKEN_CONSUMER;
            HashMap<Object, Object> type = new HashMap<Object, Object>();
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tokenConsumerConfig._className);
            try {
                WSSFactory factory = WSSFactory.getInstance("soap");
                tokenConsumerConfig._instance = (TokenConsumerComponent)factory.createConsumer(type, properties);
            }
            catch (SoapSecurityException e) {
                if (!tc.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
        tokenConsumerConfig._type = valueType;
        tokenConsumerConfig._usedForDecryption = false;
        tokenConsumerConfig._usedForVerification = false;
        tokenConsumerConfig._jaasConfig = loginConfigName;
        if (callbackHandler != null) {
            PrivateCommonConfig.CallbackHandlerConfImpl callbackHandlerConfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
            callbackHandlerConfig._className = callbackHandler.getClass().getName();
            callbackHandlerConfig._instance = callbackHandler;
            tokenConsumerConfig._callbackHandler = callbackHandlerConfig;
        }
        this._tokenRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenConsumerConfig(QName, String, CallbackHandler)");
        }
        return tokenConsumerConfig;
    }

    private PrivateConsumerConfig.KeyInfoContentConsumerConfImpl createKeyInfoContentConsumerConfig(PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfig) {
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfig;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createKeyInfoContentConsumeConfig(TokenConsumerConfig tokenConsumerConfig)");
            }
            keyInfoContentConsumerConfig = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
            keyInfoContentConsumerConfig._className = COMMON_KEYINFO_CONTENT_CONSUMER;
            HashMap<Object, Object> type = new HashMap<Object, Object>();
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
            type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", keyInfoContentConsumerConfig._className);
            try {
                WSSFactory factory = WSSFactory.getInstance("soap");
                keyInfoContentConsumerConfig._instance = (KeyInfoContentConsumerComponent)factory.createConsumer(type, properties);
            }
            catch (SoapSecurityException e) {
                if (!tc.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        keyInfoContentConsumerConfig._tokenConsumer = tokenConsumerConfig;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfoContentConsumeConfig(TokenConsumerConfig)");
        }
        return keyInfoContentConsumerConfig;
    }

    private PrivateConsumerConfig.KeyInfoConsumerConfImpl createKeyInfoConsumerConfig(List<KeyInfoContentConsumerConfig> keyInfoContentConsumerList) {
        PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
        keyInfoConsumerConfig._contentConsumers = keyInfoContentConsumerList;
        return keyInfoConsumerConfig;
    }

    private DerivedKeyInfoConfig createDerivedKeyInfo(CallbackHandler callbackHandler) throws WSSException {
        int nonceLeng;
        String clientLabel;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " createDerivedKeyInfo");
        }
        DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
        DerivedKeyInfoCallback dkcallback = new DerivedKeyInfoCallback();
        Callback[] callbacks = new Callback[]{dkcallback};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            derivedKeyInfo.setRequireDerivedKeys(false);
            return derivedKeyInfo;
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".createDerivedKeyInfo()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", callbackHandler.getClass().getName(), (Throwable)e);
        }
        String serviceLabel = dkcallback.getServerLabel();
        if (serviceLabel != null && serviceLabel.length() > 0) {
            derivedKeyInfo.setServiceLabel(serviceLabel);
        }
        if ((clientLabel = dkcallback.getClientLabel()) != null && clientLabel.length() > 0) {
            derivedKeyInfo.setClientLabel(clientLabel);
        }
        boolean requirDKT = dkcallback.getRequiredDKT();
        derivedKeyInfo.setRequireDerivedKeys(requirDKT);
        int keyLeng = dkcallback.getKeyBytesLength();
        if (keyLeng != 0) {
            String keyL = new Integer(keyLeng).toString();
            derivedKeyInfo.setKeyLength(keyL);
        }
        if ((nonceLeng = dkcallback.getNonceBytesLength()) != 0) {
            String keyL = new Integer(nonceLeng).toString();
            derivedKeyInfo.setNonceLength(keyL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " createDerivedKeyInfo");
        }
        return derivedKeyInfo;
    }
}

