/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextRetrieverFactory;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextRetriever;
import com.ibm.ws.wssecurity.wssapi.WSSGeneratorTransform;
import com.ibm.ws.wssecurity.wssapi.WSSOutboundConfig;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;

public class WSSGeneratorTransformImpl
implements WSSGeneratorTransform {
    private static final TraceComponent tc = Tr.register(WSSGeneratorTransformImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static WSSGeneratorTransform instance = new WSSGeneratorTransformImpl();

    private WSSGeneratorTransformImpl() {
    }

    public static WSSGeneratorTransform getInstance() {
        return instance;
    }

    @Override
    public WSSGeneratorConfig transform(Object obj) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(Object obj)");
        }
        if (obj == null) {
            throw WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSGeneratorTransform", "obj"});
        }
        WSSContextRetrieverFactory factory = WSSContextRetrieverFactory.getInstance();
        WSSGenerationContextRetriever retriever = factory.getWSSGeneratoinContextRetrieverFactory(obj);
        WSSGenerationContextImpl genContext = (WSSGenerationContextImpl)retriever.getWSSGeneratoinContext(obj);
        if (genContext == null) {
            throw WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSGeneratorTransform", "genContext"});
        }
        WSSOutboundConfig config2 = new WSSOutboundConfig(genContext.getSecurityTokenManagerImpl());
        config2.setActor(genContext.getActor());
        for (Generatable objx : genContext.getContexts()) {
            config2.process(objx);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(Object obj)");
        }
        return config2;
    }
}

