/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSFactory;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptionImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignatureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerificationImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;

public class WSSFactoryImpl
extends WSSFactory {
    private static final TraceComponent tc = Tr.register(WSSFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSFactoryImpl.class.getName();
    private static Map<String, String> tokensMap = new HashMap<String, String>();
    private static final String SCT_DRAFT_VERSION_CLASS_NAME = "com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken";
    private static final String SCT_13_VERSION_CLASS_NAME = "com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken13";
    private Map<Object, Object> context = new HashMap<Object, Object>();
    private SecurityTokenManagerImpl securityTokenManager = new SecurityTokenManagerImpl(this.context);

    @Override
    public WSSGenerationContext newWSSGenerationContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSGenerationContext()");
        }
        WSSGenerationContextImpl impl = new WSSGenerationContextImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSGenerationContext()");
        }
        return impl;
    }

    @Override
    public WSSGenerationContext newWSSGenerationContext(String actor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSGenerationContext(" + actor + ")");
        }
        WSSGenerationContextImpl impl = new WSSGenerationContextImpl(actor, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSGenerationContext(String)");
        }
        return impl;
    }

    @Override
    public WSSConsumingContext newWSSConsumingContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSConsumingContext()");
        }
        WSSConsumingContextImpl impl = new WSSConsumingContextImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSConsumingContext()");
        }
        return impl;
    }

    @Override
    public WSSConsumingContext newWSSConsumingContext(String actor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSConsumingContext(" + actor + ")");
        }
        WSSConsumingContextImpl impl = new WSSConsumingContextImpl(actor, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSConsumingContext(actor)");
        }
        return impl;
    }

    @Override
    public WSSSignature newWSSSignature(SecurityToken token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSSignature(" + token.toString() + ")");
        }
        WSSSignatureImpl impl = new WSSSignatureImpl(token, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSSignature(SecurityToken)");
        }
        return impl;
    }

    @Override
    public WSSSignPart newWSSSignPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSSignPart()");
        }
        WSSSignPartImpl impl = new WSSSignPartImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSSignPart()");
        }
        return impl;
    }

    @Override
    public WSSEncryption newWSSEncryption(SecurityToken token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryption( token[" + token.toString() + "])");
        }
        WSSEncryptionImpl impl = new WSSEncryptionImpl(token, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryption(SecurityToken)");
        }
        return impl;
    }

    @Override
    public WSSEncryption newWSSEncryption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryption()");
        }
        WSSEncryptionImpl impl = new WSSEncryptionImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryption()");
        }
        return impl;
    }

    @Override
    public WSSEncryptPart newWSSEncryptPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryptPart()");
        }
        WSSEncryptPartImpl impl = new WSSEncryptPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryptPart()");
        }
        return impl;
    }

    @Override
    public WSSTimestamp newWSSTimestamp() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSTimestamp()");
        }
        WSSTimestampImpl impl = new WSSTimestampImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSTimestamp()");
        }
        return impl;
    }

    @Override
    public SecurityToken newSecurityToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newSecurityToken(");
            buf.append("String loginConfigName[").append(loginConfigName).append("], ");
            buf.append("CallbackHandler callbackHandler, ");
            buf.append("Class tokenClass[");
            buf.append(tokenClass == null ? null : tokenClass.getName());
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = WSSUtil.newSecurityTokenForGnenerator(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newSecurityToken(");
            buf.append("String, CallbackHandler, Class)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    @Override
    public SecurityToken[] newSecurityTokens(Class[] tokenClasses, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newSecurityToken(");
            buf.append("String loginConfigName[").append(loginConfigName).append("], ");
            buf.append("CallbackHandler callbackHandler, ");
            buf.append("Class[] tokenClasses[");
            buf.append(tokenClasses == null ? "null" : "not null");
            buf.append("])");
            Tr.entry(tc, buf.toString());
        }
        if (tokenClasses == null || tokenClasses.length != 1) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        String stClassName = tokenClasses[0].getName();
        String implClassName = tokensMap.get(stClassName);
        if (implClassName == null) {
            implClassName = stClassName;
        }
        if (!implClassName.contains("com.ibm.ws.wssecurity.wssapi.token.impl.SCT")) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken token = null;
        try {
            token = (SecurityToken)Class.forName(implClassName).newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT Version = " + token.getValueType().getLocalPart());
            }
        }
        catch (IllegalAccessException e) {
            Tr.processException(e, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{implClassName});
            throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
        }
        catch (InstantiationException e) {
            Tr.processException(e, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{implClassName});
            throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Tr.processException(e, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{implClassName});
            throw WSSException.format("security.wssecurity.WSEC7076E", implClassName, (Throwable)e);
        }
        if (loginConfigName == null) {
            Map<QName, TokenMapping> dvmap = DefaultValueManager.getInstance().getTokenMapping();
            TokenMapping tm = dvmap.get(token.getValueType());
            loginConfigName = tm.getJaasLoginConfigNameForGenerator();
        }
        SecurityToken[] tokens = this.processSCT(loginConfigName, callbackHandler, token.getValueType());
        int il = tokens.length;
        for (int i = 0; i < il; ++i) {
            SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper(tokens[i], callbackHandler, loginConfigName);
            this.securityTokenManager.addTokenWrapper(tokenWrapper);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newSecurityToken(");
            buf.append("String, CallbackHandler, Class[])");
            buf.append(" returns SecurityToken[][").append(tokens).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokens;
    }

    private SecurityToken[] processSCT(final String loginConfigName, CallbackHandler callbackHandler, QName tokenValueType) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processSCT(");
            buf.append("String loginConfigName[").append(loginConfigName).append("], ");
            buf.append("CallbackHandker callbackHandler, ");
            buf.append("QName tokenValueType[").append(tokenValueType).append("])");
            Tr.entry(tc, buf.toString());
        }
        Map<Object, Object> context = this.securityTokenManager.getContext();
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        context.put(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenValueType);
        final CommonCallbackHandler commonCBH = new CommonCallbackHandler(callbackHandler, context);
        try {
            LoginContext lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws LoginException {
                    LoginContext lc = new LoginContext(loginConfigName, subject, commonCBH);
                    return lc;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to construct the login context.");
            }
            lcontext.login();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to login.");
            }
        }
        catch (PrivilegedActionException pae) {
            LoginException le = (LoginException)pae.getCause();
            Tr.processException(le, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{le});
            throw WSSException.format("security.wssecurity.X509TokenConsumer.s01", le);
        }
        catch (LoginException le) {
            Tr.processException(le, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{le});
            throw WSSException.format("security.wssecurity.X509TokenConsumer.s02", le);
        }
        List list = (List)context.get(Constants.WSSECURITY_TOKEN_PROCESSED);
        SecurityToken[] ret = list.toArray(new SecurityToken[0]);
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null || !(ret[i] instanceof SCTWrapper)) continue;
            ((SCTWrapper)ret[i]).setSecurityTokenManagerImpl(this.securityTokenManager);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newSecurityToken(");
            buf.append("String, CallbackHandler, Class[])");
            buf.append(" returns SecurityToken[][").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    @Override
    public SecurityToken newSecurityToken(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        return this.newSecurityToken(tokenClass, callbackHandler, null);
    }

    @Override
    public SecurityToken[] newSecurityTokens(Class[] tokenClasses, CallbackHandler callbackHandler) throws WSSException {
        return this.newSecurityTokens(tokenClasses, callbackHandler, null);
    }

    @Override
    public WSSVerification newWSSVerification(Class tokenClass) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSVerification(");
            buf.append("Class tokenClass[").append(tokenClass).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSVerificationImpl ret = new WSSVerificationImpl(tokenClass, null, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class)");
        }
        return ret;
    }

    @Override
    public WSSVerification newWSSVerification(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSVerification(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandker callbackHandler)");
            Tr.entry(tc, buf.toString());
        }
        WSSVerificationImpl ret = new WSSVerificationImpl(tokenClass, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class, CallbackHandler)");
        }
        return ret;
    }

    @Override
    public WSSVerification newWSSVerification(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSVerification(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandker callbackHandler, ");
            buf.append("String loginConfigName[").append(loginConfigName).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSVerificationImpl ret = new WSSVerificationImpl(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class, CallbackHandler, String)");
        }
        return ret;
    }

    @Override
    public WSSVerifyPart newWSSVerifyPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSVerifyPart");
        }
        WSSVerifyPartImpl impl = new WSSVerifyPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerifyPart");
        }
        return impl;
    }

    @Override
    public WSSDecryption newWSSDecryption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSDecryption()");
        }
        WSSDecryptionImpl impl = new WSSDecryptionImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption()");
        }
        return impl;
    }

    @Override
    public WSSDecryption newWSSDecryption(Class tokenClass) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSDecryptPart(");
            buf.append("Class tokenClass[").append(tokenClass).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSDecryptionImpl ret = new WSSDecryptionImpl(tokenClass, null, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class)");
        }
        return ret;
    }

    @Override
    public WSSDecryption newWSSDecryption(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSDecryptPart(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandker callbackHandler)");
            Tr.entry(tc, buf.toString());
        }
        WSSDecryptionImpl ret = new WSSDecryptionImpl(tokenClass, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class, CallbackHandler)");
        }
        return ret;
    }

    @Override
    public WSSDecryption newWSSDecryption(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("newWSSDecryptPart(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandker callbackHandler, ");
            buf.append("String loginConfigName[").append(loginConfigName).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSDecryptionImpl ret = new WSSDecryptionImpl(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class, CallbackHandler, String)");
        }
        return ret;
    }

    @Override
    public WSSDecryptPart newWSSDecryptPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSDecryptPart()");
        }
        WSSDecryptPartImpl impl = new WSSDecryptPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryptPart()");
        }
        return impl;
    }

    static {
        tokensMap.put(SCT_DRAFT_VERSION_CLASS_NAME, "com.ibm.ws.wssecurity.wssapi.token.impl.SCT");
        tokensMap.put(SCT_13_VERSION_CLASS_NAME, "com.ibm.ws.wssecurity.wssapi.token.impl.SCT13");
    }
}

