/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextRetriever;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextRetriever;
import java.util.HashMap;
import java.util.Map;

public class WSSContextRetrieverFactory {
    private static final TraceComponent tc = Tr.register(WSSContextRetrieverFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static Map<String, String> generatorMap = new HashMap<String, String>();
    private static Map<String, String> consumerMap = new HashMap<String, String>();
    private static Map<String, WSSGenerationContextRetriever> cacheGeneratorMap = new HashMap<String, WSSGenerationContextRetriever>();
    private static Map<String, WSSConsumingContextRetriever> cacheConsumerMap = new HashMap<String, WSSConsumingContextRetriever>();
    private static WSSContextRetrieverFactory instance;

    private WSSContextRetrieverFactory() {
    }

    public static WSSContextRetrieverFactory getInstance() {
        return instance;
    }

    public WSSGenerationContextRetriever getWSSGeneratoinContextRetrieverFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSGeneratoinContextRetrieverFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSGeneratoinContextRetrieverFactory"});
        }
        String className = generatorMap.get(object.getClass().getName());
        if (className == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in generatorMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSGenerationContextRetriever retriever = null;
        try {
            retriever = cacheGeneratorMap.get(className);
            if (retriever == null) {
                retriever = (WSSGenerationContextRetriever)Class.forName(className).newInstance();
                cacheGeneratorMap.put(className, retriever);
            }
        }
        catch (IllegalAccessException e) {
            throw new WSSException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new WSSException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new WSSException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSGeneratoinContextRetrieverFactory(Object object)");
        }
        return retriever;
    }

    public WSSConsumingContextRetriever getWSSConsumingContextRetrieverFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSConsumingContextRetrieverFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSConsumingContextRetrieverFactory"});
        }
        String className = consumerMap.get(object.getClass().getName());
        if (className == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in consumerMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSConsumingContextRetriever retriever = null;
        try {
            retriever = cacheConsumerMap.get(className);
            if (retriever == null) {
                retriever = (WSSConsumingContextRetriever)Class.forName(className).newInstance();
                cacheConsumerMap.put(className, retriever);
            }
        }
        catch (IllegalAccessException e) {
            throw new WSSException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new WSSException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new WSSException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSConsumingContextRetrieverFactory(Object object)");
        }
        return retriever;
    }

    static {
        generatorMap.put("org.apache.axis2.context.MessageContext", "com.ibm.ws.wssecurity.wssapi.JAXWSGenerationContextRetriever");
        consumerMap.put("org.apache.axis2.context.MessageContext", "com.ibm.ws.wssecurity.wssapi.JAXWSConsumingContextRetriever");
        instance = new WSSContextRetrieverFactory();
    }
}

