/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextPutterFactory;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class WSSConsumingContextImpl
implements WSSConsumingContext {
    private static final TraceComponent tc = Tr.register(WSSConsumingContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumingContextImpl.class.getName();
    private static final long serialVersionUID = -4814725885349270383L;
    private static Map<Integer, String> partMap = new HashMap<Integer, String>();
    private List<Consumable> targetList = new ArrayList<Consumable>();
    private String actor;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSConsumingContextImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSConsumingContextImpl(String actor, SecurityTokenManagerImpl securityTokenManager) {
        this.actor = actor;
        this.securityTokenManager = securityTokenManager;
    }

    @Override
    public void add(WSSVerification verifiaction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSVerification verifiaction)");
        }
        this.targetList.add((Consumable)((Object)verifiaction));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSVerification)");
        }
    }

    @Override
    public void add(WSSDecryption decryption) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSDecryption decryption)");
        }
        this.targetList.add((Consumable)((Object)decryption));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSDecryption)");
        }
    }

    @Override
    public void process(Object messageContext) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Object messageContext)");
        }
        WSSContextPutterFactory.getInstance().getWSSConsumingContextPutterFactory(messageContext).put(messageContext, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Object)");
        }
    }

    @Override
    public void add(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("add(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandler callbackHandler, ");
            buf.append("String loginConfigName[").append(loginConfigName).append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
        this.targetList.add(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(Class, CallbackHandler, String)");
        }
    }

    @Override
    public void add(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("add(");
            buf.append("Class tokenClass[").append(tokenClass).append("], ");
            buf.append("CallbackHandler callbackHandler)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, null, this.securityTokenManager);
        SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
        this.targetList.add(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(Class, CallbackHandler)");
        }
    }

    @Override
    public void add(int keyword) throws WSSException {
        String className;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(int keyword[" + keyword + "])");
        }
        if ((className = partMap.get(keyword)) == null) {
            throw WSSException.format("security.wssecurity.WSEC7010E");
        }
        Object obj = null;
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (IllegalAccessException e) {
            Tr.processException((Throwable)e, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (InstantiationException e) {
            Tr.processException((Throwable)e, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Tr.processException((Throwable)e, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        this.targetList.add(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(int keyword)");
        }
    }

    public List getContexts() {
        return this.targetList;
    }

    public SecurityTokenManagerImpl getSecurityTokenManagerImpl() {
        return this.securityTokenManager;
    }

    public String getActor() {
        return this.actor;
    }

    static {
        partMap.put(11, "com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl");
    }
}

