/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import javax.xml.datatype.Duration;

public class WSSAPIDuration {
    private static com.ibm.ws.wssecurity.util.Duration wssduration;
    private static WSSAPIDuration instance;
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc;
    private static final String clsName;

    public static WSSAPIDuration getInstance() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (wssduration == null) {
            try {
                wssduration = com.ibm.ws.wssecurity.util.Duration.parse(DefaultValueManager.getInstance().getDuration());
            }
            catch (Exception e) {
                Tr.processException(e, clsName + ".getInstance", "%C");
                throw WSSException.format("security.wssecurity.WSEC7075E", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance()");
        }
        return instance;
    }

    public void setDuration(Duration duration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDuration(javax.xml.datatype.Duration duration)");
        }
        this.convert(duration);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance(javax.xml.datatype.Duration duration) ");
        }
    }

    public com.ibm.ws.wssecurity.util.Duration getWSSDuration() {
        return wssduration;
    }

    private void convert(Duration duration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert(javax.xml.datatype.Duration duration)");
        }
        wssduration = new com.ibm.ws.wssecurity.util.Duration(duration.getYears(), duration.getMonths(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), 0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "duration years[" + duration.getYears() + "] " + "months[" + duration.getYears() + "] " + "days[" + duration.getDays() + "] " + "hours[" + duration.getHours() + "] " + "minutes[" + duration.getMinutes() + "] " + "seconds[" + duration.getSeconds() + "] ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert(javax.xml.datatype.Duration duration)");
        }
    }

    static {
        instance = new WSSAPIDuration();
        tc = Tr.register(WSSAPIDuration.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        clsName = WSSAPIDuration.class.getName();
    }
}

