/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

public class CommonContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(CommonContentConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonContentConsumer.class.getName();
    private static final QName ENCODINGTYPE_Q = new QName("", "EncodingType");
    private static final QName IDENTIFIERTYPE_Q = new QName("", "IdentifierType");
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(ResolvedKeyInfo kinfo, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        MessageContext messageContext;
        boolean isServer;
        QName vtype;
        String kid;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("ResolvedKeyInfo kinfo[").append(kinfo.toString()).append("], ");
            buf.append("Map type, Map context)");
            Tr.entry(tc, buf.toString());
        }
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean isSigningKeyAuditRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS, context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED, context);
        boolean isEncryptionKeyAuditRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.SUCCESS, context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.DENIED, context);
        boolean isKeyAuditRequired = isSigningKeyAuditRequired || isEncryptionKeyAuditRequired;
        KeyInfoContentConsumerConfig config2 = (KeyInfoContentConsumerConfig)context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentConsumerConfig [" + config2 + "].");
        }
        Map<Object, Object> props = config2.getProperties();
        String HWKeyStoreRef = null;
        HWKeyStoreRef = (String)props.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
        if (HWKeyStoreRef != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HW keystore name is in use = " + HWKeyStoreRef);
            }
            context.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", HWKeyStoreRef);
            if (isKeyAuditRequired) {
                WSSAuditEventGeneratorFactory.getInstance().setExtendedAuditData(context, "HwKeyStore", HWKeyStoreRef);
            }
        }
        KeyInfoResult result = new KeyInfoResult(config2);
        ResultPool.add(context, result);
        String kitype = kinfo._kitype;
        context.put(Constants.WSSECURITY_KEYINFO_TYPE, kitype);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The type of a key information is [" + kitype + "].");
        }
        OMElement tokenElem = null;
        if (ConfigUtil.isKeyInfoStrref(kitype)) {
            String refuri = kinfo._tokenReference;
            result.setIdInSubject(refuri);
            context.put(Constants.WSSECURITY_KEY_REFERENCE, refuri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reference URI to a token is [" + refuri + "].");
            }
        } else if (ConfigUtil.isKeyInfoKeyid(kitype)) {
            kid = kinfo._tokenId;
            result.setIdInSubject(kid);
            vtype = kinfo._kidValueType;
            context.put(Constants.WSSECURITY_KEY_ID, kid);
            context.put(Constants.WSSECURITY_KEY_VALUETYPE, vtype);
            context.put(Constants.WSSECURITY_KEY_ENCODING, kinfo._kidEncodingType);
            context.put(Constants.WSSECURITY_KEY_IDTYPE, kinfo._kidIdentifierType);
            isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (isServer && vtype != null && (vtype.equals(com.ibm.ws.wssecurity.common.Constants.X509_SKI) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + vtype + " key idendifier is found.        It is cached in order to use it for response generator.");
                }
                if ((messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                messageContext.setProperty("com.ibm.ws.wssecurity.constants.consumedKeyidValuetype", vtype);
            }
        } else if (ConfigUtil.isKeyInfoThumbprint(kitype)) {
            kid = kinfo._tokenId;
            result.setIdInSubject(kid);
            vtype = kinfo._kidValueType;
            context.put(Constants.WSSECURITY_KEY_THUMBPRINT_REFERENCE, kid);
            context.put(Constants.WSSECURITY_KEY_VALUETYPE, vtype);
            context.put(Constants.WSSECURITY_KEY_ENCODING, kinfo._kidEncodingType);
            context.put(Constants.WSSECURITY_KEY_IDTYPE, kinfo._kidIdentifierType);
            isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (isServer && vtype != null && vtype.equals(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + vtype + " thumbprint reference is found.  It is cached in order to use it for response generator.");
                }
                if ((messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                messageContext.setProperty("com.ibm.ws.wssecurity.constants.consumedKeyidValuetype", vtype);
            }
        } else if (ConfigUtil.isKeyInfoKeyname(kitype)) {
            String kname = kinfo._tokenName;
            result.setIdInSubject(kname);
            context.put(Constants.WSSECURITY_KEY_NAME, kname);
        } else if (ConfigUtil.isKeyInfoEmb(kitype)) {
            String embId = kinfo._tokenId;
            result.setIdInSubject(embId);
            context.put(Constants.WSSECURITY_KEY_EMBID, embId);
            tokenElem = kinfo._embeddedToken;
        } else if (ConfigUtil.isKeyInfoX509issuer(kitype)) {
            String iname = kinfo._x509issuerName;
            String inum = kinfo._x509issuerSerial;
            result.setIdInSubject(iname + ":" + inum);
            context.put(Constants.WSSECURITY_KEY_ISSUERNAME, iname);
            context.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, inum);
        } else {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey03", kitype);
        }
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        context.put(Constants.WSSECURITY_KEY_TYPE, keyType);
        String kiname = config2.getKeyName();
        context.put(Constants.WSSECURITY_KEYINFO_UNIQUE_NAME, kiname);
        if (kinfo._impliedDKNonce != null) {
            context.put("ImpliedDerivedKeys_Nonce_Prop", kinfo._impliedDKNonce);
            context.put("ImpliedDerivedKeys_Length_Prop", kinfo._impliedDKLength);
            context.put("com.ibm.ws.wssecurity.sc.dkt.externalURIReference", kinfo.isExternalUriReference);
            context.put("ImpliedDerivedKeyInstance", kinfo._tokenInstance);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implied DKT, External Reference to the token is [" + kinfo.isExternalUriReference + "].");
                Tr.debug(tc, "Implied DKT, instance to a token is [" + kinfo._tokenInstance + "].");
            }
        }
        SecurityToken token = null;
        TokenConsumerConfig tconfig = config2.getTokenConsumer();
        if (tconfig != null) {
            token = CommonContentConsumer.invokeTokenConsumer(tokenElem, tconfig, context);
        }
        context.remove(Constants.WSSECURITY_KEYINFO_TYPE);
        context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey");
        if (kinfo._impliedDKNonce != null) {
            result.setIdInSubject(token.getId());
            kinfo._tokenReference = token.getId();
        }
        Key key = null;
        final SecurityToken stoken = token;
        if ("VerifyingKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = stoken.getKey(63);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".getKey", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7074E", e.getCause());
            }
        }
        if ("DecryptingKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = stoken.getKey(64);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".getKey", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7074E", e.getCause());
            }
        }
        if (isKeyAuditRequired) {
            Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(context, "TokenId", token.getId());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "TokenPrincipal", token.getPrincipal());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "KeyInfoType", kitype);
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "Algorithm", key.getAlgorithm());
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("Element target, Map type, Map context)");
            buf.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    public static final ResolvedKeyInfo resolveKeyInfo(OMElement elKinfo, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveKeyInfo(");
            buf.append("Element elKinfo[").append(DOMUtils.getDisplayName(elKinfo)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        ResolvedKeyInfo kinfo = null;
        OMElement el = DOMUtils.getFirstElement(elKinfo);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            if (nsWsse.equals(ns)) {
                if ("SecurityTokenReference".equals(ln)) {
                    kinfo = CommonContentConsumer.resolveSecurityTokenReference(el, wssVersion, nsWsse, nsWsu, context);
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elKinfo)});
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(ns)) {
                if ("KeyName".equals(ln)) {
                    String kname = DOMUtils.getStringValue(el);
                    if (kname == null) {
                        throw SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01");
                    }
                    kinfo = new ResolvedKeyInfo("KEYNAME");
                    kinfo._tokenName = kname;
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elKinfo)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elKinfo)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveKeyInfo(");
            buf.append("Element elKinfo, Map context)");
            buf.append(" returns ResolvedKeyInfo[").append(kinfo).append("]");
            Tr.exit(tc, buf.toString());
        }
        if (kinfo == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        return kinfo;
    }

    private static final ResolvedKeyInfo resolveSecurityTokenReference(OMElement elStr, int wssVersion, String nsWsse, String nsWsu, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveSecurityTokenReference(");
            buf.append("Element elStr[").append(DOMUtils.getDisplayName(elStr)).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("], ");
            buf.append("String nsWsu[").append(nsWsu).append("])");
            Tr.entry(tc, buf.toString());
        }
        ResolvedKeyInfo kinfo = null;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        String nonceStr = null;
        String lengthStr = null;
        OMElement el = DOMUtils.getFirstElement(elStr);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            if (nsWsse.equals(ns)) {
                if ("Reference".equals(ln)) {
                    String ref;
                    kinfo = new ResolvedKeyInfo("STRREF");
                    if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(el.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q))) {
                        nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
                    }
                    nonceStr = elStr.getAttributeValue(new QName(nsWsc, "Nonce"));
                    lengthStr = elStr.getAttributeValue(new QName(nsWsc, "Length"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Implied DKTs are in use, nonce = " + nonceStr + ", WSC Name Space = " + nsWsc);
                    }
                    if (nonceStr != null) {
                        context.put(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, nsWsc);
                        kinfo._impliedDKNonce = nonceStr;
                        kinfo._impliedDKLength = lengthStr;
                    }
                    if ((ref = DOMUtils.getAttribute(el, "URI")) == null) {
                        throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI02");
                    }
                    if (!ref.startsWith("#")) {
                        kinfo.setExternalUriReference(true);
                    }
                    kinfo.setTokenReference(ref);
                    String instance = el.getAttributeValue(new QName(nsWsc, "Instance"));
                    if (instance != null) {
                        kinfo._tokenInstance = instance;
                    }
                } else if ("KeyIdentifier".equals(ln)) {
                    String vtstr = DOMUtils.getAttribute(el, "ValueType");
                    if (vtstr == null) {
                        throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token16");
                    }
                    QName vtype = DOMUtils.getQName(el, vtstr, wssVersion);
                    QName etype = com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY;
                    String etstr = el.getAttributeValue(ENCODINGTYPE_Q);
                    if (etstr != null) {
                        etype = DOMUtils.getQName(el, etstr, wssVersion);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getEncodingType02"));
                    }
                    QName itype = com.ibm.ws.wssecurity.common.Constants.ITSHA1;
                    etstr = el.getAttributeValue(IDENTIFIERTYPE_Q);
                    if (etstr != null) {
                        itype = DOMUtils.getQName(el, etstr, wssVersion);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getIdentifierType01"));
                    }
                    String kid = DOMUtils.getStringValue(el);
                    if (com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.equals(vtype)) {
                        itype = com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1;
                        kinfo = new ResolvedKeyInfo("THUMBPRINT");
                    } else {
                        kinfo = new ResolvedKeyInfo("KEYID");
                    }
                    kinfo.setTokenId(kid);
                    kinfo._kidValueType = vtype;
                    kinfo._kidEncodingType = etype;
                    kinfo._kidIdentifierType = itype;
                    nonceStr = elStr.getAttributeValue(new QName(nsWsc, "Nonce"));
                    lengthStr = elStr.getAttributeValue(new QName(nsWsc, "Length"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Implied DKTs are in use, nonce = " + nonceStr + ", WSC Name Space = " + nsWsc);
                    }
                    if (nonceStr != null) {
                        context.put(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, nsWsc);
                        kinfo._impliedDKNonce = nonceStr;
                        kinfo._impliedDKLength = lengthStr;
                    }
                } else if ("Embedded".equals(ln)) {
                    OMElement et = DOMUtils.getFirstElement(el);
                    String eid = el.getAttributeValue(new QName(nsWsu, "Id"));
                    if (eid == null) {
                        throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
                    }
                    kinfo = new ResolvedKeyInfo("EMB");
                    kinfo._embeddedToken = et;
                    kinfo._tokenId = eid;
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elStr)});
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(ns)) {
                if ("X509Data".equals(ln)) {
                    String issuerSerial;
                    OMElement serial = DOMUtils.getOneChildElement(el, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509IssuerSerial");
                    if (serial == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    OMElement name = DOMUtils.getOneChildElement(serial, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509IssuerName");
                    if (name == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    OMElement number = DOMUtils.getOneChildElement(serial, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509SerialNumber");
                    if (number == null) {
                        throw SoapSecurityException.format("security.wssecurity.X509IssuerContentConsumer.getX509Data01");
                    }
                    String issuerName = DOMUtils.getStringValue(name);
                    String in = KeyInfo.X509Data.encodeDName(issuerName);
                    if (in != null) {
                        issuerName = in;
                    }
                    if ((issuerSerial = DOMUtils.getStringValue(number)) != null) {
                        try {
                            new BigInteger(issuerSerial);
                        }
                        catch (NumberFormatException nfee) {
                            try {
                                BigInteger bint = CertificateUtil.convertSerialNumber(issuerSerial);
                                issuerSerial = bint.toString();
                            }
                            catch (ParseException pe) {
                                throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", issuerSerial, (Throwable)pe);
                            }
                        }
                    }
                    kinfo = new ResolvedKeyInfo("X509ISSUER");
                    kinfo._x509issuerName = issuerName;
                    kinfo._x509issuerSerial = issuerSerial;
                } else {
                    Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elStr)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(elStr)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveSecurityTokenReference(");
            buf.append("Element elStr, int wssVersion, String nsWsse, String nsWsu)");
            buf.append(" returns ResolvedKeyInfo[").append(kinfo).append("]");
            Tr.exit(tc, buf.toString());
        }
        return kinfo;
    }

    private static final SecurityToken invokeTokenConsumer(OMElement target, TokenConsumerConfig tconfig, Map<Object, Object> context) throws SoapSecurityException {
        PrivateConsumerConfig.TokenConsumerConfImpl confImpl;
        TokenConsumerComponent tcon;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenConsumer(");
            buf.append("Element target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("TokenConsumerConfig config, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if ((tcon = (confImpl = (PrivateConsumerConfig.TokenConsumerConfImpl)tconfig).getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        context.put("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey", tconfig);
        tcon.invoke(target, context);
        SecurityToken token = (SecurityToken)context.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenConsumer(");
            buf.append("Element target, TokenConsumerConfig config, Map context)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    public static class ResolvedKeyInfo {
        private String _kitype;
        private String _tokenReference;
        private String _tokenId;
        private QName _kidValueType;
        private QName _kidEncodingType;
        private QName _kidIdentifierType;
        private String _tokenName;
        private OMElement _embeddedToken;
        private String _x509issuerName;
        private String _x509issuerSerial;
        private String _impliedDKNonce = null;
        private String _impliedDKLength = null;
        private boolean isExternalUriReference = false;
        private String _tokenInstance = null;

        public ResolvedKeyInfo(String kitype) {
            this._kitype = kitype;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ResolvedKeyInfo)) {
                return false;
            }
            ResolvedKeyInfo kinfo = (ResolvedKeyInfo)object;
            if (this._kitype == null ? kinfo._kitype != null : !this._kitype.equals(kinfo._kitype)) {
                return false;
            }
            if (this._tokenReference == null ? kinfo._tokenReference != null : !this._tokenReference.equals(kinfo._tokenReference)) {
                return false;
            }
            if (this._tokenId == null ? kinfo._tokenId != null : !this._tokenId.equals(kinfo._tokenId)) {
                return false;
            }
            if (this._kidValueType == null ? kinfo._kidValueType != null : !this._kidValueType.equals(kinfo._kidValueType)) {
                return false;
            }
            if (this._kidEncodingType == null ? kinfo._kidEncodingType != null : !this._kidEncodingType.equals(kinfo._kidEncodingType)) {
                return false;
            }
            if (this._kidIdentifierType == null ? kinfo._kidIdentifierType != null : !this._kidIdentifierType.equals(kinfo._kidIdentifierType)) {
                return false;
            }
            if (this._tokenName == null ? kinfo._tokenName != null : !this._tokenName.equals(kinfo._tokenName)) {
                return false;
            }
            if (this._embeddedToken == null ? kinfo._embeddedToken != null : !this._embeddedToken.equals(kinfo._embeddedToken)) {
                return false;
            }
            if (this._x509issuerName == null ? kinfo._x509issuerName != null : !this._x509issuerName.equals(kinfo._x509issuerName)) {
                return false;
            }
            if (this._x509issuerSerial == null ? kinfo._x509issuerSerial != null : !this._x509issuerSerial.equals(kinfo._x509issuerSerial)) {
                return false;
            }
            if (this._impliedDKNonce == null ? kinfo._impliedDKNonce != null : !this._impliedDKNonce.equals(kinfo._impliedDKNonce)) {
                return false;
            }
            if (this._impliedDKLength == null ? kinfo._impliedDKLength != null : !this._impliedDKLength.equals(kinfo._impliedDKLength)) {
                return false;
            }
            if (!Boolean.valueOf(this.isExternalUriReference).equals(kinfo.isExternalUriReference)) {
                return false;
            }
            return !(this._tokenInstance == null ? kinfo._tokenInstance != null : !this._tokenInstance.equals(kinfo._tokenInstance));
        }

        public final String getKitype() {
            return this._kitype;
        }

        public void setKitype(String _kitype) {
            this._kitype = _kitype;
        }

        public final String getTokenReference() {
            return this._tokenReference;
        }

        public final String getTokenInstance() {
            return this._tokenReference;
        }

        public void setTokenInstance(String instance) {
            this._tokenInstance = instance;
        }

        public final boolean isExtenalUriReference() {
            return this.isExternalUriReference;
        }

        public final void setExternalUriReference(boolean refuri) {
            this.isExternalUriReference = refuri;
        }

        public void setTokenReference(String ref) {
            if (ref != null && ref.startsWith("#")) {
                ref = ref.substring(1);
            }
            this._tokenReference = ref;
        }

        public final String getTokenId() {
            return this._tokenId;
        }

        public void setTokenId(String id) {
            if (id != null && id.length() > 0) {
                id = id.trim();
            }
            this._tokenId = id;
        }

        public final QName getKidValueType() {
            return this._kidValueType;
        }

        public void setKidValueType(QName valueType) {
            this._kidValueType = valueType;
        }

        public final QName getKidEncodingType() {
            return this._kidEncodingType;
        }

        public void setKidEncodingType(QName encodingType) {
            this._kidEncodingType = encodingType;
        }

        public final QName getKidIdentifierType() {
            return this._kidIdentifierType;
        }

        public void setKidIdentifierType(QName identifierType) {
            this._kidIdentifierType = identifierType;
        }

        public final String geTtokenName() {
            return this._tokenName;
        }

        public void setTokenName(String name) {
            this._tokenName = name;
        }

        public final OMElement getEmbeddedToken() {
            return this._embeddedToken;
        }

        public void setEmbeddedToken(OMElement token) {
            this._embeddedToken = token;
        }

        public final String getX509issuerName() {
            return this._x509issuerName;
        }

        public void setX509issuerName(String name) {
            this._x509issuerName = name;
        }

        public final String getX509issuerSerial() {
            return this._x509issuerSerial;
        }

        public void setX509issuerSerial(String serial) {
            this._x509issuerSerial = serial;
        }

        public final String getImpliedDKNonce() {
            return this._impliedDKNonce;
        }

        public void setImpliedDKNonce(String nonce) {
            this._impliedDKNonce = nonce;
        }

        public final String getImpliedDKLength() {
            return this._impliedDKLength;
        }

        public void setImpliedDKLength(String length) {
            this._impliedDKLength = length;
        }
    }
}

