/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class BinaryHeap {
    private Comparable[] heapArray;
    private static final int DEFAULT_SIZE = 1024;
    private int heapSize;
    boolean memoryIsTight;
    private static final TraceComponent tc = Tr.register(BinaryHeap.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public BinaryHeap(Comparable negInfinity) {
        this.heapArray = new Comparable[1024];
        this.heapArray[0] = negInfinity;
        this.heapSize = 0;
        this.memoryIsTight = false;
    }

    private BinaryHeap(BinaryHeap heap) {
        this.heapArray = new Comparable[heap.heapSize + 1];
        System.arraycopy(heap.heapArray, 0, this.heapArray, 0, this.heapArray.length);
        this.heapSize = this.heapArray.length - 1;
        this.memoryIsTight = false;
    }

    public void insert(Comparable el) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{el, this});
        }
        ++this.heapSize;
        int i = this.heapSize--;
        try {
            this.growIfNec();
        }
        catch (OutOfMemoryError e) {
            this.memoryIsTight = true;
            throw e;
        }
        while (el.compareTo(this.heapArray[BinaryHeap.parent(i)]) < 0) {
            this.heapArray[i] = this.heapArray[BinaryHeap.parent(i)];
            i = BinaryHeap.parent(i);
        }
        this.heapArray[i] = el;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    public final Comparable minimum() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "minimum", this);
        }
        if (this.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "minimum", null);
            }
            return null;
        }
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "minimum");
        }
        return this.heapArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Comparable deleteMin() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteMin", this);
        }
        Comparable[] comparableArray = this.heapArray;
        synchronized (this.heapArray) {
            Comparable min;
            if (this.isEmpty()) {
                min = null;
            } else {
                Comparable last = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    min = last;
                } else {
                    min = this.heapArray[1];
                    this.heapArray[1] = last;
                    this.heapify(1);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteMin", min);
            }
            return min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Comparable el) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", new Object[]{el, this});
        }
        Comparable[] comparableArray = this.heapArray;
        synchronized (this.heapArray) {
            int i = this.findKey(el);
            if (i >= 0) {
                this.heapArray[i] = this.heapArray[0];
                this.percolateUp(i);
                this.deleteMin();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
            return;
        }
    }

    private int findKey(Comparable c) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKey", new Object[]{c, this});
        }
        for (int i = 1; i <= this.heapSize; ++i) {
            if (!this.heapArray[i].equals(c)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findKey", new Integer(i));
            }
            return i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKey", "-1");
        }
        return -1;
    }

    private void percolateUp(int i) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "percolateUp");
        }
        while (this.heapArray[i].compareTo(this.heapArray[BinaryHeap.parent(i)]) < 0) {
            int j = BinaryHeap.parent(i);
            Comparable c = this.heapArray[j];
            this.heapArray[j] = this.heapArray[i];
            this.heapArray[i] = c;
            int prev = i;
            i = j;
            this.heapify(prev);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "percolateUp");
        }
    }

    private final void heapify(int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "heapify", new Object[]{new Integer(i), this});
        }
        Comparable tmp = this.heapArray[i];
        while (BinaryHeap.left(i) <= this.heapSize) {
            int l = BinaryHeap.left(i);
            if (l < this.heapSize && this.heapArray[BinaryHeap.right(i)].compareTo(this.heapArray[l]) < 0) {
                ++l;
            }
            if (this.heapArray[l].compareTo(tmp) >= 0) break;
            this.heapArray[i] = this.heapArray[l];
            i = l;
        }
        this.heapArray[i] = tmp;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "heapify");
        }
    }

    void buildHeap(Comparable[] unHeap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildHeap", new Object[]{unHeap, this});
        }
        for (int i = unHeap.length; i > 1; --i) {
            this.heapify(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildHeap");
        }
    }

    public Enumeration elements() {
        return new BinaryHeapEnumeration(this);
    }

    public final boolean isEmpty() {
        return this.heapSize == 0;
    }

    public final int size() {
        return this.heapSize;
    }

    private static final int parent(int i) {
        return i / 2;
    }

    private static final int left(int i) {
        return 2 * i;
    }

    private static final int right(int i) {
        return 2 * i + 1;
    }

    private void growIfNec() {
        if (this.heapSize + 1 == this.heapArray.length) {
            Comparable[] oldHeap = this.heapArray;
            int newSize = 0;
            newSize = this.memoryIsTight || this.heapSize > 10000 ? this.heapSize * 110 / 100 : this.heapSize * 2;
            this.heapArray = new Comparable[newSize];
            System.arraycopy(oldHeap, 0, this.heapArray, 0, oldHeap.length);
        }
    }

    private class BinaryHeapEnumeration
    implements Enumeration {
        private BinaryHeap theHeap;

        private BinaryHeapEnumeration(BinaryHeap h) {
            this.theHeap = new BinaryHeap(h);
        }

        @Override
        public boolean hasMoreElements() {
            return !this.theHeap.isEmpty();
        }

        public Object nextElement() {
            if (this.theHeap.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.theHeap.deleteMin();
        }
    }
}

