/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.ThreadPool;
import com.ibm.ws.wssecurity.util.timer._Alarm;

class AlarmThreadPool
extends ThreadPool {
    private static final TraceComponent tc = Tr.register(AlarmThreadPool.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static int minPoolSize = 1;
    private static int maxPoolSize = 4;
    private static int idleTimeout = 90000;

    AlarmThreadPool() {
        super("Alarm", minPoolSize, maxPoolSize);
        this.setKeepAliveTime(idleTimeout);
    }

    AlarmThreadPool(String threadPoolName) {
        super(threadPoolName, minPoolSize, maxPoolSize);
        this.setKeepAliveTime(idleTimeout);
    }

    public void fireAlarm(_Alarm alarm) {
        Tr.entry(tc, "firing alarm", alarm);
        try {
            this.execute(alarm);
        }
        catch (Throwable ex) {
            Tr.warning(tc, "Encountered a failure in the fireAlarm method {0}", ex);
        }
        Tr.exit(tc, "alarm fired");
    }
}

