/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import com.ibm.ws.wssecurity.util.timer.AlarmThreadPool;
import com.ibm.ws.wssecurity.util.timer.BinaryHeap;
import com.ibm.ws.wssecurity.util.timer._Alarm;

class AlarmManagerThread
implements Runnable {
    private static final TraceComponent tc = Tr.register(AlarmManagerThread.class, null, null);
    BinaryHeap alarmQ;
    boolean deferredAlarms = false;
    String alarmThreadPoolName;

    AlarmManagerThread(BinaryHeap _AlarmQ, boolean runDeferred) {
        this.alarmQ = _AlarmQ;
        this.deferredAlarms = runDeferred;
    }

    AlarmManagerThread(BinaryHeap _AlarmQ, boolean runDeferred, String alarmThrPoolName) {
        this.alarmQ = _AlarmQ;
        this.deferredAlarms = runDeferred;
        this.alarmThreadPoolName = alarmThrPoolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AlarmThreadPool alarmThreadPool = new AlarmThreadPool(this.alarmThreadPoolName);
        while (true) {
            try {
                while (true) {
                    _Alarm next = null;
                    BinaryHeap binaryHeap = this.alarmQ;
                    synchronized (binaryHeap) {
                        next = null;
                        if (this.alarmQ.isEmpty()) {
                            this.alarmQ.wait();
                        } else {
                            next = (_Alarm)this.alarmQ.minimum();
                            long delta = next.expirationTime - System.currentTimeMillis();
                            if (delta <= 0L) {
                                this.alarmQ.deleteMin();
                                next.fired = true;
                            } else {
                                next = null;
                                if (!this.deferredAlarms || AlarmManager.getActiveWork() > 0) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alarm manager thread waiting", new Long(delta));
                                    }
                                    this.alarmQ.wait(delta);
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alarm Manager waiting for next server work request");
                                    }
                                    this.alarmQ.wait();
                                }
                            }
                        }
                    }
                    if (next == null) continue;
                    alarmThreadPool.fireAlarm(next);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

