/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;

public class MultipleInputStream
extends InputStream {
    private static final TraceComponent tc = Tr.register(MultipleInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected int current;
    protected InputStream[] inputStreamArray;

    public MultipleInputStream(InputStream[] inputStreamArray) {
        if (inputStreamArray == null) {
            throw new NullPointerException();
        }
        if (inputStreamArray.length == 0) {
            this.current = 0;
        }
        this.inputStreamArray = inputStreamArray;
        this.current = inputStreamArray.length;
        for (int i = 0; i < inputStreamArray.length; ++i) {
            if (inputStreamArray[i] == null) continue;
            this.current = i;
            break;
        }
    }

    private int readNextInputStream() throws IOException {
        int b = -1;
        for (int i = this.current; i < this.inputStreamArray.length; ++i) {
            if (this.inputStreamArray[i] == null) continue;
            this.current = i;
            b = this.inputStreamArray[this.current].read();
            if (b < 0) continue;
            return b;
        }
        return -1;
    }

    private int readByteNextInputStream(byte[] b, int off, int len) throws IOException {
        int count = -1;
        for (int i = this.current; i < this.inputStreamArray.length; ++i) {
            if (this.inputStreamArray[i] == null) continue;
            this.current = i;
            count = this.inputStreamArray[this.current].read(b, off, len);
            if (count < 0) continue;
            return count;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.current >= this.inputStreamArray.length) {
            return -1;
        }
        int b = this.inputStreamArray[this.current].read();
        if (b >= 0) {
            return b;
        }
        return this.readNextInputStream();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.current >= this.inputStreamArray.length) {
            return -1;
        }
        int count = 0;
        int total = 0;
        int offset = off;
        int length = 0;
        boolean keep_reading = true;
        do {
            offset = off + (total += count);
            length = len - total;
            if (length > 0) {
                count = this.inputStreamArray[this.current].read(b, offset, length);
                continue;
            }
            keep_reading = false;
        } while (count > 0 && keep_reading);
        if (total == 0 && count < 0) {
            total = count;
        }
        if (total >= 0) {
            return total;
        }
        return this.readByteNextInputStream(b, off, len);
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.inputStreamArray.length; ++i) {
            if (this.inputStreamArray[i] == null) continue;
            this.inputStreamArray[i].close();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public final int getCurrent() {
        return this.current;
    }

    public final InputStream[] getInputStreamArray() {
        return this.inputStreamArray;
    }
}

