/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public final class ByteArrayHolder {
    private static final TraceComponent tc = Tr.register(ByteArrayHolder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private byte[] value;
    private int offset;
    private final int length;
    private String description;

    public ByteArrayHolder(byte[] value) {
        this(value, 0, value.length);
    }

    public ByteArrayHolder(byte[] value, int offset, int length) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is minus.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is minus.");
        }
        if (offset + length > value.length) {
            throw new IllegalArgumentException("length is longer than value size, or offset is wrong. (offset + length > value.length)");
        }
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public final byte[] getValue() {
        return this.value;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final byte[] toByteArray() {
        if (this.offset == 0 && this.length == this.value.length) {
            return this.value;
        }
        byte[] ret = new byte[this.length];
        System.arraycopy(this.value, this.offset, ret, 0, this.length);
        this.value = ret;
        this.offset = 0;
        return ret;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByteArrayHolder) {
            ByteArrayHolder bah = (ByteArrayHolder)object;
            if (this.length != bah.getLength()) {
                return false;
            }
            int offset2 = bah.getOffset();
            byte[] value2 = bah.getValue();
            if (this.value == value2 && this.offset == offset2) {
                return true;
            }
            int offset1 = this.offset;
            for (int i = 0; i < this.length; ++i) {
                if (this.value[offset1++] == value2[offset2++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.value, this.offset, this.length);
    }
}

