/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public class Base64Table {
    private static final TraceComponent tc;
    private static final boolean DEBUG = false;
    private static final String EXCEPTION_STR_0 = "Specified length or offset is bad.";
    private static final String EXCEPTION_STR_1 = "Bad character exits in Base64 array";
    private static final String EXCEPTION_STR_3 = "Length of output byte array is short";
    private static final String EXCEPTION_STR_4 = "Input length not multiple of 4 bytes/chars";
    private static final byte[] LENGTH0_BYTE;
    private static final char[] LENGTH0_CHAR;
    private static final String LENGTH0_STRING = "";
    private static final char S_BASE64PAD = '=';
    private static final int[] INDEX_TABLE;
    private static final int BADCHAR_INDEX = -1;
    private static final int PAD_INDEX = 64;
    private static final byte[][] A12toB0table;
    private static final byte[][] A23toB1table;
    private static final byte[][] A34toB2table;
    private static final char[] S_BASE64CHAR;
    private static final byte[] S_BASE64BYTE;

    protected static final int getEncodedBlockSize(int encodedLength) {
        int rem = encodedLength % 4;
        if (rem != 0) {
            throw new RuntimeException(EXCEPTION_STR_4);
        }
        int blockSize = encodedLength / 4;
        return blockSize;
    }

    protected static final int estimateDecodedSize(int blockSize, int lastchar, int secondlastchar) {
        int obufSizeEstimated = blockSize * 3;
        if (lastchar == 61) {
            obufSizeEstimated = blockSize * 3 - 1;
        }
        if (secondlastchar == 61) {
            obufSizeEstimated = blockSize * 3 - 2;
        }
        return obufSizeEstimated;
    }

    public static final byte[] decode(String base64String, int off, int length) {
        if (off + length > base64String.length()) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return LENGTH0_BYTE;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64String.charAt(off + length - 1), base64String.charAt(off + length - 2));
        byte[] obuf = new byte[obufSizeEstimated];
        int obufCount = Base64Table.decode0(base64String, off, blockSize, obuf, 0);
        byte[] ret = null;
        if (obufCount == obuf.length) {
            ret = obuf;
        } else {
            ret = new byte[obufCount];
            System.arraycopy(obuf, 0, ret, 0, obufCount);
        }
        return ret;
    }

    public static final byte[] decode(char[] base64char, int off, int length) {
        if (off + length > base64char.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return LENGTH0_BYTE;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64char[off + length - 1], base64char[off + length - 2]);
        byte[] obuf = new byte[obufSizeEstimated];
        int obufCount = Base64Table.decode0(base64char, off, blockSize, obuf, 0);
        byte[] ret = null;
        if (obufCount == obuf.length) {
            ret = obuf;
        } else {
            ret = new byte[obufCount];
            System.arraycopy(obuf, 0, ret, 0, obufCount);
        }
        return ret;
    }

    public static final byte[] decode(byte[] base64byte, int off, int length) {
        if (off + length > base64byte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return LENGTH0_BYTE;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64byte[off + length - 1], base64byte[off + length - 2]);
        byte[] obuf = new byte[obufSizeEstimated];
        int obufCount = Base64Table.decode0(base64byte, off, blockSize, obuf, 0);
        byte[] ret = null;
        if (obufCount == obuf.length) {
            ret = obuf;
        } else {
            ret = new byte[obufCount];
            System.arraycopy(obuf, 0, ret, 0, obufCount);
        }
        return ret;
    }

    public static final int decode(String base64String, int off, int length, byte[] outbuf, int outbuffoff) {
        if (off + length > base64String.length()) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return 0;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64String.charAt(off + length - 1), base64String.charAt(off + length - 2));
        if (obufSizeEstimated > outbuf.length - outbuffoff) {
            throw new RuntimeException("Out buffer size is not enourgh.");
        }
        int obufCount = Base64Table.decode0(base64String, off, blockSize, outbuf, outbuffoff);
        return obufCount;
    }

    public static final int decode(char[] base64char, int off, int length, byte[] outbuf, int outbuffoff) {
        if (off + length > base64char.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return 0;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64char[off + length - 1], base64char[off + length - 2]);
        if (obufSizeEstimated > outbuf.length - outbuffoff) {
            throw new RuntimeException("Out buffer size is not enourgh.");
        }
        int obufCount = Base64Table.decode0(base64char, off, blockSize, outbuf, outbuffoff);
        return obufCount;
    }

    public static final int decode(byte[] base64byte, int off, int length, byte[] outbuf, int outbuffoff) {
        if (off + length > base64byte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        if (length < 4) {
            return 0;
        }
        int blockSize = Base64Table.getEncodedBlockSize(length);
        int obufSizeEstimated = Base64Table.estimateDecodedSize(blockSize, base64byte[off + length - 1], base64byte[off + length - 2]);
        if (obufSizeEstimated > outbuf.length - outbuffoff) {
            throw new RuntimeException("Out buffer size is not enourgh.");
        }
        int obufCount = Base64Table.decode0(base64byte, off, blockSize, outbuf, outbuffoff);
        return obufCount;
    }

    private static final int decode0(String base64String, int off, int blockSize, byte[] obuf, int outoff) {
        int base64charCount = off;
        int obufCount = outoff;
        int i0 = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        try {
            block7: for (int i = 0; i < blockSize; ++i) {
                i0 = INDEX_TABLE[base64String.charAt(base64charCount++)];
                i1 = INDEX_TABLE[base64String.charAt(base64charCount++)];
                i2 = INDEX_TABLE[base64String.charAt(base64charCount++)];
                i3 = INDEX_TABLE[base64String.charAt(base64charCount++)];
                int outlen = i2 == 64 ? 1 : (i3 == 64 ? 2 : 3);
                switch (outlen) {
                    case 1: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        continue block7;
                    }
                    case 2: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        continue block7;
                    }
                    case 3: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        obuf[obufCount++] = A34toB2table[i2][i3];
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (base64String.charAt(base64charCount) >= INDEX_TABLE.length) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (i0 < 0 || i1 < 0 || i2 < 0 || i3 < 0) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (obufCount >= obuf.length) {
                throw new RuntimeException(EXCEPTION_STR_3, e);
            }
            throw e;
        }
        return obufCount -= outoff;
    }

    private static final int decode0(byte[] base64byte, int off, int blockSize, byte[] obuf, int outoff) {
        int base64charCount = off;
        int obufCount = outoff;
        int i0 = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        try {
            block7: for (int i = 0; i < blockSize; ++i) {
                i0 = INDEX_TABLE[base64byte[base64charCount++]];
                i1 = INDEX_TABLE[base64byte[base64charCount++]];
                i2 = INDEX_TABLE[base64byte[base64charCount++]];
                i3 = INDEX_TABLE[base64byte[base64charCount++]];
                int outlen = i2 == 64 ? 1 : (i3 == 64 ? 2 : 3);
                switch (outlen) {
                    case 1: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        continue block7;
                    }
                    case 2: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        continue block7;
                    }
                    case 3: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        obuf[obufCount++] = A34toB2table[i2][i3];
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (base64byte[base64charCount] >= INDEX_TABLE.length) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (i0 < 0 || i1 < 0 || i2 < 0 || i3 < 0) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (obufCount >= obuf.length) {
                throw new RuntimeException(EXCEPTION_STR_3, e);
            }
            throw e;
        }
        return obufCount -= outoff;
    }

    private static final int decode0(char[] base64char, int off, int blockSize, byte[] obuf, int outoff) {
        int base64charCount = off;
        int obufCount = outoff;
        int i0 = 0;
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        try {
            block7: for (int i = 0; i < blockSize; ++i) {
                i0 = INDEX_TABLE[base64char[base64charCount++]];
                i1 = INDEX_TABLE[base64char[base64charCount++]];
                i2 = INDEX_TABLE[base64char[base64charCount++]];
                i3 = INDEX_TABLE[base64char[base64charCount++]];
                int outlen = i2 == 64 ? 1 : (i3 == 64 ? 2 : 3);
                switch (outlen) {
                    case 1: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        continue block7;
                    }
                    case 2: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        continue block7;
                    }
                    case 3: {
                        obuf[obufCount++] = A12toB0table[i0][i1];
                        obuf[obufCount++] = A23toB1table[i1][i2];
                        obuf[obufCount++] = A34toB2table[i2][i3];
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (base64char[base64charCount] >= INDEX_TABLE.length) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (i0 < 0 || i1 < 0 || i2 < 0 || i3 < 0) {
                throw new RuntimeException(EXCEPTION_STR_1, e);
            }
            if (obufCount >= obuf.length) {
                throw new RuntimeException(EXCEPTION_STR_3, e);
            }
            throw e;
        }
        return obufCount -= outoff;
    }

    public static final byte[] encode(byte[] rawbyte, int off, int length) {
        if (length <= 0) {
            return LENGTH0_BYTE;
        }
        if (off + length > rawbyte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        int blockSize = length / 3;
        int remSize = length % 3;
        int obufSize = remSize > 0 ? blockSize * 4 + 4 : blockSize * 4;
        byte[] obuff = new byte[obufSize];
        Base64Table.encode0(rawbyte, off, obuff, 0, blockSize, remSize);
        return obuff;
    }

    public static final int encode(byte[] rawbyte, int off, int length, byte[] outbuf, int outbufoff) {
        int obufSize;
        if (length == 0) {
            return 0;
        }
        if (off + length > rawbyte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        int blockSize = length / 3;
        int remSize = length % 3;
        int n = obufSize = remSize > 0 ? blockSize * 4 + 4 : blockSize * 4;
        if (outbufoff + obufSize > outbuf.length) {
            throw new RuntimeException(EXCEPTION_STR_3);
        }
        int obufCount = Base64Table.encode0(rawbyte, off, outbuf, outbufoff, blockSize, remSize);
        return obufCount;
    }

    public static final char[] encodeToCharArray(byte[] rawbyte, int off, int length) {
        if (length == 0) {
            return LENGTH0_CHAR;
        }
        if (off + length > rawbyte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        int blockSize = length / 3;
        int remSize = length % 3;
        int obufSize = remSize > 0 ? blockSize * 4 + 4 : blockSize * 4;
        char[] obuff = new char[obufSize];
        Base64Table.encodeToChararray0(rawbyte, off, obuff, 0, blockSize, remSize);
        return obuff;
    }

    public static final int encodeToCharArray(byte[] rawbyte, int off, int length, char[] outbuf, int outbufoff) {
        int obufSize;
        if (length == 0) {
            return 0;
        }
        if (off + length > rawbyte.length) {
            throw new RuntimeException(EXCEPTION_STR_0);
        }
        int blockSize = length / 3;
        int remSize = length % 3;
        int n = obufSize = remSize > 0 ? blockSize * 4 + 4 : blockSize * 4;
        if (outbufoff + obufSize > outbuf.length) {
            throw new RuntimeException(EXCEPTION_STR_3);
        }
        int obufCount = Base64Table.encodeToChararray0(rawbyte, off, outbuf, outbufoff, blockSize, remSize);
        return obufCount;
    }

    public static final String encodeToString(byte[] rawbyte, int off, int length) {
        char[] obuf = Base64Table.encodeToCharArray(rawbyte, off, length);
        return new String(obuf, 0, obuf.length);
    }

    private static final int encode0(byte[] rawbyte, int off, byte[] outbuf, int outbufoff, int blockSize, int remSize) {
        int rawByteCount = off;
        int outbufCount = outbufoff;
        for (int i = 0; i < blockSize; ++i) {
            int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + ((rawbyte[rawByteCount++] & 0xFF) << 8) + (rawbyte[rawByteCount++] & 0xFF);
            outbuf[outbufCount++] = S_BASE64BYTE[all >> 18];
            outbuf[outbufCount++] = S_BASE64BYTE[all >> 12 & 0x3F];
            outbuf[outbufCount++] = S_BASE64BYTE[all >> 6 & 0x3F];
            outbuf[outbufCount++] = S_BASE64BYTE[all & 0x3F];
        }
        switch (remSize) {
            case 1: {
                int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + 0 + 0;
                outbuf[outbufCount++] = S_BASE64BYTE[all >> 18];
                outbuf[outbufCount++] = S_BASE64BYTE[all >> 12 & 0x3F];
                outbuf[outbufCount++] = 61;
                outbuf[outbufCount++] = 61;
                break;
            }
            case 2: {
                int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + ((rawbyte[rawByteCount++] & 0xFF) << 8) + 0;
                outbuf[outbufCount++] = S_BASE64BYTE[all >> 18];
                outbuf[outbufCount++] = S_BASE64BYTE[all >> 12 & 0x3F];
                outbuf[outbufCount++] = S_BASE64BYTE[all >> 6 & 0x3F];
                outbuf[outbufCount++] = 61;
                break;
            }
        }
        return outbufCount;
    }

    private static final int encodeToChararray0(byte[] rawbyte, int off, char[] outbuf, int outbufoff, int blockSize, int remSize) {
        int rawByteCount = off;
        int outbufCount = outbufoff;
        for (int i = 0; i < blockSize; ++i) {
            int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + ((rawbyte[rawByteCount++] & 0xFF) << 8) + (rawbyte[rawByteCount++] & 0xFF);
            outbuf[outbufCount++] = S_BASE64CHAR[all >> 18];
            outbuf[outbufCount++] = S_BASE64CHAR[all >> 12 & 0x3F];
            outbuf[outbufCount++] = S_BASE64CHAR[all >> 6 & 0x3F];
            outbuf[outbufCount++] = S_BASE64CHAR[all & 0x3F];
        }
        switch (remSize) {
            case 1: {
                int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + 0 + 0;
                outbuf[outbufCount++] = S_BASE64CHAR[all >> 18];
                outbuf[outbufCount++] = S_BASE64CHAR[all >> 12 & 0x3F];
                outbuf[outbufCount++] = 61;
                outbuf[outbufCount++] = 61;
                break;
            }
            case 2: {
                int all = ((rawbyte[rawByteCount++] & 0xFF) << 16) + ((rawbyte[rawByteCount++] & 0xFF) << 8) + 0;
                outbuf[outbufCount++] = S_BASE64CHAR[all >> 18];
                outbuf[outbufCount++] = S_BASE64CHAR[all >> 12 & 0x3F];
                outbuf[outbufCount++] = S_BASE64CHAR[all >> 6 & 0x3F];
                outbuf[outbufCount++] = 61;
                break;
            }
        }
        return outbufCount;
    }

    static {
        int j;
        int i;
        int i2;
        int i3;
        tc = Tr.register(Base64Table.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        LENGTH0_BYTE = new byte[0];
        LENGTH0_CHAR = new char[0];
        S_BASE64CHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
        char maxChar = 'a';
        byte[] S_DECODETABLE = new byte[128];
        for (i3 = 0; i3 < S_DECODETABLE.length; ++i3) {
            S_DECODETABLE[i3] = 127;
        }
        for (i3 = 0; i3 < S_BASE64CHAR.length; ++i3) {
            S_DECODETABLE[Base64Table.S_BASE64CHAR[i3]] = (byte)i3;
            if (maxChar >= S_BASE64CHAR[i3]) continue;
            maxChar = S_BASE64CHAR[i3];
        }
        S_DECODETABLE[61] = 127;
        int checkTableSize = maxChar + 1;
        INDEX_TABLE = new int[checkTableSize];
        for (i2 = 0; i2 < INDEX_TABLE.length; ++i2) {
            Base64Table.INDEX_TABLE[i2] = -1;
        }
        for (i2 = 0; i2 < S_BASE64CHAR.length; ++i2) {
            Base64Table.INDEX_TABLE[Base64Table.S_BASE64CHAR[i2]] = S_DECODETABLE[S_BASE64CHAR[i2]];
        }
        Base64Table.INDEX_TABLE[61] = 64;
        int tableSize = 65;
        A12toB0table = new byte[tableSize][tableSize];
        A23toB1table = new byte[tableSize][tableSize];
        A34toB2table = new byte[tableSize][tableSize];
        for (i = 0; i < tableSize; ++i) {
            for (j = 0; j < tableSize; ++j) {
                Base64Table.A12toB0table[i][j] = 127;
                Base64Table.A23toB1table[i][j] = 127;
                Base64Table.A34toB2table[i][j] = 127;
            }
        }
        for (i = 0; i < S_BASE64CHAR.length; ++i) {
            for (j = 0; j < S_BASE64CHAR.length; ++j) {
                char a0 = S_BASE64CHAR[i];
                char a1 = S_BASE64CHAR[j];
                int i0 = INDEX_TABLE[a0];
                int i1 = INDEX_TABLE[a1];
                byte b0 = S_DECODETABLE[a0];
                byte b1 = S_DECODETABLE[a1];
                Base64Table.A12toB0table[i0][i1] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                Base64Table.A23toB1table[i0][i1] = (byte)(b0 << 4 & 0xF0 | b1 >> 2 & 0xF);
                Base64Table.A34toB2table[i0][i1] = (byte)(b0 << 6 & 0xC0 | b1 & 0x3F);
            }
        }
        S_BASE64BYTE = new byte[S_BASE64CHAR.length];
        for (i = 0; i < S_BASE64CHAR.length; ++i) {
            Base64Table.S_BASE64BYTE[i] = (byte)S_BASE64CHAR[i];
        }
    }
}

