/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import java.io.IOException;
import java.io.OutputStream;

public class Base64EncodeOutputStream
extends OutputStream {
    private static final TraceComponent tc = Tr.register(Base64EncodeOutputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final boolean DEBUG = false;
    public static int DEFAULT_BUFFER_SIZE = 384;
    protected byte[] buffEncoded;
    protected byte[] buffRawData;
    protected int countRawData;
    protected boolean finished;
    protected OutputStream out;

    public Base64EncodeOutputStream(OutputStream out) {
        this(out, DEFAULT_BUFFER_SIZE);
    }

    public Base64EncodeOutputStream(OutputStream out, int rawdataBuffersize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, Base64EncodeOutputStream.class.getSimpleName() + "(" + "OutputStream out=" + out + " int rawdataBuffersize=" + rawdataBuffersize + ")");
        }
        if (rawdataBuffersize < 3) {
            rawdataBuffersize = DEFAULT_BUFFER_SIZE;
        }
        int blockSize = rawdataBuffersize / 3;
        int encodedBufferSize = blockSize * 4;
        rawdataBuffersize = blockSize * 3;
        this.buffRawData = new byte[rawdataBuffersize];
        this.buffEncoded = new byte[encodedBufferSize];
        this.reset(out);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64EncodeOutputStream.class.getSimpleName() + "(" + "OutputStream out=" + out + " int rawdataBuffersize=" + rawdataBuffersize + ")");
        }
    }

    public void reset(OutputStream out) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, Base64EncodeOutputStream.class.getSimpleName() + ".reset(" + "OutputStream out=" + out + ")");
        }
        this.out = out;
        this.finished = false;
        this.countRawData = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64EncodeOutputStream.class.getSimpleName() + ".reset(" + "OutputStream out=" + out + ")");
        }
    }

    public void forceFlush() throws IOException {
        if (tc.isEntryEnabled()) {
            int rem = this.countRawData % 3;
            Tr.entry(tc, Base64EncodeOutputStream.class.getSimpleName() + ".forceFlush()" + ", countRawData=" + this.countRawData + ", countRawData%3=" + rem + ", flushWithPadding=" + (rem != 0));
        }
        this.encode();
        this.out.flush();
        this.finished = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64EncodeOutputStream.class.getSimpleName() + ".forceFlush()" + ", countRawData=" + this.countRawData);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.countRawData > 0 && this.countRawData % 3 == 0) {
            this.encode();
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, Base64EncodeOutputStream.class.getSimpleName() + ".close()" + ", OutputStream out=" + this.out);
        }
        this.forceFlush();
        this.out.close();
        this.buffEncoded = null;
        this.buffRawData = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64EncodeOutputStream.class.getSimpleName() + ".close()" + ", OutputStream out=" + this.out);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.finished) {
            throw new IOException(Base64EncodeOutputStream.class.getSimpleName() + " has been already closed.");
        }
        if (this.countRawData >= this.buffRawData.length) {
            this.encode();
        }
        this.buffRawData[this.countRawData++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IOException(Base64EncodeOutputStream.class.getSimpleName() + " has been already closed.");
        }
        if (this.countRawData >= this.buffRawData.length) {
            this.encode();
        }
        int encodedCount = 0;
        if (len > this.buffRawData.length - this.countRawData) {
            encodedCount = this.buffRawData.length - this.countRawData;
            System.arraycopy(b, off, this.buffRawData, this.countRawData, encodedCount);
            this.countRawData = this.buffRawData.length;
            this.encode();
        }
        while (len - encodedCount > this.buffRawData.length) {
            int countEncoded = Base64Table.encode(b, off + encodedCount, this.buffRawData.length, this.buffEncoded, 0);
            this.out.write(this.buffEncoded, 0, countEncoded);
            this.countRawData = 0;
            encodedCount += this.buffRawData.length;
        }
        System.arraycopy(b, off + encodedCount, this.buffRawData, this.countRawData, len - encodedCount);
        this.countRawData += len - encodedCount;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    protected void encode() throws IOException {
        if (this.countRawData > 0) {
            int countEncoded = Base64Table.encode(this.buffRawData, 0, this.countRawData, this.buffEncoded, 0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, Base64EncodeOutputStream.class.getSimpleName() + ".encode(), encoded=" + new String(this.buffEncoded, 0, countEncoded));
            }
            this.out.write(this.buffEncoded, 0, countEncoded);
            this.countRawData = 0;
        }
    }
}

