/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.dsig.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPathTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;

public class XPathElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(XPathElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XPathElementSelector.class.getName();

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + dialect + "]");
        }
        if (dialect == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s01");
        }
        if (!Constants.DIALECT_XPATH.equals(dialect) && !Constants.DIALECT_FUNCTION.equals(dialect)) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + keyword + "]");
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        boolean decryption = "decryption_mode".equals((String)obj);
        boolean signature = "signature_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        String processType = (String)context.get("com.ibm.ws.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + processType + "]");
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + elements + "]");
        }
        Collection configs = (Collection)context.get("com.ibm.ws.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token generator configs [" + configs + "]");
        }
        IDResolver idResolver = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ID resolver [" + idResolver + "]");
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        boolean isContent = false;
        if (encryption || decryption) {
            boolean bl = isContent = keyword != null && keyword.endsWith("node()");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption type is #Content [" + isContent + "]");
            }
            if (isContent) {
                int pos = keyword.lastIndexOf(47);
                keyword = keyword.substring(0, pos);
            }
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        OMDocument doc = DOMUtil.getOwnerDocument(node);
        if (keyword.length() == 0) {
            com.ibm.ws.wssecurity.enc.PartList listImpl;
            list = listImpl = new ArrayList(1);
            ((ArrayList)listImpl).add(doc.getOMDocumentElement());
        } else {
            try {
                AXIOMXPath xpath = new AXIOMXPath(keyword);
                List nl = xpath.selectNodes(node);
                int l = nl.size();
                ArrayList<OMElement> listImpl = new ArrayList<OMElement>(l);
                list = listImpl;
                for (int i = 0; i < l; ++i) {
                    Object n = nl.get(i);
                    if (!(n instanceof OMElement)) continue;
                    listImpl.add((OMElement)n);
                }
            }
            catch (JaxenException ex1) {
                if (!(encryption || decryption || signature || "timestamp".equals(processType) || "nonce".equals(processType))) {
                    try {
                        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
                        OMElement xpathExpression = factory.createOMElement("XPath", Constants.NS_DSIG, "ds");
                        OMText expression = factory.createOMText(keyword);
                        xpathExpression.addChild(expression);
                        XPathTransformer transformer = new XPathTransformer();
                        transformer.setParameter(xpathExpression);
                        SignatureContext scontext = new SignatureContext();
                        scontext.setIDResolver(idResolver);
                        Vector decls = XPathUtil.fixTree(node);
                        TransformContext tcontext = new TransformContext(scontext, node);
                        transformer.transform(tcontext);
                        if (decls != null) {
                            XPathUtil.cleanTree(decls);
                        }
                        list = new PartList(tcontext.getNodeset());
                    }
                    catch (TransformException ex2) {
                        Tr.processException(ex2, clsName + ".getElements", "%C");
                        throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", new String[]{keyword, ex2.getMessage()}, (Throwable)ex2);
                    }
                }
                Tr.processException(ex1, clsName + ".getElements", "%C");
                throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", new String[]{keyword, ex1.getMessage()}, (Throwable)ex1);
            }
        }
        if (processType != null) {
            if (encryption || signature) {
                list = IntegralDialectElementSelector.postprocess(doc, processType, list, elements, nsWsse, nsWsu, nonceManager, signature, encryption, dialect, keyword);
            }
            if (encryption && list != null && ((ArrayList)list).size() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", keyword);
            }
        }
        if (encryption || decryption) {
            list = isContent ? new com.ibm.ws.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Content", list) : new com.ibm.ws.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Element", list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return list;
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> orig_list = this.getElements(node, context);
        ArrayList<XMLElement> new_list = new ArrayList<XMLElement>();
        if (orig_list != null && orig_list.size() > 0) {
            for (int i = 0; i < orig_list.size(); ++i) {
                OMNode obj = orig_list.get(i);
                XMLElement el = new XMLElement(obj);
                new_list.add(el);
            }
        }
        return new_list;
    }
}

