/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.wssapi.DOMStructure;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Element;

public class XMLStructureHelper {
    private static final TraceComponent tc = Tr.register(XMLStructureHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";

    public OMElement getOMElement(SecurityToken token, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOMElement(SecurityToken, Map)..." + token);
        }
        if (token == null) {
            throw new SoapSecurityException("Null SecurityToken.");
        }
        OMElement ome = null;
        XMLStructure xmlStr = token.getXML();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "XMLStructure: " + xmlStr);
        }
        if (xmlStr == null) {
            throw new SoapSecurityException("Null XMLStructure");
        }
        if (xmlStr instanceof OMStructure) {
            ome = ((OMStructure)xmlStr).getNode();
            if (ome == null) {
                throw new SoapSecurityException("Null OMElement.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OMElement:\n" + DOMUtils.toString(ome));
            }
        } else if (xmlStr instanceof DOMStructure) {
            if (context == null) {
                throw new SoapSecurityException("Null Map<Object,Object> context for name-value pairs.");
            }
            HashMap hmap = (HashMap)context.get("com.ibm.ws.wssecurity.domElementOmElementMap");
            if (hmap == null) {
                throw new SoapSecurityException("Null Map for com.ibm.ws.wssecurity.domElementOmElementMap");
            }
            DOMStructure domStruc = (DOMStructure)xmlStr;
            Element el = domStruc.getNode();
            if (el == null) {
                throw new SoapSecurityException("Null Element.");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DOM element NodeName: " + el.getNodeName());
                    Tr.debug(tc, "DOM element NameSpace URI: " + el.getNamespaceURI());
                    Tr.debug(tc, "DOM element LocalName: " + el.getLocalName());
                    Tr.debug(tc, "DOM element hashcode: " + el.hashCode());
                }
                if (hmap.containsKey(token)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "FOUND SecurityToken: " + token);
                    }
                    ome = (OMElement)hmap.get(token);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ADD SecurityToken: " + token);
                    }
                    if ((ome = XMLUtils.toOM(el)) != null) {
                        hmap.put(token, ome);
                        this.detach(ome);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "XMLUtils.toOM() returns Null OMElement.");
                    }
                }
            }
            catch (Exception ex) {
                throw new SoapSecurityException(ex);
            }
            if (ome == null) {
                throw new SoapSecurityException("Null OMElement.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DOMStructure - OMElement:\n" + DOMUtils.toString(ome));
            }
        } else {
            throw new SoapSecurityException("Unexpected XMLStructure: " + xmlStr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOMElement() with OMElement hashcode: " + ome.hashCode());
        }
        return ome;
    }

    private void detach(OMElement ome) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "detach(OMElement)...hashcode: " + ome.hashCode());
        }
        if (ome.getParent() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got parent: detaching...");
            }
            ome.detach();
            StAXBuilder aBuilder = (StAXBuilder)ome.getBuilder();
            if (aBuilder != null) {
                aBuilder.releaseParserOnClose(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "detach(OMElement)...hashcode: " + ome.hashCode());
        }
    }
}

