/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class WSSecurityFactoryBuilder {
    private static final TraceComponent tc = Tr.register(WSSecurityFactoryBuilder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static Hashtable _factoryImpl = new Hashtable();
    private static Hashtable _factoryImplClassNames = new Hashtable();

    public static Object getInstance(String factoryClass) {
        if (_factoryImpl != null && _factoryImpl.containsKey(factoryClass)) {
            return _factoryImpl.get(factoryClass);
        }
        final String className = (String)WSSecurityFactoryBuilder.getImplClassName(factoryClass);
        Object cf = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WSSecurityFactoryBuilder.loadImplFromClass(className);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + factoryClass);
            Tr.debug(tc, "factory impl class = " + className);
        }
        _factoryImpl.put(factoryClass, cf);
        return cf;
    }

    public static Object getInstance(String factoryClass, boolean cache) {
        if (cache) {
            return WSSecurityFactoryBuilder.getInstance(factoryClass);
        }
        final String className = (String)WSSecurityFactoryBuilder.getImplClassName(factoryClass);
        Object cf = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WSSecurityFactoryBuilder.loadImplFromClass(className);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + factoryClass);
            Tr.debug(tc, "factory impl class = " + className);
        }
        return cf;
    }

    public static Object loadImplFromClass(String classname) {
        ClassLoader cl = WSSecurityFactoryBuilder.class.getClassLoader();
        try {
            Class<?> aClass = cl.loadClass(classname);
            return aClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> bClass = Class.forName(classname);
                return bClass.newInstance();
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
    }

    public static Object getImplClassName(String factoryClass) {
        block7: {
            InputStream in;
            if (_factoryImplClassNames != null && !_factoryImplClassNames.isEmpty()) {
                return _factoryImplClassNames.get(factoryClass);
            }
            String platform = "properties/platform.properties";
            if (PlatformContextUtil.isWebSphereThinClient()) {
                platform = "com/ibm/ws/wssecurity/platform/websphere/properties/thinclient.properties";
            }
            if ((in = WSSecurityFactoryBuilder.class.getClassLoader().getResourceAsStream(platform)) == null) {
                ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                in = loader == null ? ClassLoader.getSystemResourceAsStream(platform) : loader.getResourceAsStream(platform);
            }
            if (in != null) {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("com.ibm") || line.indexOf(61) <= 0) continue;
                        int begin_index = line.indexOf(61) + 1;
                        String key = line.substring(0, begin_index - 1);
                        String value = line.substring(begin_index);
                        if (key == null || value == null) continue;
                        _factoryImplClassNames.put(key, value);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "factory key = " + key);
                        Tr.debug(tc, "factory impl class name = " + value);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception while create WSSecurity factory.", e);
                    e.printStackTrace();
                }
            }
        }
        return _factoryImplClassNames.get(factoryClass);
    }
}

