/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Nonce;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Security;
import com.ibm.ws.wssecurity.wssobject.impl.wsu.Timestamp;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class WSSObjectUtils {
    private static final TraceComponent tc = Tr.register(WSSObjectUtils.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static boolean isWSSObjectEnabled(Map context) {
        Object obj = context.get("com.ibm.ws.wssecurity.useWSSObject");
        boolean useWSSObject = false;
        if (obj != null && obj instanceof Boolean) {
            useWSSObject = (Boolean)obj;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isWSSObjectEnabled is " + useWSSObject);
        }
        return useWSSObject;
    }

    public static Security getWSSObjectSecurityHeader(Map context) {
        Security security = null;
        if (WSSObjectUtils.isWSSObjectEnabled(context)) {
            Object obj = context.get("com.ibm.ws.wssecurity.WSSObjectSecurityHeader");
            if (obj != null && obj instanceof Security) {
                security = (Security)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found WSSObject Security header in context Map");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find WSSObject Security header in context Map");
            }
        }
        return security;
    }

    public static Timestamp getTimestamp(Security security) {
        Timestamp timestamp = null;
        ArrayList<WSSObject> list = security.getChildren();
        if (list != null && !list.isEmpty()) {
            for (WSSObject obj : list) {
                if (!(obj instanceof Timestamp)) continue;
                timestamp = (Timestamp)obj;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            if (timestamp == null) {
                Tr.debug(tc, "Did not find Timestamp in Security header");
            } else {
                Tr.debug(tc, "Found Timestamp in Security header: " + timestamp);
            }
        }
        return timestamp;
    }

    public static void setCreated(Timestamp timestamp) {
        Date now = new Date();
        String created = UTC.format(now);
        timestamp.setCreated(VariablePartFactory.getInstance().createTextValueWithString(created));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set Created date of " + created + " to Timestamp");
        }
    }

    public static void setExpires(Timestamp timestamp, Duration duration) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        duration.addTo(cal);
        String expires = UTC.format(cal.getTime());
        timestamp.setExpires(VariablePartFactory.getInstance().createTextValueWithString(expires));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set Expires date of " + expires + " to Timestamp");
        }
    }

    public static void addCreated(WSSObjectElementImpl parent) {
        Date now = new Date();
        String created = UTC.format(now);
        parent.addChildAsSimpleTextElement(Utf8ByteConstantsQNames.WSU.QN_CREATED, VariablePartFactory.getInstance().createTextValueWithString(created));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added Created date of " + created + " to element " + parent.getQName());
        }
    }

    public static void addNonce(WSSObjectElement parent, NonceManager nmanager) throws SoapSecurityException {
        Nonce nonceElem = new Nonce(parent.getWSSObjectDocument());
        byte[] nonce = NonceUtil.generateUnencodedNonce(nmanager);
        nonceElem.setContent(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(nonce));
        parent.addChild(nonceElem);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added Nonce of " + Base64.decode(nonce) + " to element " + parent.getQName());
        }
    }

    public static VariablePartAttributeValue getAttribute(WSSObjectElement wssObjectElement, javax.xml.namespace.QName qname) {
        if (qname == null) {
            return null;
        }
        return WSSObjectUtils.getAttribute(wssObjectElement, qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static VariablePartAttributeValue getAttribute(WSSObjectElement wssObjectElement, String namespace, String localname) {
        if (localname == null || localname.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSObjectUtils.getAttribute() returns null; No localname supplied");
            }
            return null;
        }
        if (namespace == null) {
            namespace = "";
        }
        VariablePartAttributeValue vPartAttr = null;
        AttributeSortedSet attrSortedSet = wssObjectElement.getAttributeSortedSet();
        if (attrSortedSet != null && attrSortedSet.size() > 0) {
            for (int i = 0; i < attrSortedSet.size(); ++i) {
                String ln;
                QName qname = attrSortedSet.getQName(i);
                if (qname == null || (ln = qname.getLocalName()) == null || ln.isEmpty()) continue;
                String ns = null;
                NamespacePrefixPair nspp = qname.getNamespacePrefixPair();
                if (nspp != null) {
                    ns = nspp.getUri();
                }
                if (ns == null) {
                    ns = "";
                }
                if (!ln.equals(localname) || !ns.equals(namespace)) continue;
                vPartAttr = attrSortedSet.getVariableParts(i);
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSObjectUtils.getAttribute() returns " + vPartAttr);
        }
        return vPartAttr;
    }

    public static WSSObjectElement getChild(WSSObjectElement parent, QName qname) {
        WSSObjectElement child = null;
        int index = WSSObjectUtils.getChildIndex(parent, qname);
        if (index >= 0) {
            child = (WSSObjectElement)parent.getChild(index);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSObjectUtils.getChild() returns " + (child == null ? "null" : child.getQName()));
        }
        return child;
    }

    public static int getChildIndex(WSSObjectElement parent, QName qname) {
        ArrayList<WSSObject> children = parent.getChildren();
        if (qname != null && children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                WSSObjectElement child;
                WSSObject obj = children.get(i);
                if (!(obj instanceof WSSObjectElement) || !qname.equals((child = (WSSObjectElement)obj).getQName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSObjectUtils.getChildIndex() returns " + i);
                }
                return i;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSObjectUtils.getChildIndex() returns -1");
        }
        return -1;
    }

    public static String getIdAttributeValue(WSSObjectElement wssObjectElement) {
        AttributeSortedSet attrSortedSet;
        String id = null;
        if (wssObjectElement != null && (attrSortedSet = wssObjectElement.getAttributeSortedSet()) != null && attrSortedSet.size() > 0) {
            for (int i = 0; i < attrSortedSet.size(); ++i) {
                QName qname = attrSortedSet.getQName(i);
                if (!Utf8ByteConstantsQNames.WSU.QN_ID.equals(qname) && !Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ID.equals(qname)) continue;
                VariablePartAttributeValue val = attrSortedSet.getVariableParts(i);
                id = val.toString();
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSObjectUtils.getIdAttributeValue() returns " + id);
        }
        return id;
    }

    public static ArrayList<XMLElement> getChildXMLElements(WSSObjectElement parent, QName qname) {
        ArrayList<XMLElement> list = new ArrayList<XMLElement>();
        ArrayList<WSSObject> children = parent.getChildren();
        if (qname != null && children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                WSSObjectElement child;
                WSSObject obj = children.get(i);
                if (!(obj instanceof WSSObjectElement) || !qname.equals((child = (WSSObjectElement)obj).getQName())) continue;
                list.add(new XMLElement(child));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSObjectUtils.getChildXMLElements() returns " + list.size() + " " + qname + " elements");
        }
        return list;
    }
}

